; infix notation implementation
; please do not mix math ops with arguments,
; i mean no '1+2' but '1 + 2'
(define-library (owl math infix)
   (export
      MATH:)
   (import
      (owl math))
   (begin
      (define-syntax MATH:
         (syntax-rules (+ - * /)
            ; раскрытие внешних скобок
            ((MATH: (a))
               (MATH: a))
            ((MATH: (a .x))
               (MATH: a .x))

            ;; functions
            ((MATH: f (.x))
               (f (MATH: .x)))
            ((MATH: f (a (unquote .x)))
               (f (MATH: a) (MATH: .x)))


      ;; a + b
      ((MATH: a      + b)
         (+ (MATH: a)      (MATH: b)))
      ((MATH: a      + b(.bb))
         (+ (MATH: a)      (MATH: b(.bb))))
      ((MATH: a(.aa) + b)
         (+ (MATH: a(.aa)) (MATH: b)))
      ((MATH: a(.aa) + b(.bb))
         (+ (MATH: a(.aa)) (MATH: b(.bb))))

      ;; a - b
      ((MATH: a      - b)
         (- (MATH: a)      (MATH: b)))
      ((MATH: a      - b(.bb))
         (- (MATH: a)      (MATH: b(.bb))))
      ((MATH: a(.aa) - b)
         (- (MATH: a(.aa)) (MATH: b)))
      ((MATH: a(.aa) - b(.bb))
         (- (MATH: a(.aa)) (MATH: b(.bb))))

      ;; a * b
      ((MATH: a      * b)
         (* (MATH: a)      (MATH: b)))
      ((MATH: a      * b(.bb))
         (* (MATH: a)      (MATH: b(.bb))))
      ((MATH: a(.aa) * b)
         (* (MATH: a(.aa)) (MATH: b)))
      ((MATH: a(.aa) * b(.bb))
         (* (MATH: a(.aa)) (MATH: b(.bb))))

      ;; a / b
      ((MATH: a      / b)
         (/ (MATH: a)      (MATH: b)))
      ((MATH: a      / b(.bb))
         (/ (MATH: a)      (MATH: b(.bb))))
      ((MATH: a(.aa) / b)
         (/ (MATH: a(.aa)) (MATH: b)))
      ((MATH: a(.aa) / b(.bb))
         (/ (MATH: a(.aa)) (MATH: b(.bb))))
      ;; a + b ...
      ;; a + b + c
      ((MATH: a      + b      + c      .x)
         (MATH: (a      +  b     ) + c      .x))
      ((MATH: a      + b      + c(.cc) .x)
         (MATH: (a      +  b     ) + c(.cc) .x))
      ((MATH: a      + b(.bb) + c      .x)
         (MATH: (a      +  b(.bb)) + c      .x))
      ((MATH: a      + b(.bb) + c(.cc) .x)
         (MATH: (a      +  b(.bb)) + c(.cc) .x))
      ((MATH: a(.aa) + b      + c      .x)
         (MATH: (a(.aa) +  b     ) + c      .x))
      ((MATH: a(.aa) + b      + c(.cc) .x)
         (MATH: (a(.aa) +  b     ) + c(.cc) .x))
      ((MATH: a(.aa) + b(.bb) + c      .x)
         (MATH: (a(.aa) +  b(.bb)) + c      .x))
      ((MATH: a(.aa) + b(.bb) + c(.cc) .x)
         (MATH: (a(.aa) +  b(.bb)) + c(.cc) .x))
      ;; a + b - c
      ((MATH: a      + b      - c      .x)
         (MATH: (a      +  b     ) - c      .x))
      ((MATH: a      + b      - c(.cc) .x)
         (MATH: (a      +  b     ) - c(.cc) .x))
      ((MATH: a      + b(.bb) - c      .x)
         (MATH: (a      +  b(.bb)) - c      .x))
      ((MATH: a      + b(.bb) - c(.cc) .x)
         (MATH: (a      +  b(.bb)) - c(.cc) .x))
      ((MATH: a(.aa) + b      - c      .x)
         (MATH: (a(.aa) +  b     ) - c      .x))
      ((MATH: a(.aa) + b      - c(.cc) .x)
         (MATH: (a(.aa) +  b     ) - c(.cc) .x))
      ((MATH: a(.aa) + b(.bb) - c      .x)
         (MATH: (a(.aa) +  b(.bb)) - c      .x))
      ((MATH: a(.aa) + b(.bb) - c(.cc) .x)
         (MATH: (a(.aa) +  b(.bb)) - c(.cc) .x))
      ;; a + b * c
      ((MATH: a      + b      * c      .x)
         (MATH:  a      + (b       * c      .x)))
      ((MATH: a      + b      * c(.cc) .x)
         (MATH:  a      + (b       * c(.cc) .x)))
      ((MATH: a      + b(.bb) * c      .x)
         (MATH:  a      + (b(.bb)  * c      .x)))
      ((MATH: a      + b(.bb) * c(.cc) .x)
         (MATH:  a      + (b(.bb)  * c(.cc) .x)))
      ((MATH: a(.aa) + b      * c      .x)
         (MATH:  a(.aa) + (b       * c      .x)))
      ((MATH: a(.aa) + b      * c(.cc) .x)
         (MATH:  a(.aa) + (b       * c(.cc) .x)))
      ((MATH: a(.aa) + b(.bb) * c      .x)
         (MATH:  a(.aa) + (b(.bb)  * c      .x)))
      ((MATH: a(.aa) + b(.bb) * c(.cc) .x)
         (MATH:  a(.aa) + (b(.bb)  * c(.cc) .x)))
      ;; a + b / c
      ((MATH: a      + b      / c      .x)
         (MATH:  a      + (b       / c      .x)))
      ((MATH: a      + b      / c(.cc) .x)
         (MATH:  a      + (b       / c(.cc) .x)))
      ((MATH: a      + b(.bb) / c      .x)
         (MATH:  a      + (b(.bb)  / c      .x)))
      ((MATH: a      + b(.bb) / c(.cc) .x)
         (MATH:  a      + (b(.bb)  / c(.cc) .x)))
      ((MATH: a(.aa) + b      / c      .x)
         (MATH:  a(.aa) + (b       / c      .x)))
      ((MATH: a(.aa) + b      / c(.cc) .x)
         (MATH:  a(.aa) + (b       / c(.cc) .x)))
      ((MATH: a(.aa) + b(.bb) / c      .x)
         (MATH:  a(.aa) + (b(.bb)  / c      .x)))
      ((MATH: a(.aa) + b(.bb) / c(.cc) .x)
         (MATH:  a(.aa) + (b(.bb)  / c(.cc) .x)))
      ;; a - b ...
      ;; a - b + c
      ((MATH: a      - b      + c      .x)
         (MATH: (a      -  b     ) + c      .x))
      ((MATH: a      - b      + c(.cc) .x)
         (MATH: (a      -  b     ) + c(.cc) .x))
      ((MATH: a      - b(.bb) + c      .x)
         (MATH: (a      -  b(.bb)) + c      .x))
      ((MATH: a      - b(.bb) + c(.cc) .x)
         (MATH: (a      -  b(.bb)) + c(.cc) .x))
      ((MATH: a(.aa) - b      + c      .x)
         (MATH: (a(.aa) -  b     ) + c      .x))
      ((MATH: a(.aa) - b      + c(.cc) .x)
         (MATH: (a(.aa) -  b     ) + c(.cc) .x))
      ((MATH: a(.aa) - b(.bb) + c      .x)
         (MATH: (a(.aa) -  b(.bb)) + c      .x))
      ((MATH: a(.aa) - b(.bb) + c(.cc) .x)
         (MATH: (a(.aa) -  b(.bb)) + c(.cc) .x))
      ;; a - b - c
      ((MATH: a      - b      - c      .x)
         (MATH: (a      -  b     ) - c      .x))
      ((MATH: a      - b      - c(.cc) .x)
         (MATH: (a      -  b     ) - c(.cc) .x))
      ((MATH: a      - b(.bb) - c      .x)
         (MATH: (a      -  b(.bb)) - c      .x))
      ((MATH: a      - b(.bb) - c(.cc) .x)
         (MATH: (a      -  b(.bb)) - c(.cc) .x))
      ((MATH: a(.aa) - b      - c      .x)
         (MATH: (a(.aa) -  b     ) - c      .x))
      ((MATH: a(.aa) - b      - c(.cc) .x)
         (MATH: (a(.aa) -  b     ) - c(.cc) .x))
      ((MATH: a(.aa) - b(.bb) - c      .x)
         (MATH: (a(.aa) -  b(.bb)) - c      .x))
      ((MATH: a(.aa) - b(.bb) - c(.cc) .x)
         (MATH: (a(.aa) -  b(.bb)) - c(.cc) .x))
      ;; a - b * c
      ((MATH: a      - b      * c      .x)
         (MATH:  a      - (b       * c      .x)))
      ((MATH: a      - b      * c(.cc) .x)
         (MATH:  a      - (b       * c(.cc) .x)))
      ((MATH: a      - b(.bb) * c      .x)
         (MATH:  a      - (b(.bb)  * c      .x)))
      ((MATH: a      - b(.bb) * c(.cc) .x)
         (MATH:  a      - (b(.bb)  * c(.cc) .x)))
      ((MATH: a(.aa) - b      * c      .x)
         (MATH:  a(.aa) - (b       * c      .x)))
      ((MATH: a(.aa) - b      * c(.cc) .x)
         (MATH:  a(.aa) - (b       * c(.cc) .x)))
      ((MATH: a(.aa) - b(.bb) * c      .x)
         (MATH:  a(.aa) - (b(.bb)  * c      .x)))
      ((MATH: a(.aa) - b(.bb) * c(.cc) .x)
         (MATH:  a(.aa) - (b(.bb)  * c(.cc) .x)))
      ;; a - b / c
      ((MATH: a      - b      / c      .x)
         (MATH:  a      - (b       / c      .x)))
      ((MATH: a      - b      / c(.cc) .x)
         (MATH:  a      - (b       / c(.cc) .x)))
      ((MATH: a      - b(.bb) / c      .x)
         (MATH:  a      - (b(.bb)  / c      .x)))
      ((MATH: a      - b(.bb) / c(.cc) .x)
         (MATH:  a      - (b(.bb)  / c(.cc) .x)))
      ((MATH: a(.aa) - b      / c      .x)
         (MATH:  a(.aa) - (b       / c      .x)))
      ((MATH: a(.aa) - b      / c(.cc) .x)
         (MATH:  a(.aa) - (b       / c(.cc) .x)))
      ((MATH: a(.aa) - b(.bb) / c      .x)
         (MATH:  a(.aa) - (b(.bb)  / c      .x)))
      ((MATH: a(.aa) - b(.bb) / c(.cc) .x)
         (MATH:  a(.aa) - (b(.bb)  / c(.cc) .x)))
      ;; a * b ...
      ;; a * b + c
      ((MATH: a      * b      + c      .x)
         (MATH: (a      *  b     ) + c      .x))
      ((MATH: a      * b      + c(.cc) .x)
         (MATH: (a      *  b     ) + c(.cc) .x))
      ((MATH: a      * b(.bb) + c      .x)
         (MATH: (a      *  b(.bb)) + c      .x))
      ((MATH: a      * b(.bb) + c(.cc) .x)
         (MATH: (a      *  b(.bb)) + c(.cc) .x))
      ((MATH: a(.aa) * b      + c      .x)
         (MATH: (a(.aa) *  b     ) + c      .x))
      ((MATH: a(.aa) * b      + c(.cc) .x)
         (MATH: (a(.aa) *  b     ) + c(.cc) .x))
      ((MATH: a(.aa) * b(.bb) + c      .x)
         (MATH: (a(.aa) *  b(.bb)) + c      .x))
      ((MATH: a(.aa) * b(.bb) + c(.cc) .x)
         (MATH: (a(.aa) *  b(.bb)) + c(.cc) .x))
      ;; a * b - c
      ((MATH: a      * b      - c      .x)
         (MATH: (a      *  b     ) - c      .x))
      ((MATH: a      * b      - c(.cc) .x)
         (MATH: (a      *  b     ) - c(.cc) .x))
      ((MATH: a      * b(.bb) - c      .x)
         (MATH: (a      *  b(.bb)) - c      .x))
      ((MATH: a      * b(.bb) - c(.cc) .x)
         (MATH: (a      *  b(.bb)) - c(.cc) .x))
      ((MATH: a(.aa) * b      - c      .x)
         (MATH: (a(.aa) *  b     ) - c      .x))
      ((MATH: a(.aa) * b      - c(.cc) .x)
         (MATH: (a(.aa) *  b     ) - c(.cc) .x))
      ((MATH: a(.aa) * b(.bb) - c      .x)
         (MATH: (a(.aa) *  b(.bb)) - c      .x))
      ((MATH: a(.aa) * b(.bb) - c(.cc) .x)
         (MATH: (a(.aa) *  b(.bb)) - c(.cc) .x))
      ;; a * b * c
      ((MATH: a      * b      * c      .x)
         (MATH: (a      *  b     ) * c      .x))
      ((MATH: a      * b      * c(.cc) .x)
         (MATH: (a      *  b     ) * c(.cc) .x))
      ((MATH: a      * b(.bb) * c      .x)
         (MATH: (a      *  b(.bb)) * c      .x))
      ((MATH: a      * b(.bb) * c(.cc) .x)
         (MATH: (a      *  b(.bb)) * c(.cc) .x))
      ((MATH: a(.aa) * b      * c      .x)
         (MATH: (a(.aa) *  b     ) * c      .x))
      ((MATH: a(.aa) * b      * c(.cc) .x)
         (MATH: (a(.aa) *  b     ) * c(.cc) .x))
      ((MATH: a(.aa) * b(.bb) * c      .x)
         (MATH: (a(.aa) *  b(.bb)) * c      .x))
      ((MATH: a(.aa) * b(.bb) * c(.cc) .x)
         (MATH: (a(.aa) *  b(.bb)) * c(.cc) .x))
      ;; a * b / c
      ((MATH: a      * b      / c      .x)
         (MATH: (a      *  b     ) / c      .x))
      ((MATH: a      * b      / c(.cc) .x)
         (MATH: (a      *  b     ) / c(.cc) .x))
      ((MATH: a      * b(.bb) / c      .x)
         (MATH: (a      *  b(.bb)) / c      .x))
      ((MATH: a      * b(.bb) / c(.cc) .x)
         (MATH: (a      *  b(.bb)) / c(.cc) .x))
      ((MATH: a(.aa) * b      / c      .x)
         (MATH: (a(.aa) *  b     ) / c      .x))
      ((MATH: a(.aa) * b      / c(.cc) .x)
         (MATH: (a(.aa) *  b     ) / c(.cc) .x))
      ((MATH: a(.aa) * b(.bb) / c      .x)
         (MATH: (a(.aa) *  b(.bb)) / c      .x))
      ((MATH: a(.aa) * b(.bb) / c(.cc) .x)
         (MATH: (a(.aa) *  b(.bb)) / c(.cc) .x))
      ;; a / b ...
      ;; a / b + c
      ((MATH: a      / b      + c      .x)
         (MATH: (a      /  b     ) + c      .x))
      ((MATH: a      / b      + c(.cc) .x)
         (MATH: (a      /  b     ) + c(.cc) .x))
      ((MATH: a      / b(.bb) + c      .x)
         (MATH: (a      /  b(.bb)) + c      .x))
      ((MATH: a      / b(.bb) + c(.cc) .x)
         (MATH: (a      /  b(.bb)) + c(.cc) .x))
      ((MATH: a(.aa) / b      + c      .x)
         (MATH: (a(.aa) /  b     ) + c      .x))
      ((MATH: a(.aa) / b      + c(.cc) .x)
         (MATH: (a(.aa) /  b     ) + c(.cc) .x))
      ((MATH: a(.aa) / b(.bb) + c      .x)
         (MATH: (a(.aa) /  b(.bb)) + c      .x))
      ((MATH: a(.aa) / b(.bb) + c(.cc) .x)
         (MATH: (a(.aa) /  b(.bb)) + c(.cc) .x))
      ;; a / b - c
      ((MATH: a      / b      - c      .x)
         (MATH: (a      /  b     ) - c      .x))
      ((MATH: a      / b      - c(.cc) .x)
         (MATH: (a      /  b     ) - c(.cc) .x))
      ((MATH: a      / b(.bb) - c      .x)
         (MATH: (a      /  b(.bb)) - c      .x))
      ((MATH: a      / b(.bb) - c(.cc) .x)
         (MATH: (a      /  b(.bb)) - c(.cc) .x))
      ((MATH: a(.aa) / b      - c      .x)
         (MATH: (a(.aa) /  b     ) - c      .x))
      ((MATH: a(.aa) / b      - c(.cc) .x)
         (MATH: (a(.aa) /  b     ) - c(.cc) .x))
      ((MATH: a(.aa) / b(.bb) - c      .x)
         (MATH: (a(.aa) /  b(.bb)) - c      .x))
      ((MATH: a(.aa) / b(.bb) - c(.cc) .x)
         (MATH: (a(.aa) /  b(.bb)) - c(.cc) .x))
      ;; a / b * c
      ((MATH: a      / b      * c      .x)
         (MATH: (a      /  b     ) * c      .x))
      ((MATH: a      / b      * c(.cc) .x)
         (MATH: (a      /  b     ) * c(.cc) .x))
      ((MATH: a      / b(.bb) * c      .x)
         (MATH: (a      /  b(.bb)) * c      .x))
      ((MATH: a      / b(.bb) * c(.cc) .x)
         (MATH: (a      /  b(.bb)) * c(.cc) .x))
      ((MATH: a(.aa) / b      * c      .x)
         (MATH: (a(.aa) /  b     ) * c      .x))
      ((MATH: a(.aa) / b      * c(.cc) .x)
         (MATH: (a(.aa) /  b     ) * c(.cc) .x))
      ((MATH: a(.aa) / b(.bb) * c      .x)
         (MATH: (a(.aa) /  b(.bb)) * c      .x))
      ((MATH: a(.aa) / b(.bb) * c(.cc) .x)
         (MATH: (a(.aa) /  b(.bb)) * c(.cc) .x))
      ;; a / b / c
      ((MATH: a      / b      / c      .x)
         (MATH: (a      /  b     ) / c      .x))
      ((MATH: a      / b      / c(.cc) .x)
         (MATH: (a      /  b     ) / c(.cc) .x))
      ((MATH: a      / b(.bb) / c      .x)
         (MATH: (a      /  b(.bb)) / c      .x))
      ((MATH: a      / b(.bb) / c(.cc) .x)
         (MATH: (a      /  b(.bb)) / c(.cc) .x))
      ((MATH: a(.aa) / b      / c      .x)
         (MATH: (a(.aa) /  b     ) / c      .x))
      ((MATH: a(.aa) / b      / c(.cc) .x)
         (MATH: (a(.aa) /  b     ) / c(.cc) .x))
      ((MATH: a(.aa) / b(.bb) / c      .x)
         (MATH: (a(.aa) /  b(.bb)) / c      .x))
      ((MATH: a(.aa) / b(.bb) / c(.cc) .x)
         (MATH: (a(.aa) /  b(.bb)) / c(.cc) .x))

      ((MATH: (a + b))
         (+ (MATH: a) (MATH: b)))

      ((MATH: (a - b))
         (- (MATH: a) (MATH: b)))

      ((MATH: (a * b))
         (* (MATH: a) (MATH: b)))

      ((MATH: (a / b))
         (/ (MATH: a) (MATH: b)))

      ;; single value
      ((MATH: x)
         x)))
))
