/*
 * vim:nomodifiable
 *
 * ************* DO NOT EDIT **************
 * This file is autogenerated from all.h.m4
 * ****************************************
 */
/** @file
 * @brief HID report descriptor - all usages
 *
 * Copyright (C) 2010 Nikolai Kondrashov
 *
 * This file is part of hidrd.
 *
 * Hidrd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Hidrd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with hidrd; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @author Nikolai Kondrashov <spbnick@gmail.com>
 */

#ifndef __HIDRD_USAGE_ALL_H__
#define __HIDRD_USAGE_ALL_H__

#include "hidrd/cfg.h"
#include "hidrd/util/num.h"
#include "hidrd/usage/page.h"
#include "hidrd/usage/id.h"
#include "hidrd/usage/type.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum hidrd_usage {
#define _U(_page, _id) (((HIDRD_USAGE_PAGE_##_page) << 16) | (_id))

    HIDRD_USAGE_UNDEFINED = _U(UNDEFINED, 0x0000U),

    /*
     * Generic desktop controls page
     */
#define _PU(_id) _U(DESKTOP, _id)

    /** Pointer (CP) */
    HIDRD_USAGE_DESKTOP_POINTER = _PU(0x0001U),
    /** Mouse (CA) */
    HIDRD_USAGE_DESKTOP_MOUSE = _PU(0x0002U),
    /** Joystick (CA) */
    HIDRD_USAGE_DESKTOP_JOYSTICK = _PU(0x0004U),
    /** Gamepad (CA) */
    HIDRD_USAGE_DESKTOP_GAMEPAD = _PU(0x0005U),
    /** Keyboard (CA) */
    HIDRD_USAGE_DESKTOP_KEYBOARD = _PU(0x0006U),
    /** Keypad (CA) */
    HIDRD_USAGE_DESKTOP_KEYPAD = _PU(0x0007U),
    /** Multi-axis controller (CA) */
    HIDRD_USAGE_DESKTOP_MULTI_AXIS_CTRL = _PU(0x0008U),
    /** Tablet PC system controls (CA) */
    HIDRD_USAGE_DESKTOP_TABLET_PC_SYSTEM = _PU(0x0009U),
    /** X (DV) */
    HIDRD_USAGE_DESKTOP_X = _PU(0x0030U),
    /** Y (DV) */
    HIDRD_USAGE_DESKTOP_Y = _PU(0x0031U),
    /** Z (DV) */
    HIDRD_USAGE_DESKTOP_Z = _PU(0x0032U),
    /** Rx (DV) */
    HIDRD_USAGE_DESKTOP_RX = _PU(0x0033U),
    /** Ry (DV) */
    HIDRD_USAGE_DESKTOP_RY = _PU(0x0034U),
    /** Rz (DV) */
    HIDRD_USAGE_DESKTOP_RZ = _PU(0x0035U),
    /** Slider (DV) */
    HIDRD_USAGE_DESKTOP_SLIDER = _PU(0x0036U),
    /** Dial (DV) */
    HIDRD_USAGE_DESKTOP_DIAL = _PU(0x0037U),
    /** Wheel (DV) */
    HIDRD_USAGE_DESKTOP_WHEEL = _PU(0x0038U),
    /** Hat switch (DV) */
    HIDRD_USAGE_DESKTOP_HAT_SWITCH = _PU(0x0039U),
    /** Counted buffer (CL) */
    HIDRD_USAGE_DESKTOP_COUNTED_BUFFER = _PU(0x003AU),
    /** Byte count (DV) */
    HIDRD_USAGE_DESKTOP_BYTE_COUNT = _PU(0x003BU),
    /** Motion wakeup (OSC) */
    HIDRD_USAGE_DESKTOP_MOTION_WAKEUP = _PU(0x003CU),
    /** Start (OOC) */
    HIDRD_USAGE_DESKTOP_START = _PU(0x003DU),
    /** Select (OOC) */
    HIDRD_USAGE_DESKTOP_SELECT = _PU(0x003EU),
    /** Vx (DV) */
    HIDRD_USAGE_DESKTOP_VX = _PU(0x0040U),
    /** Vy (DV) */
    HIDRD_USAGE_DESKTOP_VY = _PU(0x0041U),
    /** Vz (DV) */
    HIDRD_USAGE_DESKTOP_VZ = _PU(0x0042U),
    /** Vbrx (DV) */
    HIDRD_USAGE_DESKTOP_VBRX = _PU(0x0043U),
    /** Vbry (DV) */
    HIDRD_USAGE_DESKTOP_VBRY = _PU(0x0044U),
    /** Vbrz (DV) */
    HIDRD_USAGE_DESKTOP_VBRZ = _PU(0x0045U),
    /** Vno (DV) */
    HIDRD_USAGE_DESKTOP_VNO = _PU(0x0046U),
    /** Feature notification (DV,DF) */
    HIDRD_USAGE_DESKTOP_FEATURE_NOTIFICATION = _PU(0x0047U),
    /** Resolution multiplier (DV) */
    HIDRD_USAGE_DESKTOP_RESOLUTION_MULTIPLIER = _PU(0x0048U),
    /** System control (CA) */
    HIDRD_USAGE_DESKTOP_SYS_CONTROL = _PU(0x0080U),
    /** System power down (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_POWER_DOWN = _PU(0x0081U),
    /** System sleep (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_SLEEP = _PU(0x0082U),
    /** System wake up (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_WAKE_UP = _PU(0x0083U),
    /** System context menu (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_CONTEXT_MENU = _PU(0x0084U),
    /** System main menu (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_MAIN_MENU = _PU(0x0085U),
    /** System app menu (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_APP_MENU = _PU(0x0086U),
    /** System menu help (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_MENU_HELP = _PU(0x0087U),
    /** System menu exit (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_MENU_EXIT = _PU(0x0088U),
    /** System menu select (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_MENU_SELECT = _PU(0x0089U),
    /** System menu right (RTC) */
    HIDRD_USAGE_DESKTOP_SYS_MENU_RIGHT = _PU(0x008AU),
    /** System menu left (RTC) */
    HIDRD_USAGE_DESKTOP_SYS_MENU_LEFT = _PU(0x008BU),
    /** System menu up (RTC) */
    HIDRD_USAGE_DESKTOP_SYS_MENU_UP = _PU(0x008CU),
    /** System menu down (RTC) */
    HIDRD_USAGE_DESKTOP_SYS_MENU_DOWN = _PU(0x008DU),
    /** System cold restart (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_COLD_RESTART = _PU(0x008EU),
    /** System warm restart (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_WARM_RESTART = _PU(0x008FU),
    /** D-pad up (OOC) */
    HIDRD_USAGE_DESKTOP_D_PAD_UP = _PU(0x0090U),
    /** D-pad down (OOC) */
    HIDRD_USAGE_DESKTOP_D_PAD_DOWN = _PU(0x0091U),
    /** D-pad right (OOC) */
    HIDRD_USAGE_DESKTOP_D_PAD_RIGHT = _PU(0x0092U),
    /** D-pad left (OOC) */
    HIDRD_USAGE_DESKTOP_D_PAD_LEFT = _PU(0x0093U),
    /** System dock (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_DOCK = _PU(0x00A0U),
    /** System undock (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_UNDOCK = _PU(0x00A1U),
    /** System setup (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_SETUP = _PU(0x00A2U),
    /** System break (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_BREAK = _PU(0x00A3U),
    /** System debugger break (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_DBGR_BREAK = _PU(0x00A4U),
    /** Application break (OSC) */
    HIDRD_USAGE_DESKTOP_APP_BREAK = _PU(0x00A5U),
    /** Application debugger break (OSC) */
    HIDRD_USAGE_DESKTOP_APP_DBGR_BREAK = _PU(0x00A6U),
    /** System speaker mute (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_SPEAKER_MUTE = _PU(0x00A7U),
    /** System hibernate (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_HIBERNATE = _PU(0x00A8U),
    /** System display invert (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_DSPL_INVERT = _PU(0x00B0U),
    /** System display internal (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_DSPL_INTERNAL = _PU(0x00B1U),
    /** System display external (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_DSPL_EXTERNAL = _PU(0x00B2U),
    /** System display both (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_DSPL_BOTH = _PU(0x00B3U),
    /** System display dual (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_DSPL_DUAL = _PU(0x00B4U),
    /** System display toggle int/ext (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_DSPL_TOGGLE_INT_EXT = _PU(0x00B5U),
    /** System display swap primary/secondary (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_DSPL_SWAP_1_2 = _PU(0x00B6U),
    /** System display LCD autoscale (OSC) */
    HIDRD_USAGE_DESKTOP_SYS_DSPL_LCD_AUTOSCALE = _PU(0x00B7U),
    /** System display rotation lock button (OOC) */
    HIDRD_USAGE_DESKTOP_SYS_DSPL_ROT_LOCK_BTN = _PU(0x00C9U),
    /** System display rotation lock slider switch (OOC) */
    HIDRD_USAGE_DESKTOP_SYS_DSPL_ROT_LOCK_SLD = _PU(0x00CAU),

#undef _PU

    /*
     * Keyboard/keypad page
     */
#define _PU(_id) _U(KEYBOARD, _id)

    /** No event (Sel) */
    HIDRD_USAGE_KEYBOARD_NONE = _PU(0x0000U),
    /** Keyboard ErrorRollOver (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_ERRORROLLOVER = _PU(0x0001U),
    /** Keyboard POSTFail (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_POSTFAIL = _PU(0x0002U),
    /** Keyboard ErrorUndefined (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_ERRORUNDEFINED = _PU(0x0003U),
    /** Keyboard a and A (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_A = _PU(0x0004U),
    /** Keyboard b and B (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_B = _PU(0x0005U),
    /** Keyboard c and C (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_C = _PU(0x0006U),
    /** Keyboard d and D (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_D = _PU(0x0007U),
    /** Keyboard e and E (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_E = _PU(0x0008U),
    /** Keyboard f and F (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F = _PU(0x0009U),
    /** Keyboard g and G (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_G = _PU(0x000AU),
    /** Keyboard h and H (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_H = _PU(0x000BU),
    /** Keyboard i and I (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_I = _PU(0x000CU),
    /** Keyboard j and J (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_J = _PU(0x000DU),
    /** Keyboard k and K (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_K = _PU(0x000EU),
    /** Keyboard l and L (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_L = _PU(0x000FU),
    /** Keyboard m and M (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_M = _PU(0x0010U),
    /** Keyboard n and N (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_N = _PU(0x0011U),
    /** Keyboard o and O (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_O = _PU(0x0012U),
    /** Keyboard p and P (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_P = _PU(0x0013U),
    /** Keyboard q and Q (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_Q = _PU(0x0014U),
    /** Keyboard r and R (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_R = _PU(0x0015U),
    /** Keyboard s and S (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_S = _PU(0x0016U),
    /** Keyboard t and T (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_T = _PU(0x0017U),
    /** Keyboard u and U (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_U = _PU(0x0018U),
    /** Keyboard v and V (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_V = _PU(0x0019U),
    /** Keyboard w and W (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_W = _PU(0x001AU),
    /** Keyboard x and X (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_X = _PU(0x001BU),
    /** Keyboard y and Y (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_Y = _PU(0x001CU),
    /** Keyboard z and Z (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_Z = _PU(0x001DU),
    /** Keyboard 1 and ! (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_1_AND_EXCLAM = _PU(0x001EU),
    /** Keyboard 2 and @ (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_2_AND_AT = _PU(0x001FU),
    /** Keyboard 3 and number (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_3_AND_NUMBER = _PU(0x0020U),
    /** Keyboard 4 and $ (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_4_AND_DOLLAR = _PU(0x0021U),
    /** Keyboard 5 and % (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_5_AND_PERCENT = _PU(0x0022U),
    /** Keyboard 6 and ^ (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_6_AND_CARET = _PU(0x0023U),
    /** Keyboard 7 and & (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_7_AND_AMP = _PU(0x0024U),
    /** Keyboard 8 and * (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_8_AND_STAR = _PU(0x0025U),
    /** Keyboard 9 and left parenthesis (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_9_AND_LEFT_PAREN = _PU(0x0026U),
    /** Keyboard 0 and right parenthesis (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_0_AND_RIGHT_PAREN = _PU(0x0027U),
    /** Keyboard Return (ENTER) (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_ENTER = _PU(0x0028U),
    /** Keyboard Escape (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_ESCAPE = _PU(0x0029U),
    /** Keyboard Delete (Backspace) (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_DELETE = _PU(0x002AU),
    /** Keyboard Tab (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_TAB = _PU(0x002BU),
    /** Keyboard spacebar (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_SPACEBAR = _PU(0x002CU),
    /** Keyboard - and _ (underscore) (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_MINUS_AND_UNDERSCORE = _PU(0x002DU),
    /** Keyboard = and + (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_EQUALS_AND_PLUS = _PU(0x002EU),
    /** Keyboard [ and { (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LBOXBRACKET_AND_LBRACE = _PU(0x002FU),
    /** Keyboard ] and } (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_RBOXBRACKET_AND_RBRACE = _PU(0x0030U),
    /** Keyboard backslash and | (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_BACKSLASH_AND_PIPE = _PU(0x0031U),
    /** Keyboard non-US number and ~ (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_NON_US_NUMBER_AND_TILDE = _PU(0x0032U),
    /** Keyboard ; and : (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_SEMICOLON_AND_COLON = _PU(0x0033U),
    /** Keyboard ‘ and “ (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_QUOT_AND_DBLQUOT = _PU(0x0034U),
    /** Keyboard grave accent and tilde (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_GRAVE_ACCENT_AND_TILDE = _PU(0x0035U),
    /** Keyboard  (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_COMMA_AND_LT = _PU(0x0036U),
    /** Keyboard . and > (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_PERIOD_AND_GT = _PU(0x0037U),
    /** Keyboard / and ? (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_SLASH_AND_QUESTION = _PU(0x0038U),
    /** Keyboard Caps Lock (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_CAPS_LOCK = _PU(0x0039U),
    /** Keyboard F1 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F1 = _PU(0x003AU),
    /** Keyboard F2 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F2 = _PU(0x003BU),
    /** Keyboard F3 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F3 = _PU(0x003CU),
    /** Keyboard F4 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F4 = _PU(0x003DU),
    /** Keyboard F5 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F5 = _PU(0x003EU),
    /** Keyboard F6 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F6 = _PU(0x003FU),
    /** Keyboard F7 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F7 = _PU(0x0040U),
    /** Keyboard F8 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F8 = _PU(0x0041U),
    /** Keyboard F9 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F9 = _PU(0x0042U),
    /** Keyboard F10 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F10 = _PU(0x0043U),
    /** Keyboard F11 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F11 = _PU(0x0044U),
    /** Keyboard F12 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F12 = _PU(0x0045U),
    /** Keyboard Print Screen (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_PRINT_SCREEN = _PU(0x0046U),
    /** Keyboard Scroll Lock (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_SCROLL_LOCK = _PU(0x0047U),
    /** Keyboard Pause (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_PAUSE = _PU(0x0048U),
    /** Keyboard Insert (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_INSERT = _PU(0x0049U),
    /** Keyboard Home (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_HOME = _PU(0x004AU),
    /** Keyboard PageUp (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_PAGEUP = _PU(0x004BU),
    /** Keyboard Delete Forward (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_DELETE_FORWARD = _PU(0x004CU),
    /** Keyboard End (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_END = _PU(0x004DU),
    /** Keyboard PageDown (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_PAGEDOWN = _PU(0x004EU),
    /** Keyboard RightArrow (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_RIGHTARROW = _PU(0x004FU),
    /** Keyboard LeftArrow (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LEFTARROW = _PU(0x0050U),
    /** Keyboard DownArrow (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_DOWNARROW = _PU(0x0051U),
    /** Keyboard UpArrow (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_UPARROW = _PU(0x0052U),
    /** Keypad Num Lock and Clear (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_NUM_LOCK_AND_CLEAR = _PU(0x0053U),
    /** Keypad / (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_SLASH = _PU(0x0054U),
    /** Keypad * (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_STAR = _PU(0x0055U),
    /** Keypad - (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_MINUS = _PU(0x0056U),
    /** Keypad + (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_PLUS = _PU(0x0057U),
    /** Keypad Enter (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_ENTER = _PU(0x0058U),
    /** Keypad 1 and End (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_1_AND_END = _PU(0x0059U),
    /** Keypad 2 and Down Arrow (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_2_AND_DOWNARROW = _PU(0x005AU),
    /** Keypad 3 and PageDn (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_3_AND_PAGEDN = _PU(0x005BU),
    /** Keypad 4 and Left Arrow (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_4_AND_LEFTARROW = _PU(0x005CU),
    /** Keypad 5 (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_5 = _PU(0x005DU),
    /** Keypad 6 and Right Arrow (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_6_AND_RIGHTARROW = _PU(0x005EU),
    /** Keypad 7 and Home (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_7_AND_HOME = _PU(0x005FU),
    /** Keypad 8 and Up Arrow (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_8_AND_UPARROW = _PU(0x0060U),
    /** Keypad 9 and PageUp (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_9_AND_PAGEUP = _PU(0x0061U),
    /** Keypad 0 and Insert (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_0_AND_INSERT = _PU(0x0062U),
    /** Keypad . and Delete (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_PERIOD_AND_DELETE = _PU(0x0063U),
    /** Keyboard non-US backslash and | (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_NON_US_BACKSLASH_AND_PIPE = _PU(0x0064U),
    /** Keyboard Application (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_APPLICATION = _PU(0x0065U),
    /** Keyboard Power (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_POWER = _PU(0x0066U),
    /** Keypad = (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_EQUALS = _PU(0x0067U),
    /** Keyboard F13 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F13 = _PU(0x0068U),
    /** Keyboard F14 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F14 = _PU(0x0069U),
    /** Keyboard F15 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F15 = _PU(0x006AU),
    /** Keyboard F16 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F16 = _PU(0x006BU),
    /** Keyboard F17 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F17 = _PU(0x006CU),
    /** Keyboard F18 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F18 = _PU(0x006DU),
    /** Keyboard F19 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F19 = _PU(0x006EU),
    /** Keyboard F20 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F20 = _PU(0x006FU),
    /** Keyboard F21 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F21 = _PU(0x0070U),
    /** Keyboard F22 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F22 = _PU(0x0071U),
    /** Keyboard F23 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F23 = _PU(0x0072U),
    /** Keyboard F24 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_F24 = _PU(0x0073U),
    /** Keyboard Execute (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_EXECUTE = _PU(0x0074U),
    /** Keyboard Help (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_HELP = _PU(0x0075U),
    /** Keyboard Menu (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_MENU = _PU(0x0076U),
    /** Keyboard Select (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_SELECT = _PU(0x0077U),
    /** Keyboard Stop (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_STOP = _PU(0x0078U),
    /** Keyboard Again (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_AGAIN = _PU(0x0079U),
    /** Keyboard Undo (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_UNDO = _PU(0x007AU),
    /** Keyboard Cut (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_CUT = _PU(0x007BU),
    /** Keyboard Copy (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_COPY = _PU(0x007CU),
    /** Keyboard Paste (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_PASTE = _PU(0x007DU),
    /** Keyboard Find (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_FIND = _PU(0x007EU),
    /** Keyboard Mute (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_MUTE = _PU(0x007FU),
    /** Keyboard Volume Up (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_VOLUME_UP = _PU(0x0080U),
    /** Keyboard Volume Down (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_VOLUME_DOWN = _PU(0x0081U),
    /** Keyboard locking Caps Lock (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LOCKING_CAPS_LOCK = _PU(0x0082U),
    /** Keyboard locking Num Lock (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LOCKING_NUM_LOCK = _PU(0x0083U),
    /** Keyboard locking Scroll Lock (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LOCKING_SCROLL_LOCK = _PU(0x0084U),
    /** Keypad comma (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_COMMA = _PU(0x0085U),
    /** Keypad = (AS/400) (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_EQUALS_AS_400 = _PU(0x0086U),
    /** Keyboard International1 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_INTL1 = _PU(0x0087U),
    /** Keyboard International2 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_INTL2 = _PU(0x0088U),
    /** Keyboard International3 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_INTL3 = _PU(0x0089U),
    /** Keyboard International4 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_INTL4 = _PU(0x008AU),
    /** Keyboard International5 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_INTL5 = _PU(0x008BU),
    /** Keyboard International6 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_INTL6 = _PU(0x008CU),
    /** Keyboard International7 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_INTL7 = _PU(0x008DU),
    /** Keyboard International8 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_INTL8 = _PU(0x008EU),
    /** Keyboard International9 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_INTL9 = _PU(0x008FU),
    /** Keyboard LANG1 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LANG1 = _PU(0x0090U),
    /** Keyboard LANG2 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LANG2 = _PU(0x0091U),
    /** Keyboard LANG3 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LANG3 = _PU(0x0092U),
    /** Keyboard LANG4 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LANG4 = _PU(0x0093U),
    /** Keyboard LANG5 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LANG5 = _PU(0x0094U),
    /** Keyboard LANG6 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LANG6 = _PU(0x0095U),
    /** Keyboard LANG7 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LANG7 = _PU(0x0096U),
    /** Keyboard LANG8 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LANG8 = _PU(0x0097U),
    /** Keyboard LANG9 (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_LANG9 = _PU(0x0098U),
    /** Keyboard Alternate Erase (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_ALTERNATE_ERASE = _PU(0x0099U),
    /** Keyboard SysReq/Attention (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_SYSREQ_OR_ATTENTION = _PU(0x009AU),
    /** Keyboard Cancel (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_CANCEL = _PU(0x009BU),
    /** Keyboard Clear (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_CLEAR = _PU(0x009CU),
    /** Keyboard Prior (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_PRIOR = _PU(0x009DU),
    /** Keyboard Return (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_RETURN = _PU(0x009EU),
    /** Keyboard Separator (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_SEPARATOR = _PU(0x009FU),
    /** Keyboard Out (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_OUT = _PU(0x00A0U),
    /** Keyboard Oper (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_OPER = _PU(0x00A1U),
    /** Keyboard Clear/Again (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_CLEAR_OR_AGAIN = _PU(0x00A2U),
    /** Keyboard CrSel/Props (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_CRSEL_OR_PROPS = _PU(0x00A3U),
    /** Keyboard ExSel (Sel) */
    HIDRD_USAGE_KEYBOARD_KB_EXSEL = _PU(0x00A4U),
    /** Keypad 00 (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_00 = _PU(0x00B0U),
    /** Keypad 000 (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_000 = _PU(0x00B1U),
    /** Thousands separator (Sel) */
    HIDRD_USAGE_KEYBOARD_THOUSANDS_SEPARATOR = _PU(0x00B2U),
    /** Decimal separator (Sel) */
    HIDRD_USAGE_KEYBOARD_DECIMAL_SEPARATOR = _PU(0x00B3U),
    /** Currency unit (Sel) */
    HIDRD_USAGE_KEYBOARD_CURRENCY_UNIT = _PU(0x00B4U),
    /** Currency sub-unit (Sel) */
    HIDRD_USAGE_KEYBOARD_CURRENCY_SUBUNIT = _PU(0x00B5U),
    /** Keypad left parenthesis (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_LEFT_PAREN = _PU(0x00B6U),
    /** Keypad right parenthesis (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_RIGHT_PAREN = _PU(0x00B7U),
    /** Keypad { (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_LEFT_BRACE = _PU(0x00B8U),
    /** Keypad } (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_RIGHT_BRACE = _PU(0x00B9U),
    /** Keypad Tab (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_TAB = _PU(0x00BAU),
    /** Keypad Backspace (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_BACKSPACE = _PU(0x00BBU),
    /** Keypad A (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_A = _PU(0x00BCU),
    /** Keypad B (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_B = _PU(0x00BDU),
    /** Keypad C (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_C = _PU(0x00BEU),
    /** Keypad D (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_D = _PU(0x00BFU),
    /** Keypad E (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_E = _PU(0x00C0U),
    /** Keypad F (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_F = _PU(0x00C1U),
    /** Keypad XOR (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_XOR = _PU(0x00C2U),
    /** Keypad ^ (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_CARET = _PU(0x00C3U),
    /** Keypad % (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_PERCENT = _PU(0x00C4U),
    /** Keypad < (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_LT = _PU(0x00C5U),
    /** Keypad > (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_GT = _PU(0x00C6U),
    /** Keypad & (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_AMP = _PU(0x00C7U),
    /** Keypad && (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_DBLAMP = _PU(0x00C8U),
    /** Keypad | (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_PIPE = _PU(0x00C9U),
    /** Keypad || (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_DBLPIPE = _PU(0x00CAU),
    /** Keypad : (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_COLON = _PU(0x00CBU),
    /** Keypad number (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_NUMBER = _PU(0x00CCU),
    /** Keypad Space (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_SPACE = _PU(0x00CDU),
    /** Keypad @ (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_AT = _PU(0x00CEU),
    /** Keypad ! (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_EXCLAMATION = _PU(0x00CFU),
    /** Keypad Memory Store (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_MEM_STORE = _PU(0x00D0U),
    /** Keypad Memory Recall (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_MEM_RECALL = _PU(0x00D1U),
    /** Keypad Memory Clear (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_MEM_CLEAR = _PU(0x00D2U),
    /** Keypad Memory Add (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_MEM_ADD = _PU(0x00D3U),
    /** Keypad Memory Subtract (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_MEM_SUBTRACT = _PU(0x00D4U),
    /** Keypad Memory Multiply (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_MEM_MULTIPLY = _PU(0x00D5U),
    /** Keypad Memory Divide (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_MEM_DIVIDE = _PU(0x00D6U),
    /** Keypad +/- (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_PLUS_MINUS = _PU(0x00D7U),
    /** Keypad Clear (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_CLEAR = _PU(0x00D8U),
    /** Keypad Clear Entry (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_CLEAR_ENTRY = _PU(0x00D9U),
    /** Keypad Binary (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_BINARY = _PU(0x00DAU),
    /** Keypad Octal (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_OCTAL = _PU(0x00DBU),
    /** Keypad Decimal (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_DECIMAL = _PU(0x00DCU),
    /** Keypad Hexadecimal (Sel) */
    HIDRD_USAGE_KEYBOARD_KP_HEXADECIMAL = _PU(0x00DDU),
    /** Keyboard left control (DV) */
    HIDRD_USAGE_KEYBOARD_KB_LEFTCONTROL = _PU(0x00E0U),
    /** Keyboard left shift (DV) */
    HIDRD_USAGE_KEYBOARD_KB_LEFTSHIFT = _PU(0x00E1U),
    /** Keyboard left alt (DV) */
    HIDRD_USAGE_KEYBOARD_KB_LEFTALT = _PU(0x00E2U),
    /** Keyboard left GUI (DV) */
    HIDRD_USAGE_KEYBOARD_KB_LEFT_GUI = _PU(0x00E3U),
    /** Keyboard right control (DV) */
    HIDRD_USAGE_KEYBOARD_KB_RIGHTCONTROL = _PU(0x00E4U),
    /** Keyboard right shift (DV) */
    HIDRD_USAGE_KEYBOARD_KB_RIGHTSHIFT = _PU(0x00E5U),
    /** Keyboard right alt (DV) */
    HIDRD_USAGE_KEYBOARD_KB_RIGHTALT = _PU(0x00E6U),
    /** Keyboard right GUI (DV) */
    HIDRD_USAGE_KEYBOARD_KB_RIGHT_GUI = _PU(0x00E7U),

#undef _PU

    /*
     * Consumer page
     */
#define _PU(_id) _U(CONSUMER, _id)

    /** Consumer control (CA) */
    HIDRD_USAGE_CONSUMER_CONSUMER_CONTROL = _PU(0x0001U),
    /** Numeric key pad (NAry) */
    HIDRD_USAGE_CONSUMER_NUMERIC_KEYPAD = _PU(0x0002U),
    /** Programmable buttons (NAry) */
    HIDRD_USAGE_CONSUMER_PROGRAMMABLE_BUTTONS = _PU(0x0003U),
    /** Microphone (CA) */
    HIDRD_USAGE_CONSUMER_MICROPHONE = _PU(0x0004U),
    /** Headphone (CA) */
    HIDRD_USAGE_CONSUMER_HEADPHONE = _PU(0x0005U),
    /** Graphic equalizer (CA) */
    HIDRD_USAGE_CONSUMER_GRAPHIC_EQUALIZER = _PU(0x0006U),
    /** +10 (OSC) */
    HIDRD_USAGE_CONSUMER_PLUS_10 = _PU(0x0020U),
    /** +100 (OSC) */
    HIDRD_USAGE_CONSUMER_PLUS_100 = _PU(0x0021U),
    /** AM/PM (OSC) */
    HIDRD_USAGE_CONSUMER_AM_PM = _PU(0x0022U),
    /** Power (OOC) */
    HIDRD_USAGE_CONSUMER_POWER = _PU(0x0030U),
    /** Reset (OSC) */
    HIDRD_USAGE_CONSUMER_RESET = _PU(0x0031U),
    /** Sleep (OSC) */
    HIDRD_USAGE_CONSUMER_SLEEP = _PU(0x0032U),
    /** Sleep after (OSC) */
    HIDRD_USAGE_CONSUMER_SLEEP_AFTER = _PU(0x0033U),
    /** Sleep mode (RTC) */
    HIDRD_USAGE_CONSUMER_SLEEP_MODE = _PU(0x0034U),
    /** Illumination (OOC) */
    HIDRD_USAGE_CONSUMER_ILLUMINATION = _PU(0x0035U),
    /** Function buttons (NAry) */
    HIDRD_USAGE_CONSUMER_FUNCTION_BUTTONS = _PU(0x0036U),
    /** Menu (OOC) */
    HIDRD_USAGE_CONSUMER_MENU = _PU(0x0040U),
    /** Menu pick (OSC) */
    HIDRD_USAGE_CONSUMER_MENU_PICK = _PU(0x0041U),
    /** Menu up (OSC) */
    HIDRD_USAGE_CONSUMER_MENU_UP = _PU(0x0042U),
    /** Menu down (OSC) */
    HIDRD_USAGE_CONSUMER_MENU_DOWN = _PU(0x0043U),
    /** Menu left (OSC) */
    HIDRD_USAGE_CONSUMER_MENU_LEFT = _PU(0x0044U),
    /** Menu right (OSC) */
    HIDRD_USAGE_CONSUMER_MENU_RIGHT = _PU(0x0045U),
    /** Menu escape (OSC) */
    HIDRD_USAGE_CONSUMER_MENU_ESCAPE = _PU(0x0046U),
    /** Menu value increase (OSC) */
    HIDRD_USAGE_CONSUMER_MENU_VALUE_INC = _PU(0x0047U),
    /** Menu value decrease (OSC) */
    HIDRD_USAGE_CONSUMER_MENU_VALUE_DEC = _PU(0x0048U),
    /** Data on screen (OOC) */
    HIDRD_USAGE_CONSUMER_DATA_ON_SCREEN = _PU(0x0060U),
    /** Closed caption (OOC) */
    HIDRD_USAGE_CONSUMER_CLOSED_CAPTION = _PU(0x0061U),
    /** Closed caption select (OSC) */
    HIDRD_USAGE_CONSUMER_CLOSED_CAPTION_SELECT = _PU(0x0062U),
    /** VCR/TV (OOC) */
    HIDRD_USAGE_CONSUMER_VCR_TV = _PU(0x0063U),
    /** Broadcast mode (OSC) */
    HIDRD_USAGE_CONSUMER_BROADCAST_MODE = _PU(0x0064U),
    /** Snapshot (OSC) */
    HIDRD_USAGE_CONSUMER_SNAPSHOT = _PU(0x0065U),
    /** Still (OSC) */
    HIDRD_USAGE_CONSUMER_STILL = _PU(0x0066U),
    /** Selection (NAry) */
    HIDRD_USAGE_CONSUMER_SELECTION = _PU(0x0080U),
    /** Assign selection (OSC) */
    HIDRD_USAGE_CONSUMER_ASSIGN_SELECTION = _PU(0x0081U),
    /** Mode step (OSC) */
    HIDRD_USAGE_CONSUMER_MODE_STEP = _PU(0x0082U),
    /** Recall last (OSC) */
    HIDRD_USAGE_CONSUMER_RECALL_LAST = _PU(0x0083U),
    /** Enter channel (OSC) */
    HIDRD_USAGE_CONSUMER_ENTER_CHANNEL = _PU(0x0084U),
    /** Order movie (OSC) */
    HIDRD_USAGE_CONSUMER_ORDER_MOVIE = _PU(0x0085U),
    /** Channel (LC) */
    HIDRD_USAGE_CONSUMER_CHANNEL = _PU(0x0086U),
    /** Media selection (NAry) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECTION = _PU(0x0087U),
    /** Media select computer (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_COMPUTER = _PU(0x0088U),
    /** Media select TV (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_TV = _PU(0x0089U),
    /** Media select WWW (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_WWW = _PU(0x008AU),
    /** Media select DVD (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_DVD = _PU(0x008BU),
    /** Media select telephone (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_TELEPHONE = _PU(0x008CU),
    /** Media select program guide (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_PROGRAM_GUIDE = _PU(0x008DU),
    /** Media select video phone (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_VIDEO_PHONE = _PU(0x008EU),
    /** Media select games (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_GAMES = _PU(0x008FU),
    /** Media select messages (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_MESSAGES = _PU(0x0090U),
    /** Media select CD (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_CD = _PU(0x0091U),
    /** Media select VCR (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_VCR = _PU(0x0092U),
    /** Media select tuner (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_TUNER = _PU(0x0093U),
    /** Quit (OSC) */
    HIDRD_USAGE_CONSUMER_QUIT = _PU(0x0094U),
    /** Help (OOC) */
    HIDRD_USAGE_CONSUMER_HELP = _PU(0x0095U),
    /** Media select tape (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_TAPE = _PU(0x0096U),
    /** Media select cable (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_CABLE = _PU(0x0097U),
    /** Media select satellite (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_SATELLITE = _PU(0x0098U),
    /** Media select security (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_SECURITY = _PU(0x0099U),
    /** Media select home (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_HOME = _PU(0x009AU),
    /** Media select call (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_CALL = _PU(0x009BU),
    /** Channel increment (OSC) */
    HIDRD_USAGE_CONSUMER_CHANNEL_INC = _PU(0x009CU),
    /** Channel decrement (OSC) */
    HIDRD_USAGE_CONSUMER_CHANNEL_DEC = _PU(0x009DU),
    /** Media select SAP (Sel) */
    HIDRD_USAGE_CONSUMER_MEDIA_SELECT_SAP = _PU(0x009EU),
    /** VCR plus (OSC) */
    HIDRD_USAGE_CONSUMER_VCR_PLUS = _PU(0x00A0U),
    /** Once (OSC) */
    HIDRD_USAGE_CONSUMER_ONCE = _PU(0x00A1U),
    /** Daily (OSC) */
    HIDRD_USAGE_CONSUMER_DAILY = _PU(0x00A2U),
    /** Weekly (OSC) */
    HIDRD_USAGE_CONSUMER_WEEKLY = _PU(0x00A3U),
    /** Monthly (OSC) */
    HIDRD_USAGE_CONSUMER_MONTHLY = _PU(0x00A4U),
    /** Play (OOC) */
    HIDRD_USAGE_CONSUMER_PLAY = _PU(0x00B0U),
    /** Pause (OOC) */
    HIDRD_USAGE_CONSUMER_PAUSE = _PU(0x00B1U),
    /** Record (OOC) */
    HIDRD_USAGE_CONSUMER_RECORD = _PU(0x00B2U),
    /** Fast forward (OOC) */
    HIDRD_USAGE_CONSUMER_FAST_FORWARD = _PU(0x00B3U),
    /** Rewind (OOC) */
    HIDRD_USAGE_CONSUMER_REWIND = _PU(0x00B4U),
    /** Scan next track (OSC) */
    HIDRD_USAGE_CONSUMER_SCAN_NEXT_TRACK = _PU(0x00B5U),
    /** Scan previous track (OSC) */
    HIDRD_USAGE_CONSUMER_SCAN_PREVIOUS_TRACK = _PU(0x00B6U),
    /** Stop (OSC) */
    HIDRD_USAGE_CONSUMER_STOP = _PU(0x00B7U),
    /** Eject (OSC) */
    HIDRD_USAGE_CONSUMER_EJECT = _PU(0x00B8U),
    /** Random play (OOC) */
    HIDRD_USAGE_CONSUMER_RANDOM_PLAY = _PU(0x00B9U),
    /** Select disc (NAry) */
    HIDRD_USAGE_CONSUMER_SELECT_DISC = _PU(0x00BAU),
    /** Enter disc (MC) */
    HIDRD_USAGE_CONSUMER_ENTER_DISC = _PU(0x00BBU),
    /** Repeat (OSC) */
    HIDRD_USAGE_CONSUMER_REPEAT = _PU(0x00BCU),
    /** Tracking (LC) */
    HIDRD_USAGE_CONSUMER_TRACKING = _PU(0x00BDU),
    /** Track normal (OSC) */
    HIDRD_USAGE_CONSUMER_TRACK_NORMAL = _PU(0x00BEU),
    /** Slow tracking (LC) */
    HIDRD_USAGE_CONSUMER_SLOW_TRACKING = _PU(0x00BFU),
    /** Frame forward (RTC) */
    HIDRD_USAGE_CONSUMER_FRAME_FORWARD = _PU(0x00C0U),
    /** Frame back (RTC) */
    HIDRD_USAGE_CONSUMER_FRAME_BACK = _PU(0x00C1U),
    /** Mark (OSC) */
    HIDRD_USAGE_CONSUMER_MARK = _PU(0x00C2U),
    /** Clear mark (OSC) */
    HIDRD_USAGE_CONSUMER_CLEAR_MARK = _PU(0x00C3U),
    /** Repeat from mark (OOC) */
    HIDRD_USAGE_CONSUMER_REPEAT_FROM_MARK = _PU(0x00C4U),
    /** Return to mark (OSC) */
    HIDRD_USAGE_CONSUMER_RETURN_TO_MARK = _PU(0x00C5U),
    /** Search mark forward (OSC) */
    HIDRD_USAGE_CONSUMER_SEARCH_MARK_FORWARD = _PU(0x00C6U),
    /** Search mark backwards (OSC) */
    HIDRD_USAGE_CONSUMER_SEARCH_MARK_BACKWARDS = _PU(0x00C7U),
    /** Counter Reset (OSC) */
    HIDRD_USAGE_CONSUMER_COUNTER_RESET = _PU(0x00C8U),
    /** Show counter (OSC) */
    HIDRD_USAGE_CONSUMER_SHOW_COUNTER = _PU(0x00C9U),
    /** Tracking increment (RTC) */
    HIDRD_USAGE_CONSUMER_TRACKING_INC = _PU(0x00CAU),
    /** Tracking decrement (RTC) */
    HIDRD_USAGE_CONSUMER_TRACKING_DEC = _PU(0x00CBU),
    /** Stop/eject (OSC) */
    HIDRD_USAGE_CONSUMER_STOP_EJECT = _PU(0x00CCU),
    /** Play/pause (OSC) */
    HIDRD_USAGE_CONSUMER_PLAY_PAUSE = _PU(0x00CDU),
    /** Play/skip (OSC) */
    HIDRD_USAGE_CONSUMER_PLAY_SKIP = _PU(0x00CEU),
    /** Volume (LC) */
    HIDRD_USAGE_CONSUMER_VOLUME = _PU(0x00E0U),
    /** Balance (LC) */
    HIDRD_USAGE_CONSUMER_BALANCE = _PU(0x00E1U),
    /** Mute (OOC) */
    HIDRD_USAGE_CONSUMER_MUTE = _PU(0x00E2U),
    /** Bass (LC) */
    HIDRD_USAGE_CONSUMER_BASS = _PU(0x00E3U),
    /** Treble (LC) */
    HIDRD_USAGE_CONSUMER_TREBLE = _PU(0x00E4U),
    /** Bass boost (OOC) */
    HIDRD_USAGE_CONSUMER_BASS_BOOST = _PU(0x00E5U),
    /** Surround mode (OSC) */
    HIDRD_USAGE_CONSUMER_SURROUND_MODE = _PU(0x00E6U),
    /** Loudness (OOC) */
    HIDRD_USAGE_CONSUMER_LOUDNESS = _PU(0x00E7U),
    /** MPX (OOC) */
    HIDRD_USAGE_CONSUMER_MPX = _PU(0x00E8U),
    /** Volume increment (RTC) */
    HIDRD_USAGE_CONSUMER_VOLUME_INC = _PU(0x00E9U),
    /** Volume decrement (RTC) */
    HIDRD_USAGE_CONSUMER_VOLUME_DEC = _PU(0x00EAU),
    /** Speed select (OSC) */
    HIDRD_USAGE_CONSUMER_SPEED_SELECT = _PU(0x00F0U),
    /** Playback speed (NAry) */
    HIDRD_USAGE_CONSUMER_PLAYBACK_SPEED = _PU(0x00F1U),
    /** Standard play (Sel) */
    HIDRD_USAGE_CONSUMER_STANDARD_PLAY = _PU(0x00F2U),
    /** Long play (Sel) */
    HIDRD_USAGE_CONSUMER_LONG_PLAY = _PU(0x00F3U),
    /** Extended play (Sel) */
    HIDRD_USAGE_CONSUMER_EXTENDED_PLAY = _PU(0x00F4U),
    /** Slow (OSC) */
    HIDRD_USAGE_CONSUMER_SLOW = _PU(0x00F5U),
    /** Fan enable (OOC) */
    HIDRD_USAGE_CONSUMER_FAN_ENABLE = _PU(0x0100U),
    /** Fan speed (LC) */
    HIDRD_USAGE_CONSUMER_FAN_SPEED = _PU(0x0101U),
    /** Light enable (OOC) */
    HIDRD_USAGE_CONSUMER_LIGHT_ENABLE = _PU(0x0102U),
    /** Light illumination level (LC) */
    HIDRD_USAGE_CONSUMER_LIGHT_ILLUMINATION_LEVEL = _PU(0x0103U),
    /** Climate control enable (OOC) */
    HIDRD_USAGE_CONSUMER_CLIMATE_CONTROL_ENABLE = _PU(0x0104U),
    /** Room temperature (LC) */
    HIDRD_USAGE_CONSUMER_ROOM_TEMPERATURE = _PU(0x0105U),
    /** Security enable (OOC) */
    HIDRD_USAGE_CONSUMER_SECURITY_ENABLE = _PU(0x0106U),
    /** Fire alarm (OSC) */
    HIDRD_USAGE_CONSUMER_FIRE_ALARM = _PU(0x0107U),
    /** Police alarm (OSC) */
    HIDRD_USAGE_CONSUMER_POLICE_ALARM = _PU(0x0108U),
    /** Proximity (LC) */
    HIDRD_USAGE_CONSUMER_PROXIMITY = _PU(0x0109U),
    /** Motion (OSC) */
    HIDRD_USAGE_CONSUMER_MOTION = _PU(0x010AU),
    /** Duress alarm (OSC) */
    HIDRD_USAGE_CONSUMER_DURESS_ALARM = _PU(0x010BU),
    /** Holdup alarm (OSC) */
    HIDRD_USAGE_CONSUMER_HOLDUP_ALARM = _PU(0x010CU),
    /** Medical alarm (OSC) */
    HIDRD_USAGE_CONSUMER_MEDICAL_ALARM = _PU(0x010DU),
    /** Balance right (RTC) */
    HIDRD_USAGE_CONSUMER_BALANCE_RIGHT = _PU(0x0150U),
    /** Balance left (RTC) */
    HIDRD_USAGE_CONSUMER_BALANCE_LEFT = _PU(0x0151U),
    /** Bass increment (RTC) */
    HIDRD_USAGE_CONSUMER_BASS_INC = _PU(0x0152U),
    /** Bass decrement (RTC) */
    HIDRD_USAGE_CONSUMER_BASS_DEC = _PU(0x0153U),
    /** Treble increment (RTC) */
    HIDRD_USAGE_CONSUMER_TREBLE_INC = _PU(0x0154U),
    /** Treble decrement (RTC) */
    HIDRD_USAGE_CONSUMER_TREBLE_DEC = _PU(0x0155U),
    /** Speaker system (CL) */
    HIDRD_USAGE_CONSUMER_SPEAKER_SYSTEM = _PU(0x0160U),
    /** Channel left (CL) */
    HIDRD_USAGE_CONSUMER_CHANNEL_LEFT = _PU(0x0161U),
    /** Channel right (CL) */
    HIDRD_USAGE_CONSUMER_CHANNEL_RIGHT = _PU(0x0162U),
    /** Channel center (CL) */
    HIDRD_USAGE_CONSUMER_CHANNEL_CENTER = _PU(0x0163U),
    /** Channel front (CL) */
    HIDRD_USAGE_CONSUMER_CHANNEL_FRONT = _PU(0x0164U),
    /** Channel center front (CL) */
    HIDRD_USAGE_CONSUMER_CHANNEL_CENTER_FRONT = _PU(0x0165U),
    /** Channel side (CL) */
    HIDRD_USAGE_CONSUMER_CHANNEL_SIDE = _PU(0x0166U),
    /** Channel surround (CL) */
    HIDRD_USAGE_CONSUMER_CHANNEL_SURROUND = _PU(0x0167U),
    /** Channel low frequency enhancement (CL) */
    HIDRD_USAGE_CONSUMER_CHANNEL_LOW_FREQ_ENHAN = _PU(0x0168U),
    /** Channel top (CL) */
    HIDRD_USAGE_CONSUMER_CHANNEL_TOP = _PU(0x0169U),
    /** Channel unknown (CL) */
    HIDRD_USAGE_CONSUMER_CHANNEL_UNKNOWN = _PU(0x016AU),
    /** Sub-channel (LC) */
    HIDRD_USAGE_CONSUMER_SUBCHANNEL = _PU(0x0170U),
    /** Sub-channel increment (OSC) */
    HIDRD_USAGE_CONSUMER_SUBCHANNEL_INC = _PU(0x0171U),
    /** Sub-channel decrement (OSC) */
    HIDRD_USAGE_CONSUMER_SUBCHANNEL_DEC = _PU(0x0172U),
    /** Alternate audio increment (OSC) */
    HIDRD_USAGE_CONSUMER_ALTERNATE_AUDIO_INC = _PU(0x0173U),
    /** Alternate audio decrement (OSC) */
    HIDRD_USAGE_CONSUMER_ALTERNATE_AUDIO_DEC = _PU(0x0174U),
    /** Application launch buttons (NAry) */
    HIDRD_USAGE_CONSUMER_APP_LAUNCH_BUTTONS = _PU(0x0180U),
    /** AL launch button configuration tool (Sel) */
    HIDRD_USAGE_CONSUMER_AL_LAUNCH_BUTTON_CONFIG_TOOL = _PU(0x0181U),
    /** AL programmable button configuration (Sel) */
    HIDRD_USAGE_CONSUMER_AL_PROGRAMMABLE_BUTTON_CONFIG = _PU(0x0182U),
    /** AL consumer control configuration (Sel) */
    HIDRD_USAGE_CONSUMER_AL_CONSUMER_CONTROL_CONFIG = _PU(0x0183U),
    /** AL word processor (Sel) */
    HIDRD_USAGE_CONSUMER_AL_WORD_PROC = _PU(0x0184U),
    /** AL text editor (Sel) */
    HIDRD_USAGE_CONSUMER_AL_TEXT_EDITOR = _PU(0x0185U),
    /** AL spreadsheet (Sel) */
    HIDRD_USAGE_CONSUMER_AL_SPREADSHEET = _PU(0x0186U),
    /** AL graphics editor (Sel) */
    HIDRD_USAGE_CONSUMER_AL_GRAPHICS_EDITOR = _PU(0x0187U),
    /** AL presentation app (Sel) */
    HIDRD_USAGE_CONSUMER_AL_PRESENTATION_APP = _PU(0x0188U),
    /** AL database app (Sel) */
    HIDRD_USAGE_CONSUMER_AL_DATABASE_APP = _PU(0x0189U),
    /** AL email reader (Sel) */
    HIDRD_USAGE_CONSUMER_AL_EMAIL_READER = _PU(0x018AU),
    /** AL newsreader (Sel) */
    HIDRD_USAGE_CONSUMER_AL_NEWSREADER = _PU(0x018BU),
    /** AL voicemail (Sel) */
    HIDRD_USAGE_CONSUMER_AL_VOICEMAIL = _PU(0x018CU),
    /** AL contacts/address book (Sel) */
    HIDRD_USAGE_CONSUMER_AL_CONTACTS_OR_ADDRESS_BOOK = _PU(0x018DU),
    /** AL calendar/schedule (Sel) */
    HIDRD_USAGE_CONSUMER_AL_CALENDAR_OR_SCHEDULE = _PU(0x018EU),
    /** AL task/project manager (Sel) */
    HIDRD_USAGE_CONSUMER_AL_TASK_OR_PROJECT_MNGR = _PU(0x018FU),
    /** AL log/journal/timecard (Sel) */
    HIDRD_USAGE_CONSUMER_AL_LOG_OR_JOURNAL_OR_TIMECARD = _PU(0x0190U),
    /** AL checkbook/finance (Sel) */
    HIDRD_USAGE_CONSUMER_AL_CHECKBOOK_OR_FINANCE = _PU(0x0191U),
    /** AL calculator (Sel) */
    HIDRD_USAGE_CONSUMER_AL_CALCULATOR = _PU(0x0192U),
    /** AL A/V capture/playback (Sel) */
    HIDRD_USAGE_CONSUMER_AL_AV_CAPTURE_OR_PLAYBACK = _PU(0x0193U),
    /** AL local machine browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_LOCAL_MACHINE_BRWSR = _PU(0x0194U),
    /** AL LAN/WAN browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_LAN_OR_WAN_BRWSR = _PU(0x0195U),
    /** AL Internet browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_INTERNET_BRWSR = _PU(0x0196U),
    /** AL remote networking/ISP connect (Sel) */
    HIDRD_USAGE_CONSUMER_AL_REMOTE_NET_OR_ISP_CONNECT = _PU(0x0197U),
    /** AL network conference (Sel) */
    HIDRD_USAGE_CONSUMER_AL_NETWORK_CONFERENCE = _PU(0x0198U),
    /** AL network chat (Sel) */
    HIDRD_USAGE_CONSUMER_AL_NETWORK_CHAT = _PU(0x0199U),
    /** AL telephony/dialer (Sel) */
    HIDRD_USAGE_CONSUMER_AL_TELEPHONY_OR_DIALER = _PU(0x019AU),
    /** AL logon (Sel) */
    HIDRD_USAGE_CONSUMER_AL_LOGON = _PU(0x019BU),
    /** AL logoff (Sel) */
    HIDRD_USAGE_CONSUMER_AL_LOGOFF = _PU(0x019CU),
    /** AL logon/logoff (Sel) */
    HIDRD_USAGE_CONSUMER_AL_LOGON_OR_LOGOFF = _PU(0x019DU),
    /** AL terminal lock/screensaver (Sel) */
    HIDRD_USAGE_CONSUMER_AL_TERM_LOCK_OR_SCREENSAVER = _PU(0x019EU),
    /** AL control panel (Sel) */
    HIDRD_USAGE_CONSUMER_AL_CONTROL_PANEL = _PU(0x019FU),
    /** AL command line processor/run (Sel) */
    HIDRD_USAGE_CONSUMER_AL_CMD_LINE_PROC_OR_RUN = _PU(0x01A0U),
    /** AL process/task manager (Sel) */
    HIDRD_USAGE_CONSUMER_AL_PROC_OR_TASK_MNGR = _PU(0x01A1U),
    /** AL select task/application (Sel) */
    HIDRD_USAGE_CONSUMER_AL_SELECT_TASK_OR_APP = _PU(0x01A2U),
    /** AL next task/application (Sel) */
    HIDRD_USAGE_CONSUMER_AL_NEXT_TASK_OR_APP = _PU(0x01A3U),
    /** AL previous task/application (Sel) */
    HIDRD_USAGE_CONSUMER_AL_PREVIOUS_TASK_OR_APP = _PU(0x01A4U),
    /** AL preemptive halt task/application (Sel) */
    HIDRD_USAGE_CONSUMER_AL_PREEMPTIVE_HALT_TASK_OR_APP = _PU(0x01A5U),
    /** AL integrated help center (Sel) */
    HIDRD_USAGE_CONSUMER_AL_INTEGRATED_HELP_CENTER = _PU(0x01A6U),
    /** AL documents (Sel) */
    HIDRD_USAGE_CONSUMER_AL_DOCUMENTS = _PU(0x01A7U),
    /** AL thesaurus (Sel) */
    HIDRD_USAGE_CONSUMER_AL_THESAURUS = _PU(0x01A8U),
    /** AL dictionary (Sel) */
    HIDRD_USAGE_CONSUMER_AL_DICTIONARY = _PU(0x01A9U),
    /** AL desktop (Sel) */
    HIDRD_USAGE_CONSUMER_AL_DESKTOP = _PU(0x01AAU),
    /** AL spell check (Sel) */
    HIDRD_USAGE_CONSUMER_AL_SPELL_CHECK = _PU(0x01ABU),
    /** AL grammar check (Sel) */
    HIDRD_USAGE_CONSUMER_AL_GRAMMAR_CHECK = _PU(0x01ACU),
    /** AL wireless status (Sel) */
    HIDRD_USAGE_CONSUMER_AL_WIRELESS_STATUS = _PU(0x01ADU),
    /** AL keyboard layout (Sel) */
    HIDRD_USAGE_CONSUMER_AL_KEYBOARD_LAYOUT = _PU(0x01AEU),
    /** AL virus protection (Sel) */
    HIDRD_USAGE_CONSUMER_AL_VIRUS_PROTECTION = _PU(0x01AFU),
    /** AL encryption (Sel) */
    HIDRD_USAGE_CONSUMER_AL_ENCRYPTION = _PU(0x01B0U),
    /** AL screen saver (Sel) */
    HIDRD_USAGE_CONSUMER_AL_SCREEN_SAVER = _PU(0x01B1U),
    /** AL alarms (Sel) */
    HIDRD_USAGE_CONSUMER_AL_ALARMS = _PU(0x01B2U),
    /** AL clock (Sel) */
    HIDRD_USAGE_CONSUMER_AL_CLOCK = _PU(0x01B3U),
    /** AL file browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_FILE_BRWSR = _PU(0x01B4U),
    /** AL power status (Sel) */
    HIDRD_USAGE_CONSUMER_AL_POWER_STATUS = _PU(0x01B5U),
    /** AL image browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_IMAGE_BRWSR = _PU(0x01B6U),
    /** AL audio browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_AUDIO_BRWSR = _PU(0x01B7U),
    /** AL movie browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_MOVIE_BRWSR = _PU(0x01B8U),
    /** AL digital rights manager (Sel) */
    HIDRD_USAGE_CONSUMER_AL_DIGITAL_RIGHTS_MNGR = _PU(0x01B9U),
    /** AL digital wallet (Sel) */
    HIDRD_USAGE_CONSUMER_AL_DIGITAL_WALLET = _PU(0x01BAU),
    /** AL instant messaging (Sel) */
    HIDRD_USAGE_CONSUMER_AL_INSTANT_MESSAGING = _PU(0x01BCU),
    /** AL OEM features/tips/tutorial browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_OEM_FEATS_BRWSR = _PU(0x01BDU),
    /** AL OEM help (Sel) */
    HIDRD_USAGE_CONSUMER_AL_OEM_HELP = _PU(0x01BEU),
    /** AL online community (Sel) */
    HIDRD_USAGE_CONSUMER_AL_ONLINE_COMMUNITY = _PU(0x01BFU),
    /** AL entertainment content browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_ENT_CONTENT_BRWSR = _PU(0x01C0U),
    /** AL online shopping browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_ONLINE_SHOPPING_BRWSR = _PU(0x01C1U),
    /** AL smartcard information/help (Sel) */
    HIDRD_USAGE_CONSUMER_AL_SMARTCARD_INFO_OR_HELP = _PU(0x01C2U),
    /** AL market monitor/finance browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_MRKT_MON_OR_FIN_BRWSR = _PU(0x01C3U),
    /** AL customized corporate news browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_CUSTOM_CORP_NEWS_BRWSR = _PU(0x01C4U),
    /** AL online activity browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_ONLINE_ACTIVITY_BRWSR = _PU(0x01C5U),
    /** AL research/search browser (Sel) */
    HIDRD_USAGE_CONSUMER_AL_RESEARCH_OR_SEARCH_BRWSR = _PU(0x01C6U),
    /** AL audio player (Sel) */
    HIDRD_USAGE_CONSUMER_AL_AUDIO_PLAYER = _PU(0x01C7U),
    /** Generic GUI application controls (Nary) */
    HIDRD_USAGE_CONSUMER_GENERIC_GUI_APP_CONTROLS = _PU(0x0200U),
    /** AC new (Sel) */
    HIDRD_USAGE_CONSUMER_AC_NEW = _PU(0x0201U),
    /** AC open (Sel) */
    HIDRD_USAGE_CONSUMER_AC_OPEN = _PU(0x0202U),
    /** AC close (Sel) */
    HIDRD_USAGE_CONSUMER_AC_CLOSE = _PU(0x0203U),
    /** AC exit (Sel) */
    HIDRD_USAGE_CONSUMER_AC_EXIT = _PU(0x0204U),
    /** AC maximize (Sel) */
    HIDRD_USAGE_CONSUMER_AC_MAXIMIZE = _PU(0x0205U),
    /** AC minimize (Sel) */
    HIDRD_USAGE_CONSUMER_AC_MINIMIZE = _PU(0x0206U),
    /** AC save (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SAVE = _PU(0x0207U),
    /** AC print (Sel) */
    HIDRD_USAGE_CONSUMER_AC_PRINT = _PU(0x0208U),
    /** AC properties (Sel) */
    HIDRD_USAGE_CONSUMER_AC_PROPERTIES = _PU(0x0209U),
    /** AC undo (Sel) */
    HIDRD_USAGE_CONSUMER_AC_UNDO = _PU(0x021AU),
    /** AC copy (Sel) */
    HIDRD_USAGE_CONSUMER_AC_COPY = _PU(0x021BU),
    /** AC cut (Sel) */
    HIDRD_USAGE_CONSUMER_AC_CUT = _PU(0x021CU),
    /** AC paste (Sel) */
    HIDRD_USAGE_CONSUMER_AC_PASTE = _PU(0x021DU),
    /** AC select all (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SELECT_ALL = _PU(0x021EU),
    /** AC find (Sel) */
    HIDRD_USAGE_CONSUMER_AC_FIND = _PU(0x021FU),
    /** AC find and replace (Sel) */
    HIDRD_USAGE_CONSUMER_AC_FIND_AND_REPLACE = _PU(0x0220U),
    /** AC search (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SEARCH = _PU(0x0221U),
    /** AC go to (Sel) */
    HIDRD_USAGE_CONSUMER_AC_GO_TO = _PU(0x0222U),
    /** AC home (Sel) */
    HIDRD_USAGE_CONSUMER_AC_HOME = _PU(0x0223U),
    /** AC back (Sel) */
    HIDRD_USAGE_CONSUMER_AC_BACK = _PU(0x0224U),
    /** AC forward (Sel) */
    HIDRD_USAGE_CONSUMER_AC_FORWARD = _PU(0x0225U),
    /** AC stop (Sel) */
    HIDRD_USAGE_CONSUMER_AC_STOP = _PU(0x0226U),
    /** AC refresh (Sel) */
    HIDRD_USAGE_CONSUMER_AC_REFRESH = _PU(0x0227U),
    /** AC previous link (Sel) */
    HIDRD_USAGE_CONSUMER_AC_PREVIOUS_LINK = _PU(0x0228U),
    /** AC next link (Sel) */
    HIDRD_USAGE_CONSUMER_AC_NEXT_LINK = _PU(0x0229U),
    /** AC bookmarks (Sel) */
    HIDRD_USAGE_CONSUMER_AC_BOOKMARKS = _PU(0x022AU),
    /** AC history (Sel) */
    HIDRD_USAGE_CONSUMER_AC_HISTORY = _PU(0x022BU),
    /** AC subscriptions (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SUBSCRIPTIONS = _PU(0x022CU),
    /** AC zoom in (Sel) */
    HIDRD_USAGE_CONSUMER_AC_ZOOM_IN = _PU(0x022DU),
    /** AC zoom out (Sel) */
    HIDRD_USAGE_CONSUMER_AC_ZOOM_OUT = _PU(0x022EU),
    /** AC zoom (LC) */
    HIDRD_USAGE_CONSUMER_AC_ZOOM = _PU(0x022FU),
    /** AC full screen view (Sel) */
    HIDRD_USAGE_CONSUMER_AC_FULL_SCREEN_VIEW = _PU(0x0230U),
    /** AC normal view (Sel) */
    HIDRD_USAGE_CONSUMER_AC_NORMAL_VIEW = _PU(0x0231U),
    /** AC view toggle (Sel) */
    HIDRD_USAGE_CONSUMER_AC_VIEW_TOGGLE = _PU(0x0232U),
    /** AC scroll up (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SCROLL_UP = _PU(0x0233U),
    /** AC scroll down (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SCROLL_DOWN = _PU(0x0234U),
    /** AC scroll (LC) */
    HIDRD_USAGE_CONSUMER_AC_SCROLL = _PU(0x0235U),
    /** AC pan left (Sel) */
    HIDRD_USAGE_CONSUMER_AC_PAN_LEFT = _PU(0x0236U),
    /** AC pan right (Sel) */
    HIDRD_USAGE_CONSUMER_AC_PAN_RIGHT = _PU(0x0237U),
    /** AC pan (LC) */
    HIDRD_USAGE_CONSUMER_AC_PAN = _PU(0x0238U),
    /** AC new window (Sel) */
    HIDRD_USAGE_CONSUMER_AC_NEW_WINDOW = _PU(0x0239U),
    /** AC tile horizontally (Sel) */
    HIDRD_USAGE_CONSUMER_AC_TILE_HORIZ = _PU(0x023AU),
    /** AC tile vertically (Sel) */
    HIDRD_USAGE_CONSUMER_AC_TILE_VERT = _PU(0x023BU),
    /** AC format (Sel) */
    HIDRD_USAGE_CONSUMER_AC_FORMAT = _PU(0x023CU),
    /** AC edit (Sel) */
    HIDRD_USAGE_CONSUMER_AC_EDIT = _PU(0x023DU),
    /** AC bold (Sel) */
    HIDRD_USAGE_CONSUMER_AC_BOLD = _PU(0x023EU),
    /** AC italics (Sel) */
    HIDRD_USAGE_CONSUMER_AC_ITALICS = _PU(0x023FU),
    /** AC underline (Sel) */
    HIDRD_USAGE_CONSUMER_AC_UNDERLINE = _PU(0x0240U),
    /** AC strikethrough (Sel) */
    HIDRD_USAGE_CONSUMER_AC_STRIKETHROUGH = _PU(0x0241U),
    /** AC subscript (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SUBSCRIPT = _PU(0x0242U),
    /** AC superscript (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SUPERSCRIPT = _PU(0x0243U),
    /** AC all caps (Sel) */
    HIDRD_USAGE_CONSUMER_AC_ALL_CAPS = _PU(0x0244U),
    /** AC rotate (Sel) */
    HIDRD_USAGE_CONSUMER_AC_ROTATE = _PU(0x0245U),
    /** AC resize (Sel) */
    HIDRD_USAGE_CONSUMER_AC_RESIZE = _PU(0x0246U),
    /** AC flip horizontal (Sel) */
    HIDRD_USAGE_CONSUMER_AC_FLIP_HORIZ = _PU(0x0247U),
    /** AC flip vertical (Sel) */
    HIDRD_USAGE_CONSUMER_AC_FLIP_VERT = _PU(0x0248U),
    /** AC mirror horizontal (Sel) */
    HIDRD_USAGE_CONSUMER_AC_MIRROR_HORIZ = _PU(0x0249U),
    /** AC mirror vertical (Sel) */
    HIDRD_USAGE_CONSUMER_AC_MIRROR_VERT = _PU(0x024AU),
    /** AC font select (Sel) */
    HIDRD_USAGE_CONSUMER_AC_FONT_SELECT = _PU(0x024BU),
    /** AC font color (Sel) */
    HIDRD_USAGE_CONSUMER_AC_FONT_COLOR = _PU(0x024CU),
    /** AC font size (Sel) */
    HIDRD_USAGE_CONSUMER_AC_FONT_SIZE = _PU(0x024DU),
    /** AC justify left (Sel) */
    HIDRD_USAGE_CONSUMER_AC_JUSTIFY_LEFT = _PU(0x024EU),
    /** AC justify center H (Sel) */
    HIDRD_USAGE_CONSUMER_AC_JUSTIFY_CENTER_H = _PU(0x024FU),
    /** AC justify right (Sel) */
    HIDRD_USAGE_CONSUMER_AC_JUSTIFY_RIGHT = _PU(0x0250U),
    /** AC justify block H (Sel) */
    HIDRD_USAGE_CONSUMER_AC_JUSTIFY_BLOCK_H = _PU(0x0251U),
    /** AC justify top (Sel) */
    HIDRD_USAGE_CONSUMER_AC_JUSTIFY_TOP = _PU(0x0252U),
    /** AC justify center V (Sel) */
    HIDRD_USAGE_CONSUMER_AC_JUSTIFY_CENTER_V = _PU(0x0253U),
    /** AC justify bottom (Sel) */
    HIDRD_USAGE_CONSUMER_AC_JUSTIFY_BOTTOM = _PU(0x0254U),
    /** AC justify block V (Sel) */
    HIDRD_USAGE_CONSUMER_AC_JUSTIFY_BLOCK_V = _PU(0x0255U),
    /** AC indent decrease (Sel) */
    HIDRD_USAGE_CONSUMER_AC_INDENT_DEC = _PU(0x0256U),
    /** AC indent increase (Sel) */
    HIDRD_USAGE_CONSUMER_AC_INDENT_INC = _PU(0x0257U),
    /** AC numbered list (Sel) */
    HIDRD_USAGE_CONSUMER_AC_NUMBERED_LIST = _PU(0x0258U),
    /** AC restart numbering (Sel) */
    HIDRD_USAGE_CONSUMER_AC_RESTART_NUMBERING = _PU(0x0259U),
    /** AC bulleted list (Sel) */
    HIDRD_USAGE_CONSUMER_AC_BULLETED_LIST = _PU(0x025AU),
    /** AC promote (Sel) */
    HIDRD_USAGE_CONSUMER_AC_PROMOTE = _PU(0x025BU),
    /** AC demote (Sel) */
    HIDRD_USAGE_CONSUMER_AC_DEMOTE = _PU(0x025CU),
    /** AC yes (Sel) */
    HIDRD_USAGE_CONSUMER_AC_YES = _PU(0x025DU),
    /** AC no (Sel) */
    HIDRD_USAGE_CONSUMER_AC_NO = _PU(0x025EU),
    /** AC cancel (Sel) */
    HIDRD_USAGE_CONSUMER_AC_CANCEL = _PU(0x025FU),
    /** AC catalog (Sel) */
    HIDRD_USAGE_CONSUMER_AC_CATALOG = _PU(0x0260U),
    /** AC buy/checkout (Sel) */
    HIDRD_USAGE_CONSUMER_AC_BUY_OR_CHECKOUT = _PU(0x0261U),
    /** AC add to cart (Sel) */
    HIDRD_USAGE_CONSUMER_AC_ADD_TO_CART = _PU(0x0262U),
    /** AC expand (Sel) */
    HIDRD_USAGE_CONSUMER_AC_EXPAND = _PU(0x0263U),
    /** AC expand all (Sel) */
    HIDRD_USAGE_CONSUMER_AC_EXPAND_ALL = _PU(0x0264U),
    /** AC collapse (Sel) */
    HIDRD_USAGE_CONSUMER_AC_COLLAPSE = _PU(0x0265U),
    /** AC collapse all (Sel) */
    HIDRD_USAGE_CONSUMER_AC_COLLAPSE_ALL = _PU(0x0266U),
    /** AC print preview (Sel) */
    HIDRD_USAGE_CONSUMER_AC_PRINT_PREVIEW = _PU(0x0267U),
    /** AC paste special (Sel) */
    HIDRD_USAGE_CONSUMER_AC_PASTE_SPECIAL = _PU(0x0268U),
    /** AC insert mode (Sel) */
    HIDRD_USAGE_CONSUMER_AC_INSERT_MODE = _PU(0x0269U),
    /** AC delete (Sel) */
    HIDRD_USAGE_CONSUMER_AC_DELETE = _PU(0x026AU),
    /** AC lock (Sel) */
    HIDRD_USAGE_CONSUMER_AC_LOCK = _PU(0x026BU),
    /** AC unlock (Sel) */
    HIDRD_USAGE_CONSUMER_AC_UNLOCK = _PU(0x026CU),
    /** AC protect (Sel) */
    HIDRD_USAGE_CONSUMER_AC_PROTECT = _PU(0x026DU),
    /** AC unprotect (Sel) */
    HIDRD_USAGE_CONSUMER_AC_UNPROTECT = _PU(0x026EU),
    /** AC attach comment (Sel) */
    HIDRD_USAGE_CONSUMER_AC_ATTACH_COMMENT = _PU(0x026FU),
    /** AC delete comment (Sel) */
    HIDRD_USAGE_CONSUMER_AC_DELETE_COMMENT = _PU(0x0270U),
    /** AC view comment (Sel) */
    HIDRD_USAGE_CONSUMER_AC_VIEW_COMMENT = _PU(0x0271U),
    /** AC select word (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SELECT_WORD = _PU(0x0272U),
    /** AC select sentence (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SELECT_SENTENCE = _PU(0x0273U),
    /** AC select paragraph (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SELECT_PARAGRAPH = _PU(0x0274U),
    /** AC select column (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SELECT_COLUMN = _PU(0x0275U),
    /** AC select row (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SELECT_ROW = _PU(0x0276U),
    /** AC select table (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SELECT_TABLE = _PU(0x0277U),
    /** AC select object (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SELECT_OBJECT = _PU(0x0278U),
    /** AC redo/repeat (Sel) */
    HIDRD_USAGE_CONSUMER_AC_REDO_OR_REPEAT = _PU(0x0279U),
    /** AC sort (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SORT = _PU(0x027AU),
    /** AC sort ascending (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SORT_ASCENDING = _PU(0x027BU),
    /** AC sort descending (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SORT_DESCENDING = _PU(0x027CU),
    /** AC filter (Sel) */
    HIDRD_USAGE_CONSUMER_AC_FILTER = _PU(0x027DU),
    /** AC set clock (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SET_CLOCK = _PU(0x027EU),
    /** AC view clock (Sel) */
    HIDRD_USAGE_CONSUMER_AC_VIEW_CLOCK = _PU(0x027FU),
    /** AC select time zone (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SELECT_TIME_ZONE = _PU(0x0280U),
    /** AC edit time zones (Sel) */
    HIDRD_USAGE_CONSUMER_AC_EDIT_TIME_ZONES = _PU(0x0281U),
    /** AC set alarm (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SET_ALARM = _PU(0x0282U),
    /** AC clear alarm (Sel) */
    HIDRD_USAGE_CONSUMER_AC_CLEAR_ALARM = _PU(0x0283U),
    /** AC snooze alarm (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SNOOZE_ALARM = _PU(0x0284U),
    /** AC reset alarm (Sel) */
    HIDRD_USAGE_CONSUMER_AC_RESET_ALARM = _PU(0x0285U),
    /** AC synchronize (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SYNCHRONIZE = _PU(0x0286U),
    /** AC send/receive (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SEND_OR_RECEIVE = _PU(0x0287U),
    /** AC send to (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SEND_TO = _PU(0x0288U),
    /** AC reply (Sel) */
    HIDRD_USAGE_CONSUMER_AC_REPLY = _PU(0x0289U),
    /** AC reply all (Sel) */
    HIDRD_USAGE_CONSUMER_AC_REPLY_ALL = _PU(0x028AU),
    /** AC forward msg (Sel) */
    HIDRD_USAGE_CONSUMER_AC_FORWARD_MSG = _PU(0x028BU),
    /** AC send (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SEND = _PU(0x028CU),
    /** AC attach file (Sel) */
    HIDRD_USAGE_CONSUMER_AC_ATTACH_FILE = _PU(0x028DU),
    /** AC upload (Sel) */
    HIDRD_USAGE_CONSUMER_AC_UPLOAD = _PU(0x028EU),
    /** AC download (save target as) (Sel) */
    HIDRD_USAGE_CONSUMER_AC_DOWNLOAD_AND_SAVE_AS = _PU(0x028FU),
    /** AC set borders (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SET_BORDERS = _PU(0x0290U),
    /** AC insert row (Sel) */
    HIDRD_USAGE_CONSUMER_AC_INSERT_ROW = _PU(0x0291U),
    /** AC insert column (Sel) */
    HIDRD_USAGE_CONSUMER_AC_INSERT_COLUMN = _PU(0x0292U),
    /** AC insert file (Sel) */
    HIDRD_USAGE_CONSUMER_AC_INSERT_FILE = _PU(0x0293U),
    /** AC insert picture (Sel) */
    HIDRD_USAGE_CONSUMER_AC_INSERT_PICTURE = _PU(0x0294U),
    /** AC insert object (Sel) */
    HIDRD_USAGE_CONSUMER_AC_INSERT_OBJECT = _PU(0x0295U),
    /** AC insert symbol (Sel) */
    HIDRD_USAGE_CONSUMER_AC_INSERT_SYMBOL = _PU(0x0296U),
    /** AC save and close (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SAVE_AND_CLOSE = _PU(0x0297U),
    /** AC rename (Sel) */
    HIDRD_USAGE_CONSUMER_AC_RENAME = _PU(0x0298U),
    /** AC merge (Sel) */
    HIDRD_USAGE_CONSUMER_AC_MERGE = _PU(0x0299U),
    /** AC split (Sel) */
    HIDRD_USAGE_CONSUMER_AC_SPLIT = _PU(0x029AU),
    /** AC disribute horizontally (Sel) */
    HIDRD_USAGE_CONSUMER_AC_DISRIBUTE_HORIZ = _PU(0x029BU),
    /** AC distribute vertically (Sel) */
    HIDRD_USAGE_CONSUMER_AC_DISTRIBUTE_VERT = _PU(0x029CU),

#undef _PU

    /*
     * Digitizer page
     */
#define _PU(_id) _U(DIGITIZER, _id)

    /** Digitizer (CA) */
    HIDRD_USAGE_DIGITIZER_DIGITIZER = _PU(0x0001U),
    /** Pen (CA) */
    HIDRD_USAGE_DIGITIZER_PEN = _PU(0x0002U),
    /** Light pen (CA) */
    HIDRD_USAGE_DIGITIZER_LIGHT_PEN = _PU(0x0003U),
    /** Touch screen (CA) */
    HIDRD_USAGE_DIGITIZER_TOUCHSCREEN = _PU(0x0004U),
    /** Touch pad (CA) */
    HIDRD_USAGE_DIGITIZER_TOUCHPAD = _PU(0x0005U),
    /** White board (CA) */
    HIDRD_USAGE_DIGITIZER_WHITEBOARD = _PU(0x0006U),
    /** Coordinate measuring machine (CA) */
    HIDRD_USAGE_DIGITIZER_COORD_MEASURING_MACHINE = _PU(0x0007U),
    /** 3D digitizer (CA) */
    HIDRD_USAGE_DIGITIZER_3D_DIGITIZER = _PU(0x0008U),
    /** Stereo plotter (CA) */
    HIDRD_USAGE_DIGITIZER_STEREO_PLOTTER = _PU(0x0009U),
    /** Articulated arm (CA) */
    HIDRD_USAGE_DIGITIZER_ARTICULATED_ARM = _PU(0x000AU),
    /** Armature (CA) */
    HIDRD_USAGE_DIGITIZER_ARMATURE = _PU(0x000BU),
    /** Multiple point digitizer (CA) */
    HIDRD_USAGE_DIGITIZER_MULTIPOINT_DIGITIZER = _PU(0x000CU),
    /** Free space wand (CA) */
    HIDRD_USAGE_DIGITIZER_FREE_SPACE_WAND = _PU(0x000DU),
    /** Configuration (CA) */
    HIDRD_USAGE_DIGITIZER_CONFIGURATION = _PU(0x000EU),
    /** Capacitive heat map digitizer (CA) */
    HIDRD_USAGE_DIGITIZER_CAPACITIVE_HM_DIGITIZER = _PU(0x000FU),
    /** Stylus (CA,CL) */
    HIDRD_USAGE_DIGITIZER_STYLUS = _PU(0x0020U),
    /** Puck (CL) */
    HIDRD_USAGE_DIGITIZER_PUCK = _PU(0x0021U),
    /** Finger (CL) */
    HIDRD_USAGE_DIGITIZER_FINGER = _PU(0x0022U),
    /** Device settings (CL) */
    HIDRD_USAGE_DIGITIZER_DEVICE_SETTINGS = _PU(0x0023U),
    /** Character gesture (CL) */
    HIDRD_USAGE_DIGITIZER_CHARACTER_GESTURE = _PU(0x0024U),
    /** Tip pressure (DV) */
    HIDRD_USAGE_DIGITIZER_TIP_PRESSURE = _PU(0x0030U),
    /** Barrel pressure (DV) */
    HIDRD_USAGE_DIGITIZER_BARREL_PRESSURE = _PU(0x0031U),
    /** In range (MC) */
    HIDRD_USAGE_DIGITIZER_IN_RANGE = _PU(0x0032U),
    /** Touch (MC) */
    HIDRD_USAGE_DIGITIZER_TOUCH = _PU(0x0033U),
    /** Untouch (OSC) */
    HIDRD_USAGE_DIGITIZER_UNTOUCH = _PU(0x0034U),
    /** Tap (OSC) */
    HIDRD_USAGE_DIGITIZER_TAP = _PU(0x0035U),
    /** Quality (DV) */
    HIDRD_USAGE_DIGITIZER_QUALITY = _PU(0x0036U),
    /** Data valid (MC) */
    HIDRD_USAGE_DIGITIZER_DATA_VALID = _PU(0x0037U),
    /** Transducer index (DV) */
    HIDRD_USAGE_DIGITIZER_TRANSDUCER_INDEX = _PU(0x0038U),
    /** Tablet function keys (CL) */
    HIDRD_USAGE_DIGITIZER_TABLET_FUNCTION_KEYS = _PU(0x0039U),
    /** Program change keys (CL) */
    HIDRD_USAGE_DIGITIZER_PROGRAM_CHANGE_KEYS = _PU(0x003AU),
    /** Battery strength (DV) */
    HIDRD_USAGE_DIGITIZER_BATTERY_STRENGTH = _PU(0x003BU),
    /** Invert (MC) */
    HIDRD_USAGE_DIGITIZER_INVERT = _PU(0x003CU),
    /** X tilt (DV) */
    HIDRD_USAGE_DIGITIZER_X_TILT = _PU(0x003DU),
    /** Y tilt (DV) */
    HIDRD_USAGE_DIGITIZER_Y_TILT = _PU(0x003EU),
    /** Azimuth (DV) */
    HIDRD_USAGE_DIGITIZER_AZIMUTH = _PU(0x003FU),
    /** Altitude (DV) */
    HIDRD_USAGE_DIGITIZER_ALTITUDE = _PU(0x0040U),
    /** Twist (DV) */
    HIDRD_USAGE_DIGITIZER_TWIST = _PU(0x0041U),
    /** Tip switch (MC) */
    HIDRD_USAGE_DIGITIZER_TIP_SWITCH = _PU(0x0042U),
    /** Secondary tip switch (MC) */
    HIDRD_USAGE_DIGITIZER_SECONDARY_TIP_SWITCH = _PU(0x0043U),
    /** Barrel switch (MC) */
    HIDRD_USAGE_DIGITIZER_BARREL_SWITCH = _PU(0x0044U),
    /** Eraser (MC) */
    HIDRD_USAGE_DIGITIZER_ERASER = _PU(0x0045U),
    /** Tablet pick (MC) */
    HIDRD_USAGE_DIGITIZER_TABLET_PICK = _PU(0x0046U),
    /** Touch valid (MC) */
    HIDRD_USAGE_DIGITIZER_TOUCH_VALID = _PU(0x0047U),
    /** Width (DV) */
    HIDRD_USAGE_DIGITIZER_WIDTH = _PU(0x0048U),
    /** Height (DV) */
    HIDRD_USAGE_DIGITIZER_HEIGHT = _PU(0x0049U),
    /** Contact identifier (DV) */
    HIDRD_USAGE_DIGITIZER_CONTACT_IDENTIFIER = _PU(0x0051U),
    /** Device input mode (DV) */
    HIDRD_USAGE_DIGITIZER_DEVICE_MODE = _PU(0x0052U),
    /** Device identifier (DV) */
    HIDRD_USAGE_DIGITIZER_DEVICE_IDENTIFIER = _PU(0x0053U),
    /** Contact count (DV) */
    HIDRD_USAGE_DIGITIZER_CONTACT_COUNT = _PU(0x0054U),
    /** Contact count maximum (SV) */
    HIDRD_USAGE_DIGITIZER_CONTACT_COUNT_MAXIMUM = _PU(0x0055U),
    /** Scan time (DV) */
    HIDRD_USAGE_DIGITIZER_SCAN_TIME = _PU(0x0056U),
    /** Surface switch (DF) */
    HIDRD_USAGE_DIGITIZER_SURFACE_SWITCH = _PU(0x0057U),
    /** Button switch (DF) */
    HIDRD_USAGE_DIGITIZER_BUTTON_SWITCH = _PU(0x0058U),
    /** Pad type (SF) */
    HIDRD_USAGE_DIGITIZER_PAD_TYPE = _PU(0x0059U),
    /** Secondary barrel switch (MC) */
    HIDRD_USAGE_DIGITIZER_SECONDARY_BARREL_SWITCH = _PU(0x005AU),
    /** Transducer serial number (SV) */
    HIDRD_USAGE_DIGITIZER_TRANSDUCER_SERIAL_NUMBER = _PU(0x005BU),
    /** Preferred color (DV) */
    HIDRD_USAGE_DIGITIZER_PREFERRED_COLOR = _PU(0x005CU),
    /** Preferred color is locked (MC) */
    HIDRD_USAGE_DIGITIZER_PREFERRED_COLOR_LOCKED = _PU(0x005DU),
    /** Preferred line width (DV) */
    HIDRD_USAGE_DIGITIZER_PREFERRED_LINE_WIDTH = _PU(0x005EU),
    /** Preferred line width is locked (MC) */
    HIDRD_USAGE_DIGITIZER_PREFERRED_LINE_WIDTH_LOCKED = _PU(0x005FU),
    /** Latency mode (DF) */
    HIDRD_USAGE_DIGITIZER_LATENCY_MODE = _PU(0x0060U),
    /** Gesture character quality (DV) */
    HIDRD_USAGE_DIGITIZER_GESTURE_CHAR_QUALITY = _PU(0x0061U),
    /** Character gesture data length (DV) */
    HIDRD_USAGE_DIGITIZER_CHAR_GESTURE_DATA_LEN = _PU(0x0062U),
    /** Character gesture data (DV) */
    HIDRD_USAGE_DIGITIZER_CHAR_GESTURE_DATA = _PU(0x0063U),
    /** Gesture character encoding (NAry) */
    HIDRD_USAGE_DIGITIZER_GESTURE_CHAR_ENCODING = _PU(0x0064U),
    /** Utf8 character gesture encoding (Sel) */
    HIDRD_USAGE_DIGITIZER_UTF8_CHAR_GESTURE_ENC = _PU(0x0065U),
    /** Utf16 little endian character gesture encoding (Sel) */
    HIDRD_USAGE_DIGITIZER_UTF16LE_CHAR_GESTURE_ENC = _PU(0x0066U),
    /** Utf16 big endian character gesture encoding (Sel) */
    HIDRD_USAGE_DIGITIZER_UTF16BE_CHAR_GESTURE_ENC = _PU(0x0067U),
    /** Utf32 little endian character gesture encoding (Sel) */
    HIDRD_USAGE_DIGITIZER_UTF32LE_CHAR_GESTURE_ENC = _PU(0x0068U),
    /** Utf32 big endian character gesture encoding (Sel) */
    HIDRD_USAGE_DIGITIZER_UTF32BE_CHAR_GESTURE_ENC = _PU(0x0069U),
    /** Gesture character enable (DF) */
    HIDRD_USAGE_DIGITIZER_GESTURE_CHAR_ENABLE = _PU(0x006AU),

    /** Capacitive heat map protocol version (SV) */
    HIDRD_USAGE_DIGITIZER_CAPACITIVE_HM_PROTO_VER = _PU(0x006BU),
    /** Capacitive heat map frame data (DV) */
    HIDRD_USAGE_DIGITIZER_CAPACITIVE_HM_FRAME_DATA = _PU(0x006CU),
    /** Preferred line style (NAry) */
    HIDRD_USAGE_DIGITIZER_PREFERRED_LINE_STYLE = _PU(0x0070U),
    /** Preferred line style is locked (MC) */
    HIDRD_USAGE_DIGITIZER_PREFERRED_LINE_STYLE_LOCKED = _PU(0x0071U),
    /** Ink (Sel) */
    HIDRD_USAGE_DIGITIZER_INK = _PU(0x0072U),
    /** Pencil (Sel) */
    HIDRD_USAGE_DIGITIZER_PENCIL = _PU(0x0073U),
    /** Highlighter (Sel) */
    HIDRD_USAGE_DIGITIZER_HIGHLIGHTER = _PU(0x0074U),
    /** Chisel marker (Sel) */
    HIDRD_USAGE_DIGITIZER_CHISEL_MARKER = _PU(0x0075U),
    /** Brush (Sel) */
    HIDRD_USAGE_DIGITIZER_BRUSH = _PU(0x0076U),
    /** No preference (Sel) */
    HIDRD_USAGE_DIGITIZER_NO_PREFERENCE = _PU(0x0077U),
    /** Digitizer diagnostic (CL) */
    HIDRD_USAGE_DIGITIZER_DIGITIZER_DIAGNOSTIC = _PU(0x0080U),
    /** Digitizer error (NAry) */
    HIDRD_USAGE_DIGITIZER_DIGITIZER_ERROR = _PU(0x0081U),
    /** Err normal status (Sel) */
    HIDRD_USAGE_DIGITIZER_ERR_NORMAL_STATUS = _PU(0x0082U),
    /** Err transducers exceeded (Sel) */
    HIDRD_USAGE_DIGITIZER_ERR_TRANSDUCERS_EXCEEDED = _PU(0x0083U),
    /** Err full transducer features unavailable (Sel) */
    HIDRD_USAGE_DIGITIZER_ERR_FULL_TRANS_FT_UNAVAIL = _PU(0x0084U),
    /** Err charge low (Sel) */
    HIDRD_USAGE_DIGITIZER_ERR_CHARGE_LOW = _PU(0x0085U),
    /** Transducer software info (CL) */
    HIDRD_USAGE_DIGITIZER_TRANSDUCER_SOFTWARE_INFO = _PU(0x0090U),
    /** Transducer vendor id (SV) */
    HIDRD_USAGE_DIGITIZER_TRANSDUCER_VENDOR_ID = _PU(0x0091U),
    /** Transducer product id (SV) */
    HIDRD_USAGE_DIGITIZER_TRANSDUCER_PRODUCT_ID = _PU(0x0092U),
    /** Device supported protocols (NAry,CL) */
    HIDRD_USAGE_DIGITIZER_DEVICE_SUPPORT_PROTOS = _PU(0x0093U),
    /** Transducer supported protocols (NAry,CL) */
    HIDRD_USAGE_DIGITIZER_TRANSDUCER_SUPPORT_PROTOS = _PU(0x0094U),
    /** No protocol (Sel) */
    HIDRD_USAGE_DIGITIZER_NO_PROTOCOL = _PU(0x0095U),
    /** Wacom aes protocol (Sel) */
    HIDRD_USAGE_DIGITIZER_WACOM_AES_PROTOCOL = _PU(0x0096U),
    /** Usi protocol (Sel) */
    HIDRD_USAGE_DIGITIZER_USI_PROTOCOL = _PU(0x0097U),
    /** Microsoft pen protocol (Sel) */
    HIDRD_USAGE_DIGITIZER_MICROSOFT_PEN_PROTOCOL = _PU(0x0098U),
    /** Supported report rates (SV,CL) */
    HIDRD_USAGE_DIGITIZER_SUPPORTED_REPORT_RATES = _PU(0x00a0U),
    /** Report rate (DV) */
    HIDRD_USAGE_DIGITIZER_REPORT_RATE = _PU(0x00a1U),
    /** Transducer connected (SF) */
    HIDRD_USAGE_DIGITIZER_TRANSDUCER_CONNECTED = _PU(0x00a2U),
    /** Switch disabled (Sel) */
    HIDRD_USAGE_DIGITIZER_SWITCH_DISABLED = _PU(0x00a3U),
    /** Switch unimplemented (Sel) */
    HIDRD_USAGE_DIGITIZER_SWITCH_UNIMPLEMENTED = _PU(0x00a4U),
    /** Transducer switches (CL) */
    HIDRD_USAGE_DIGITIZER_TRANSDUCER_SWITCHES = _PU(0x00a5U),

#undef _PU

     /*
     * Vendor-defined page FFFF (last possible)
     */
#define _PU(_id) _U(VENDOR_FFFF, _id)

    /** Usage FFFF (last possible) */
    HIDRD_USAGE_VENDOR_FFFF_FFFF = _PU(0xFFFFU)

#undef _PU

#undef _U
} hidrd_usage;

#define HIDRD_USAGE_MIN HIDRD_USAGE_UNDEFINED
#define HIDRD_USAGE_MAX HIDRD_USAGE_VENDOR_FFFF_FFFF

/**
 * Check if a usage is valid.
 *
 * @param usage Usage to check.
 *
 * @return True if usage is valid, false otherwise.
 */
extern bool hidrd_usage_valid(hidrd_usage usage);

/**
 * Check if a usage is known, in effect, if there is a description for it.
 *
 * @param usage Usage to check.
 *
 * @return True if the usage is known, false otherwise.
 */
extern bool hidrd_usage_known(hidrd_usage usage);

/* Declare usage to string conversion functions */
HIDRD_NUM_CONV_DECLS(usage);

/**
 * Retrieve usage page from a usage.
 *
 * @param usage Usage to retrieve usage page from.
 *
 * @return Usage page.
 */
static inline hidrd_usage_page
hidrd_usage_get_page(hidrd_usage usage)
{
    assert(hidrd_usage_valid(usage));
    return (usage >> 16) & UINT16_MAX;
}


/**
 * Check if a usage has defined page.
 *
 * @param usage Usage to check.
 *
 * @return True if the usage has defined page, false otherwise.
 */
static inline bool
hidrd_usage_defined_page(hidrd_usage usage)
{
    assert(hidrd_usage_valid(usage));
    return hidrd_usage_page_defined(hidrd_usage_get_page(usage));
}


/**
 * Set usage page.
 *
 * @param usage Usage to set page to.
 * @param page  Usage page to set.
 *
 * @return Usage with modified page.
 */
static inline hidrd_usage
hidrd_usage_set_page(hidrd_usage usage, hidrd_usage_page page)
{
    assert(hidrd_usage_valid(usage));
    assert(hidrd_usage_page_valid(page));
    return (usage & UINT16_MAX) | (page << 16);
}


/**
 * Retrieve usage ID from a usage.
 *
 * @param usage Usage to retrieve usage ID from.
 *
 * @return Usage ID.
 */
static inline hidrd_usage_id
hidrd_usage_get_id(hidrd_usage usage)
{
    assert(hidrd_usage_valid(usage));
    return usage & UINT16_MAX;
}


/**
 * Set usage ID.
 *
 * @param usage Usage to set ID to.
 * @param page  Usage ID to set.
 *
 * @return Usage with modified ID.
 */
static inline hidrd_usage
hidrd_usage_set_id(hidrd_usage usage, hidrd_usage_id id)
{
    assert(hidrd_usage_valid(usage));
    assert(hidrd_usage_id_valid(id));
    return (usage & (UINT16_MAX << 16)) | id;
}


/**
 * Compose a new usage from usage page and ID.
 *
 * @param page  Usage page.
 * @param id    Usage ID.
 *
 * @return New usage.
 */
static inline hidrd_usage
hidrd_usage_compose(hidrd_usage_page page, hidrd_usage_id id)
{
    assert(hidrd_usage_page_valid(page));
    assert(hidrd_usage_id_valid(id));
    return (page << 16) | id;
}


/**
 * Check if a usage is top-level (in effect, if its ID is top-level).
 *
 * @param usage Usage to check.
 *
 * @return True if the usage is top-level, false otherwise.
 */
static inline bool
hidrd_usage_top_level(hidrd_usage usage)
{
    assert(hidrd_usage_valid(usage));
    return hidrd_usage_id_top_level(hidrd_usage_get_id(usage));
}


#ifdef HIDRD_WITH_TOKENS
/**
 * Convert a usage to a string token.
 *
 * @param usage Usage.
 *
 * @return Dynamically allocated usage token, or NULL if no token was found
 *         or failed to allocate memory (check errno for the latter).
 */
extern char *hidrd_usage_to_token(hidrd_usage usage);


/**
 * Convert a usage to a ID token string.
 *
 * @param usage Usage.
 *
 * @return Dynamically allocated usage ID token, or NULL if no token was
 *         found or failed to allocate memory (check errno for the latter).
 */
extern char *hidrd_usage_to_id_token(hidrd_usage usage);


/**
 * Convert a string token to a usage.
 *
 * @param pusage    Location for usage; will not be modified in case of
 *                  error; could be NULL.
 * @param token     String token.
 *
 * @return True if token is found, false otherwise.
 */
extern bool hidrd_usage_from_token(hidrd_usage *pusage,
                                   const char  *token);

#endif /* HIDRD_WITH_TOKENS */

#ifdef HIDRD_WITH_NAMES

/**
 * Retrieve usage ID name string (close to specification).
 *
 * @param usage Usage code.
 *
 * @return Usage ID name string, or NULL if not found.
 */
extern const char *hidrd_usage_id_name(hidrd_usage usage);

#ifdef HIDRD_WITH_TOKENS

/**
 * Format description of usage ID as used in particular usage.
 *
 * @param usage Usage code to generate ID description for.
 *
 * @return Dynamically allocated usage ID description, or NULL if failed to
 *         allocate memory; could be an empty string, if there is nothing to
 *         tell about the usage ID.
 */
extern char *hidrd_usage_desc_id_str(hidrd_usage usage);

/**
 * Format usage description.
 *
 * @param usage Usage code to generate description for.
 *
 * @return Dynamically allocated usage description, or NULL if failed to
 *         allocate memory; could be an empty string, if there is nothing to
 *         tell about the usage.
 */
extern char *hidrd_usage_desc_str(hidrd_usage usage);

#endif /* HIDRD_WITH_TOKENS */

#endif /* HIDRD_WITH_NAMES */

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __HIDRD_USAGE_ALL_H__ */
