/*
 * vim:nomodifiable
 *
 * ***************** DO NOT EDIT *******************
 * This file is autogenerated from id_desc_list.h.m4
 * *************************************************
 */
/** @file
 * @brief HID report descriptor - usage ID description lists
 *
 * Copyright (C) 2010 Nikolai Kondrashov
 *
 * This file is part of hidrd.
 *
 * Hidrd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Hidrd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with hidrd; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @author Nikolai Kondrashov <spbnick@gmail.com>
 */

#ifndef __HIDRD_USAGE_ID_DESC_LIST_H__
#define __HIDRD_USAGE_ID_DESC_LIST_H__

#include <stddef.h>
#include "hidrd/cfg.h"
#include "hidrd/usage/id_desc.h"

#ifdef __cplusplus
extern "C" {
#endif

extern bool hidrd_usage_id_desc_list_valid(const hidrd_usage_id_desc *list,
                                           size_t                     num);

extern const hidrd_usage_id_desc *hidrd_usage_id_desc_list_lkp_by_value(
                                        const hidrd_usage_id_desc  *list,
                                        size_t                      num,
                                        hidrd_usage_id              value);

#ifdef HIDRD_WITH_TOKENS
extern const hidrd_usage_id_desc *hidrd_usage_id_desc_list_lkp_by_token(
                                        const hidrd_usage_id_desc  *list,
                                        size_t                      num,
                                        const char                 *token);
#endif

/** Undefined page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_undefined[1];

/** Generic desktop controls page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_desktop[71];
/** Simulation controls page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_simulation[0];
/** Virtual reality controls page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_vr[0];
/** Sport controls page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_sport[0];
/** Game controls page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_game[0];
/** Generic device controls page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_device[0];
/** Keyboard/keypad page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_keyboard[219];
/** LEDs page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_led[0];
/** Button page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_button[0];
/** Ordinal page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_ordinal[0];
/** Telephony page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_telephony[0];
/** Consumer page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_consumer[364];
/** Digitizer page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_digitizer[
103];
/** Physical interface device page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_pid[0];
/** Unicode page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_unicode[0];
/** Alphanumeric display page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_alnum_display[0];
/** Medical page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_medical[0];
/** USB monitor page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_monitor[0];
/** Monitor enumerated values page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_monitor_enum[0];
/** Monitor VESA virtual control panel page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_monitor_vesa_vcp[0];
/** Power device page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_power_device[0];
/** Power battery system page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_power_batsys[0];
/** POS devices - bar code scanner page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_pos_bcs[0];
/** POS devices - scale page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_pos_scale[0];
/** POS devices - magnetic stripe reader page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_pos_msr[0];
/** Camera control page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_camera[0];
/** Arcade page ID list */
extern const hidrd_usage_id_desc    hidrd_usage_id_desc_list_arcade[0];

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __HIDRD_USAGE_ID_DESC_LIST_H__ */
