include(CMakeFindDependencyMacro)

if(EXISTS ${CMAKE_CURRENT_LIST_DIR}/RPPackageVersions.cmake)
    include(${CMAKE_CURRENT_LIST_DIR}/RPPackageVersions.cmake)
endif()

set(USED_PACKAGES Threads;Clipper;Boost;NLopt)

list(APPEND CMAKE_MODULE_PATH ${CMAKE_CURRENT_LIST_DIR})

set(TBB_STATIC )

foreach(package ${USED_PACKAGES})
    if(NOT ${CMAKE_FIND_PACKAGE_NAME}_FIND_QUIETLY)
        if(${${package}_VERSION})
            set(_verstr "requested version: ${${package}_VERSION}")
        endif()
        message(STATUS "Using dependent package: ${package} ${_verstr}")
    endif()
    find_dependency(${package} ${${package}_VERSION})
endforeach()

unset(USED_PACKAGES)

include("${CMAKE_CURRENT_LIST_DIR}/Libnest2DTargets.cmake")
