/*
 * Copyright © Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 2 or 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MIR_INPUT_DEVICE_STATE_H_
#define MIR_INPUT_DEVICE_STATE_H_

#include <mir_toolkit/event.h>

#include <vector>

namespace mir
{
namespace events
{

struct InputDeviceState
{
    MirInputDeviceId id;
    std::vector<uint32_t> pressed_keys;
    MirPointerButtons buttons;
};

}
}

#endif // MIR_INPUT_DEVICE_STATE_H_
