/**
 * The MIT License (MIT)
 *
 * Copyright (c) 2021 Marcus Britanicus (https://gitlab.com/marcusbritanicus)
 * Copyright (c) 2021 Abrar (https://gitlab.com/s96Abrar)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 **/

#pragma once

#include <QObject>
#include <QSize>

struct wl_surface;
struct wl_output;

struct ext_session_lock_manager_v1;
struct ext_session_lock_v1;
struct ext_session_lock_surface_v1;
struct ext_session_lock_v1_listener;
struct ext_session_lock_surface_v1_listener;

class QWindow;

namespace WQt {
    class SessionLockManager;
    class SessionLocker;
    class SessionLockSurface;
}

/** Implementation class for WQt::SessionLockSurface */
class SessionLockSurfaceImpl;

class WQt::SessionLockManager : public QObject {
    Q_OBJECT;

    public:
        SessionLockManager( ext_session_lock_manager_v1 *lockMgr );
        ~SessionLockManager();

        WQt::SessionLocker *getLocker();

        ext_session_lock_manager_v1 *get();

    private:
        /** Raw C pointer to this class */
        ext_session_lock_manager_v1 *mObj;
};

class WQt::SessionLocker : public QObject {
    Q_OBJECT;

    public:
        SessionLocker( ext_session_lock_v1 *sessLock );
        ~SessionLocker();

        /** Setup the listener. First connect the signals to your slots, and then call this */
        void setup();

        /** Check if the screen is locked with this instance */
        bool isLocked();

        static WQt::SessionLockSurface * lockSurfaceForWindow( QWindow *window );

        WQt::SessionLockSurface * getLockSurface( QWindow *window, wl_output *output );
        void unlockAndDestroy();

        ext_session_lock_v1 *get();

    private:
        static void handleFinished( void *, ext_session_lock_v1 * );
        static void handleLocked( void *, ext_session_lock_v1 * );

        /** Raw C pointer to this class */
        ext_session_lock_v1 *mObj = nullptr;

        /** Flag for locked state */
        bool mLocked = false;

        /** Flag for init state */
        bool mIsSetup = false;

        /**
         * Pending events: True implies the respective signal was emitted.
         * If lockFinished/lockFailed is emitted, acquired will be set to false,
         * and lockFailed will be emitted.
         */
        struct pending_t {
            bool acquired = false;
            bool failed   = false;
        }
        mPendingEvents;

        /** Listener */
        static const ext_session_lock_v1_listener mListener;

    Q_SIGNALS:
        void lockAcquired();
        void lockFinished();
        void lockFailed();
};

class WQt::SessionLockSurface : public QObject {
    Q_OBJECT;

    public:
        SessionLockSurface( QWindow *window, ext_session_lock_surface_v1 *lockSurf );
        SessionLockSurface( SessionLockSurfaceImpl *impl );

        ~SessionLockSurface();

        bool isValid();

        ext_session_lock_surface_v1 *get();

    private:
        SessionLockSurfaceImpl *impl = nullptr;
};
