//
// DO NOT EDIT Version.h (this file)! It is generated from Version.h.in.
//

/*
 * Copyright (C) 2013 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Michi Henning <michi.henning@canonical.com>
 */

#include <lomiri/SymbolExport.h>

#ifndef LOMIRI_API_VERSION_H
#define LOMIRI_API_VERSION_H

#define LOMIRI_API_VERSION_MAJOR 0
#define LOMIRI_API_VERSION_MINOR 2
#define LOMIRI_API_VERSION_MICRO 0

#define LOMIRI_API_VERSION_STRING "0.2.0"

/**
\brief Top-level namespace for all things Lomiri-related.
*/
namespace lomiri
{

/**
\brief Top-level namespace for public functionality of the Lomiri API.
*/
namespace api
{

/** @name Version information

Version information is represented as
<i>&lt;<code>major</code>&gt;</i>.<i>&lt;<code>minor</code>&gt;</i>.<i>&lt;<code>micro</code>&gt;</i>.

Releases that differ in the major version number are binary incompatible.

Releases that differ in the minor or micro version number are binary compatible with older releases,
so client code does not need to be recompiled to use the newer library version.

Changes in the micro version number indicate bug fixes.

Changes in the minor version indicate feature additions that are binary compatible.
*/

/**
\brief Returns the major version number of the Lomiri API library.

The major version number is also available as the macro <code>LOMIRI_API_VERSION_MAJOR</code>.
*/

/// @cond
LOMIRI_API
/// @endcond
int major_version();

/**
\brief Returns the minor version number of the Lomiri API library.

The minor version number is also available as the macro <code>LOMIRI_API_VERSION_MINOR</code>.
*/
/// @cond
LOMIRI_API
/// @endcond
int minor_version();

/**
\brief Returns the micro version number of the Lomiri API library.

The micro version number is also available as the macro <code>LOMIRI_API_VERSION_MICRO</code>.
*/
/// @cond
LOMIRI_API
/// @endcond
int micro_version();

/**
\brief Returns the Lomiri API version as a string in the format
<i>&lt;<code>major</code>&gt;</i>.<i>&lt;<code>minor</code>&gt;</i>.<i>&lt;<code>micro</code>&gt;</i>.

The version string is also available as the macro <code>LOMIRI_API_VERSION_STRING</code>.
*/
/// @cond
LOMIRI_API
/// @endcond
const char* str();    // Returns "major.minor.micro"

/// }@

// TODO: Add methods to report compiler version and compiler flags

} // namespace api

} // namespace lomiri

#endif
