# **Mobroute:** CLI Documentation
The following CLI documentation is automatically generated from using the `-h` flag on each `mobroute` subcommand. These docs provide a good comprehensive high-level overview of functionality for each CLI subcommand. If you are looking for a more step-like tutorial / guide to using mobroute's CLI; please see also the [userguide](userguide_cli.md).

## **Mobroute CLI: usage**
```
Usage of ./mobroute:
  mobroute [subcommand]

Description:
  Mobroute is a general purpose FOSS public transportation router (e.g. trip planner). See: http://sr.ht/~mil/mobroute

Subcommands:
  - route: Perform a routing request via CSA algorithm calculation based on GTFS data
  - stops: Query to determine stops near a specific geocoordinate based on GTFS data
  - schedule: Query departure schedules (upcoming departures) for specific stops based on GTFS data
  - database: Download, import, clear, and manage GTFS data in the SQLite database (run before: route, stops, or schedule)
  - databaseq: Query the SQLite database for status of loaded GTFS feeds
  - version: Display the version information for this release
```

## **Mobroute CLI: database**
```
Usage of ./mobroute database:

Description:
  The database subcommand provides diagnostic functionality allowing you to alter the local SQLite database to import GTFS data (load), prepare routing optimizated tables (compute), and remove existing data (purge). This is essentially a passthrough to mobroute's underlying data ETL library mobsql.  After running database subcommands it's also helpful to query the database using the databaseq command for the effected feed IDs.  See Mobsql (http://git.sr.ht/~mil/mobsql) for in-depth documentation on functionality (which this subcommand is a passthrough to).

Flags: 
  -h	Show this usage message
  -p string
    	
    	JSON Parameters for database subcommand.
    	
    	Required database parameters:
    	  - feed_ids: Array of integer feed IDs to use for database requests (ex: [767])
    	  - op: Operation to perform - may be one of "loadmdbgtfs", "loadcustomgtfs", "compute", "purge_gtfs", "purge_computed", "purge_all" (ex: "loadmdbgtfs")
    	
    	Optional database parameters:
    	  - loadmdbgtfs_cacheclear: Used optionally when setting op to loadmdbgtfs, this flag makes the system ignore underlying caching systems and explicitly update the Mobility DB & GTFS feed - if you have limited bandwidth (or simply wish to test with *already* downloaded data) set this to false. (ex: true)
    	  - loadmdbgtfs_direct_urls: Used optionally when setting op to loadmdbgtfs, flags whether to use 'direct' agency URLs, if false or unset downloading uses Mobility Database cloud bucket URLs (ex: true)
    	  - loadcustomgtfs_uri: Used when setting op to loadcustomgtfs, this allows you to specify the URI to load for the custom GTFS archive (http:// or file://)
    	

Examples:
  Purge Computed Tables:
    mobroute database -p '{"op": "purge_computed", "feed_ids": [767]}'
  Purge All Tables:
    mobroute database -p '{"op": "purge_all", "feed_ids": [767]}'
  Load a Mobility Database GTFS Feed:
    mobroute database -p '{"op": "loadmdbgtfs", "feed_ids": [767]}'
  Load a Mobility Database GTFS Feed (without clearing cache):
    mobroute database -p '{"op": "loadmdbgtfs", "feed_ids": [767], "loadmdbgtfs_cacheclear": false}'
  Load a Custom GTFS Feed:
    mobroute database -p '{"op": "loadcustomgtfs", "feed_ids": [-33], "loadcustomgtfs_uri": "http://web.mta.info/developers/data/nyct/subway/google_transit.zip"}'
  Compute Routing-Optimized GTFS Derived Tables:
    mobroute database -p '{"op": "compute", "feed_ids": [767]}'
  Purge GTFS Feed Data:
    mobroute database -p '{"op": "purge_gtfs", "feed_ids": [767]}'

```

## **Mobroute CLI: databaseq**
```
Usage of ./mobroute databaseq:

Description:
  The databaseq subcommand queries the underlying SQLite database to determine the loaded/computed status along with metadata of particular GTFS feeds. This subcommand can be run after the database command (and before route, schedule, stops) commands to ensure data is loaded/computed. It can also be used to arbitrarily query metadata via the search filter ability.  See Mobsql (http://git.sr.ht/~mil/mobsql) for in-depth documentation on functionality (which this subcommand is a passthrough to). 	

Flags: 
  -h	Show this usage message
  -p string
    	
    	JSON Parameters for the databaseq subcommand.
    	
    	Optional databaseq parameters:
    	  - feed_ids: Array of integer feed IDs to use for databaseq request (ex: [767])
    	  - feed_searchfilter: Search filter object (ex: {"glob": "new york"})
    	

Examples:
  Determine the status of single GTFS feed:
    mobroute databaseq -p '{"feed_ids": [767]}'
  Determine the status of multiple GTFS feeds:
    mobroute databaseq -p '{"feed_ids": [767, 516]}'
  Determine the status of a particular search for GTFS feeds:
    mobroute databaseq -p '{"feed_searchfilter": {"glob": "new york"}}'

```

## **Mobroute CLI: route**
```
Usage of ./mobroute route:

Description:
  The route subcommand allows you to perform routing calculations using the Connection-Scan Algorithm. Provides point-to-point routing formatted in a number of ways.  Before running this subcommand, the target feed_ids should be loaded & computed in the database.

Flags: 
  -h	Show this usage message
  -p string
    	
    	JSON Parameters for route subcommand.
    	
    	Required route parameters:
    	  - feed_ids: Array of integer feed IDs (MDBID) to use for routing requests (ex: [516, 510])
    	  - from: Array of two floats in lat, lon format (ex: [50.012338, 19.88192])
    	  - to: Array of two floats in lat, lon format (ex: [50.012338, 19.88192])
    	  - transfer_categories: Array of transfers categories to load - may include "f" for feed, "i" for implicit, "g" for generated (ex: ["f", "i"])
    	  - output_formats: Array of formats for the output may include - may include "legs", "geojson", "connections", "diagnostics", "mapurl", "request" (ex: ["legs", "geojson"])
    	
    	Optional route parameters:
    	  - time: Datetime string at which route should depart in RFC3339 format (default: current system time)
    	  - max_walk_seconds: Maximum seconds walking distance on start/end of trip to get to/from origin/destination stops (default: 1200)
    	  - max_trip_seconds: Maximum seconds the entire route/trip can take (default: 14400)
    	  - min_transfer_seconds: Minimum seconds each transfer in the route can take (default: 180)
    	  - max_transfer_seconds: Maximum seconds each transfer in the route can take (default: 2400)
    	  - max_n_transfers: Maximum number of transfers a route can contain (default: 20)
    	  - walkspeed_km_hr: Ratio of kilometers per hour the user walk (default: 4.5)
    	  - optimizations: Array of optimizations to apply (default: ["feedsclean"])
    	
    	Note:
    	  - Additional information on tunable parameters at: http://mr.lrdu.org/mobroute/doc/routing_tunables
    	  - Additional information on output_formats at: http://mr.lrdu.org/mobroute/doc/routing_output_formats
    	

Examples:
  Brussels Routing Example:
    mobroute route -p '{"feed_ids":[1088],"from":[50.85728,4.351426],"to":[50.83214,4.350534],"transfer_categories":["f","i"],"output_formats":["legs","diagnostics","mapurl","request"]}'
  Krakow Routing Example:
    mobroute route -p '{"feed_ids":[1270],"from":[50.012338,19.88192],"to":[50.08785,20.02387],"transfer_categories":["f","i"],"output_formats":["legs","diagnostics","mapurl","request"]}'
  NYC Routing Example:
    mobroute route -p '{"feed_ids":[516],"from":[40.70940,-74.00537],"to":[40.72879,-73.95215],"transfer_categories":["f","i"],"output_formats":["legs","diagnostics","mapurl","request"]}'

```

## **Mobroute CLI: stops**
```
Usage of ./mobroute stops:

Description:
  The stops subcommand allows you to query stops for a given set of feed IDs optionally bounded to a km distance from a specific coordinate. If km distance or coordinate is unspecified, all stops for the feed are returned.  Before running this subcommand, the target feed_ids should be loaded & computed in the database.

Flags: 
  -h	Show this usage message
  -p string
    	
    	JSON Parameters for stops subcommand.
    	
    	Required stops parameters:
    	  - feed_ids: Array of integer feed IDs to use for routing requests (ex: [1088, 516])
    	
    	Optional stops parameters:
    		- n_limit: Limit number of stops (if unset no limit - e.g. -1)
    		- bounds: Set of lat,lon pairs, e.g. 4 floats, to contrain bounding box (if unset doesn't apply)
    		- glob: String to match stop_name against to filter results (if unset no glob is applied)
    		- from_coord: Latlon coordinate pair to limit (Coordinate to bound results from if max_km_distance provided)
    		- from_maxdistkm: Maximum km distance from  (Maximum distance km)
    	

Examples:
  Brussels Stops (all) Example:
    mobroute stops -p '{"feed_ids": [1088]}'
  Krakow Stops (all) Example:
    mobroute stops -p '{"feed_ids": [1270]}'
  NYC Stops (all) Example:
    mobroute stops -p '{"feed_ids": [516]}'
  NYC Stops (with bounds filter) Example:
    mobroute stops -p '{"feed_ids": [516], "bounds": [40.69911, -73.95912, 40.71987, -73.93055]}'
  Prague Stops (with distance filter) Example:
    mobroute stops -p '{"feed_ids": [767], "from_coord": [49.620842, 13.576023], "from_maxdistkm": 4}'

```

## **Mobroute CLI: schedule**
```
Usage of ./mobroute schedule:

Description:
  The schedule subcommand allows you to query departure schedules for a given set of stop_uids for the given feeds given a input date and maximum seconds delta threshold.  The underlying logic for timeconversion and timetable assembly is the same between the schedule and routing logic so this may also be used as a helpful diagnostic tool.  The stop_uids provided should be in the format of FEEDID_STOPID to disambiguate between feeds with duplicate stop ID handles. Stop IDs can be queried using the stops command.  Before running this subcommand, the target feed_ids should be loaded & computed in the database. 	

Flags: 
  -h	Show this usage message
  -p string
    	
    	JSON Parameters for schedule subcommand.
    	
    	Required schedule parameters:
    	  - feed_ids: Array of integer feed IDs to use for routing requests (ex: [1088, 516])
    	  - stop_uids: Array of string stop_uids in FEEDID_RAWSTOPID format (ex: ["1088_7225", "516_S30"])
    	  - max_seconds: Cutoff threshold in integer seconds from departure time to consider (ex: 600)
    	
    	Optional schedule parameters:
    	  - time: Datetime string at which to consider departures from in RFC3339 format (default: current system time)
    	

Examples:
  NYC Schedule Example:
    mobroute schedule -p '{"feed_ids": [516], "stop_uids": ["516_S30"], "max_seconds": 99999}'
  Brussels Schedule Example:
    mobroute schedule -p '{"feed_ids": [1088], "stop_uids": ["1088_7225"], "max_seconds": 99999}'
  Krakow Schedule Example:
    mobroute schedule -p '{"feed_ids": [1270], "stop_uids": ["1270_stop_293_61329"], "max_seconds": 99999}'

```


