# Contribute

[Mobroute](http://sr.ht/~mil/mobroute) and it's associated
subprojects ([Transito](http://git.sr.ht/~mil/transito) &
[Mobsql](http://git.sr.ht/~mil/mobsql)) are very open to potential
contributions in both the forms of code/patches or feedback in terms
of tickets etc. All contributions are greatly welcomed.

Development currently is managed through
[sourcehut](https://sourcehut.org/). If you're unfamiliar it similar to
Github, Gitlab, etc.; the main difference being in contribution workflow
via email. If you are unsure about overall contribution flow, feel free to
[reach out with questions](http://milesalan.com).

## Tickets
> The **Ticket tracker** can be found at: [https://todo.sr.ht/~mil/mobroute-tickets](https://todo.sr.ht/~mil/mobroute-tickets)

This ticket tracker can be used for general feedback (about Mobroute, Transito,
or Mobsql), bug reports, feature requests or anything else. Please do search
through the ticket tracker before submitting a new ticket to avoid opening a
duplicate ticket.

## Mailing List

> The **Mailing List** can be found at: [~mil/mobroute-devel@lists.sr.ht](https://lists.sr.ht/~mil/mobroute-devel)

This mailing list can be used for general feedback (as an alternative to using
ticket) and you may also send patches here. If you're unfamiliar with sourcehut/email-based
contribution workflow I would highly recommend [this guide for git send-email](https://git-send-email.io/). The essence of
code contribution is similar to Gitlab/Github etc. in-terms of creating a patchset; however instead of
creating a merge-request you send a 'patch-set' to the mailing list.

## Project Git Repositories

Below is a list of git repositories for each subproject:

- [git.sr.ht/~mil/mobroute](https://git.sr.ht/~mil/mobroute): General-Purpose FOSS Public Transportation Router in development based on GTFS & the simple Connection Scan Algorithm (CSA); implemented in Go
- [git.sr.ht/~mil/mobsql](https://git.sr.ht/~mil/mobsql): GTFS to SQLite import utility with automatic ingestion from Mobility DB; pairs with mobroute
- [git.sr.ht/~mil/transito](https://git.sr.ht/~mil/transito): FOSS data-provider-agnostic (GTFS) public transportation app; supports Android & Linux. Point-to-point directions without comprising user freedoms or privacy
- [git.sr.ht/~mil/mobroute-docs](https://git.sr.ht/~mil/mobroute-docs): Documentation for Mobroute (covering Mobroute, Mobsql, and Transito)
- [git.sr.ht/~mil/geojson.lrdu.org](https://git.sr.ht/~mil/geojson.lrdu.org): Web UI / JS to render GeoJSON passed in hash on Leaflet Map
- [git.sr.ht/~mil/mdb.lrdu.org](https://git.sr.ht/~mil/mdb.lrdu.org): Web UI / JS to visualize the Mobility Database Catalogs CSV
