# **Mobroute**: Diagrams
These diagrams are intended to be helpful in understanding general library
usage & patterns. Note diagrams are SVGs & each image linked to its source
 so feel free to click on each diagram to zoom in further.

## System Diagram

Overall system diagram explaining the relationship
between [Mobsql](http://mr.lrdu.org/mobsql),
[Mobroute](http://mr.lrdu.org/mobroute), and
[Transito](http://mr.lrdu.org/transito). See the project page for each
for more details about each individual project.

[![diagrams/system.svg](diagrams/system.svg)](diagrams/system.svg)


## Library Usage Pattern

Demonstrates the basic library usage pattern
for the Mobroute Go library. See also the [Go Library
Documentation](https://pkg.go.dev/git.sr.ht/~mil/mobroute?tab=versions).
Note same workflow also applies for the [CLI](doc_cli.md).

[![diagrams/libraryusage.svg](diagrams/libraryusage.svg)](diagrams/libraryusage.svg)

## GTFS Feeds Compatibility

Explains GTFS feed compatability & dataflow. Both [Mobility
Database](https://mobilitydatabase.org) (~1500) public GTFS feeds
and custom GTFS feeds are supported in load. See also the [GTFS Feeds
doc](doc_gtfsfeeds.md).

[![diagrams/gtfsfeeds.svg](diagrams/gtfsfeeds.svg)](diagrams/gtfsfeeds.svg)


## Routing Dataflow Pattern

Shows the overall dataflow of GTFS data load & routing. GTFS data
is stored in a SQLite DB & implementation of CSA exists in Go
(unaware of SQL). Simple SQL queries (1-each for connections,
transfers, and stopwalks) extract data for CSA function
input. [Formatters](routing_output_formats.md) transform CSA output
result into usable forms.

[![diagrams/routingpattern.svg](diagrams/routingpattern.svg)](diagrams/routingpattern.svg)
