# GTFS Feeds

[Mobroute](http://mr.lrdu.org/mobroute) and its
associated projects ([Mobsql](http://mr.lrdu.org/mobsql)
and [Transito](http://mr.lrdu.org/transito))
are designed to be compatible with all standard
[GTFS](https://gtfs.org/documentation/schedule/reference/) static
feeds meeting latest specification. A GTFS feed is a ZIP archive
containing a number of CSV files indicating transit data - see the
[specification](https://gtfs.org/documentation/schedule/reference/)
for more details.

There are namely two *providers* of GTFS feeds supported by Mobroute,
Transito, and Mobsql in current implementation:

1. [Mobility Database GTFS Feeds](#mobility-database-gtfs-feeds)
2. [Custom GTFS Feeds](#custom-gtfs-feeds)

## **Mobility Database GTFS Feeds**
The [Mobility Database](https://database.mobilitydata.org/) maps
**numerical positive integer** feed IDs to an underlying GTFS ZIP URL
and associated metadata. Integration with this provider is builtin to
Mobsql, Mobroute, and Transito and is the simplest and recommended way
to get started routing. There are over ~1,500 builtin feeds with this
provider to choose from and a wide array of data to available globally.

For end-users, utilizing a feed from the Mobility Database is as simple
as specifying which GTFS Feed ID to use. You can [search for feed
IDs to use here](https://mdb.lrdu.org/) on a web UI for the Mobility
Database. Additionally, in Transito there is a text search functionality
where you can [search for which Mobility DB GTFS feed ID to use by
keyword](http://mr.lrdu.org/transito/doc/doc_transito_userguide/#usage).

If you want more information on finding feeds using the Mobility Database,
a helpful few links for quickly determining which Mobility Database feed
IDs to use for your metro are below:

- [User-Reported Known Good Feeds Ticket](https://todo.sr.ht/~mil/mobroute-tickets/25)
- [CI-Tested Feeds / Routes Page](https://ci.lrdu.org/tests_results/)
- [Mobility Database Website](https://mobilitydatabase.org/)
- [Browseable Mobility Database Source Catalog UI](https://mdb.lrdu.org/)
- [Mobility Database Catalogs Github](https://github.com/MobilityData/mobility-database-catalogs)

If you notice a problem with any of Mobility Database feed and its
usage with Mobsql, Mobroute or Transito, users are encouraged to [file a
ticket on the ticket tracker](https://todo.sr.ht/~mil/mobroute-tickets)
or alternatively you may also address the problem in the underlying
[mobility-database-catalogs repo](https://github.com/MobilityData/mobility-database-catalogs).

## **Custom GTFS Feeds**
Custom feeds may be specified as **numerical negative integer** feed
IDs mapped to a *user-provided* custom GTFS archive (either via a
`file://` or `http(s)://` URI). Since the Mobility Database doesn't
contain *every* feed you might want to use, by using a custom feed ID
you can use Mobsql/Mobroute's underlying load logic without integration
from the Mobility Database.

By convention, using a negative integer for custom GTFS feed IDs
provides disambiguation between Mobility Database Feeds & Custom GTFS
feeds (which can be used in combination & loaded to your Mobroute's
local SQLite database simultaneously).

Currently custom GTFS feeds are supported in Mobsql & Mobroute; [support
for custom GTFS feeds in Transito is planned for implementation](https://todo.sr.ht/~mil/mobroute-tickets/57).
