# **Mobroute**: Roadmap

## Milestone 1: Switch to SQLite for GTFS Feed Storage (complete: 20230803, tag: v0.1.0)
Currently upon performing a routing request, mobroute downloads &
caches the necessary Mobility DB GTFS archive, extracts the source
archive to a temporary directory, and loads the GTFS data into memory in
full. This milestone revolves around modifying this logic to instead
download and store data in a sqlite database.  And additionally,
rather then extracting (all) data for an entire feed upon executing
a routing request, SQL queries will be designed to load only the
data needed for the request. Preliminary work on SQL fetching and
loading to a DB has been done via the bootstrapped mobsql repository
(http://git.sr.ht/~mil/mobsql); this work needs followup, polishing,
and integration work so that mobsql and mobroute work well together.

Done:
  - Properly load source field in mobsql based on either mdb_source_id or
    provider/name unique rather then current stub limiting load to 1 GTFS
    provider
  - Remove all Mobility DB & HTTP GTFS feed fetching logic from mobroute
    repository (migrated to mobsql)
  - Remove all references to manual GTFS parsing (go-gtfs) within mobsql and
    complete migration to custom datastructures (mgtfs) for GTFS datatypes
  - Implement proper handling for fields marked as enum types in load 
    process for mobsql & add generated database enum constraints
  - Modify primary keys generation in mobsql schema creation to account for
    source field
  - Validate schema upon load by ensuring all required fields are marked
    appropriately in mobsql GTFS to sqlite conversion logic
  - Improve error handling & logging capability to cleanly report errors
    with source GTFS feed when imports fail
  - Switch to batch / transaction-based insertion for data loading in mobsql
    and add variable to customize insertion batch size
  - Add ability to customize location of sqlite database file used for
    mobsql
  - Switch the mobroute routing algorithm to load data directly from sqlite
    DB via mobsql rather then directly fetching & unzipping GTFS archives on
    each request
  - Add documentation to mobsql repository explaining functionality such
    that its GTFS-to-sqlite load pipeline capability could be used
    independently of mobroute
  - Create an initial tagged version of mobsql which mobroute will import /
    use as a go module


------------------------------------------------------------------------------

## Milestone 2: Transfers Table Generation & Multi-Feed Support (complete: 20231024, tag: v0.2.0)
Many feeds omit the (optional) transfers.txt table responsible for
listing valid transfers from one station to another. However in its
current state, mobroute depends on transfers.txt in order to determine
transfers, and feeds which omit transfers.txt fail to perform anything
but single trip/route routing requests. As such, this milestone focuses
on building out support for 'system-generated' transfers based on
haversine distance from one stop to another. Additionally, supporting
system-generated transfers also opens the door to multi-feed support,
wherein not just a single but multiple (2 through n) GTFS feeds are used
to generate routes. So in addition to system-generated transfer support,
this milestone also focuses on enabling the capability for using multiple
GTFS source archives in a single routing request.

Done:
  - Modify logic currently which uses GTFS regex to match against Mobility
    DB provider/name limiting routing to 1 GTFS feed to instead appropriately
    load arbitrary n GTFS feeds based on handle(s)
  - Create logic to generate & cache transfers table based on haversine
    distance
  - Modify mobsql load process to allow skipping non-required tables such
    as transfers.txt rather then erroring out
  - Add subcommand to mobroute CLI to tune maximum walkspeed/distance for
    transfers & create capability to (re)generate based on this parameter
  - Add & document pragmatic defaults for maximum walkspeed/distance
    for generated transfers & transfer generation methodology
  - Add reporting to core routing dastastructures to report source GTFS
    archive(s) used for which part(s) of route present for simpler debugging
  - Add logic to (automatically) utilize transfers table generation & caching
    when using >1 GTFS source OR when transfers.txt does not exist for
    single GTFS source
  - Add capability to use either (a) generated transfers, (b) transfers.txt
    based transfers, or both (a) and (b) as tunable / from CLI
  - Modify core routing datastructures to report transfer information based
    on walkspeed & distance (and additionally whether transfers included in
    routes were system-generated or based on transfers.txt)
  - Export transfer & trip part source information in available formatters
    so this information is available to end-users
  - Autogenerate transfers table using mobsql computed tables functionality

------------------------------------------------------------------------------

## Milestone 3: Performance Tuning (complete: 20231229, tag: v0.3.0)
Mobroute's routing algorithm performance is largely effected by 2 factors:
(a) load speed of getting the required data into memory and (b) executing
the actual routing algorithm - currently based on Dijkstra's algorithm,
once the necessary datastructures are available in memory. Milestone
1 builds out a new data storage model based on sqlite; and building on
this a number of improvements in this milestone can be made in regards
to (a). And as for (b), benchmarking and performance updates can be
made based on addressing data locality, minimizing lookups, and general
algorithm performance tuning.

Done:
  - Create logic to automatically create indexes on relevant fields in mobsql
    to optimize sqlite to memory/datastructures loading speed
  - Separate configuration as param for routing algorithm for tunables such
    as {walk speed, max trip duration, etc.}
  - Add ordering to data storage of stoptimes in memory such that routing
    algorithm's route sequential stoptime lookup is O(1)
  - Improve load performance by adding ability to load only given timeframe
    to memory (ability to set max trip duration) (e.g. stoptime pruning)
  - Improve debugging output to provide an overview of cost in elapsed time
    duration for each stage of routing algorithm pipeline
  - Add ability to limit stops & associated data loaded to memory based on
    criteria (e.g. stops pruning)
  - Add ability to customize maximum number of transfers in a trip
  - Add tooling or logging to assist in benchmark generation
  - Generate & document basic performance statistics/benchmarking for
    common routing scenarios

------------------------------------------------------------------------------

## Milestone 4: GTFS Spec & Unit Tests (complete: 20240430, tag: v0.5.0)
This milestone revolves around bringing mobroute up to GTFS Static's
full specification & implementing unit tests for the same. In creating
the initial release of Mobroute, GTFS's specification was partially
implemented, however a number of edgecases were omitted such as: parsing
of the calendar dates schedule (e.g. for holidays), handling routes which
cross the threshold of multiple days, and handling multiple agencies
for a single GTFS feed to name a few edgecases. Many GTFS feeds fail
to load with Mobroute in it's current implementation and this needs to
be resolved; ensuring compliance with GTFS spec will ensure Mobroute
is usable in all metros (which distribute GTFS data up to spec). All
required fields should be addressed and mock-data and unit tests should
be added to the repository to ensure compliance. There are (optional
tagged) aspects of GTFS that may be omitted such as fare attributes and
frequencies; but parsing for and handling in the routing algorithm for
the tables marked as required in the GTFS spec (e.g. tables which make
up a valid GTFS archive) must be implemented.

Done:
  - Add unit tests & logic for multiple agencies (multiple agency_id in
    agency.txt) & handle routes' route_id / agency_id unique combination
  - Add unit tests for routes.txt route_short_name / route_long_name
    handling; 1+ must be present
  - Add unit tests & logic for stoptimes crossing boundaries of days (e.g.
    stoptime with departure/arrival time > 24:00:00)
  - Add unit tests & logic for stoptimes timezone based on agency
    (agency_timezone), stops (stop_timezone), and inheritance from parent
    stop (stop_timezone)
  - Add unit tests & logic for stops.txt handling where stop_lat/stop_lon
    undefined (location_type=3 or location_type=4)
  - Add support for calendar_dates.txt to mobsql & routing algorithm
  - Implement unit tests & GTFS mock framework for common scenarios
  - Add smoketesting capability / script for validating load & routing 
    capabilities for several common metros spanning international boundaries
    (EU, US, Asia, etc.) & inclusive of different GTFS source archive sizes
  - Add unit tests to ensure all cases work: calendar_dates.txt/no
    calendar.txt, calendar.txt/no calendar_dates.txt, both
    calendar_dates.txt/calendar.txt provided
  - Add logic for routes.txt route_short_name / route_long_name
    handling; 1+ must be present
  - Implement integration testing via srht for patches sent to mailing list
    to ensure tests pass


------------------------------------------------------------------------------

## Milestone 5: Go Module, Transito Mobile App, and Packaging (complete: 20240702, tag: v0.6.0)
This milestone focuses on: (a) ensuring the core application logic for
Mobroute's routing system (ETL + algorithm) can be interfaced with by
other developers by exposing Mobroute's API as a Go module (library);
and (b) finishing an initial version of Mobroute's integration
with Transito (cross-platform Go/Gio & Android) app to serve as a
defacto reference implementation for using Mobroute's Go module as
a library. Additionally a smaller subtask (c) will be to update the
tooling for Mepo in order to have a basic integration with an existing
Mobile Linux map application. Packages for Alpine & NixOS will be made
available for Mobroute & Transito; and an initial version for Transito
will be submitted to F-Droid.

Done:
  - Go Module: Extract Mobroute library API; ensure core application logic can be used as library (independently of Mobroute's CLI)
  - Go Module: Update Mobroute's CLI to utilize the Mobroute API (similar to how any other navigation app would as an end-consumer)
  - Transito (Android) App: Polish Transito app UI, finish usability improvements for initial general-public release
  - Transito (Android) App: Clearly indicate GTFS source (MDBID) & allow/guide user in ability to change source
  - Transito (Android) App: Update screenshots on README & update userguide for basic walkthrough on functionality
  - Mepo (Linux) App: Implement Mepo ticket #65 to address making shellpipe_sync cancelable
  - Mepo (Linux) App: Add Mepo/Mobroute integration script via Mobroute CLI to allow routing from/to via simple prompts
  - Packaging: Update packaging for Mepo on Alpine & Nix given new Mobroute support
  - Packaging: Package Mobroute & Transito for Alpine & submit PR to aports
  - Packaging: Package Mobroute & Transito for Nix & submit PR to nixpkgs
  - Packaging: Package Transito for F-Droid & submit initial version PR to F-Droid

------------------------------------------------------------------------------

## Milestone 6: Tooling & Usability Improvements (complete: 20241105, tag: v0.8.0)
This milestone focuses on both upstream & internal tooling to address
usability of the Mobroute project overall. Upstream tooling updates
include submitting PRs to the mobility-database-catalogs project in
order to make it simpler to determine GTFS source(s) that are are
'good'/'valid' (in that they will likely produce usable routes) for
routing within Mobroute. The mobility-database-catalogs's CI already
runs through upstream GTFS sources so adding metadata 'at-the-source'
to determine 'good' feeds will help Mobroute in turn provide a better
UX to end-users (and potentially benefit the upstream project as well).
And internal tooling updates for Mobroute include addressing some latent
but important usability issues such as exposing licensing details to
end users, improving error formatting, and other smaller details.

Done:
  - Upstream Tooling: Submit PR to mobility-database-catalogs generator script to add filesize as generated property
  - Upstream Tooling: Submit PR to mobility-database-catalogs generator script to address 6-month status/active staleness issue
  - Internal Tooling: Add subcommand to fetch GTFS source(s) / load to DB cache without explicitly submitting routing/stops request etc.
  - Internal Tooling: Add clear subcommand to invalidate cache or remove GTFS source(s) from DB to enable refetching / updating data
  - Internal Tooling: Address licensing / pass through upstream GTFS source licenses in ingest process and add option to present licenese(s) to end-users
  - Internal Tooling: Allow loading GTFS file(s) from filesystem not pulled from Mobility Database
  - Internal Tooling: Update error formatting response for Mobroute to show more context on failed routing requests
  - Internal Tooling: Bump Transito to expose improved error formatting via Mobroute API

------------------------------------------------------------------------------

## Milestone 7: Documentation (complete: 20241228, tag: v0.9.0)
This milestone focuses on improving overall documentation for the project
with the end-goal of making Mobroute more approachable as a whole to
end-users and developers. At the end of this milestone, the overall
documentation state of the project should be comprehensive covering:
GTFS ingestion via Mobsql, Mobroute's routing system, and the Transito
app. New users and potential contributors should be able to quickly jump
into the project and quickly determine how each subsystem functions.

Tasks:
  - Systems Doc: Add system architecture diagram to explain dataflow from: GTFS ingestion, to routing, to formatting
  - Mobroute & Mobsql Doc: Improve docstrings to cover all functions/structs in public API
  - Mobroute & Mobsql Doc: Add Go API userguide explaining library usage
  - Mobroute & Mobsql Doc: Explain usage/load of local/non-Mobility Database GTFS archives
  - Mobroute Doc: Add CLI userguide explaining routing via CLI (adjusting tunables, metros, etc.)
  - Mobroute Doc: Document the various available formatters for the routing API (legs, geojson, map URL)
  - Mobroute Doc: Add guide on usage of tunable parameters (and link from Transito doc)
  - Mobsql Doc: Add CLI guide explaining GTFS-to-SQLite data ingestion pipeline without using Mobroute
