# **Mobroute:** Routing Output Formats

The routing library call (`RTRoute`) and the [CLI route
subcommand](doc_cli.md#mobroute-cli-route) supports
a number of output formats. Which output formats are
enabled are defined by the [output formats property in
tunables](routing_tunables.md#output-formats-output_formats). These
formats don't effects the calculation of the target route at all
but rather provide the end-user with a number of different ways
to format and consume the calculated route.  For more information
on general routing dataflow, see the [routing dataflow pattern
diagram](doc_diagrams.md#routing-dataflow-pattern).

The currently supported output formats are as follows:

- [Legs](#legs-legs)
- [Geojson](#geojson-geojson)
- [Map URL](#map-url-mapurl)
- [Diagnostics](#diagnostics-diagnostics)
- [Connections](#connections-connections)
- [Request](#request-request)

## Legs (`legs`)

> Datatype: Array of Leg Objects

The `legs` output format is most applicable for building route planners (e.g. this
is the route information in 'raw') format. Each "leg" so to speak of the calculated
route is presented separately. The returned output format is an array of `Legs`.

Note importantly for every leg, the following properties are always available:

- `leg_type`: May be `trip`, `walk`, or `transfer`
- `leg_begin_time`: RFC3399 UTC time start
- `leg_end_time`: RFC3399 UTC time end
- `leg_duration`: Leg duration in seconds
- `leg_from_coords`: Origin coordinates in lat, lon format
- `leg_to_coords`: Destination coordinates in lat, lon format

And depending on the `leg_type` other properties are visible.

Example:

```json
[
  {
    "leg_type": "trip",
    "leg_begin_time": "2024-12-13T17:10:00-05:00",
    "leg_end_time": "2024-12-13T17:58:00-05:00",
    "leg_duration": "48m0s",
    "leg_from_coords": [ 50.01844, 19.88948 ],
    "leg_to_coords": [ 50.090025, 20.021395 ],
    "trip_route": "52",
    "trip_route_headsign": "Os.Piastów",
    "trip_from": "Czerwone Maki P+R",
    "trip_to": "Rondo Hipokratesa",
  }, ...
]
```

Correlates to Go type [RouteLeg](https://pkg.go.dev/git.sr.ht/~mil/mobroute#RouteLeg).

## GeoJSON (`geojson`)

> Datatype: array of Feature Objects (standard [GeoJSON](https://en.wikipedia.org/wiki/GeoJSON))

The `geojson` output format allows viewing the route as standard
GeoJSON. GeoJSON is helpful mostly for integration with other map &
navigation applications that natively support GeoJSON. Support with
GeoJSON is demonstrated by the integration with Mepo; however any map
application with GeoJSON support should work.

Each [leg](#legs-legs) and individual stops within each leg (for trip
legs) is represented by a single GeoJSON feature. And within each feature,
the properties contains two keys: `icon` and `name`. The `icon` key may
be `walk`, `board`, or `stop.  And the name property is an instruction
to complete the step.

For example:

```json
[
  {
    "type": "Feature",
    "properties": { "icon": "walk", "name": "Walk from origin ([50.012338 19.88192]): 16:57 → 17:12 (14m 52s)" },
    "geometry": { "type": "Point", "coordinates": [ 19.88192, 50.012338 ] }
  },
  ...
]
```

Correlates to Go type [GeoJSONFeature](https://pkg.go.dev/git.sr.ht/~mil/mobroute/api/apirtroute/formattergeojson#GeoJSONFeature).

## Map URL (`mapurl`)

> Datatype: `string` (HTTP URI for the map URL)

The `mapurl` output format generates a URL for the
[geojson.lrdu.org](https://geojson.lrdu.org) service which essentially
passes the entire rendered [GeoJSON route](#geojson-geojson) in the
URL. This allows for a quick way to test / visualize routes on a Leaflet
OSM map. The advantage of this formatter is its convenience.

Example: [Rendered Route](https://geojson.lrdu.org/#%5B%7B%22type%22:%22Feature%22,%22properties%22:%7B%22name%22:%22NYC%20Point%20A%22,%22icon%22:%22walk%22%7D,%22geometry%22:%7B%22type%22:%22Point%22,%22coordinates%22:%5B-73.991083,40.739153%5D%7D%7D,%7B%22type%22:%22Feature%22,%22properties%22:%7B%22name%22:%22NYC%20Point%20B%22,%22icon%22:%22board%22%7D,%22geometry%22:%7B%22type%22:%22Point%22,%22coordinates%22:%5B-73.977623,40.761723%5D%7D%7D,%7B%22type%22:%22Feature%22,%22properties%22:%7B%22name%22:%22NYC%20Point%20C%22,%22icon%22:%22stop%22%7D,%22geometry%22:%7B%22type%22:%22Point%22,%22coordinates%22:%5B-73.986246,40.738895%5D%7D%7D,%7B%22type%22:%22Feature%22,%22properties%22:%7B%22name%22:%22NYC%20Point%20D%22,%22icon%22:%22walk%22%7D,%22geometry%22:%7B%22type%22:%22Point%22,%22coordinates%22:%5B-73.991457,40.748817%5D%7D%7D,%7B%22type%22:%22Feature%22,%22properties%22:null,%22geometry%22:%7B%22type%22:%22LineString%22,%22coordinates%22:%5B%5B-73.991083,40.739153%5D,%5B-73.977623,40.761723%5D,%5B-73.986246,40.738895%5D,%5B-73.991457,40.748817%5D%5D%7D%7D%5D)


## Diagnostics (`diagnostics`)

> Datatype: Diagnostics Object

The `diagnostics` output format is a meta-level format which passes through
details about performance & internals during the route calculation process.
This is largely an advanced type used for debugging but may be helpful for
end-users & library users in that some helpful statistics are shown about
the route.

Example:
```json
{
  "perf_smemload_connections": "123.145667ms",
  "perf_smemload_transfers": "2.787208ms",
  "perf_smemload_walksfrom": "2.315434ms",
  "perf_smemload_walksto": "2.281694ms",
  "perf_smemload_connsverb": "51.09542ms",
  "perf_sroute": "3.865538ms",
  "perf_nmemtransfers": 343,
  "perf_nmemwalksfrom": 343,
  "perf_nmemwalksfromnonnil": 1,
  "perf_nmemwalksto": 343,
  "perf_nmemwalkstononnil": 16,
  "perf_nmemconns": 24424,
  "perf_optimizedfeeds": [ 1270 ],
  "routeinfo_ntransfers": 1,
  "routeinfo_duration": 4369,
  "routeinfo_duration_walkfrom": 892,
  "routeinfo_duration_walktto": 308,
  "routeinfo_duration_transit": 3169,
  "routeinfo_depart": "2024-12-13T17:05:18.615731229-05:00",
  "routeinto_arrive": "2024-12-13T18:18:08-05:00"
}
```

Correlates to Go type [RouteDiagnostics](https://pkg.go.dev/git.sr.ht/~mil/mobroute/api/apirtroute/diagnosticst#RouteDiagnostics).

## Connections (`connections`)

> Datatype: Array of ConnectionVerbose Objects

The `connections` output format is an advanced type for debugging that shows
raw "connections" as outputted by the Connection Scan Algorithm (CSA). CSA
itself on input takes a *large* set of connections and narrows the result
down to the very small set of connections that form a valid route.

This is an *advanced* type in that that can be incredibly helpful in
debugging the routing algorithm as it allows you to show the raw output
of CSA *before* [legs](#legs-legs) formatting.

Example:

```json
[
  {
    "conn_oid": 1563365,
    "feed_id": 1270,
    "service_id": "service_4",
    "service_date": "20241213",
    "from_stop_id": "stop_572_303819",
    "direction_id": 0,
    "from_stop_sequence": 1,
    "from_stop_parent_id": "stop_572_303819",
    "from_stop_parent_uid": "1270_stop_572_303819",
    "from_stop_lat": 50.01844,
    "from_stop_lon": 19.88948,
    "from_stop_name": "Czerwone Maki P+R",
    "from_stop_time": 41100,
    "from_stop_drutctime": 44700,
    "route_id": "route_70",
    "agency_id": "agency_1",
    "route_short_name": "52",
    "route_long_name": "52",
    "tid": "block_386_trip_7_service_4",
    "to_stop_sequence": "2",
    "to_stop_id": "stop_347_269129",
    "to_stop_parent_id": "stop_347_269129",
    "to_stop_parent_uid": "1270_stop_347_269129",
    "to_stop_lat": 50.020825,
    "to_stop_lon": 19.898122,
    "to_stop_name": "Chmieleniec",
    "to_stop_time": 41160,
    "to_stop_drutctime": 44760,
    "trip_headsign": "Os.Piastów"
  }, ...
]
```

Correlates to Go type [ConnectionVerbose](https://pkg.go.dev/git.sr.ht/~mil/mobroute/dbt#ConnectionVerbose).

## Request (`request`)

> Datatype: Request Object

The `request` output format is a meta-level format which passes through
the raw input routing request. This request can be used for running the
`RTRoute` function again for replication of the same request (or running
on the CLI as `mobroute route -p '{}'`). This can be helpful for debugging
& replicating the same request again (as the input params may be frozen
this way).

Example:
```json
{
  "feed_ids": [ 516 ],
  "from": [ 40.7094, -74.00537 ],
  "to": [ 40.72879, -73.95215 ],
  "transfer_categories": [ "f", "i" ],
  "output_formats": [ "legs", "diagnostics", "mapurl", "request" ],
  "time": "2024-12-13T17:10:42.164544395-05:00",
  "max_n_transfers": 20,
  "max_transfer_seconds": 2400,
  "max_trip_seconds": 14400,
  "max_walk_seconds": 1200,
  "min_transfer_seconds": 180,
  "walkspeed_km_hr": 3.5,
  "optimizations": [ "feedsclean" ]
}
```

Correlates to Go type [RouteParams](https://pkg.go.dev/git.sr.ht/~mil/mobroute#RouteParams).
