# **Mobroute:** Routing Tunables

The routing library call (`RTRoute`) and accessible via the [CLI
route subcommand](doc_cli.md#mobroute-cli-route) supports a number of
parameters (or tunables) that allow you to intricately effect the routing
calculations. Defaults are set to be generally *pragmatic* defaults
but if you know more about your particular routing context or desired
result likely adjusting some of these tunables will be very helpful. For
more information on general routing dataflow, see the [routing dataflow
pattern diagram](doc_diagrams.md#routing-dataflow-pattern).

## Feed IDs (`feed_ids`)

- *Datatype: `array of n ints`*

Allows you to determine which [feed IDs](doc_gtfsfeeds.md) to use for
the route.  Note, you should have previously explicitly loaded & computed
the associated GTFS feed IDs prior to submitting the routing request. As
consistent in rest of Mobroute, positive feed IDs are Mobility Database
feeds; negative feed IDs are custom feed IDs.

## From & To (`from` and `to`) 

- *Datatype: `array of 2 floats`*

Origin and destination geocoordinates in `[lat, lon]` format. The routing
system uses these coordinates to determine the stops to consider for
first and last nodes in a route.

If you know specifically you want to depart or arrive at a certain stop,
you can set the `from` or `to` params as equal to the stop's lat / lon &
set `max_walk_seconds` to an arbitrary low value like `1`.

## Transfer Categories (`transfer_categories`)

- *Datatype: `array of strings`*

Allows you to determine which *type* of transfers to consider for the
calculated route. This tunable is passed as an array. If *no* transfer
categories are specified (e.g. an empty array) then it is implied you
only which to calculate *direct* routes (as to transfer from one trip to
another you defacto need to have some form for transfer provided).

There are currently three types of transfers supported which are explained below:

| Transfer Category | String Code | Enabled by Default in Transito | Explanation |
|---|---|---|---|
| Implicit | `i` | ✓ | Transfers from one stop to the same stop (or another stop with the same parent stop). |
| Table | `t` | ✓ | Transfers as defined by the GTFS `transfers.txt` table. |
| Generated | `g` |  | Transfers from one stop to another stop less then 3km distance, time being dynamically calculated via the time to walk between the stops (see `walkspeed_km_hr`). Both applies for a single feed & for intrafeed transfers. |

## Output Formats (`output_formats`)

*Datatype: `array of strings`*

Allows you to determine which [output formats](routing_output_formats.md)
the route will be rendered as. You can set multiple output formats
simultaneously, the JSON response will contain a key for each output
format. Setting additional `output_formats` has a negligible effect on
performance as this is a formatting / UX only property.

Valid output formats are: `mapurl`, `legs`, `geojson`, `connections`,
`diagnostics`, and `request`.


See the [output formats doc](routing_output_formats.md) for extended
information on each output format.

## Max N Transfers (`max_n_transfers`)

- *Datatype: `int`*
- *Default: `20`*

The max number of transfers that would be considered valid for a generated
route. This is a broad limiting tunable that directly effects a hardcap
in the CSA algorithm implementation.

If you only wish to consider direct trips you can set this to `0` to
consider direct trips with no transfers.

## Min Transfer Seconds (`min_transfer_seconds`)

- *Datatype: `int`*
- *Default: `180`*

This is the minimum number of seconds a transfer can take which all
transfers will be internally rounded up to. This prevents excessively small
transfers (as defined by both `min_transfer_time` in GTFS `transfers.txt`
and also dynamically calculated implicit / generated transfers) from
applying to generated routes. You can lower or raise this tunable as
desired to apply more liberal or conservative transfer times. See also
`max_transfer_seconds`.

## Max Transfer Seconds (`max_transfer_seconds`)

- *Datatype: `int`*
- *Default: `2400`*

This is the maximum number of seconds a transfer can take which all
transfers must be within the limit of. If you don't want to have a transfer
take an excessively long time or have a long dwell time this tunable can
be quite helpful. See also `min_transfer_seconds`.

## Max Trip Seconds (`max_trip_seconds`)

- *Datatype: `int`*
- *Default: `14440`*

Maximum number of seconds the entire trip/calculated route can be (as an
upper bound).This is largely used for optimizations as the way the CSA
algorithm functions is that the entire timetable is scanned to find the
most ideal / efficient route.  By limiting the total number of seconds
the calculated route can take, we effectively make time to both extract the
timetable from SQL & run the timetable through CSA substantially quicker.

Lowering this value will always make the total duration to calculate a
route time quicker. The default is that a calculated route can take up
to 4 hours (14,400 seconds).  If you know a route will take longer then
this, you should adjust this value up.

## Max Walk Seconds (`max_walk_seconds`)

- *Datatype: `int`*
- *Default: `1200`*

The maximum number of seconds to consider walking as valid for both:
to reach the first / departure stop for the first public transit trip
and at the end of the last trip to reach the destination.  This tunable
is effected & works together with `walkspeed_km_hr`.

By default set to 1,200 seconds (or 20 minutes). If you wish to have
'lazier' routes in that you know your origin `from` or destination `to`
are (or could be) near stops you can lower this value to get you closer
to your origin/destination stop.

## Walkspeed Km/Hr (`walkspeed_km_hr`)

- *Datatype: `float`*
- *Default: `4.5`*

The rate at which walking is calculated for durations to work in tandem
with `max_walk_seconds`.  This can be adjusted if you know you typically
walk faster or slower then average.

This can also be used as a rough 'costing factor' in that if you set
this to a lower value, walking becomes 'more expensive' in terms of
the algorithm as if you can get to a stop quicker by transit that will
be preferred.

## Optimizations (`optimizations`)

- *Datatype: `array of strings`*
- *Default: `["feedsclean"]`*

This is the set of optimizations to apply. This is advanced functionality
and should only be changed from the default if you know what you are doing.

Currently supported optimizations:

- `feedsclean`: Only include & try to extract data for provided GTFS
  feed IDs if the GTFS feed ID's bounding box matches the from/to
  geocoordinate lat/lon.  This is helpful to limit the amount of
  data extracted (for timetable etc.)  in the case of isolated regions
  (e.g. if you route for a city in Europe and request feed data for both a
  city in America & the city in Europe; only the feed data for the city
  in Europe would be applied).
