# **Mobroute:** CLI Userguide

Mobroute primarily serves as a [Go
library](https://pkg.go.dev/git.sr.ht/~mil/mobroute?tab=versions) other
applications (such as [Transito](http://mr.lrdu.org/transito)) can use to
integrate with to offer GTFS routing capabilities in mobile environments.
However, all functionality available through the Go library is also
accessible through a CLI interface.

Using the CLI you can load GTFS feeds, compute derived routing
optimized tables, search feeds, query stoptimes, calculate offline
routes and more. For full usage of the CLI you can see the [CLI
doc](doc_cli.md). This document (the userguide), is not meant to
be comprehensive guide for all functionality; but rather steps you as an
end-user through some common usecases for the CLI.


## **Mobroute CLI: Install**
Mobroute functions as both a commandline and as a Go library. Installation
as a CLI is as follows:

- Installation for usage a CLI application (**install via package**):
    - On some distributions the Mobroute CLI has been packaged, if available
      this is the simplest installation method.
    - Distribution packages:
        - Alpine Linux Testing: `apk add mobroute`
- Installation for usage a CLI application (**build from source**):
    - Install Go & SQLite-dev (distro-dependent):
        - Debian: `apt-get install go libsqlite3-dev`
        - Alpine: `apk add go sqlite-dev`
    - Clone repo: `git clone https://git.sr.ht/~mil/mobroute`
    - Build executable: `go build -tags=sqlite_math_functions cli/*.go`
    - Run via: `./mobroute`
    - *Optionally install to $PATH etc.*: `cp mobroute /usr/local/bin`


## Loading a Mobility Database GTFS Source to the DB

The most basic example of CLI usage would be to load a [Mobility
Database](https://mobilitydatabase.org/) GTFS to the local DB. This
both downloads the GTFS data and imports the data to SQLite. Note the
parameter `loadmdbgtfs_direct_urls` will control whether to fetch GTFS
data directly from the agency (if true); if unset or false Mobility
Database's CI bucket URLs are utilized (which may be slightly less up
to date but are generally more reliable).

For example:
```sh
mobroute database -p '{"op": "loadmdbgtfs", "loadmdbgtfs_direct_urls": true, "feed_ids": [767]}'
```

After load, you can either use the `databaseq` mobroute subcommand, or
inspect the database yourself via SQLite to observe tables. For example:

```sh
sqlite3 ~/.cache/mobroute/sqlite.db 'select * from stop_times where feed_id = 767 limit 5;'
```

## Loading a Custom GTFS Source to the DB

Similarly to loading a Mobility Database GTFS feed; if instead you want
to provide your own custom GTFS feed (zip file), you can do the same
using the `database` command but instead using the `loadcustomgtfs` op.

For example:

```sh
mobroute database -p '{"op": "loadcustomgtfs", "feed_ids": [-33], "loadcustomgtfs_uri": "http://web.mta.info/developers/data/nyct/subway/google_transit.zip"}'
```

After load, you can either use the `databaseq` mobroute subcommand, or
inspect the database yourself via SQLite to observe tables. For example:

```sh
sqlite3 ~/.cache/mobroute/sqlite.db 'select * from stop_times where feed_id = -33 limit 5;'
```


## Compute a GTFS Feed (Derived Tables)

After loading a GTFS feed, before you can route, obtain
stops, or schedules, you need to 'compute' GTFS-derived
tables. Under-the-hood this involves transforming the data in
raw GTFS tables in SQLite into routing-optimized tables. This
is a one-step process and you can see details in the [extra schema
config](https://git.sr.ht/~mil/mobroute/tree/master/item/dbschemaextra/schemaextra.go)
You can use the `compute` op of the `database` CLI command to load the
computed tables for a given feed:

For example (assuming you've already loaded feed ID `767`):
```sh
mobroute database -p '{"op": "compute", "feed_ids": [767]}'
```

This will populate the [computed
tables](https://git.sr.ht/~mil/mobroute/tree/master/item/dbschemaextra/schemaextra.go)
such as `_ctconn` which contains a connections timetable compatible with
the CSA algorithm. You can verify this using SQLite. For example:

```sh
sqlite3 ~/.cache/mobroute/sqlite.db 'select * from _ctconn where feed_id = 767 limit 5;'
```

## Query Feed Statuses and Searching for Feeds
While we have used the `sqlite3` CLI so far to observe changes in the database,
you can also use the builtin `databaseq` (short for database query) subcommand
to query the database for feeds statuses &metadata.

Example:
```sh
mobroute databaseq -p '{"feed_ids": [767]}'
```

If a feed has been loaded & computed, you'll notice a few important
properties in the returned JSON. Particularly of note `min_date` and
`max_date` indicate the earliest and latest dates covered by the origin
GTFS `calendar`/`calendar_dates` tables.

For unloaded feeds, you can also use `databaseq` to search in order
to determine potential feeds to load (as an alternative to looking up
GTFS feed IDs in the [Mobility Database UI](http://mdb.lrdu.org)  or
similar). For example if you wanted to search for all feeds containing
the glob 'Paris' you might run:

```sh
mobroute databaseq -p '{"feed_searchfilter": {"glob": "paris"}}'
```

## Calculating a Route for a Feed

Once a feed has been both loaded & computed you can calculate a
geocoordinate-to-geocoordinate route using the `route` subcommand
which runs the GTFS data stored in the DB through the [Connection Scan
Algorithm](https://i11www.iti.kit.edu/extra/publications/dpsw-isftr-13.pdf).
Please take note of the [routing tunables](routing_tunables.md) and
[output formats](routing_output_formats.md) documentation which are very
relevant to routing. Also see the [diagrams](doc_diagrams.md) page which
is helpful for undertsanding overall routing dataflow.


Example route with feed ID 767:
```sh
mobroute route -p '{
  "feed_ids": [767], 
  "from": [50.10541, 14.53826],
  "to": [50.06846, 14.43794],
  "transfer_categories": ["f", "i"],
  "output_formats": ["legs", "diagnostics", "mapurl"]
}'
```

If you're intrested in seeing some sample routes, you can see the [CI
routing tests results page](https://ci.lrdu.org/tests_results/) which
is run & automatically updated on each new commit.

A common usecase in routing is just viewing the route result on an
OSM map (in the browser). Taking the same input route request above,
you can pipe the result to `jq` and `firefox` to open the result for
`mapurl` in a browser simply like:
```sh
mobroute route -p '{
  "feed_ids": [767], 
  "from": [50.10541, 14.53826],
  "to": [50.06846, 14.43794],
  "transfer_categories": ["f", "i"],
  "output_formats": ["legs", "diagnostics", "mapurl"]
}' | jq '.mapurl' | xargs firefox
```

## Querying Stops for a Feed

Aside from routing, another common usecase is querying stops for
a feed.  This allows you to determine feeds near a given geocoordinate
by specifying the coordinate and a max distance km threshold. This can
be done using the `stops` CLI subcommand. For example:

```sh
mobroute stops -p '{
  "feed_ids": [767],
  "from_coord": [49.620842, 13.576023],
  "from_maxdistkm": 4
}'
```

If you just want to query all stops for a given GTFS feed, you can omit the
`from_coord` and `from_maxdistkm` properties as such:

```sh
mobroute stops -p '{
  "feed_ids": [767]
}'
```

## Querying Departure Schedules for Feed Stops
Using the stop UIDs returned by the stops command, you can also query
upcoming departure times using the `schedule` CLI subcommand for a
particular set of stops. For example:


```sh
mobroute schedule -p '{
  "feed_ids": [767],
  "stop_uids": ["767_U31904Z1"],
  "max_seconds": 60000
}'
```

## Additional Documentation

The above usecases are far from the only possibilities available with
the `mobroute` CLI. You can use the `-h` flag on each subcommand for
more details or full documentation on all CLI functionality is also
available at:

  - [CLI Documentation](doc_cli.md)
