#
# Project Ginger Base
#
# Copyright IBM Corp, 2015-2016
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA
#

import os
import threading
from cherrypy.lib.reprconf import Parser

from wok.config import CACHEEXPIRES, PluginConfig, PluginPaths

gingerBaseLock = threading.Lock()


def get_debugreports_path():
    return os.path.join(PluginPaths('gingerbase').state_dir, 'debugreports')


def get_object_store():
    return os.path.join(PluginPaths('gingerbase').state_dir,
                        'objectstore')


def get_config():
    plugin_conf = PluginPaths('gingerbase').conf_file
    return Parser().dict_from_file(plugin_conf)


config = get_config()


class GingerBasePaths(PluginPaths):

    def __init__(self):
        super(GingerBasePaths, self).__init__('gingerbase')


gingerBasePaths = GingerBasePaths()


class GingerBaseConfig(PluginConfig):
    def __init__(self):
        super(GingerBaseConfig, self).__init__('gingerbase')

        custom_config = {
            '/data/debugreports': {
                'tools.staticdir.on': True,
                'tools.staticdir.dir': os.path.join(gingerBasePaths.state_dir,
                                                    'debugreports'),
                'tools.nocache.on': False,
                'tools.wokauth.on': True,
                'tools.staticdir.content_types': {'xz': 'application/x-xz'}
            },
            '/help': {
                'tools.staticdir.on': True,
                'tools.staticdir.dir': os.path.join(gingerBasePaths.ui_dir,
                                                    'pages/help'),
                'tools.nocache.on': True
            },
            '/images': {
                'tools.staticdir.on': True,
                'tools.staticdir.dir': os.path.join(gingerBasePaths.ui_dir,
                                                    'images'),
                'tools.wokauth.on': False,
                'tools.nocache.on': False
            }
        }

        for dirname in ('css', 'js', 'images'):
            custom_config['/' + dirname] = {
                'tools.staticdir.on': True,
                'tools.staticdir.dir': os.path.join(gingerBasePaths.ui_dir,
                                                    dirname),
                'tools.wokauth.on': False,
                'tools.nocache.on': False}
            if dirname != 'images':
                custom_config['/' + dirname].update({
                    'tools.expires.on': True,
                    'tools.expires.secs': CACHEEXPIRES})

        self.update(custom_config)
