/*
 * vim:nomodifiable
 *
 * ***************** DO NOT EDIT *********************
 * This file is autogenerated from page_desc_list.h.m4
 * ***************************************************
 */
/** @file
 * @brief HID report descriptor - usage description description list
 *
 * Copyright (C) 2010 Nikolai Kondrashov
 *
 * This file is part of hidrd.
 *
 * Hidrd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Hidrd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with hidrd; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @author Nikolai Kondrashov <spbnick@gmail.com>
 */

#ifndef __HIDRD_USAGE_PAGE_DESC_LIST_H__
#define __HIDRD_USAGE_PAGE_DESC_LIST_H__

#include "hidrd/cfg.h"
#include "hidrd/usage/page_desc.h"

#ifdef __cplusplus
extern "C" {
#endif

extern const hidrd_usage_page_desc hidrd_usage_page_desc_list[28];

/**
 * Lookup a usage page description by a usage page value.
 *
 * @param value The usage page value.
 *
 * @return Page description or NULL, if not found.
 */
extern const hidrd_usage_page_desc *hidrd_usage_page_desc_list_lkp_by_value(
                                                hidrd_usage_page    value);

#ifdef HIDRD_WITH_TOKENS
/**
 * Lookup a usage page description by a page token.
 *
 * @param value The token.
 *
 * @return Page description or NULL, if not found.
 */
extern const hidrd_usage_page_desc *hidrd_usage_page_desc_list_lkp_by_token(
                                                const char         *token);
#endif /* HIDRD_WITH_TOKENS */

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __HIDRD_USAGE_PAGE_DESC_LIST_H__ */
