/******************************************************************************
 * <<< MPCSMon - Monitor for MPCS >>>                        (w) by dukat 2006
 ******************************************************************************/

#ifdef DM7025
#  define MPCSMON_DREAM_7025
#endif

#ifdef MPCSMON_DREAM_7025
#  ifndef OLDFT
#    define OLDFT
#  endif
#  ifndef HAVE_DVB_API_VERSION
#    define HAVE_DVB_API_VERSION 3
#  endif
#  define MPCSMON_FB_32BPP
#  define CFGFILE  "/var/tuxbox/mpcsmon.conf"
#else
#  include "config.h"
#  ifdef HAVE_DREAMBOX_HARDWARE
#    define MPCSMON_DREAM_PPC
#    ifndef OLDFT
#      define OLDFT
#    endif
#  endif
#  if !defined(HAVE_DVB_API_VERSION) && defined(HAVE_OST_DMX_H)
#    define HAVE_DVB_API_VERSION 1
#  endif
#  define CFGFILE  "/var/tuxbox/config/mpcsmon.conf"
#endif

#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <linux/fb.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <time.h>

#include <ft2build.h>
#include FT_FREETYPE_H
#include FT_CACHE_H
#include FT_CACHE_SMALL_BITMAPS_H

#if HAVE_DVB_API_VERSION == 3
#include <linux/input.h>
struct input_event ev;
#endif

#ifdef MPCSMON_DREAM_7025

#define	RC_0			'0'
#define	RC_1			'1'
#define	RC_2			'2'
#define	RC_3			'3'
#define	RC_4			'4'
#define	RC_5			'5'
#define	RC_6			'6'
#define	RC_7			'7'
#define	RC_8			'8'
#define	RC_9			'9'

#define	RC_RIGHT	0x0191
#define	RC_LEFT		0x0192
#define	RC_UP			0x0193
#define	RC_DOWN		0x0194
#define	RC_PLUS		0x0195
#define	RC_MINUS	0x0196

#define	RC_OK				0x0D
#define	RC_STANDBY	0x1C
#define RC_ESC			RC_HOME

#define	RC_HOME			0x01B1
#define	RC_MUTE			0x01B2
#define	RC_HELP			0x01B3
#define	RC_DBOX			0x01B4

#define	RC_GREEN	0x01A1
#define	RC_YELLOW	0x01A2
#define	RC_RED		0x01A3
#define	RC_BLUE		0x01A4

#define RC_PAUSE	RC_HELP
#define RC_ALTGR	0x12
#define RC_BS			0x7F
#define RC_POS1		RC_HOME
#define RC_END		0x13
#define RC_INS		0x10
#define RC_ENTF		0x11
#define RC_STRG		0x00
#define RC_LSHIFT	0x0E
#define RC_RSHIFT	0x0E
#define RC_ALT		0x0F
#define RC_NUM		RC_DBOX
#define RC_ROLLEN	0x00
#define RC_F5			RC_DBOX
#define RC_F6			RC_HELP
#define RC_F7			RC_MUTE
#define RC_F8			0x01C8
#define RC_F9			0x01C9
#define RC_F10		0x01CA
#define RC_RET		0x0D
#define RC_RET1		0x01CC
#define RC_CAPSLOCK	0x01CD
#define RC_ON			0x01CE

#define RC_F1		RC_RED
#define RC_F2		RC_GREEN
#define RC_F3		RC_YELLOW
#define RC_F4		RC_BLUE
#define RC_PAGEUP	RC_PLUS
#define RC_PAGEDOWN	RC_MINUS

#else	// MPCSMON_DREAM_7025

#include <plugin.h>

//rc codes

// #if HAVE_DVB_API_VERSION == 1

#define	RC1_0		0x5C00
#define	RC1_1		0x5C01
#define	RC1_2		0x5C02
#define	RC1_3		0x5C03
#define	RC1_4		0x5C04
#define	RC1_5		0x5C05
#define	RC1_6		0x5C06
#define	RC1_7		0x5C07
#define	RC1_8		0x5C08
#define	RC1_9		0x5C09
#define	RC1_STANDBY	0x5C0C
#define	RC1_UP		0x5C0E
#define	RC1_DOWN	0x5C0F
#define	RC1_PLUS	0x5C16
#define	RC1_MINUS	0x5C17
#define	RC1_HOME	0x5C20
#define	RC1_DBOX	0x5C27
#define	RC1_MUTE	0x5C28
#define	RC1_RED		0x5C2D
#define	RC1_RIGHT	0x5C2E
#define	RC1_LEFT	0x5C2F
#define	RC1_OK		0x5C30
#define	RC1_BLUE	0x5C3B
#define	RC1_YELLOW	0x5C52
#define	RC1_GREEN	0x5C55
#define	RC1_HELP	0x5C82

// #endif

#define	RC_0		0x00
#define	RC_1		0x01
#define	RC_2		0x02
#define	RC_3		0x03
#define	RC_4		0x04
#define	RC_5		0x05
#define	RC_6		0x06
#define	RC_7		0x07
#define	RC_8		0x08
#define	RC_9		0x09
#define	RC_RIGHT	0x0A
#define	RC_LEFT		0x0B
#define	RC_UP		0x0C
#define	RC_DOWN		0x0D
#define	RC_OK		0x0E
#define	RC_MUTE		0x0F
#define	RC_STANDBY	0x10
#define	RC_GREEN	0x11
#define	RC_YELLOW	0x12
#define	RC_RED		0x13
#define	RC_BLUE		0x14
#define	RC_PLUS		0x15
#define	RC_MINUS	0x16
#define	RC_HELP		0x17
#define	RC_DBOX		0x18
#define	RC_HOME		0x1F

#endif	// MPCSMON_DREAM_7025

//freetype stuff

#define FONT FONTDIR "/pakenham.ttf"

enum {LEFT, CENTER, RIGHT};
enum {TINY, SMALL, BIG};

//framebuffer stuff
static struct fb_fix_screeninfo fix_screeninfo;
static struct fb_var_screeninfo var_screeninfo;

enum {FILL, GRID};
enum {TRANSP,
      BLACK, RED  , GREEN  , BROWN , BLUE  , MAGENTA  , CYAN  , B_GRAY,
      GRAY , B_RED, B_GREEN, YELLOW, B_BLUE, B_MAGENTA, B_CYAN, WHITE ,
      BLUE0, BLUE1, BLUE2, BLUE3, ORANGE};

#ifdef MPCSMON_FB_32BPP

static unsigned char bgra[][4] = {
	"\x00\x00\x00\x00","\x00\x00\x00\xFF","\x00\x00\x80\xFF","\x00\x80\x00\xFF",
	"\x00\x48\xA0\xFF","\x80\x00\x00\xFF","\x80\x00\x80\xFF","\x80\x80\x00\xFF",
	"\xA0\xA0\xA0\xFF","\x50\x50\x50\xFF","\x00\x00\xFF\xFF","\x00\xFF\x00\xFF",
	"\x00\xFF\xFF\xFF","\xFF\x00\x00\xFF","\xFF\x00\xFF\xFF","\xFF\xFF\x00\xFF",
	"\xFF\xFF\xFF\xFF","\xFF\x80\x00\xF0","\x80\x00\x00\xF0","\xFF\x80\x00\xFF",
	"\x40\x20\x00\xFF","\x00\xC0\xFF\xFF"
};

#else	// MPCSMON_FB_32BPP

static unsigned short rd[] = {
	0x01<<8, 0x80<<8, 0x00<<8, 0xA0<<8, 0x00<<8, 0x80<<8, 0x00<<8, 0xA0<<8,
	0x50<<8, 0xFF<<8, 0x00<<8, 0xFF<<8, 0x00<<8, 0xFF<<8, 0x00<<8, 0xFF<<8,
	0x00<<8, 0x00<<8, 0x00<<8, 0x00<<8, 0xFF<<8
};
static unsigned short gn[] = {
	0x01<<8, 0x00<<8, 0x80<<8, 0x48<<8, 0x00<<8, 0x00<<8, 0x80<<8, 0xA0<<8,
	0x50<<8, 0x00<<8, 0xFF<<8, 0xFF<<8, 0x00<<8, 0x00<<8, 0xFF<<8, 0xFF<<8,
	0x80<<8, 0x00<<8, 0x80<<8, 0x20<<8, 0xC0<<8
};
static unsigned short bl[] = {
	0x01<<8, 0x00<<8, 0x00<<8, 0x00<<8, 0x80<<8, 0x80<<8, 0x80<<8, 0xA0<<8,
	0x50<<8, 0x00<<8, 0x00<<8, 0x00<<8, 0xFF<<8, 0xFF<<8, 0xFF<<8, 0xFF<<8,
	0xFF<<8, 0x80<<8, 0xFF<<8, 0x40<<8, 0x00<<8
};
static unsigned short tr[] = {
	0x00<<8, 0x00<<8, 0x00<<8, 0x00<<8, 0x00<<8, 0x00<<8, 0x00<<8, 0x00<<8,
	0x00<<8, 0x00<<8, 0x00<<8, 0x00<<8, 0x00<<8, 0x00<<8, 0x00<<8, 0x00<<8,
	0x0A<<8, 0x0A<<8, 0x00<<8, 0x00<<8, 0x00<<8
};

static struct fb_cmap colormap = {1, 21, rd, gn, bl, tr};

#endif	// MPCSMON_FB_32BPP

char circle[] =
{
	0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,
	0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,
	0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,
	0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,
	0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,
	0,0,0,0,0,1,1,1,1,1,0,0,0,0,0
};

#ifdef NOT_USED_YET
char scroll_up[] =
{
	BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, WHITE, WHITE, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, WHITE, WHITE, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1,
	BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1,
	BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1,
	BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1,
	WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE,
	WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE
};

char scroll_dn[] =
{
	WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE,
	WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE,
	BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1,
	BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1,
	BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1,
	BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, WHITE, WHITE, WHITE, WHITE, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, WHITE, WHITE, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1,
	BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, WHITE, WHITE, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1, BLUE1
};

//lcd stuff

unsigned char lcd_buffer[] =
{
	0xE0, 0xF8, 0xFC, 0xFE, 0xFE, 0xFF, 0x7F, 0x7F, 0x7F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0xFF, 0xFF, 0xFF, 0xC7, 0xBB, 0x3B, 0xFB, 0xFB, 0x3B, 0xBB, 0xC7, 0xFF, 0x07, 0xFB, 0xFB, 0x07, 0xFB, 0xFB, 0xFB, 0x07, 0xFF, 0x87, 0x7B, 0xFB, 0xC7, 0xFB, 0x7B, 0x7B, 0x87, 0xFF, 0x07, 0xFB, 0xFB, 0x3B, 0xFB, 0xFB, 0xFB, 0x3B, 0xFB, 0xFB, 0x07, 0xFF, 0x07, 0xFB, 0xFB, 0xBB, 0xFB, 0xFB, 0xFB, 0x07, 0xFF, 0x27, 0xDB, 0xDB, 0x27, 0xFF, 0x07, 0xFB, 0xFB, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x7F, 0x7F, 0x7F, 0xFF, 0xFE, 0xFE, 0xFC, 0xF8, 0xE0,
	0xFF, 0x7F, 0x7F, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x70, 0x6F, 0x6F, 0x70, 0x7F, 0x7F, 0x7F, 0x70, 0x6F, 0x6F, 0x6C, 0x6F, 0x6F, 0x6F, 0x70, 0x7F, 0x70, 0x6F, 0x6F, 0x71, 0x6F, 0x6F, 0x6F, 0x70, 0x7F, 0x70, 0x6F, 0x6F, 0x70, 0x6F, 0x6F, 0x6F, 0x70, 0x6F, 0x6F, 0x70, 0x7F, 0x70, 0x6F, 0x6F, 0x71, 0x6F, 0x6F, 0x6F, 0x70, 0x7F, 0x70, 0x6F, 0x6F, 0x70, 0x7F, 0x70, 0x6F, 0x6F, 0x6C, 0x6D, 0x6D, 0x6D, 0x73, 0x7F, 0x7F, 0x7F, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7F, 0x7F, 0xFF,
	0xFF, 0x00, 0x00, 0x00, 0xF8, 0xFC, 0x04, 0xFC, 0xF8, 0x00, 0xFC, 0xFC, 0x30, 0x60, 0xFC, 0xFC, 0x00, 0xFC, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x40, 0xC0, 0x00, 0xC0, 0x40, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0xE0, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0xE0, 0x00, 0x00, 0x00, 0xC0, 0x20, 0x20, 0x20, 0x20, 0xC0, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0xE0, 0x00, 0x00, 0x00, 0xFF,
	0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x01, 0x01, 0x80, 0xC0, 0xE1, 0x31, 0x18, 0x09, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x77, 0x55, 0xDD, 0x00, 0xDD, 0x55, 0xDD, 0x00, 0xDD, 0x55, 0x77, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xE3, 0x14, 0x14, 0x14, 0x14, 0xE3, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
	0xFF, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x81, 0x83, 0x9F, 0x9E, 0x8F, 0x87, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xFF, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x83, 0x86, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x86, 0x83, 0x80, 0x80, 0x80, 0xFF, 0x80, 0x80, 0x80, 0x83, 0x86, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x86, 0x83, 0x80, 0x80, 0x80, 0x83, 0x86, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x86, 0x83, 0x80, 0x80, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x80, 0x80, 0x80, 0x83, 0x86, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x86, 0x83, 0x80, 0x80, 0x80, 0x83, 0x86, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x86, 0x83, 0x80, 0x00, 0x00, 0xFF,
	0xFF, 0x00, 0x00, 0x00, 0xE0, 0x60, 0x60, 0xA0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xA0, 0x60, 0x60, 0xE0, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x10, 0x10, 0x10, 0x10, 0xE0, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0xE0, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0xE0, 0x00, 0x00, 0x00, 0xFF,
	0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x80, 0x40, 0x21, 0x11, 0x0A, 0x06, 0x04, 0x08, 0x08, 0x04, 0x06, 0x0A, 0x11, 0x21, 0x40, 0x80, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3E, 0x01, 0x00, 0x00, 0xC0, 0x3E, 0x01, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
	0x07, 0x18, 0x20, 0x40, 0x43, 0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x83, 0x83, 0x80, 0x80, 0x80, 0x80, 0x83, 0x86, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x86, 0x83, 0x80, 0x80, 0x80, 0x83, 0x86, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x86, 0x83, 0x80, 0x80, 0x80, 0x83, 0x86, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x86, 0x83, 0x80, 0x80, 0x80, 0x80, 0x83, 0x84, 0x84, 0x84, 0x84, 0x83, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x83, 0x86, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x86, 0x83, 0x80, 0x80, 0x80, 0x83, 0x86, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x86, 0x83, 0x80, 0x80, 0x80, 0x83, 0x86, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x86, 0x43, 0x40, 0x20, 0x18, 0x07
};

char lcd_status[] =
{
	1,1,1,1,0,0,1,1,1,1,1,0,1,1,0,1,1,	/* PAU */
	1,1,0,1,1,0,1,1,0,1,1,0,1,1,0,1,1,
	1,1,0,1,1,0,1,1,0,1,1,0,1,1,0,1,1,
	1,1,1,1,0,0,1,1,1,1,1,0,1,1,0,1,1,
	1,1,0,0,0,0,1,1,0,1,1,0,1,1,0,1,1,
	1,1,0,0,0,0,1,1,0,1,1,0,1,1,0,1,1,
	1,1,0,0,0,0,1,1,0,1,1,0,1,1,1,1,1,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,
	0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,0,0,
	0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,
	0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,
	0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
	0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,
	0,0,0,0,1,1,1,0,1,1,0,0,0,0,0,0,0,
	0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,

	0,1,1,1,0,0,1,1,0,0,1,1,0,1,1,0,0,	/* ONL */
	1,1,0,1,1,0,1,1,0,0,1,1,0,1,1,0,0,
	1,1,0,1,1,0,1,1,1,0,1,1,0,1,1,0,0,
	1,1,0,1,1,0,1,1,1,1,1,1,0,1,1,0,0,
	1,1,0,1,1,0,1,1,0,1,1,1,0,1,1,0,0,
	1,1,0,1,1,0,1,1,0,0,1,1,0,1,1,0,0,
	0,1,1,1,0,0,1,1,0,0,1,1,0,1,1,1,1,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,
	0,0,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,
	0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,
	0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,
	0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,

	0,1,1,1,0,0,1,1,1,1,1,1,0,1,1,0,0,	/* OFL */
	1,1,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,
	1,1,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,
	1,1,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,
	1,1,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,
	1,1,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,
	0,1,1,1,0,0,0,1,1,0,0,0,0,1,1,1,1,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,0,0,
	0,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,
	0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
	0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,
	0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,
	0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,
	0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

char lcd_digits[] =
{
	0,1,1,1,1,1,1,1,1,0,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,1,1,0,0,0,1,
	1,0,0,0,1,1,0,0,0,1,
	1,0,0,0,1,1,0,0,0,1,
	1,0,0,0,1,1,0,0,0,1,
	1,0,0,0,1,1,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	0,1,1,1,1,1,1,1,1,0,

	0,0,0,1,1,1,1,0,0,0,
	0,0,1,1,0,0,1,1,0,0,
	0,0,1,0,0,0,0,1,0,0,
	0,0,1,0,0,0,0,1,0,0,
	0,0,1,0,0,0,0,1,0,0,
	0,0,1,0,0,0,0,1,0,0,
	0,0,1,0,0,0,0,1,0,0,
	0,0,1,0,0,0,0,1,0,0,
	0,0,1,0,0,0,0,1,0,0,
	0,0,1,0,0,0,0,1,0,0,
	0,0,1,0,0,0,0,1,0,0,
	0,0,1,0,0,0,0,1,0,0,
	0,0,1,0,0,0,0,1,0,0,
	0,0,1,1,0,0,1,1,0,0,
	0,0,0,1,1,1,1,0,0,0,

	0,1,1,1,1,1,1,1,1,0,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,0,1,
	0,1,1,1,1,1,0,0,0,1,
	1,1,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,1,1,
	1,0,0,0,0,1,1,1,1,0,
	1,0,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	0,1,1,1,1,1,1,1,1,0,

	0,1,1,1,1,1,1,1,1,0,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,0,1,
	0,1,1,1,1,1,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,1,1,0,
	1,1,0,0,0,0,0,0,1,1,
	0,1,1,1,1,1,0,0,0,1,
	1,1,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	0,1,1,1,1,1,1,1,1,0,

	0,1,1,1,0,1,1,1,1,0,
	1,1,0,1,1,1,0,0,1,1,
	1,0,0,0,1,0,0,0,0,1,
	1,0,0,0,1,0,0,0,0,1,
	1,0,0,0,1,0,0,0,0,1,
	1,0,0,0,1,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,0,1,
	0,1,1,1,1,0,0,0,0,1,
	0,0,0,0,1,0,0,0,0,1,
	0,0,0,0,1,0,0,0,0,1,
	0,0,0,0,1,0,0,0,0,1,
	0,0,0,0,1,1,0,0,1,1,
	0,0,0,0,0,1,1,1,1,0,

	0,1,1,1,1,1,1,1,1,0,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,1,1,
	1,0,0,0,0,1,1,1,1,0,
	1,0,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,0,1,
	0,1,1,1,1,1,0,0,0,1,
	1,1,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	0,1,1,1,1,1,1,1,1,0,

	0,1,1,1,1,1,1,1,1,0,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,1,1,
	1,0,0,0,0,1,1,1,1,0,
	1,0,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,1,1,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	0,1,1,1,1,1,1,1,1,0,

	0,1,1,1,1,1,1,1,1,0,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,0,1,
	0,1,1,1,1,0,0,0,0,1,
	0,0,0,0,1,0,0,0,0,1,
	0,0,0,0,1,0,0,0,0,1,
	0,0,0,0,1,0,0,0,0,1,
	0,0,0,0,1,0,0,0,0,1,
	0,0,0,0,1,0,0,0,0,1,
	0,0,0,0,1,0,0,0,0,1,
	0,0,0,0,1,0,0,0,0,1,
	0,0,0,0,1,1,0,0,1,1,
	0,0,0,0,0,1,1,1,1,0,

	0,1,1,1,1,1,1,1,1,0,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,1,1,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	0,1,1,0,0,0,0,1,1,0,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,1,1,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	0,1,1,1,1,1,1,1,1,0,

	0,1,1,1,1,1,1,1,1,0,
	1,1,0,0,0,0,0,0,1,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,1,1,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,0,1,
	0,1,1,1,1,0,0,0,0,1,
	1,1,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,0,0,0,0,0,0,0,0,1,
	1,1,0,0,0,0,0,0,1,1,
	0,1,1,1,1,1,1,1,1,0,
};

#endif
