package Command::Runner::Quote;
use strict;
use warnings;

use String::ShellQuote ();

use Exporter 'import';
our @EXPORT_OK = qw(quote quote_win32 quote_unix);

sub win32_quote_literal {
    my ($text, $force) = @_;

    # basic argument quoting.  uses backslashes and quotes to escape
    # everything.
    if (!$force && $text ne '' && $text !~ /[ \t\n\x0b"]/) {
        # no quoting needed
    }
    else {
        $text =~ s{(\\*)(?="|\z)}{$1$1}g;
        $text =~ s{"}{\\"}g;
        $text = qq{"$text"};
    }

    return $text;
}

sub quote_win32 {
    my $str = shift;
    win32_quote_literal($str, 1);
}

sub quote_unix {
    my $str = shift;
    String::ShellQuote::shell_quote_best_effort($str);
}

if ($^O eq 'MSWin32') {
    *quote = \&quote_win32;
} else {
    *quote = \&quote_unix;
}

1;
