;;; lab-loaddefs.el --- automatically extracted autoloads (do not edit)   -*- lexical-binding: t -*-
;; Generated by the `loaddefs-generate' function.

;; This file is part of GNU Emacs.

;;; Code:



;;; Generated autoloads from lab.el

(defvar lab-map (let ((map (make-sparse-keymap))) (define-key map "c" #'lab-git-clone) (define-key map "pl" #'lab-act-on-last-failed-pipeline-job) (define-key map "pp" #'lab-list-project-pipelines) (define-key map "pg" #'lab-list-all-group-projects) (define-key map "po" #'lab-list-all-owned-projects) (define-key map "wp" #'lab-watch-pipeline) (define-key map "wc" #'lab-watch-pipeline-for-last-commit) (define-key map "mc" #'lab-create-merge-request) (define-key map "mm" #'lab-list-my-merge-requests) (define-key map "mg" #'lab-list-group-merge-requests) (define-key map "mb" #'lab-list-branch-merge-requests) (define-key map "mp" #'lab-list-project-merge-requests) map) "\
Keymap for commonly used interactive lab functions.
It is not bound to any key by default.  You can bind this keymap
to a key, like following:

  (bind-key \"C-x l\" lab-map)

...and now you can do `C-x mm' to list your open merge requests,
for example.  Do \\[execute-extended-command] `describe-keymap'
lab-map to list all actions in this keymap.")
(autoload 'lab-all-project-roots "lab" "\
Find every project dir under DIR.
DIR is `lab-projects-directory' by default.

This function simply checks for folders with `.git' under them.

(fn &optional DIR)")
(autoload 'lab-git-current-branch "lab" "\
Return current branch's name.")
(autoload 'lab-git-last-commit-sha "lab" "\
Return last commits SHA for current project.")
(autoload 'lab-git-get-config "lab" "\
`git config --get CONF' wrapper.

(fn CONF)")
(autoload 'lab-git-user-name "lab" "\
Return user name.")
(autoload 'lab-git-remote-homepage "lab" "\
Generate API base homepage from repository origin remote URL.")
(autoload 'lab-git-dir? "lab" "\
Check if DIR is git version controlled directory.

(fn DIR)")
(autoload 'lab-git-origin-switch-to-ssh "lab" "\
Switch remote origin address to SSH from HTTPS." t)
(autoload 'lab-git-clone "lab" "\
Clone URL to DIR.
DIR will be the parent directory of the repo you've just cloned.
You can think this as simple \"git clone URL\" call in DIR.

CALLBACK is called with either t or nil, indicating success
status.

Also see `lab-after-git-clone-functions'.

(fn URL DIR &key SHALLOW CALLBACK)" '((list (read-string "URL: ") (read-directory-name "Directory to clone in: " lab-projects-directory))))
(autoload 'lab-clone-bulk "lab" "\
Clone all REPOSITORIES to ROOT directory.
REPOSITORIES is a list containing repository alists in the form of

  \\='((path_with_namespace . \"group/subgroup/.../project_name\")
    (ssh_url_to_repo . \"ssh://...\")
    (https_url_to_repo . \"ssh://...\"))

This is typically returned by GitLab API.  Each project is cloned
under \"ROOT/path_with_namespace\", so it replicates the same
project hierarchy in GitLab in your local path ROOT.

If the inferred path for a project already exist in the
filesystem, that project will be simply skipped.

When called interactively, it asks for a path to clone projects
in (also see `lab-projects-directory') and also asks for a GitLab
group path to fetch all projects of (also see `lab-group').

(fn ROOT REPOSITORIES)" t)
(autoload 'lab-list-all-group-projects "lab" "\
List all GROUP projects and act on them.
See `lab-group'.  BE CAREFUL, this function tries to fetch all
functions belonging to given group.  Result is memoized after
first call for `memoize-default-timeout'.

(fn &optional GROUP)" t)
(autoload 'lab-list-all-owned-projects "lab" "\
Get all projects owned by you.
BE CAREFUL, this function tries to fetch all functions belonging
to given group.  Result is memoized after first call for
`memoize-default-timeout'." t)
(autoload 'lab-list-project-merge-requests "lab" "\
List all open MRs that belongs to PROJECT.
If it's omitted, currently open project is used.

(fn &optional PROJECT)" t)
(autoload 'lab-get-project-pipelines "lab" "\
Get pipelines for PROJECT.
If PROJECT is nil, current git project is used.

(fn &optional PROJECT)")
(autoload 'lab-list-project-pipelines "lab" "\
List latest pipelines belonging to PROJECT.
If PROJECT is nil,current git project is used.

(fn &optional PROJECT)" t)
(autoload 'lab-act-on-last-project-pipeline "lab" "\
List latest pipelines belonging to PROJECT.
If PROJECT is nil,current git project is used.

(fn &optional PROJECT)" t)
(autoload 'lab-get-pipeline "lab" "\
Get detailed information for PIPELINE-ID in PROJECT-ID.

(fn PROJECT-ID PIPELINE-ID)")
(autoload 'lab-get-pipeline-jobs "lab" "\
Get latest jobs for PIPELINE-ID in PROJECT-ID.

(fn PROJECT-ID PIPELINE-ID)")
(autoload 'lab-list-pipeline-jobs "lab" "\
List latest jobs for PIPELINE-ID in PROJECT-ID.

(fn PROJECT-ID PIPELINE-ID)")
(autoload 'lab-watch-pipeline "lab" "\
Start watching pipeline URL status.
Send a notification if it's finished, failed or waiting for a
manual action.  RERUN? is used to indicate that this is a
recurring call, instead of a new watch request.

(fn URL &optional RERUN?)" t)
(autoload 'lab-watch-pipeline-for-last-commit "lab" "\
Start watching the pipeline created by your last commit." t)
(autoload 'lab-watch-merge-request-last-pipeline "lab" "\
Start watching the latest pipeline of given MR.

(fn MR)")
(register-definition-prefixes "lab" '("lab-"))

;;; End of scraped data

(provide 'lab-loaddefs)

;; Local Variables:
;; version-control: never
;; no-byte-compile: t
;; no-update-autoloads: t
;; no-native-compile: t
;; coding: utf-8-emacs-unix
;; End:

;;; lab-loaddefs.el ends here
