if command -v flatpak > /dev/null; then
    # set XDG_DATA_DIRS to include Flatpak installations

    new_dirs=$(
        (
            unset G_MESSAGES_DEBUG
            echo "${XDG_DATA_HOME:-"$HOME/.local/share"}/flatpak"
            GIO_USE_VFS=local flatpak --installations
        ) | (
            new_dirs=
            while read -r install_path
            do
                share_path=$install_path/exports/share
                case ":$XDG_DATA_DIRS:" in
                    (*":$share_path:"*) :;;
                    (*":$share_path/:"*) :;;
                    (*) new_dirs=${new_dirs:+${new_dirs}:}$share_path;;
                esac
            done
            echo "$new_dirs"
        )
    )

    export XDG_DATA_DIRS
    XDG_DATA_DIRS="${new_dirs:+${new_dirs}:}${XDG_DATA_DIRS:-/usr/local/share:/usr/share}"

    unset new_dirs

    # set TZDIR to our setup-timezone directory
    # see https://gitlab.alpinelinux.org/alpine/aports/-/issues/14844
    if [ -d /etc/zoneinfo ]; then
        # this directory only exists if setup-timezone was run to add one timezone and not add tzdata.
        # unconditionally setting it would break things when it does not exist, so make sure it does.
        # if it does not exist, then /etc/localtime is going to be pointing to /usr/share/zoneinfo.
        contents="$(command ls -A /etc/zoneinfo)"
        # it can also be empty. don't export it then
        if [ -n "$contents" ]; then
            export TZDIR=/etc/zoneinfo
        fi
        unset contents
    fi
fi
