/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import org.hyperic.sigar.ProcExe;
import org.hyperic.sigar.ProcFd;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class ProcFileInfo
extends SigarCommandBase {
    public ProcFileInfo(Shell shell) {
        super(shell);
    }

    public ProcFileInfo() {
    }

    protected boolean validateArgs(String[] args) {
        return true;
    }

    public String getUsageShort() {
        return "Display process file info";
    }

    public boolean isPidCompleter() {
        return true;
    }

    public void output(String[] args) throws SigarException {
        long[] pids = this.shell.findPids(args);
        for (int i = 0; i < pids.length; ++i) {
            try {
                this.output(pids[i]);
            }
            catch (SigarPermissionDeniedException e) {
                this.println(this.shell.getUserDeniedMessage(pids[i]));
            }
            catch (SigarException e) {
                this.println("(" + e.getMessage() + ")");
            }
            this.println("\n------------------------\n");
        }
    }

    public void output(long pid) throws SigarException {
        this.println("pid=" + pid);
        try {
            ProcFd fd = this.sigar.getProcFd(pid);
            this.println("open file descriptors=" + fd.getTotal());
        }
        catch (SigarNotImplementedException fd) {
            // empty catch block
        }
        ProcExe exe = this.sigar.getProcExe(pid);
        String name = exe.getName();
        if (name.length() == 0) {
            name = "unknown";
        }
        this.println("name=" + name);
        this.println("cwd=" + exe.getCwd());
    }

    public static void main(String[] args) throws Exception {
        new ProcFileInfo().processCommand(args);
    }
}

