/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.shell;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.pager.PageControl;
import org.hyperic.sigar.pager.PageFetchException;
import org.hyperic.sigar.pager.PageFetcher;
import org.hyperic.sigar.pager.PageList;
import org.hyperic.sigar.shell.CollectionCompleter;
import org.hyperic.sigar.shell.NormalQuitCommandException;
import org.hyperic.sigar.shell.SIGINT;
import org.hyperic.sigar.shell.ShellCommandExecException;
import org.hyperic.sigar.shell.ShellCommandHandler;
import org.hyperic.sigar.shell.ShellCommandInitException;
import org.hyperic.sigar.shell.ShellCommandMapper;
import org.hyperic.sigar.shell.ShellCommandUsageException;
import org.hyperic.sigar.shell.ShellCommand_alias;
import org.hyperic.sigar.shell.ShellCommand_get;
import org.hyperic.sigar.shell.ShellCommand_help;
import org.hyperic.sigar.shell.ShellCommand_quit;
import org.hyperic.sigar.shell.ShellCommand_set;
import org.hyperic.sigar.shell.ShellCommand_sleep;
import org.hyperic.sigar.shell.ShellCommand_source;
import org.hyperic.sigar.shell.ShellIntHandler;
import org.hyperic.sigar.util.Getline;
import org.hyperic.sigar.util.GetlineCompleter;
import org.hyperic.sigar.util.IteratorIterator;

public abstract class ShellBase
implements ShellCommandMapper,
GetlineCompleter,
SIGINT {
    public static final String PROP_PAGE_SIZE = "page.size";
    private static final int DEFAULT_PAGE_SIZE = 20;
    private String name = null;
    private String prompt = null;
    private Map handlers = null;
    private HashMap hiddenCommands;
    protected Getline gl;
    protected PrintStream out = System.out;
    protected PrintStream err = System.err;
    private boolean doHistoryAdd;
    private int pageSize;
    private boolean isRedirected;
    private GetlineCompleter completer;

    public void handleSIGINT() {
        this.gl.reset();
    }

    public void initHistory() throws IOException {
        String historyFileName = "." + this.name + "_history";
        this.initHistory(new File(System.getProperty("user.home"), historyFileName));
    }

    public void initHistory(File file) throws IOException {
        this.doHistoryAdd = true;
        this.gl.initHistoryFile(file);
    }

    public void registerSigIntHandler() {
        ShellIntHandler.register(this);
    }

    public void init(String applicationName, PrintStream out, PrintStream err) {
        this.name = applicationName;
        this.prompt = applicationName;
        this.gl = new Getline();
        this.out = out;
        this.err = err;
        this.doHistoryAdd = false;
        this.pageSize = Integer.getInteger(PROP_PAGE_SIZE, 20);
        if (this.pageSize != -1) {
            --this.pageSize;
            if (this.pageSize < 1) {
                this.pageSize = 1;
            }
        }
        this.isRedirected = false;
        this.handlers = new HashMap();
        this.hiddenCommands = new HashMap();
        try {
            ShellCommand_quit quitCommand = new ShellCommand_quit();
            ShellCommand_source sourceCommand = new ShellCommand_source();
            this.registerCommandHandler(".", sourceCommand);
            this.registerCommandHandler("alias", new ShellCommand_alias());
            this.registerCommandHandler("exit", quitCommand);
            this.registerCommandHandler("get", new ShellCommand_get());
            this.registerCommandHandler("help", new ShellCommand_help());
            this.registerCommandHandler("q", quitCommand);
            this.registerCommandHandler("quit", quitCommand);
            this.registerCommandHandler("set", new ShellCommand_set());
            this.registerCommandHandler("source", sourceCommand);
            this.registerCommandHandler("sleep", new ShellCommand_sleep());
        }
        catch (Exception e) {
            err.println("ERROR: could not register standard commands: " + e);
            e.printStackTrace(err);
        }
        this.setHandlerHidden(".", true);
        this.setHandlerHidden("q", true);
        this.setHandlerHidden("exit", true);
        this.registerSigIntHandler();
        this.completer = new CollectionCompleter(this){

            public Iterator getIterator() {
                IteratorIterator it = new IteratorIterator();
                it.add(ShellBase.this.getCommandNameIterator());
                it.add(ShellCommand_alias.getAliases());
                return it;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRCFile(File rcFile, boolean echoCommands) throws IOException {
        FileInputStream is = null;
        boolean oldHistAdd = this.doHistoryAdd;
        this.doHistoryAdd = false;
        try {
            String line = null;
            is = new FileInputStream(rcFile);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                if (echoCommands) {
                    this.err.println(line);
                }
                this.handleCommand(line);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            this.doHistoryAdd = oldHistAdd;
        }
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public void registerCommandHandler(String commandName, ShellCommandHandler handler) throws ShellCommandInitException {
        this.handlers.put(commandName, handler);
        handler.init(commandName, this);
    }

    public String getInput(String prompt) throws EOFException, IOException {
        return this.gl.getLine(prompt);
    }

    public String getInput(String prompt, boolean addToHistory) throws EOFException, IOException {
        return this.gl.getLine(prompt, addToHistory);
    }

    public String getHiddenInput(String prompt) throws EOFException, IOException {
        return Sigar.getPassword(prompt);
    }

    public void sendToOutStream(String s) {
        this.out.println(s);
    }

    public void sendToErrStream(String s) {
        this.err.println(s);
    }

    public void run() {
        String input = null;
        ShellIntHandler.push(this);
        while (true) {
            try {
                input = this.gl.getLine(this.prompt + "> ", false);
            }
            catch (EOFException e) {
                break;
            }
            catch (Exception e) {
                this.err.println("Fatal error reading input line: " + e);
                e.printStackTrace(this.err);
                return;
            }
            if (input == null || input.trim().length() == 0) {
                if (Getline.isTTY()) continue;
                break;
            }
            try {
                this.handleCommand(input);
            }
            catch (NormalQuitCommandException nqce) {
                // empty catch block
                break;
            }
        }
        if (Getline.isTTY()) {
            this.out.println("Goodbye.");
        }
    }

    public void handleCommand(String line) {
        String[] args;
        try {
            args = ShellBase.explodeQuoted(line);
        }
        catch (IllegalArgumentException exc) {
            this.out.println("Syntax error: Unbalanced quotes");
            return;
        }
        if (args.length != 0) {
            this.handleCommand(line, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommand(String line, String[] args) {
        ShellCommandHandler handler = null;
        PrintStream oldSysOut = null;
        PrintStream oldOut = null;
        String command = args[0];
        if (args.length == 0) {
            return;
        }
        handler = this.getHandler(command);
        if (handler == null) {
            String[] aliasArgs = ShellCommand_alias.getAlias(command);
            if (aliasArgs == null) {
                this.err.println("unknown command: " + command);
                return;
            }
            this.handleCommand(line, aliasArgs);
            return;
        }
        int useArgs = args.length;
        if (args.length > 2 && args[args.length - 2].equals(">")) {
            PrintStream newOut;
            oldSysOut = System.out;
            oldOut = this.out;
            try {
                FileOutputStream fOut = new FileOutputStream(args[args.length - 1]);
                newOut = new PrintStream(fOut);
            }
            catch (IOException exc) {
                this.err.println("Failed to redirect to output file: " + exc);
                return;
            }
            this.isRedirected = true;
            this.out = newOut;
            System.setOut(newOut);
            useArgs -= 2;
        }
        String[] subArgs = new String[useArgs - 1];
        System.arraycopy(args, 1, subArgs, 0, subArgs.length);
        try {
            this.processCommand(handler, subArgs);
        }
        catch (ShellCommandUsageException e) {
            String msg = e.getMessage();
            if (msg == null || msg.trim().length() == 0) {
                msg = "an unknown error occurred";
            }
            this.err.println(command + ": " + msg);
        }
        catch (ShellCommandExecException e) {
            this.err.println(e.getMessage());
        }
        catch (NormalQuitCommandException e) {
            throw e;
        }
        catch (Exception e) {
            this.err.println("Unexpected exception processing command '" + command + "': " + e);
            e.printStackTrace(this.err);
        }
        finally {
            if (this.doHistoryAdd) {
                this.gl.addToHistory(line);
            }
            if (oldSysOut != null) {
                this.isRedirected = false;
                System.setOut(oldSysOut);
                this.out = oldOut;
            }
        }
    }

    public void processCommand(ShellCommandHandler handler, String[] args) throws ShellCommandUsageException, ShellCommandExecException {
        handler.processCommand(args);
    }

    public PrintStream getOutStream() {
        return this.out;
    }

    public PrintStream getErrStream() {
        return this.err;
    }

    public Getline getGetline() {
        return this.gl;
    }

    public boolean hasCompleter(ShellCommandHandler handler) {
        return GetlineCompleter.class.isAssignableFrom(handler.getClass());
    }

    public String complete(ShellCommandHandler handler, String line) {
        if (this.hasCompleter(handler)) {
            return ((GetlineCompleter)((Object)handler)).complete(line);
        }
        return line;
    }

    public String complete(String line) {
        if (line == null) {
            return null;
        }
        int ix = line.indexOf(" ");
        if (ix != -1) {
            String cmd = line.substring(0, ix);
            String sub = line.substring(ix + 1, line.length());
            ShellCommandHandler handler = this.getHandler(cmd);
            if (handler != null) {
                String hline = this.complete(handler, sub);
                return cmd + " " + hline;
            }
            return line;
        }
        if (this.getHandler(line = this.completer.complete(line)) != null) {
            return line + " ";
        }
        return line;
    }

    public ShellCommandHandler getHandler(String command) {
        if (command == null) {
            return null;
        }
        return (ShellCommandHandler)this.handlers.get(command.toLowerCase());
    }

    public void setHandlerHidden(String handlerName, boolean isHidden) {
        if (this.getHandler(handlerName) == null) {
            throw new IllegalArgumentException("Unknown handler: " + handlerName);
        }
        this.hiddenCommands.put(handlerName, isHidden ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean handlerIsHidden(String handlerName) {
        return this.hiddenCommands.get(handlerName) != null;
    }

    public Iterator getCommandNameIterator() {
        ArrayList<String> keyArray = new ArrayList<String>();
        Iterator i = this.handlers.keySet().iterator();
        while (i.hasNext()) {
            String keyName = (String)i.next();
            if (this.handlerIsHidden(keyName)) continue;
            keyArray.add(keyName);
        }
        Object[] keys = keyArray.toArray(new String[0]);
        Arrays.sort(keys);
        return Arrays.asList(keys).iterator();
    }

    public void shutdown() {
    }

    public boolean isRedirected() {
        return this.isRedirected;
    }

    public void setPageSize(int size) {
        if (size == 0 || size < -1) {
            throw new IllegalArgumentException("Page size must be > 0 or -1");
        }
        this.pageSize = size;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    private int getNumPages(PageControl control, PageList list) {
        int pageSize = control.getPagesize();
        int totalElems = list.getTotalSize();
        if (pageSize == -1) {
            return 1;
        }
        if (pageSize == 0) {
            return 0;
        }
        if (totalElems % pageSize == 0) {
            return totalElems / pageSize;
        }
        return totalElems / pageSize + 1;
    }

    private void printPage(PrintStream out, PageList data, int lineNo, boolean printLineNumbers) {
        Iterator i = data.iterator();
        while (i.hasNext()) {
            if (printLineNumbers) {
                out.print(lineNo++ + ": ");
            }
            out.println((String)i.next());
        }
    }

    public PageControl getDefaultPageControl() {
        PageControl res = new PageControl(0, this.getPageSize() == -1 ? -1 : this.getPageSize());
        return res;
    }

    public void performPaging(PageFetcher fetcher) throws PageFetchException {
        this.performPaging(fetcher, this.getDefaultPageControl());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performPaging(PageFetcher fetcher, PageControl control) throws PageFetchException {
        if (control.getPagesize() == 0) {
            return;
        }
        boolean lineNumberMode = false;
        PrintStream out = this.getOutStream();
        if (this.isRedirected()) {
            control.setPagesize(-1);
        }
        PageList data = fetcher.getPage((PageControl)control.clone());
        this.printPage(out, data, control.getPageEntityIndex() + 1, lineNumberMode);
        if (control.getPagesize() == -1 || data.size() < control.getPagesize()) {
            return;
        }
        while (true) {
            String cmd;
            boolean printPage = false;
            int totalPages = this.getNumPages(control, data);
            try {
                cmd = this.getInput("--More-- (Page " + (control.getPagenum() + 1) + " of " + totalPages + ")", false);
            }
            catch (IOException exc) {
                out.println();
                return;
            }
            if (cmd == null || (cmd = cmd.trim()).length() == 0) {
                printPage = true;
                control.setPagenum(control.getPagenum() + 1);
            } else {
                if (cmd.equals("q")) return;
                if (cmd.equals("b")) {
                    printPage = true;
                    if (control.getPagenum() > 0) {
                        control.setPagenum(control.getPagenum() - 1);
                    }
                } else if (cmd.equals("l")) {
                    lineNumberMode = !lineNumberMode;
                    printPage = true;
                } else if (cmd.equals("?")) {
                    out.println("  'b'        - Scroll back one page");
                    out.println("  'l'        - Toggle line number mode");
                    out.println("  'q'        - Quit paging");
                    out.println("  '<number>' - Jump to the specified page #");
                    out.println("  '<enter>'  - Scroll forward one page");
                } else {
                    int newPageNo;
                    try {
                        newPageNo = Integer.parseInt(cmd);
                    }
                    catch (NumberFormatException exc) {
                        out.println("Unknown command '" + cmd + "'  type '?' for paging help");
                        continue;
                    }
                    if (newPageNo < 1 || newPageNo > totalPages) {
                        out.println(newPageNo + " out of range (must be 1 to " + totalPages + ")");
                    } else {
                        control.setPagenum(newPageNo - 1);
                        printPage = true;
                    }
                }
            }
            if (!printPage) continue;
            data = fetcher.getPage((PageControl)control.clone());
            this.printPage(out, data, control.getPageEntityIndex() + 1, lineNumberMode);
            if (data.size() < control.getPagesize()) return;
        }
    }

    private static String[] explodeQuoted(String arg) {
        ArrayList<String> res = new ArrayList<String>();
        boolean inQuote = false;
        arg = arg.trim();
        StringTokenizer quoteTok = new StringTokenizer(arg, "\"", true);
        while (quoteTok.hasMoreTokens()) {
            String elem = (String)quoteTok.nextElement();
            if (elem.equals("\"")) {
                inQuote = !inQuote;
                continue;
            }
            if (inQuote) {
                res.add(elem);
                continue;
            }
            StringTokenizer spaceTok = new StringTokenizer(elem.trim());
            while (spaceTok.hasMoreTokens()) {
                res.add(spaceTok.nextToken());
            }
        }
        if (inQuote) {
            throw new IllegalArgumentException("Unbalanced quotation marks");
        }
        return res.toArray(new String[0]);
    }
}

