/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class ProcInfo
extends SigarCommandBase {
    private boolean isSingleProcess;

    public ProcInfo(Shell shell) {
        super(shell);
    }

    public ProcInfo() {
    }

    protected boolean validateArgs(String[] args) {
        return true;
    }

    public String getUsageShort() {
        return "Display all process info";
    }

    public boolean isPidCompleter() {
        return true;
    }

    public void output(String[] args) throws SigarException {
        this.isSingleProcess = false;
        if (args.length != 0 && args[0].startsWith("-s")) {
            this.isSingleProcess = true;
        }
        if (this.isSingleProcess) {
            for (int i = 1; i < args.length; ++i) {
                try {
                    this.output(args[i]);
                }
                catch (SigarException e) {
                    this.println("(" + e.getMessage() + ")");
                }
                this.println("\n------------------------\n");
            }
        } else {
            long[] pids = this.shell.findPids(args);
            for (int i = 0; i < pids.length; ++i) {
                try {
                    this.output(String.valueOf(pids[i]));
                }
                catch (SigarPermissionDeniedException e) {
                    this.println(this.shell.getUserDeniedMessage(pids[i]));
                }
                catch (SigarException e) {
                    this.println("(" + e.getMessage() + ")");
                }
                this.println("\n------------------------\n");
            }
        }
    }

    public void output(String pid) throws SigarException {
        block10: {
            this.println("pid=" + pid);
            try {
                this.println("state=" + this.sigar.getProcState(pid));
            }
            catch (SigarException e) {
                if (!this.isSingleProcess) break block10;
                this.println(e.getMessage());
            }
        }
        try {
            this.println("mem=" + this.sigar.getProcMem(pid));
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        try {
            this.println("cpu=" + this.sigar.getProcCpu(pid));
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        try {
            this.println("cred=" + this.sigar.getProcCred(pid));
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        try {
            this.println("credname=" + this.sigar.getProcCredName(pid));
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        new ProcInfo().processCommand(args);
    }
}

