local mymodule = {}

mymodule.default_action = "listmessages"

mymodule.listfolders = function( self )
	return self.model.list_folders()
end

mymodule.listusers = function( self )
	return self.model.list_users(self, self.clientdata)
end

mymodule.editusers = function( self )
	return self.model.list_users(self, self.clientdata)
end

mymodule.deleteuser = function( self )
	return self.handle_form(self, self.model.get_delete_user, self.model.set_delete_user, self.clientdata, "Delete", "Delete User", "User Deleted")
end

mymodule.listmessages = function( self )
	return self.model.list_messages(self.clientdata.username)
end

mymodule.listmymessages = function( self )
	return self.model.list_messages(self.sessiondata.userinfo.userid)
end

mymodule.downloadmessage = function( self )
	return self.handle_form(self, self.model.get_download_message, self.model.download_message, self.clientdata, "Download", "Download Message")
end

mymodule.downloadmymessage = function( self )
	self.clientdata.username = self.sessiondata.userinfo.userid
	local retval = self.handle_form(self, self.model.get_download_message, self.model.download_message, self.clientdata, "Download", "Download Message")
	retval.value.username.readonly = true
	return retval
end

mymodule.deletemessage = function( self )
	return self.handle_form(self, self.model.get_delete_message, self.model.set_delete_message, self.clientdata, "Delete", "Delete Message", "Message Deleted")
end

mymodule.deletemymessage = function( self )
	self.clientdata.username = nil
	if self.sessiondata.userinfo then
		self.clientdata.username = self.sessiondata.userinfo.userid
	end
	return self.handle_form(self, self.model.get_delete_message, self.model.set_delete_message, self.clientdata, "Delete", "Delete Message", "Message Deleted")
end

mymodule.forwardmessage = function( self )
	return self.handle_form(self, self.model.get_forward_message, self.model.forward_message, self.clientdata, "Forward", "Forward Message", "Message Forwarded")
end

mymodule.forwardmymessage = function( self )
	self.clientdata.username = nil
	if self.sessiondata.userinfo then
		self.clientdata.username = self.sessiondata.userinfo.userid
	end
	return self.handle_form(self, self.model.get_forward_message, self.model.forward_message, self.clientdata, "Forward", "Forward Message", "Message Forwarded")
end

mymodule.emailmessage = function( self )
	return self.handle_form(self, self.model.get_email_message, self.model.email_message, self.clientdata, "Email", "Email Message")
end

mymodule.emailmymessage = function( self )
	self.clientdata.username = nil
	if self.sessiondata.userinfo then
		self.clientdata.username = self.sessiondata.userinfo.userid
	end
	return self.handle_form(self, self.model.get_email_message, self.model.email_message, self.clientdata, "Email", "Email Message")
end

mymodule.movemessage = function( self )
	return self.handle_form(self, self.model.get_move_message, self.model.move_message, self.clientdata, "Move")
end

mymodule.movemymessage = function( self )
	self.clientdata.username = nil
	if self.sessiondata.userinfo then
		self.clientdata.username = self.sessiondata.userinfo.userid
	end
	return self.handle_form(self, self.model.get_move_message, self.model.move_message, self.clientdata, "Move")
end

mymodule.callbackmessage = function( self )
	return self.handle_form(self, self.model.get_callback_message, self.model.callback_message, self.clientdata, "Callme")
end

mymodule.callbackmymessage = function( self )
	self.clientdata.username = nil
	if self.sessiondata.userinfo then
		self.clientdata.username = self.sessiondata.userinfo.userid
	end
	return self.handle_form(self, self.model.get_callback_message, self.model.callback_message, self.clientdata, "Callme")
end

mymodule.editusersettings = function( self )
	return self.handle_form(self, self.model.get_usersettings, self.model.update_usersettings, self.clientdata, "Save", "Edit Settings", "Settings Saved")
end

mymodule.editmyusersettings = function( self )
	self.clientdata.username = nil
	if self.sessiondata.userinfo then
		self.clientdata.username = self.sessiondata.userinfo.userid
	end
	return self.handle_form(self, self.model.get_usersettings, self.model.update_usersettings, self.clientdata, "Save", "Edit Settings", "Settings Saved")
end

mymodule.createuser = function( self )
	return self.handle_form(self, self.model.get_usersettings, self.model.create_usersettings, self.clientdata, "Create", "Create User", "User Created")
end

mymodule.createmanyusers = function( self )
	return self.handle_form(self, self.model.get_bunchsettings, self.model.set_bunchsettings, self.clientdata, "Create Many", "Create Users", "Users Created")
end

mymodule.processdialplanxml = function( self )
	self.conf.viewtype = "xml"
	return self.model.process_dialplan_xml_request(self.clientdata)
end

mymodule.processdirectoryxml = function( self )
	self.conf.viewtype = "xml"
	return self.model.process_directory_xml_request(self.clientdata)
end

mymodule.editconfig = function( self )
	return self.handle_form(self, self.model.get_config, self.model.update_config, self.clientdata, "Save", "Update Config", "Config Saved")
end

return mymodule
