-- Authentication from voicemail DB
local mymodule = {}

authenticator = require("authenticator")
md5 = require("md5")

-- We will not list entries from the voicemail database, as you must use the freeswitch-vmail controller
-- to list/view/edit entries. Similarly, we will not allow deletion. We will only allow reading single
-- entries, as is done during authentication. These entries will be specified for table=authenticator.usertable
-- and field="". Roles and home page are hardcoded below.

mymodule.list_fields = function(self, tabl)
	if tabl==authenticator.usertable then
		return {""}
	else
		return {}
	end
end

-- Do not list entries from vmail, must use vmail controller to view/edit
mymodule.read_field = function(self, tabl, field)
	return {}
end

-- We do not allow deletion
mymodule.delete_field = function(self, tabl, field)
	return false
end

-- We do not allow writing
mymodule.write_entry = function(self, tabl, field, id, entry)
	return false
end

mymodule.read_entry = function(self, tabl, field, id)
	local result
	if tabl == authenticator.usertable and field == "" then
		-- authenticator is reading one user
		local vmcontroller = self:new("freeswitch-vmail/vmail")
		local users = vmcontroller.model.list_passwords(id)
		if users and users.value and users.value[1] and users.value[1].password then
-- TODO can change this from md5 to password hash, not that it really matters much as the result isn't stored anywhere
			result = md5.sumhexa(users.value[1].password)..":Voicemail User:/freeswitch-vmail/vmail/USER::/freeswitch-vmail/vmail/listmymessages"
		end
		vmcontroller:destroy()
	end
	return result
end

-- We do not allow deletion
mymodule.delete_entry = function (self, tabl, field, id)
	return false
end

return mymodule
