
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was pdb-redoConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)
find_dependency(GSL REQUIRED)
find_dependency(cifpp 5.0.4 REQUIRED)
find_dependency(Eigen3 REQUIRED)
find_dependency(CCP4 REQUIRED ccp4c clipper-core clipper-ccp4 clipper-contrib)

INCLUDE("${CMAKE_CURRENT_LIST_DIR}/pdb-redoTargets.cmake")

set_and_check(PDB-REDO_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(PDB-REDO_LIBRARY_DIR "${PACKAGE_PREFIX_DIR}/lib")

check_required_components(pdb-redo)
