from collections.abc import Mapping, Sequence
import enum
from typing import overload


class Coord_orth:
    def __init__(self, arg0: float, arg1: float, arg2: float, /) -> None: ...

    def x(self) -> float: ...

    def y(self) -> float: ...

    def z(self) -> float: ...

class map_molecule_centre_info_t:
    @property
    def success(self) -> bool: ...

    @property
    def updated_centre(self) -> Coord_orth: ...

    @property
    def suggested_contour_level(self) -> float: ...

class Cell_descr:
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, /) -> None: ...

    def a(self) -> float: ...

    def b(self) -> float: ...

    def c(self) -> float: ...

    def alpha(self) -> float: ...

    def beta(self) -> float: ...

    def gamma(self) -> float: ...

    def alpha_deg(self) -> float: ...

    def beta_deg(self) -> float: ...

    def gamma_deg(self) -> float: ...

    def format(self) -> Clipper_String: ...

class Cell(Cell_descr):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg: Cell_descr, /) -> None: ...

    def a_star(self) -> float: ...

    def b_star(self) -> float: ...

    def c_star(self) -> float: ...

    def alpha_star(self) -> float: ...

    def beta_star(self) -> float: ...

    def gamma_star(self) -> float: ...

    def descr(self) -> Cell_descr: ...

    def is_null(self) -> bool: ...

    def init(self, arg: Cell_descr, /) -> None: ...

class Xmap_base:
    def cell(self) -> Cell: ...

class Clipper_String:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg: str, /) -> None: ...

class Xmap_float(Xmap_base):
    def __init__(self) -> None: ...

class CCP4MAPfile:
    def __init__(self) -> None: ...

    def open_read(self, arg: Clipper_String, /) -> None: ...

    def open_write(self, arg: Clipper_String, /) -> None: ...

    def close_read(self) -> None: ...

    def close_write(self) -> None: ...

class Atom:
    def __init__(self) -> None: ...

    @property
    def x(self) -> float: ...

    @x.setter
    def x(self, arg: float, /) -> None: ...

    @property
    def y(self) -> float: ...

    @y.setter
    def y(self, arg: float, /) -> None: ...

    @property
    def z(self) -> float: ...

    @z.setter
    def z(self, arg: float, /) -> None: ...

    @property
    def serNum(self) -> int: ...

    @serNum.setter
    def serNum(self, arg: float, /) -> None: ...

    @property
    def occupancy(self) -> float: ...

    @occupancy.setter
    def occupancy(self, arg: float, /) -> None: ...

    @property
    def tempFactor(self) -> float: ...

    @tempFactor.setter
    def tempFactor(self, arg: float, /) -> None: ...

    @property
    def charge(self) -> float: ...

    @charge.setter
    def charge(self, arg: float, /) -> None: ...

    @property
    def sigX(self) -> float: ...

    @sigX.setter
    def sigX(self, arg: float, /) -> None: ...

    @property
    def sigY(self) -> float: ...

    @sigY.setter
    def sigY(self, arg: float, /) -> None: ...

    @property
    def sigZ(self) -> float: ...

    @sigZ.setter
    def sigZ(self, arg: float, /) -> None: ...

    @property
    def sigOcc(self) -> float: ...

    @sigOcc.setter
    def sigOcc(self, arg: float, /) -> None: ...

    @property
    def sigTemp(self) -> float: ...

    @sigTemp.setter
    def sigTemp(self, arg: float, /) -> None: ...

    @property
    def u11(self) -> float: ...

    @u11.setter
    def u11(self, arg: float, /) -> None: ...

    @property
    def u22(self) -> float: ...

    @u22.setter
    def u22(self, arg: float, /) -> None: ...

    @property
    def u33(self) -> float: ...

    @u33.setter
    def u33(self, arg: float, /) -> None: ...

    @property
    def u13(self) -> float: ...

    @u13.setter
    def u13(self, arg: float, /) -> None: ...

    @property
    def u23(self) -> float: ...

    @u23.setter
    def u23(self, arg: float, /) -> None: ...

    @property
    def Het(self) -> bool: ...

    @Het.setter
    def Het(self, arg: bool, /) -> None: ...

    @property
    def Ter(self) -> bool: ...

    @Ter.setter
    def Ter(self, arg: bool, /) -> None: ...

    def GetNBonds(self) -> int: ...

    def GetModelNum(self) -> int: ...

    def GetSeqNum(self) -> int: ...

    def GetLabelSeqID(self) -> int: ...

    def GetLabelEntityID(self) -> int: ...

    def GetSSEType(self) -> int: ...

    def isTer(self) -> bool: ...

    def isMetal(self) -> bool: ...

    def isSolvent(self) -> bool: ...

    def isInSelection(self, arg: int, /) -> bool: ...

    def isNTerminus(self) -> bool: ...

    def isCTerminus(self) -> bool: ...

    def GetResidueNo(self) -> int: ...

    def GetIndex(self) -> int: ...

    def GetAtomName(self) -> str: ...

    def SetAtomName(self, arg: str, /) -> None: ...

    def GetChainID(self) -> str: ...

    def GetLabelAsymID(self) -> str: ...

    def GetLabelCompID(self) -> str: ...

    def GetInsCode(self) -> str: ...

class Residue:
    def __init__(self) -> None: ...

    @property
    def seqNum(self) -> int: ...

    @seqNum.setter
    def seqNum(self, arg: int, /) -> None: ...

    @property
    def label_seq_id(self) -> int: ...

    @label_seq_id.setter
    def label_seq_id(self, arg: int, /) -> None: ...

    @property
    def label_entity_id(self) -> int: ...

    @label_entity_id.setter
    def label_entity_id(self, arg: int, /) -> None: ...

    @property
    def index(self) -> int: ...

    @index.setter
    def index(self, arg: int, /) -> None: ...

    @property
    def nAtoms(self) -> int: ...

    @nAtoms.setter
    def nAtoms(self, arg: int, /) -> None: ...

    def GetModelNum(self) -> int: ...

    def GetSeqNum(self) -> int: ...

    def GetLabelSeqID(self) -> int: ...

    def GetLabelEntityID(self) -> int: ...

    def GetResidueNo(self) -> int: ...

    def GetNofAltLocations(self) -> int: ...

    def isAminoacid(self) -> bool: ...

    def isNucleotide(self) -> bool: ...

    def isDNARNA(self) -> int: ...

    def isSugar(self) -> bool: ...

    def isSolvent(self) -> bool: ...

    def isModRes(self) -> bool: ...

    def isInSelection(self, arg: int, /) -> bool: ...

    def isNTerminus(self) -> bool: ...

    def isCTerminus(self) -> bool: ...

    def GetResName(self) -> str: ...

    def GetChainID(self) -> str: ...

    def GetLabelAsymID(self) -> str: ...

    def GetLabelCompID(self) -> str: ...

    def GetInsCode(self) -> str: ...

    def GetAtom(self, arg: int, /) -> Atom: ...

    def GetNumberOfAtoms(self) -> int: ...

    def GetNumberOfAtoms_countTers(self, arg: bool, /) -> int: ...

class molecules_container_t:
    def __init__(self, be_verbose_when_reading_dictionary: bool) -> None:
        """molecules container Documentation"""

    def M2T_updateFloatParameter(self, imol: int, param_name: str, value: float) -> None:
        """
        Update float parameter for MoleculesToTriangles molecular mesh. 

            Args:
                imol (int): 
                param_name (str): 
                value (float): 

            Returns:
                None
        """

    def M2T_updateIntParameter(self, imol: int, param_name: str, value: int) -> None:
        """
        Update int parameter for MoleculesToTriangles molecular mesh. 

            Args:
                imol (int): 
                param_name (str): 
                value (int): 

            Returns:
                None
        """

    def SSM_superpose(self, imol_ref: int, chain_id_ref: str, imol_mov: int, chain_id_mov: str) -> superpose_results_t:
        """
        Superposition (using SSM)

            The specified chain of the moving molecule is superposed onto the chain in the reference molecule (if possible).

            Args:
                imol_ref (int): the reference model molecule index 
                chain_id_ref (str): the chain ID for the reference chain 
                imol_mov (int): the moving model molecule index 
                chain_id_mov (str): the chain ID for the moving chain
        """

    def add_alternative_conformation(self, imol_model: int, cid: str) -> int:
        """
        Add an alternative conformation for the specified residue

            Args:
                imol_model (int): is the model molecule index 
                cid (str): is the selection CID e.g "//A/15" (residue 15 in chain A)

            Returns:
                int: 1 on a successful addition, 0 on failure.
        """

    def add_colour_rule(self, imol: int, selection_cid: str, colour: str) -> None:
        """
        Add a colour rule for M2T representations. 

            Args:
                imol (int): 
                selection_cid (str): 
                colour (str): 

            Returns:
                None
        """

    def add_colour_rules_multi(self, imol: int, selections_and_colours_combo_string: str) -> None:
        """
        Add multiple colour rules

            Args:
                imol (int): 
                selections_and_colours_combo_string (str): e.g. "//A/1^#cc0000|//A/2^#cb0002|//A/3^#c00007", where "|" is the separator for each rule and "^" is the separator for the selection string and the colour string 

            Returns:
                None
        """

    def add_hydrogen_atoms(self, imol_model: int) -> int:
        """
        Add hydrogen atoms

            Args:
                imol_model (int): is the model molecule index

            Returns:
                int: 1 on success, 0 on failure.
        """

    def add_lsq_superpose_match(self, chain_id_ref: str, res_no_ref_start: int, res_no_ref_end: int, chain_id_mov: str, res_no_mov_start: int, res_no_mov_end: int, match_type: int) -> None:
        """
        Superpose using LSQ - setup the matches

            Args:
                chain_id_ref (str): the chain ID for the reference chain 
                res_no_ref_start (int): the starting residue number in the reference chain 
                res_no_ref_end (int): the ending residue number in the reference chain 
                chain_id_mov (str): the chain ID for the moving chain 
                res_no_mov_start (int): the starting residue number in the moving chain 
                res_no_mov_end (int): the ending residue number in the moving chain 
                match_type (int): 0: all, 1: main, 2: CAs, 3: N, CA, C, 4: N, CA, CB, C 

            Returns:
                None
        """

    def add_lsq_superpose_atom_match(self, chain_id_ref: str, res_no_ref: int, atom_name_ref: str, chain_id_mov: str, res_no_mov: int, atom_name_mov: str) -> None:
        """
        Superpose using LSQ for a scpecific atom - setup the matches

            Args:
                chain_id_ref (str): the chain ID for the reference chain 
                res_no_ref (int): the residue number in the reference chain 
                atom_name_ref (str): the name of the reference atom 
                chain_id_mov (str): the chain ID for the moving chain 
                res_no_mov (int): the residue number in the moving chain 
                atom_name_mov (str): the name of the moving atom 

            Returns:
                None
        """

    def add_named_glyco_tree(self, imol_model: int, imol_map: int, glycosylation_name: str, asn_chain_id: str, asn_res_no: int) -> None:
        """
        Add N-linked glycosylation

            Args:
                imol_model (int): is the model molecule index 
                imol_map (int): is the map molecule index 
                glycosylation_name (str): is the type of glycosylation, one of: "NAG-NAG-BMA" or "high-mannose" or "hybrid" or "mammalian-biantennary" or "plant-biantennary" 
                asn_chain_id (str): is the chain-id of the ASN to which the carbohydrate is to be added 
                asn_res_no (int): is the residue number of the ASN to which the carbohydrate is to be added 

            Returns:
                None
        """

    def add_target_position_restraint(self, imol: int, atom_cid: str, pos_x: float, pos_y: float, pos_z: float) -> None:
        """
        Add or update restraint (if it has a pull restraint already)

            Args:
                imol (int): is the model molecule index 
                atom_cid (str): is the selection CID e.g "//A/15/OH" (atom OH of residue 15 of chain A) 
                pos_x (float): is the x coordinate of the target position of the specified atom 
                pos_y (float): is the y coordinate of the target position of the specified atom 
                pos_z (float): is the z coordinate of the target position of the specified atom 

            Returns:
                None
        """

    def add_target_position_restraint_and_refine(self, imol: int, atom_cid: str, pos_x: float, pos_y: float, pos_z: float, n_cycles: int) -> instanced_mesh_t:
        """
        Create a new position for the given atom and create a new bonds mesh based on that

            This is currently "heavyweight" as the bonds mesh is calculated from scratch (it is not (yet) merely a distortion of an internally-stored mesh).

            Args:
                imol (int): is the model molecule index 
                atom_cid (str): is the selection CID e.g "//A/15/OH" (atom OH of residue 15 of chain A) 
                pos_x (float): is the x coordinate of the target position of the specified atom 
                pos_y (float): is the y coordinate of the target position of the specified atom 
                pos_z (float): is the z coordinate of the target position of the specified atom 
                n_cycles (int): specifies the number of refinement cyles to run after the target position of the atom has been applied. If n_cycles is -1 then, no cycles are done and the mesh is bonds merely calculated.
        """

    def add_terminal_residue_directly(self, imol: int, chain_id: str, res_no: int, ins_code: str) -> tuple[int, str]:
        """
        Add a residue onto the end of the chain by fitting to density

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" for chain A 
                res_no (int): is the residue number, e.g. 12 
                ins_code (str): is the insertion code, e.g. "A"

            Returns:
                tuple: first: 1 on success, second is failure message
        """

    def add_terminal_residue_directly_using_cid(self, imol: int, cid: str) -> int:
        """
        Add a residue onto the end of the chain by fitting to density using cid

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID e.g "//A/15/OH" (atom OH in residue 15) 

            Returns:
                int: success status (1 for good, 0 for not done)
        """

    def add_to_non_drawn_bonds(self, imol: int, atom_selection_cid: str) -> None:
        """
        Add an atom selection cid for atoms and bonds not to be drawn

            Args:
                imol (int): is the model molecule index 
                atom_selection_cid (str): e.g "//A/15" (all the atoms in residue 15 of chain A) 

            Returns:
                None
        """

    def add_waters(self, imol_model: int, imol_map: int) -> int:
        """
        Add waters

            Args:
                imol_model (int): 
                imol_map (int): is the map molecule index

            Returns:
                int: the number of waters added on a success, -1 on failure.
        """

    def all_molecule_contact_dots(self, imol: int, smoothness_factor: int) -> instanced_mesh_t:
        """
        Contact dots for the whole molecule/model

            Args:
                imol (int): is the model molecule index 
                smoothness_factor (unsigned int): is 1, 2 or 3 (3 is the most smooth). Recently added (20230202)
        """

    def apply_transformation_to_atom_selection(self, imol: int, atoms_selection_cid: str, n_atoms: int, m00: float, m01: float, m02: float, m10: float, m11: float, m12: float, m20: float, m21: float, m22: float, c0: float, c1: float, c2: float, t0: float, t1: float, t2: float) -> int:
        """
        Apply transformation to atom selection in the given molecule

            Args:
                imol (int): 
                atoms_selection_cid (str): 
                n_atoms (int): 
                m00 (float): 
                m01 (float): 
                m02 (float): 
                m10 (float): 
                m11 (float): 
                m12 (float): 
                m20 (float): 
                m21 (float): 
                m22 (float): 
                c0 (float): 
                c1 (float): 
                c2 (float): 
                t0 (float): 
                t1 (float): 
                t2 (float): 

            Returns:
                int: the number of atoms moved.
        """

    def assign_sequence(self, imol_model: int, imol_map: int) -> None:
        """
        Assign a sequence to a molecule

            Often one might copy out a fragment from a more complete molecule (and then copy it back after the sequence has been added). This runs 

            Args:
                imol_model (int): 
                imol_map (int): is the map molecule index 

            Returns:
                None
        """

    def associate_data_mtz_file_with_map(self, imol: int, data_mtz_file_name: str, f_col: str, sigf_col: str, free_r_col: str) -> None:
        """
        Associate a data mtz file with a molecule

            This function is called before calling "connect_updating_maps()"

            Args:
                imol (int): is the map molecule index 
                data_mtz_file_name (str): is the name of the mtz file 
                f_col (str): is the F column, e.g. "FOBS" 
                sigf_col (str): e.g. "SIGFOBS" 
                free_r_col (str): e.g. "RFREE" 

            Returns:
                None
        """

    def associate_sequence(self, imol: int, name_or_chain_id: str, sequence: str) -> None:
        """
        Associate a sequence with a molecule

            Args:
                imol (int): is the model molecule index 
                name_or_chain_id (str): e.g. "A" 
                sequence (str): is the model sequence 

            Returns:
                None
        """

    def auto_fit_rotamer(self, imol: int, chain_id: str, res_no: int, ins_code: str, alt_conf: str, imol_map: int) -> int:
        """
        Auto-fit rotamer

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" for chain A 
                res_no (int): is the residue number, e.g. 12 
                ins_code (str): is the insertion code, e.g. "A" 
                alt_conf (str): is the alternate conformation, e.g. "A" or "B" 
                imol_map (int): is the map molecule index

            Returns:
                int: 1 on successful modification, return 0 on failure
        """

    def auto_read_mtz(self, file_name: str) -> list["molecules_container_t::auto_read_mtz_info_t"]:
        """
        Auto read the given mtz file

            Args:
                file_name (str): is the name of the MTZ file

            Returns:
                list: a vector of the maps created from reading the file
        """

    def average_map(self, imol_maps: str, scales: Sequence[float]) -> int:
        """
        Get the average map

            This function does no normalization of the scales, presuming that they are pre-normalized.

            Args:
                imol_maps (str): is a colon-separated list of map indices e.g. "2:3:4" 
                scales (list): is the list of weights corresponding to the list of maps. The number of scales factors should match the number of maps

            Returns:
                int: the index of the new map, or -1 on failure.
        """

    def calculate_new_rail_points(self) -> int:
        """
        Calling this adds to the rail_points history. Make this pairs when we add model scoring

            Returns:
                int: the new rail points (since last modification)
        """

    def change_to_first_rotamer(self, imol: int, residue_cid: str, alt_conf: str) -> rotamer_change_info_t:
        """
        Change to the first (0th) rotamer

            Args:
                imol (int): is the model molecule index 
                residue_cid (str): is the atom selection CID e.g "//A/15" (all the atoms in residue 15 of chain A) 
                alt_conf (str): is the alternate conformation, e.g. "A" or "B"
        """

    def change_to_next_rotamer(self, imol: int, residue_cid: str, alt_conf: str) -> rotamer_change_info_t:
        """
        Change to the next rotamer (rotamer cycling is implicit if needed)

            Args:
                imol (int): is the model molecule index 
                residue_cid (str): is the atom selection CID e.g "//A/15" (all the atoms in residue 15 of chain A) 
                alt_conf (str): is the alternate conformation, e.g. "A" or "B"
        """

    def change_to_previous_rotamer(self, imol: int, residue_cid: str, alt_conf: str) -> rotamer_change_info_t:
        """
        Change to the previous rotamer (rotamer cycling is implicit if needed)

            Args:
                imol (int): is the model molecule index 
                residue_cid (str): is the atom selection CID e.g "//A/15" (all the atoms in residue 15 of chain A) 
                alt_conf (str): is the alternate conformation, e.g. "A" or "B"
        """

    def cis_trans_convert(self, imol: int, atom_cid: str) -> int:
        """
        Convert a cis peptide to a trans or vice versa

            Args:
                imol (int): is the model molecule index 
                atom_cid (str): is the atom selection CID e.g "//A/15/OH" (atom OH residue 15 of chain A)

            Returns:
                int: 1 on a successful conversion.
        """

    def clear_extra_restraints(self, imol: int) -> None:
        """
        Clear the extra restraints

            Args:
                imol (int): is the model molecule index 

            Returns:
                None
        """

    def clear_lsq_matches(self) -> None:
        """
        Clear any existing lsq matchers. 

            Returns:
                None
        """

    def clear_non_drawn_bonds(self, imol: int) -> None:
        """
        Clear the set of non-drawn atoms (so that they can be displayed again)

            Args:
                imol (int): is the model molecule index 

            Returns:
                None
        """

    def clear_refinement(self, imol: int) -> None:
        """
        Call this after molecule refinement has finished (say when the molecule molecule is accepted into the original molecule)

            Args:
                imol (int): is the model molecule index 

            Returns:
                None
        """

    def clear_target_position_restraints(self, imol: int) -> None:
        """
        Clear any and all drag-atom target position restraints

            Args:
                imol (int): is the model molecule index 

            Returns:
                None
        """

    def change_alt_locs(self, imol: int, cid: str, change_mode: str) -> int:
        """
        Change alternate conformation

            Note that this function only deals with (swaps) alt confs "A" and "B" - any alt-conf other than that is ignored.

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID e.g "//A/15" (residue 15 in chain A) 
                change_mode (str): is either "residue", "main-chain", "side-chain" or a comma-separated atom-name pairs (e.g "N,CA") - you can (of course) specify just one atom, e.g.: "N".

            Returns:
                int: the success status (1 is done, 0 means failed to do)
        """

    def close_molecule(self, imol: int) -> int:
        """
        Close the molecule (and delete dynamically allocated memory)

            Args:
                imol (int): is the model molecule index

            Returns:
                int: 1 on successful closure and 0 on failure to close
        """

    def connect_updating_maps(self, imol_model: int, imol_with_data_info_attached: int, imol_map_2fofc: int, imol_map_fofc: int) -> int:
        """
        Connect updating maps

            Reset the rail_points (calls "reset_the_rail_points()"), updates the maps (using internal/clipper SFC). Update your contour lines meshes after calling this function.

            Args:
                imol_model (int): is the model molecule index 
                imol_with_data_info_attached (int): is the map index with the data have been attached by the previous function (associate_data_mtz_file_with_map) 
                imol_map_2fofc (int): is the map molecule index of the 2FO-FC map 
                imol_map_fofc (int): is the map molecule index of the FO-FC map

            Returns:
                int: 1 if the connection was successful
        """

    def contact_dots_for_ligand(self, imol: int, cid: str, smoothness_factor: int) -> instanced_mesh_t:
        """
        Contact dots for ligand

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID e.g "//A/15" (residue 15 of chain A) 
                smoothness_factor (unsigned int): is 1, 2 or 3 (3 is the most smooth). Recently added (20230202)
        """

    def copy_fragment_for_refinement_using_cid(self, imol: int, multi_cid: str) -> int:
        """
        Copy a fragment given the multi_cid selection string for refinement

            Use this in preference to 

            Args:
                imol (int): is the model molecule index 
                multi_cid (str): 

            Returns:
                int: the new molecule number (or -1 on no atoms selected)
        """

    def copy_fragment_using_cid(self, imol: int, multi_cid: str) -> int:
        """
        Copy a fragment given the multi_cid selection string

            Args:
                imol (int): is the model molecule index 
                multi_cid (str): 

            Returns:
                int: the new molecule number (or -1 on no atoms selected)
        """

    def copy_fragment_using_residue_range(self, imol: int, chain_id: str, res_no_start: int, res_no_end: int) -> int:
        """
        Copy a residue-range fragment

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" 
                res_no_start (int): the starting residue number 
                res_no_end (int): 

            Returns:
                int: the new molecule number (or -1 on no atoms selected)
        """

    def copy_molecule(self, imol: int) -> int:
        """
        Copy the molecule

            Args:
                imol (int): the specified molecule

            Returns:
                int: the new molecule number
        """

    def dedust_map(self, imol: int) -> int:
        """
        dedust map

            Args:
                imol (int): 

            Returns:
                int: the map molecule index of the dedusted map or -1 on failure
        """

    def delete_all_carbohydrate(self, imol: int) -> bool:
        """
        delete all carbohydrate

            Args:
                imol (int): is the model molecule index

            Returns:
                bool: true on successful deletion, return false on no deletion.
        """

    def delete_atom(self, imol: int, chain_id: str, res_no: int, ins_code: str, atom_name: str, alt_conf: str) -> tuple[int, int]:
        """
        Delete atom

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" for chain A 
                res_no (int): is the residue number, e.g. 12 
                ins_code (str): is the insertion code, e.g. "A" 
                atom_name (str): is the name of the atom, e.g. "OH" 
                alt_conf (str): is the alternate conformation, e.g. "A" or "B"

            Returns:
                tuple: 1 on successful deletion, return 0 on failure to delete.
        """

    def delete_atom_using_cid(self, imol: int, cid: str) -> tuple[int, int]:
        """
        Delete atom using cid

            Args:
                imol (int): is the model molecule index 
                cid (str): is the atom selection CID e.g "//A/15/OH" (atom OH in residue 15 of chain A)

            Returns:
                tuple: 1 on successful deletion, return 0 on failure to delete.
        """

    def delete_chain_using_cid(self, imol: int, cid: str) -> tuple[int, int]:
        """
        Delete chain using chain cid

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID e.g "//A" (chain A), "//*" (all chains)

            Returns:
                tuple: 1 on successful deletion, return 0 on failure to delete.
        """

    def delete_colour_rules(self, imol: int) -> None:
        """
        Delete the colour rules for the given molecule

            Args:
                imol (int): is the model molecule index 

            Returns:
                None
        """

    def delete_hydrogen_atoms(self, imol_model: int) -> int:
        """
        Delete hydrogen atoms

            Args:
                imol_model (int): is the model molecule index

            Returns:
                int: 1 on a successful deletion, 0 on failure.
        """

    def delete_residue(self, imol: int, chain_id: str, res_no: int, ins_code: str) -> tuple[int, int]:
        """
        Delete residue

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" for chain A 
                res_no (int): is the residue number, e.g. 12 
                ins_code (str): is the insertion code, e.g. "A"

            Returns:
                tuple: 1 on successful deletion, return 0 on failure to delete.
        """

    def delete_residue_atoms_using_cid(self, imol: int, cid: str) -> tuple[int, int]:
        """
        Delete residue atoms using cid

            This is the same as 

            Args:
                imol (int): 
                cid (str): 

            Returns:
                tuple: 1 on successful deletion, return 0 on failure to delete.
        """

    def delete_residue_atoms_with_alt_conf(self, imol: int, chain_id: str, res_no: int, ins_code: str, alt_conf: str) -> tuple[int, int]:
        """
        Delete residue atoms using alt_conf

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" for chain A 
                res_no (int): is the residue number, e.g. 12 
                ins_code (str): is the insertion code, e.g. "A" 
                alt_conf (str): is the alternate conformation, e.g. "A" or "B"

            Returns:
                tuple: 1 on successful deletion, return 0 on failure to delete.
        """

    def delete_residue_using_cid(self, imol: int, cid: str) -> tuple[int, int]:
        """
        Delete residue using cid

            Args:
                imol (int): is the model molecule index 
                cid (str): is the residue selection CID e.g "//A/15" (all the atoms in residue 15 of chain A)

            Returns:
                tuple: 1 on successful deletion, return 0 on failure to delete.
        """

    def delete_side_chain(self, imol: int, chain_id: str, res_no: int, ins_code: str) -> tuple[int, int]:
        """
        Delete side chain

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" for chain A 
                res_no (int): is the residue number, e.g. 12 
                ins_code (str): is the insertion code, e.g. "A"

            Returns:
                tuple: 1 on successful deletion, return 0 on failure to delete.
        """

    def delete_using_cid(self, imol: int, cid: str, scope: str) -> tuple[int, int]:
        """
        Delete item

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID e.g "//A/15" (all the atoms in residue 15 of chain A) 
                scope (str): is one of the strings: ["ATOM", "WATER", "RESIDUE"," CHAIN"," MOLECULE", "LITERAL"]

            Returns:
                tuple: 1 on successful deletion, return 0 on failure
        """

    def density_correlation_analysis(self, imol_model: int, imol_map: int) -> validation_information_t:
        """
        Get the density correlation validation information

            Args:
                imol_model (int): is the model molecule index 
                imol_map (int): is the map molecule index
        """

    def density_fit_analysis(self, imol_model: int, imol_map: int) -> validation_information_t:
        """
        Density fit validation information.

            This function returns the sum of the densiy of the atoms in the residue

            Args:
                imol_model (int): is the model molecule index 
                imol_map (int): is the map molecule index
        """

    def dictionary_atom_name_map(self, comp_id_1: str, imol_1: int, comp_id_2: str, imol_2: int) -> dict[str, str]:
        """
        Match atom between 2 dictionaries

            Args:
                comp_id_1 (str): is the 3-letter code for the residue/ligand in the first model, e.g. "ALA" for alanine 
                imol_1 (int): is the model molecule index of the first model 
                comp_id_2 (str): is the 3-letter code for the residue/ligand in the second model, e.g. "ALA" for alanine 
                imol_2 (int): is the model molecule index of the second model

            Returns:
                std::map< std::string, std::string >: the atom name match on superposing the atoms of the given dictionaries
        """

    def difference_map_peaks(self, imol_map: int, imol_protein: int, n_rmsd: float) -> list[interesting_place_t]:
        """
        Get difference map peaks

            Args:
                imol_map (int): is the map molecule index 
                imol_protein (int): is the model molecule index 
                n_rmsd (float): number of sd, e.g. 4.8

            Returns:
                list: a vector/list of
        """

    def eigen_flip_ligand(self, imol: int, chain_id: str, res_no: int, ins_code: str) -> None:
        """
        Eigen-flip the specified ligand

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" for chain A 
                res_no (int): is the residue number, e.g. 12 
                ins_code (str): is the insertion code, e.g. "A" 

            Returns:
                None
        """

    def eigen_flip_ligand_using_cid(self, imol: int, residue_id: str) -> None:
        """
        Eigen-flip ligand using cid

            Args:
                imol (int): is the model molecule index 
                residue_cid (str): is the residue selection CID e.g "//A/15" (residue 15 of chain A) 

            Returns:
                None
        """

    def export_chemical_features_as_gltf(self, imol: int, cid: str, file_name: str) -> None:
        """
        export chemical features for the specified residue 

            Args:
                imol (int): 
                cid (str): 
                file_name (str): 

            Returns:
                None
        """

    def export_molecular_representation_as_gltf(self, imol: int, atom_selection_cid: str, colour_scheme: str, style: str, secondary_structure_usage_flag: int, file_name: str) -> None:
        """
        Export molecular representation as glTF file

            glTF files can be imported into Blender

            Args:
                imol (int): is the model molecule index 
                atom_selection_cid (str): : e.g "//A/15" (all the atoms in residue 15 of chain A) 
                colour_scheme (str): is one of "colorRampChainsScheme", "colorBySecondaryScheme", "Chain" 
                style (str): "Ribbon" or "MolecularSurface" 
                secondary_structure_usage_flag (int): 0 (USE_HEADER), 1 (DONT_USE) or 2 (CALC_SECONDARY_STRUCTURE) 
                file_name (str): of the glTF (the file will be compressed, so choose ".glb" as the extension) 

            Returns:
                None
        """

    def export_model_molecule_as_gltf(self, imol: int, selection_cid: str, mode: str, against_a_dark_background: bool, bonds_width: float, atom_radius_to_bond_width_ratio: float, smoothness_factor: int, draw_hydrogen_atoms_flag: bool, draw_missing_residue_loops: bool, file_name: str) -> None:
        """
        Export model molecule as glTF file

            glTF files can be imported into Blender or other 3D graphics applications

            Same parameters as the 

            Args:
                imol (int): 
                selection_cid (str): 
                mode (str): 
                against_a_dark_background (bool): 
                bonds_width (float): 
                atom_radius_to_bond_width_ratio (float): 
                smoothness_factor (int): 
                draw_hydrogen_atoms_flag (bool): 
                draw_missing_residue_loops (bool): 
                file_name (str): 

            Returns:
                None
        """

    def export_map_molecule_as_gltf(self, imol: int, pos_x: float, pos_y: float, pos_z: float, radius: float, contour_level: float, file_name: str) -> None:
        """
        Export map molecule as glTF file

            glTF files can be imported into Blender or other 3D graphics applications

            Args:
                imol (int): is the model molecule index 
                pos_x (float): 
                pos_y (float): 
                pos_z (float): 
                radius (float): e.g. 12.0 for X-ray map and 100.0 for Cryo-EM map 
                contour_level (float): e.g. 1.5 sd for X-ray, 5.0 sd for cryo-EM 
                file_name (str): extension should be .glb 

            Returns:
                None
        """

    def find_water_baddies(self, imol_model: int, imol_map: int, b_factor_lim: float, outlier_sigma_level: float, min_dist: float, max_dist: float, ignore_part_occ_contact_flag: bool, ignore_zero_occ_flag: bool) -> list[atom_spec_t]:
        """
        Check waters, using implicit logical OR

            Args:
                imol_model (int): is the model molecule index 
                imol_map (int): is the map molecule index 
                b_factor_lim (float): typical value is 60.0 
                outlier_sigma_level (float): typical value is 0.8 
                min_dist (float): typical value is 2.3 
                max_dist (float): typical value is 3.5 
                ignore_part_occ_contact_flag (bool): typical value is False 
                ignore_zero_occ_flag (bool): typical value is False

            Returns:
                list: a vector/list of atom specifiers
        """

    def file_name_to_string(self, file_name: str) -> str:
        """
        File name to string

            Args:
                file_name (str): is the name of the given file

            Returns:
                str: the string of the contents of the given file-name.
        """

    def fill_partial_residue(self, imol: int, chain_id: str, res_no: int, ins_code: str) -> int:
        """
        Fill the specified residue

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" for chain A 
                res_no (int): is the residue number, e.g. 12 
                ins_code (str): is the insertion code, e.g. "A"

            Returns:
                int: 1 on a successful fill, 0 on failure.
        """

    def fill_partial_residues(self, imol: int) -> int:
        """
        Fill all the the partially-filled residues in the molecule

            Args:
                imol (int): is the model molecule index

            Returns:
                int: 1 on a successful fill, 0 on failure.
        """

    def fill_rotamer_probability_tables(self) -> None:
        """
        Fill the rotamer probability tables (currently not ARG and LYS) 

            Returns:
                None
        """

    def fit_ligand(self, imol_protein: int, imol_map: int, imol_ligand: int, n_rmsd: float, use_conformers: bool, n_conformers: int) -> list[fit_ligand_info_t]:
        """
        Fit ligand

            Args:
                imol_protein (int): is the model molecule index 
                imol_map (int): is the map molecule index 
                imol_ligand (int): is the ligand molecule index 
                n_rmsd (float): the number of sd used as a cut-off for the map level when finding clusters, e.g. 1.2 
                use_conformers (bool): is True for flexible ligands 
                n_conformers (unsigned int): set the number of conformers

            Returns:
                list: a vector/list of interesting information about the fitted ligands
        """

    def fit_ligand_right_here(self, imol_protein: int, imol_map: int, imol_ligand: int, x: float, y: float, z: float, n_rmsd: float, use_conformers: bool, n_conformers: int) -> list[int]:
        """
        Fit the ligand at specified position. You can expect this to take about 20 seconds. For trivial (i.e non-flexible) ligands you should instead use the jiggle-fit algorithm, which takes a fraction of a second. (That is the algorithm used for "Add Other Solvent Molecules" in Coot.)

            Args:
                imol_protein (int): is the model molecule index 
                imol_map (int): is the map molecule index 
                imol_ligand (int): is the ligand molecule index 
                x (float): is the x position of the blob 
                y (float): is the y position of the blob 
                z (float): is the z position of the blob 
                n_rmsd (float): number of sd, e.g. 4.8 
                use_conformers (bool): is True for flexible ligands 
                n_conformers (unsigned int): set the number of conformers

            Returns:
                list: a vector/list of indices of molecules for the best fitting ligands to this blob.
        """

    def fit_to_map_by_random_jiggle(self, imol: int, res_spec: residue_spec_t, n_trials: int, translation_scale_factor: float) -> float:
        """
        Jiggle-Fit Ligand

            Args:
                imol (int): is the model molecule index 
                res_spec (const ): is the residue specifier, e.g. residue_spec_t("A", 10, "") 
                n_trials (int): is the number of trials, if n_trials is 0, then a sensible default value will be used. 
                translation_scale_factor (float): if is negative then a sensible default value will be used.

            Returns:
                float: a value less than -99.9 on failure to fit.
        """

    @overload
    def fit_to_map_by_random_jiggle_using_cid(self, imol: int, cid: str, n_trials: int, translation_scale_factor: float) -> float:
        """
        Jiggle-Fit Ligand using cid

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID, e.g "//A/15" (ligand 15 of chain A) 
                n_trials (int): is the number of trials, if n_trials is 0, then a sensible default value will be used. 
                translation_scale_factor (float): if is negative then a sensible default value will be used.

            Returns:
                float: a value less than -99.9 on failure to fit.
        """

    @overload
    def fit_to_map_by_random_jiggle_using_cid(self, imol: int, cid: str, n_trials: int, translation_scale_factor: float) -> float: ...

    def flip_peptide_using_cid(self, arg0: int, arg1: str, arg2: str, /) -> int:
        """
        Flip peptide using cid

            Args:
                imol (int): is the model molecule index 
                atom_cid (str): is the atom selection CID e.g "//A/15/OH" (atom OH in residue 15 of chain A) 
                alt_conf (str): is the alternate conformation, e.g. "A" or "B"

            Returns:
                int: 1 on a successful flip
        """

    def flip_hand(self, imol_map: int) -> int:
        """
        Generate a new map which is the hand-flipped version of the input map

            Args:
                imol_map (int): is the map molecule index

            Returns:
                int: the molecule index of the new map, or -1 on failure.
        """

    def flood(self, imol_model: int, imol_map: int, n_rmsd: float) -> int:
        """
        Flood with dummy atoms

            Args:
                imol_model (int): 
                imol_map (int): is the map molecule index 
                n_rmsd (float): e.g., 4.0

            Returns:
                int: the number of waters added on a success, -1 on failure.
        """

    def fourier_shell_correlation(self, imol_map_1: int, imol_map_2: int) -> list[tuple[float, float]]:
        """
        Fourier Shell Correlation (FSC) between maps

            Args:
                imol_map_1 (int): is the first map molecule index 
                imol_map_2 (int): is the second map molecule index

            Returns:
                list: a vector/list or pairs of graph points (resolution, correlation). The resolution is in inverse Angstroms squared. An empty list is returned on failure
        """

    def generate_self_restraints(self, imol: int, local_dist_max: float) -> int:
        """
        Generate GM self restraints for the whole molecule

            Args:
                imol (int): is the model molecule index 
                local_dist_max (float): is the maximum distance, e.g. 4.6 

            Returns:
                int
        """

    def geometry_init_standard(self) -> None:
        """
        Read the standard list of residues. 

            Returns:
                None
        """

    def get_active_atom(self, x: float, y: float, z: float, displayed_model_molecules_list: str) -> tuple[int, str]:
        """
        Get the active atom given the screen centre

            Args:
                x (float): is x position of the centre of the screen 
                y (float): is y position of the centre of the screen 
                z (float): is z position of the centre of the screen 
                displayed_model_molecules_list (str): is a colon-separated list of molecules, (e.g. "2:3:4")

            Returns:
                tuple: the molecule index and the atom cid. On failure (no molecules with atoms in them) then return -1 and a blank string.
        """

    def get_acedrg_atom_types(self, compound_id: str, imol_enc: int) -> list[tuple[str, str]]:
        """
        Get a list of atom names and their associated AceDRG atom types

            Args:
                compound_id (str): is the 3-letter code for the residue/ligand in the first model, e.g. "TYR" for tyrosine 
                imol_enc (int): is the molecule index for the residue type/compound_id

            Returns:
                list: a list of atom names and their associated AceDRG atom types, return an empty list on failure (e.g. when atoms types are not in the dictionary)
        """

    def get_acedrg_atom_types_for_ligand(self, imol: int, residue_cid: str) -> acedrg_types_for_residue_t:
        """
        Get AceDRG atom types for ligand bonds

            Args:
                imol (int): is the model molecule index 
                residue_cid (str): is the atom selection CID e.g "//A/15" (residue 15 of chain A)

            Returns:
                coot::acedrg_types_for_residue_t: a
        """

    def get_atom_differences(self, imol1: int, imol2: int) -> list[positioned_atom_spec_t]:
        """
        Get the atom differences between two molecules typically after refinement

            Args:
                imol1 (int): is the first model molecule index 
                imol2 (int): is the second model molecule index

            Returns:
                list: a vector/list of
        """

    def get_atom_using_cid(self, imol: int, atom_cid: str) -> Atom:
        """
        get an (mmdb-style) atom

            If more than one atom is selected by the selection cid, then the first atom is returned.

            Don't use this in emscript.

            Args:
                imol (int): is the model molecule index 
                cid (str): is the coordinate-id for the atom. 

            Returns:
                mmdb::Atom *: either the specified atom or nullopt (None) if not found
        """

    def get_atom_overlap_score(self, imol: int) -> float:
        """
        Get the atom overlap score

            Args:
                imol (int): the model molecule index 

            Returns:
                float: the overlap score - a negative number indicates failure
        """

    def get_bonds_mesh(self, imol: int, mode: str, against_a_dark_background: bool, bond_width: float, atom_radius_to_bond_width_ratio: float, smoothness_factor: int) -> simple_mesh_t:
        """
        Get the bonds mesh

            Args:
                imol (int): 
                mode (str): is "COLOUR-BY-CHAIN-AND-DICTIONARY", "CA+LIGANDS" or "VDW-BALLS" 
                against_a_dark_background (bool): allows the bond colours to be relevant for the background. When the background is dark, the colours should (as a rule) be bright and pastelly. When the background is light/white, the colour are darker and more saturated. 
                bond_width (float): is the bond width in Angstroms. 0.12 is a reasonable default value. 
                atom_radius_to_bond_width_ratio (float): allows the representation of "ball and stick". To do so use a value between 1.5 and 3.0. The ratio for "liquorice" representation is 1.0.
                smoothness_factor (int): controls the number of triangles used to make the bond cylinders and spheres for the atoms - it rises in powers of 4. 1 is the smallest smoothness_factor, 2 looks nice and 3 is best.
        """

    def get_bonds_mesh_for_selection_instanced(self, imol: int, atom_selection_cid: str, mode: str, against_a_dark_background: bool, bond_width: float, atom_radius_to_bond_width_ratio: float, show_atoms_as_aniso_flag: bool, show_aniso_atoms_as_ortep_flag: bool, draw_hydrogen_atoms_flag: bool, smoothness_factor: int) -> instanced_mesh_t:
        """
        As 

            Args:
                imol (int): 
                atom_selection_cid (str): e.g. "//A/15" (all the atoms in residue 15 of chain A) 
                mode (str): 
                against_a_dark_background (bool): 
                bond_width (float): 
                atom_radius_to_bond_width_ratio (float): 
                show_atoms_as_aniso_flag (bool): 
                show_aniso_atoms_as_ortep_flag (bool): 
                draw_hydrogen_atoms_flag (bool): 
                smoothness_factor (int):
        """

    def get_bonds_mesh_instanced(self, imol: int, mode: str, against_a_dark_background: bool, bond_width: float, atom_radius_to_bond_width_ratio: float, show_atoms_as_aniso_flag: bool, show_aniso_atoms_as_ortep_flag: bool, draw_hydrogen_atoms_flag: bool, smoothness_factor: int) -> instanced_mesh_t:
        """
        Get the instanced bonds mesh.

            Args:
                imol (int): 
                mode (str): is "COLOUR-BY-CHAIN-AND-DICTIONARY" - more modes to follow 
                against_a_dark_background (bool): allows the bond colours to be relevant for the background. When the background is dark, the colours should (as a rule) be bright and pastelly. When the background is light/white, the colour are darker and more saturated. 
                bond_width (float): is the bond width in Angstroms. 0.12 is a reasonable default value. 
                atom_radius_to_bond_width_ratio (float): allows the representation of "ball and stick". To do so use a value between 1.5 and 3.0. The ratio for "liquorice" representation is 1.0. 
                show_atoms_as_aniso_flag (bool): if true, if possible, show the atoms with thermal ellipsoids. 
                show_aniso_atoms_as_ortep_flag (bool): if true, show any anisotropic atoms with ortep style. 
                draw_hydrogen_atoms_flag (bool): if true, bonds to hydrogen atoms should be added. 
                smoothness_factor (int): controls the number of triangles used to make the bond cylinders and spheres for the atoms - it rises in powers of 4. 1 is the smallest smoothness_factor, 2 looks nice and 3 is best. Instancing may mean that smoothness factor 3 should be used by default.
        """

    def get_cell(self, imol: int) -> "api::cell_t":
        """
        Get the cell

            Check that 

            Args:
                imol (int): is the model molecule index
        """

    def get_chains_in_model(self, imol: int) -> list[str]:
        """
        Get the chain IDs in the given molecule

            Args:
                imol (int): is the model molecule index

            Returns:
                list: vector/list of chain-ids for the given molecule
        """

    def get_chemical_features_mesh(self, imol: int, cid: str) -> simple_mesh_t:
        """
        Get chemical features for the specified residue

            Args:
                imol (int): is the model molecule index 
                cid (str): is the atom selection CID e.g "//A/15" (all the atoms in residue 15 of chain A)
        """

    def get_colour_rules(self, imol: int) -> list[tuple[str, str]]:
        """
        Get the colour rules

            Args:
                imol (int): is the model molecule index 

            Returns:
                list
        """

    def get_colour_table_for_blender(self, imol: int) -> list[float]:
        """
        Function for Blender interface. 

            Args:
                imol (int): 

            Returns:
                list
        """

    def get_density_at_position(self, imol_map: int, x: float, y: float, z: float) -> float:
        """
        Get density at position 

            Args:
                imol_map (int): is the map molecule index 
                x (float): is the x coordinate of the target position 
                y (float): is the y coordinate of the target position 
                z (float): is the z coordinate of the target position

            Returns:
                float: the density value
        """

    def get_dictionary_conformers(self, comp_id: str, imol_enc: int, remove_internal_clash_conformers: bool) -> list[int]:
        """
        Get the conformers that can be generated by variation around rotatable bonds as described in the dictionary.

            Torsions that are marked as "const" are excluded from the variation, as are pyranose ring torsions and torsions that rotate hydrogen atoms

            Args:
                comp_id (str): is the 3-letter code for the residue/ligand, e.g. "ALA" for alanine 
                imol_enc (int): is the molecule index for the residue type/compound_id 
                remove_internal_clash_conformers (bool): is the flag for removing internal clash

            Returns:
                list: a vector/list of indices of the new molecules
        """

    def get_distances_between_atoms_of_residues(self, imol: int, cid_res_1: str, cid_res_2: str, dist_max: float) -> list[atom_distance_t]:
        """
        Get atom distances

            Args:
                imol (int): is the model molecule index 
                cid_res_1 (str): is the first atom selection CID e.g "//A/15/OH" (atom OH in residue 15 of chain A) 
                cid_res_2 (str): is the second atom selection CID e.g "//A/17/NH" (atom NH in residue 17 of chain A) 
                dist_max (float): 

            Returns:
                list
        """

    def get_gaussian_surface(self, imol: int, sigma: float, contour_level: float, box_radius: float, grid_scale: float, b_factor: float) -> simple_mesh_t:
        """
        Get a Gaussian surface representation

            Args:
                imol (int): is the model molecule index 
                sigma (float): default 4.4 
                contour_level (float): default 4.0 
                box_radius (float): default 5.0 
                grid_scale (float): default 0.7 
                b_factor (float): default 100.0 (use 0.0 for no FFT-B-factor smoothing)
        """

    def get_goodsell_style_mesh_instanced(self, imol: int, colour_wheel_rotation_step: float, saturation: float, goodselliness: float) -> instanced_mesh_t:
        """
        Get the Goodsell style mesh

            Args:
                imol (int): 
                colour_wheel_rotation_step (float): 
                saturation (float): 
                goodselliness (float): is the degree to which the C-atoms are desaturated, 0.3 is a reasonable value
        """

    def get_gphl_chem_comp_info(self, compound_id: str, imol_enc: int) -> list[tuple[str, str]]:
        """
        Get the GPhL extra restraint information (from the input cif file)

            Args:
                compound_id (str): is the 3-letter code for the residue/ligand in the first model, e.g. "TYR" for tyrosine 
                imol_enc (int): is the molecule index for the residue type/compound_id

            Returns:
                list: a vector/list of string pairs that were part of a gphl_chem_comp_info. return an empty vector/list on failure to find any such info.
        """

    def get_group_for_monomer(self, residue_name: str) -> str:
        """
        Get the group for a particular monomer

            e.g. "NON POLYMER", "PEPTIDE", etc 

            Args:
                residue_name (str): is the is the 3-letter code for the residue, e.g. "ALA" for alanine

            Returns:
                str: the group for the given residue name
        """

    def get_groups_for_monomers(self, residue_names: Sequence[str]) -> list[str]:
        """
        Get the groups for a vector/list of monomers

            e.g. "NON POLYMER", "PEPTIDE", etc

            Args:
                residue_names (list): is a list of residue names, e.g. ["ALA", "TRP"]

            Returns:
                list: the group for the given list of residue names
        """

    def get_hb_type(self, compound_id: str, imol_enc: int, atom_name: str) -> str:
        """
        Get the hydrogen bond type of a particular atom in a given residue type

            Args:
                compound_id (str): is the 3-letter code for the residue/ligand in the first model, e.g. "TYR" for tyrosine 
                imol_enc (int): is the molecule index for the residue type/compound_id 
                atom_name (str): is the name of the atom, e.g. "OH"

            Returns:
                str: the hb_type for the given atom. On failure return an empty string. Valid types are: "HB_UNASSIGNED" ,"HB_NEITHER", "HB_DONOR", "HB_ACCEPTOR", "HB_BOTH", "HB_HYDROGEN".
        """

    def get_header_info(self, imol: int) -> header_info_t:
        """
        Get header info

            (the header info is sparce at the moment)

            Args:
                imol (int): is the model molecule index

            Returns:
                moorhen::header_info_t: an object with header info.
        """

    def get_h_bonds(self, imol: int, cid_str: str, mcdonald_and_thornton_mode: bool) -> list[h_bond]: ...

    def get_HOLE(self, imol: int, start_pos_x: float, start_pos_y: float, start_pos_z: float, end_pos_x: float, end_pos_y: float, end_pos_z: float) -> instanced_mesh_t:
        """
        Get HOLE

            HOLE is a program for the analysis of the pore dimesions of ion channels. See Smart et al., 1996.

            Args:
                imol (int): 
                start_pos_x (float): 
                start_pos_y (float): 
                start_pos_z (float): 
                end_pos_x (float): 
                end_pos_y (float): 
                end_pos_z (float):
        """

    def get_imol_enc_any(self) -> int:
        """
        Get imol_enc_any (enc: encoded)

            imol_enc_any refers to the molecule number for dictionary that can be used with any molecule

            Returns:
                int: the value of
        """

    def get_ligand_validation_vs_dictionary(self, imol: int, ligand_cid: str, include_non_bonded_contacts: bool) -> list[geometry_distortion_info_container_t]:
        """
        Ligand validation

            Args:
                imol (int): is the model molecule index 
                ligand_cid (str): is the ligand selection CID e.g "//A/15" (ligand 15 of chain A) 
                include_non_bonded_contacts (bool): is the flag to include non bonded contacts

            Returns:
                list: a vector/list of interesting geometry - one for each chain involved
        """

    def get_ligand_distortion(self, imol: int, ligand_cid: str, include_non_bonded_contacts: bool) -> tuple[int, float]:
        """
        Get ligand distortion

            a more simple interface to the above

            Args:
                imol (int): is the model molecule index 
                ligand_cid (str): 
                include_non_bonded_contacts (bool): is the flag to include non bonded contacts

            Returns:
                tuple: a pair: the first is the status (1 for OK, 0 for failed to determine the distortion)
        """

    def get_lsq_matrix(self, imol_ref: int, imol_mov: int, summary_to_screen: bool) -> lsq_results_t:
        """
        Get LSQ matrix

            don't apply it to the coordinates

            Args:
                imol_ref (int): the reference model molecule index 
                imol_mov (int): the moving model molecule index 
                summary_to_screen (bool): if True, write a summary of the statistics to the output

            Returns:
                lsq_results_t: the transformation matrix in a simple class
        """

    def get_map_contours_mesh(self, imol: int, position_x: float, position_y: float, position_z: float, radius: float, contour_level: float) -> simple_mesh_t:
        """
        Get the mesh for the map contours

            This function is not const because the internal state of a 

            Args:
                imol (int): is the model molecule index 
                position_x (double): is the x coordinate of the target position 
                position_y (double): is the y coordinate of the target position 
                position_z (double): is the z coordinate of the target position 
                radius (float): is the radius of the map, e.g. 12.0 for X-ray map and 100.0 for Cryo-EM map 
                contour_level (float): e.g. 1.5 sd for X-ray, 5.0 sd for cryo-EM
        """

    def get_map_contours_mesh_using_other_map_for_colours(self, imol_ref: int, imol_map_for_colouring: int, position_x: float, position_y: float, position_z: float, radius: float, contour_level: float, other_map_for_colouring_min_value: float, other_map_for_colouring_max_value: float, invert_colour_ramp: bool) -> simple_mesh_t:
        """
        Get the mesh for the map contours using another map for colouring

            Args:
                imol_ref (int): is the reference map index 
                imol_map_for_colouring (int): 
                position_x (double): is the x coordinate of the target position 
                position_y (double): is the y coordinate of the target position 
                position_z (double): is the z coordinate of the target position 
                radius (float): is the radius of the map, e.g. 12.0 for X-ray map and 100.0 for Cryo-EM map 
                contour_level (float): e.g. 1.5 sd for X-ray, 5.0 sd for cryo-EM 
                other_map_for_colouring_min_value (float): e.g. -1.0 in the case of correlation map 
                other_map_for_colouring_max_value (float): e.g. 1.0 in the case of correlation map 
                invert_colour_ramp (bool): e.g. red to blue rather than blue to red
        """

    def get_map_molecule_centre(self, imol: int) -> map_molecule_centre_info_t:
        """
        Get the middle of the "molecule blob" in cryo-EM reconstruction maps

            Args:
                imol (int): is the map molecule index
        """

    def get_map_rmsd_approx(self, imol_map: int) -> float:
        """
        Get map rmsd approx

            the function is approximate because the epsilon factor is not taken into account

            Args:
                imol_map (int): is the map molecule index

            Returns:
                float: the map rmsd. -1 is returned if imol_map is not a valid map molecule index.
        """

    def get_map_weight(self) -> float:
        """
        Get the map weight

            Returns:
                float: the map weight
        """

    def get_mean_and_variance_of_density_for_non_water_atoms(self, imol_coords: int, imol_map: int) -> tuple[float, float]:
        """
        get mean and variance of map at non-waters

            Args:
                imol_coords (int): 
                imol_map (int): is the map molecule index

            Returns:
                tuple: the mean and variance or a negative number on failure
        """

    def get_median_temperature_factor(self, imol: int) -> float:
        """
        Get the median temperature factor for the model

            Args:
                imol (int): is the model molecule index

            Returns:
                float: a negative number on failure
        """

    def get_missing_residue_ranges(self, imol: int) -> list[residue_range_t]:
        """
        Get missing residue ranges

            Args:
                imol (int): is the model molecule index 

            Returns:
                list: missing residue ranges
        """

    def get_molecular_representation_mesh(self, imol: int, cid: str, colour_scheme: str, style: str, secondary_structure_usage_flag: int) -> simple_mesh_t:
        """
        Get ribbon and molecular surface representation

            Args:
                imol (int): is the model molecule index 
                cid (str): is the atom selection CID e.g "//A/15" (all the atoms in residue 15 of chain A) 
                colour_scheme (str): should be one of "colorRampChainsScheme", "colorBySecondaryScheme", "Chain" 
                style (str): "Ribbon" or "MolecularSurface" 
                secondary_structure_usage_flag (int): 0 (USE_HEADER), 1 (DONT_USE) or 2 (CALC_SECONDARY_STRUCTURE).
        """

    def get_molecule_centre(self, imol: int) -> Cartesian:
        """
        Get molecule centre

            Args:
                imol (int): is the model molecule index

            Returns:
                coot::Cartesian: the molecule centre
        """

    def get_molecule_name(self, imol: int) -> str:
        """
        Get the molecule name

            Args:
                imol (int): is the model molecule index

            Returns:
                str: the name of the molecule
        """

    def get_monomer(self, monomer_name: str) -> int:
        """
        Get a monomer

            Args:
                monomer_name (str): is the 3-letter code of the monomer in the dictionary, e.g. "ALA" for alanine

            Returns:
                int: the new molecule index on success and -1 on failure
        """

    def get_monomer_and_position_at(self, comp_id: str, imol: int, x: float, y: float, z: float) -> int:
        """
        Get monomer and place it at the given position for a particular molecule

            Args:
                comp_id (str): is the 3-letter code for the residue/ligand, e.g. "ALA" for alanine 
                imol (int): is the model molecule index, use -999999 (IMOL_ENC_ANY) if no molecule-specific dictionary is needed 
                x (float): is the x value of the target position 
                y (float): is the y value of the target position 
                z (float): is the z value of the target position

            Returns:
                int: the new molecule index on success and -1 on failure
        """

    def get_monomer_from_dictionary(self, comp_id: str, imol: int, idealised_flag: bool) -> int:
        """
        Get a monomer for a particular molecule

            Args:
                comp_id (str): is the 3-letter code for the residue/ligand, e.g. "ALA" for alanine 
                imol (int): is the model molecule index, use -999999 (IMOL_ENC_ANY) if no molecule-specific dictionary is needed 
                idealised_flag (bool): means that the coordinates have been minimised with a molecular modelling minimisation algo, usually the value is True

            Returns:
                int: the new molecule index on success and -1 on failure
        """

    def get_number_of_atoms(self, imol: int) -> int:
        """
        Get number of atoms

            Args:
                imol (int): is the model molecule index

            Returns:
                unsigned int: the number of atoms in the specified model, or 0 on error
        """

    def get_number_of_atoms_in_residue(self, imol: int, residue_cid: str) -> int:
        """
        get the number of atoms in a given residue

            Args:
                imol (int): is the model molecule index 
                residue_cid (str): is the selection CID e.g "//A/15" (residue 15 of chain A) 

            Returns:
                int: the number of atoms in the residue, or -1 on failure
        """

    def get_number_of_hydrogen_atoms(self, imol: int) -> int:
        """
        Get number of hydrogen atoms

            Args:
                imol (int): is the model molecule index

            Returns:
                int: the number of hydrogen atoms in the specified model, or -1 on error
        """

    def get_number_of_molecules(self) -> int:
        """
        Get the number of molecules (either map or model)

            Returns:
                unsigned int: the number of molecules
        """

    def get_number_of_map_sections(self, imol_map: int, axis_id: int) -> int:
        """
        Args:
            imol_map (int): is the map molecule index 
            axis_id (int): is 0 for X-axis, 1 for Y-axis, 2 for Z-axis

        Returns:
            int: the number of sections in the map along the given axis, -1 on failure.
        """

    def get_octahemisphere(self, n_divisions: int) -> simple_mesh_t:
        """
        Get octahemisphere

            Args:
                n_divisions (unsigned int): is a number divisible by 2, at least 4 (typically 16)
        """

    def get_overlaps(self, imol: int) -> list[plain_atom_overlap_t]:
        """
        Get Atom Overlaps. 

            Args:
                imol (int): is the model molecule index 

            Returns:
                list: a vector of atom overlap objects
        """

    def get_overlaps_for_ligand(self, imol: int, ligand_cid: str) -> list[plain_atom_overlap_t]:
        """
        Gat Atom Overlaps for a ligand or residue. 

            Args:
                imol (int): is the model molecule index 
                cid_ligand (str): is the ligand selection CID e.g "//A/15" (ligand 15 of chain A) 

            Returns:
                list: a vector of atom overlap objects
        """

    def get_q_score(self, imol_model: int, imol_map: int) -> validation_information_t:
        """
        Get the Q Score (Pintilie et al.)

            Args:
                imol_model (int): is the model molecule index 
                imol_map (int): is the map molecule index
        """

    def get_q_score_for_cid(self, imol_model: int, cid: str, imol_map: int) -> validation_information_t:
        """
        Get the Pintile et al. Q Score for a particular residue (typically a ligand)

            Args:
                imol_model (int): 
                cid (str): If the 
                imol_map (int):
        """

    def get_r_factor_stats(self) -> "molecules_container_t::r_factor_stats":
        """Get the R-factors"""

    def get_radius_of_gyration(self, arg: int, /) -> float:
        """
        Get Radius of Gyration

            Args:
                imol (int): is the model molecule index

            Returns:
                double: the molecule centre. If the number is less than zero, there was a problem finding the molecule or atoms.
        """

    def get_rama_plot_restraints_weight(self) -> float:
        """
        Get the Ramachandran plot restraints weight

            Returns:
                float: the Ramachandran plot restraints weight
        """

    def get_rdkit_mol_pickle_base64(self, res_name: str, imol_enc: int) -> str:
        """
        Extract ligand restraints from the dictionary store and make an rdkit molecule Result to be eaten by C++ only.

            Args:
                residue_name (str): the residue name 
                imol_enc (int): the molecule for the ligand (typically is imol_enc_any) 

            Returns:
                str: an RDKit RDMol. get the 64base-encoded pickled string that represents the given residue/ligand namea pickle string, return an empty string on failure.
        """

    def get_ramachandran_validation_markup_mesh(self, imol: int) -> simple_mesh_t:
        """
        Get the Ramachandran validation markup mesh

            20221126-PE: the function was renamed from ramachandran_validation_markup_mesh().

            Args:
                imol (int): is the model molecule index
        """

    def get_residue_average_position(self, imol: int, cid: str) -> list[float]:
        """
        Get the average residue position

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID e.g "//A/15" (residue 15 of chain A)

            Returns:
                list: a vector. The length of the vector is 0 on failure, otherwise it is the x,y,z values
        """

    def get_residue_CA_position(self, imol: int, cid: str) -> list[float]:
        """
        Get the residue CA position

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID e.g "//A/15" (residue 15 of chain A)

            Returns:
                list: a vector. The length of the vector is 0 on failure, otherwise it is the x,y,z values
        """

    def get_residue_name(self, imol: int, chain_id: str, res_no: int, ins_code: str) -> str:
        """
        Get residue name

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" for chain A 
                res_no (int): is the residue number, e.g. 12 
                ins_code (str): is the insertion code, e.g. "A"

            Returns:
                str: the residue name, return a blank string on residue not found.
        """

    def get_residue_names_with_no_dictionary(self, imol: int) -> list[str]:
        """
        Get a list of residues that don't have a dictionary

            Args:
                imol (int): is the model molecule index

            Returns:
                list: a list of residue names (compound_ids) for which there is no dictionary in the geometry store
        """

    def get_residue_sidechain_average_position(self, imol: int, cid: str) -> list[float]:
        """
        Get the average residue side-chain position

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID e.g "//A/15" (residue 15 of chain A)

            Returns:
                list: a vector. The length of the vector is 0 on failure, otherwise it is the x,y,z values
        """

    def get_residue_using_cid(self, imol: int, cid: str) -> Residue:
        """
        get an (mmdb-style) residue

            If more than one residue is selected by the selection cid, then the first residue is returned.

            Don't use this in emscript.

            Args:
                imol (int): is the model molecule index 
                cid (str): is the coordinate-id for the residue 

            Returns:
                mmdb::Residue *: either the specified residue or nullopt (None) if not found
        """

    def get_residues_near_residue(self, imol: int, residue_cid: str, dist: float) -> list[residue_spec_t]:
        """
        Get a list of residues specs that have atoms within distance of the atoms of the specified residue

            Args:
                imol (int): is the model molecule index 
                residue_cid (str): is the atom selection CID e.g "//A/15" (all the atoms in residue 15 of chain A) 
                dist (float): is the distance in Angstrom

            Returns:
                list: a list of residue specs
        """

    def get_rotamer_dodecs(self, imol: int) -> simple_mesh_t:
        """
        Get the rotamer dodecs for the model

            Args:
                imol (int): is the model molecule index
        """

    def get_rotamer_dodecs_instanced(self, imol: int) -> instanced_mesh_t:
        """
        Get the rotamer dodecs for the model instanced

            Args:
                imol (int): is the model molecule index
        """

    def get_single_letter_codes_for_chain(self, imol: int, chain_id: str) -> list[tuple[residue_spec_t, str]]:
        """
        Get the single letter codes for the residues in the specified chain

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" for chain A

            Returns:
                list: vector/list of single letter codes - in a pair with the given residue spec
        """

    def get_spherical_variance(self, imol_map: int, imol_model: int, atom_cid: str, mean_density_other_atoms: float) -> float:
        """
        Get spherical variance - typically for water atoms

            Args:
                imol_map (int): is the map molecule index
                imol_model (int): is the model molecule index 
                atom_cid (str): 
                mean_density_other_atoms (float): 

            Returns:
                float: the variance or a negative number on failure
        """

    def get_sum_density_for_atoms_in_residue(self, imol: int, cid: str, atom_names: Sequence[str], imol_map: int) -> float:
        """
        Args:
            imol (int): 
            cid (str): 
            atom_names (list): 
            imol_map (int): 

        Returns:
            double: the sum of the density of the given atoms in the specified CID return -1001 on failure to find the residue or any atoms in the residue or if imol_map is not a map
        """

    def get_svg_for_2d_ligand_environment_view(self, imol: int, residue_cid: str, add_key: bool) -> str:
        """
        Get SVG for 2d ligand environment view (FLEV)

            The caller should make sure that the dictionary for the ligand has been loaded - this function won't do that. It will add hydrogen atoms if needed.

            From time to time (depending on the ligand) this function will fail to produce a result.

            Not const because get_monomer_restraints_at_least_minimal() is called. Hmm.

            Args:
                imol (int): is the model molecule index 
                residue_cid (str): is the cid for the residue 
                add_key (bool): should a key be added to the figure? 

            Returns:
                str: an svg string of the representation. On failure, return an empty string.
        """

    def get_svg_for_residue_type(self, imol: int, comp_id: str, use_rdkit_svg: bool, background_type: str) -> str:
        """
        Get svg for residue type

            It won't work unless the dictionary for that ligand has been imported. The native output renderings are not very good at the moment. (The RDKit renderings are pretty good).

            If you want to load them into another image, you'd typicaly want "dark-bonds/transparent-bg" If you want to see ligands, e.g. in a grid or list, you'd typically want "dark-bonds/opaque-bg" which will give you a white rectangle behind the ligand figure.

            This function is not const because it caches the svgs.

            Args:
                imol (int): is the model molecule index, except for unusual cases, it will be IMOL_ENC_ANY (-999999) 
                comp_id (str): is the 3-letter code for the residue/ligand, e.g. "ALA" for alanine 
                use_rdkit_svg (bool): is the flag for using the rdkit svg renderer 
                background_type (str): is one of:

            Returns:
                str: the string for the SVG representation.
        """

    def get_symmetry(self, imol: int, symmetry_search_radius: float, centre_x: float, centre_y: float, centre_z: float) -> "coot::symmetry_info_t":
        """
        Get symmetry

            now comes in a simple container that also includes the cell 

            Args:
                imol (int): 
                symmetry_search_radius (float): 
                centre_x (float): 
                centre_y (float): 
                centre_z (float): 

            Returns:
                coot::symmetry_info_t
        """

    def get_temperature_factor_of_atom(self, imol: int, atom_cid: str) -> float:
        """
        Get the atom temperature factor

            Args:
                imol (int): is the model molecule index 
                atom_cid (str): is the selection cid for the atom

            Returns:
                float: a negative number on failure, otherwise the temperature factor
        """

    def get_torsion(self, imol: int, cid: str, atom_names: Sequence[str]) -> tuple[int, float]:
        """
        Get the torsion of the specified atom in the specified residue

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID, e.g. //A/15 (residue 15 in chain A) 
                atom_names (list): is a list of atom names, e.g. [" CA ", " CB ", " CG ", " CD1"]

            Returns:
                tuple: a pair, the first of which is a succes status (1 success, 0 failure), the second is the torsion in degrees
        """

    def get_torsion_restraints_weight(self) -> float:
        """
        Get the torsion restraints weight

            Returns:
                float: the torsion restraints weight
        """

    def get_triangles_for_blender(self, imol: int) -> list[int]:
        """
        Function for Blender interface. 

            Args:
                imol (int): 

            Returns:
                list
        """

    def get_types_in_molecule(self, imol: int) -> list[str]:
        """
        get types 

            Args:
                imol (int): 

            Returns:
                list
        """

    def get_use_gemmi(self) -> bool:
        """
        Get the state of using GEMMI for coordinates parsing. 

            Returns:
                bool
        """

    def get_use_rama_plot_restraints(self) -> bool:
        """
        Get the state of the rama plot restraints usage in refinement

            Returns:
                bool: the state
        """

    def get_use_torsion_restraints(self) -> bool:
        """
        Get the state of the rama plot restraints usage in refinement

            Returns:
                bool: the state
        """

    def get_validation_vs_dictionary_for_selection(self, imol: int, selection_cid: str, include_non_bonded_contacts: bool) -> list[geometry_distortion_info_container_t]:
        """
        General fragment distortion analysis

            Args:
                imol (int): is the model molecule index 
                selection_cid (str): is the selection CID e.g "//A/15-23" 
                include_non_bonded_contacts (bool): is the flag to include non bonded contacts

            Returns:
                list: a vector/list of interesting geometry - one for each chain involved
        """

    def get_vertices_for_blender(self, imol: int) -> list[float]:
        """
        Function for Blender interface. 

            Args:
                imol (int): 

            Returns:
                list
        """

    def go_to_blob(self, x1: float, y1: float, z1: float, x2: float, y2: float, z2: float, contour_level: float) -> tuple[bool, Coord_orth]:
        """
        Given a point on the front clipping plane (x1, y1, z1) and a point on the back clipping plane (x2, y2, z2) this function searches imol_refinement_map (if set) to find a the centre of a blob above the contour level. Blobs at the "front" are selected in preference to blobs at the back. If no blob is found, then the first of the pair is false. If it is found, then the second is the centre of the blob.

            In future, this function should/will be provided with a list of displayed maps and their contour levels - but for now, it uses (only) imol_refinement_map.

            Use a string to pass the map information (map index and contour level), something like "0 0.45:1 1.2:2 0.1" 

            Args:
                x1 (float): is the x point of the front clipping plane 
                y1 (float): is the y point of the front clipping plane 
                z1 (float): is the z point of the front clipping plane 
                x2 (float): is the x point of the back clipping plane 
                y2 (float): is the y point of the back clipping plane 
                z2 (float): is the z point of the back clipping plane 
                contour_level (float): 

            Returns:
                tuple
        """

    def import_cif_dictionary(self, cif_file_name: str, imol_enc: int) -> int:
        """
        Import a dictionary cif

            Args:
                cif_file_name (str): 
                imol_enc (int): is used to specify to which molecule this dictionary should apply. Use IMOL_ENC_ANY to mean "it applies to all molecules." IMOL_ENC_ANY = -999999

            Returns:
                int: 1 on success and 0 on failure
        """

    def init_refinement_of_molecule_as_fragment_based_on_reference(self, imol_frag: int, imol_ref: int, imol_map: int) -> None:
        """
        Initialise the refinement of (all of) molecule imol_frag

            Args:
                imol_frag (int): is the model molecule index of the fragment 
                imol_ref (int): is the model molecule index of the reference 
                imol_map (int): is the map molecule index 

            Returns:
                None
        """

    def is_a_difference_map(self, imol_map: int) -> bool:
        """
        Check if it the map is a difference map

            Args:
                imol_map (int): is the map molecule index

            Returns:
                bool: True or False
        """

    def is_valid_map_molecule(self, imol_map: int) -> bool:
        """
        Check if the map index is valid

            e.g. if the map is a model you will have an invalid map

            Args:
                imol_map (int): is the map molecule index

            Returns:
                bool: True or False
        """

    def is_valid_model_molecule(self, imol: int) -> bool:
        """
        Check if the model index is valid

            e.g. if the molecule is a map you will have an invalid model

            Args:
                imol (int): is the model molecule index

            Returns:
                bool: True or False
        """

    def jed_flip(self, imol: int, atom_cid: str, invert_selection: bool) -> str:
        """
        JED-Flip the ligand (or residue) at the specified atom

            Args:
                imol (int): is the model molecule index 
                atom_cid (str): is the residue selection CID e.g "//A/15" (residue 15 of chain A) 
                invert_selection (bool): is True if you want to use the larger fragment

            Returns:
                str: a non-blank message if there is a problem
        """

    def lsq_superpose(self, imol_ref: int, imol_mov: int) -> bool:
        """
        Apply the superposition using LSQ

            Args:
                imol_ref (int): the reference model molecule index 
                imol_mov (int): the moving model molecule index 

            Returns:
                bool: the success status, i.e. whether or not there were enough atoms to superpose
        """

    def make_mask(self, imol_map_ref: int, imol_model: int, atom_selection_cid: str, radius: float) -> int:
        """
        Make a masked map

            Args:
                imol_map_ref (int): is the map molecule index 
                imol_model (int): is the model molecule index 
                atom_selection_cid (str): is the atom selection CID e.g "//A/15" (all the atoms in residue 15 of chain A) 
                radius (float): is the radius of the map, e.g. 12.0 for X-ray map and 100.0 for Cryo-EM map

            Returns:
                int: the index of the newly created mask. Return -1 on failure.
        """

    def make_mesh_for_bonds_for_blender(self, imol: int, mode: str, against_a_dark_background: bool, bond_width: float, atom_radius_to_bond_width_ratio: float, smoothness_factor: int) -> None:
        """
        Function for Blender interface. 

            Args:
                imol (int): 
                mode (str): 
                against_a_dark_background (bool): 
                bond_width (float): 
                atom_radius_to_bond_width_ratio (float): 
                smoothness_factor (int): 

            Returns:
                None
        """

    def make_mesh_for_gaussian_surface_for_blender(self, imol: int, sigma: float, contour_level: float, box_radius: float, grid_scale: float, b_factor: float) -> None:
        """
        Function for Blender interface. 

            Args:
                imol (int): 
                sigma (float): 
                contour_level (float): 
                box_radius (float): 
                grid_scale (float): 
                b_factor (float): 

            Returns:
                None
        """

    def make_mesh_for_goodsell_style_for_blender(self, imol: int, colour_wheel_rotation_step: float, saturation: float, goodselliness: float) -> None:
        """
        blender 
        Function for Blender interface 

            Args:
                imol (int): 
                colour_wheel_rotation_step (float): 
                saturation (float): 
                goodselliness (float): 

            Returns:
                None
        """

    def make_mesh_for_map_contours_for_blender(self, imol: int, x: float, y: float, z: float, level: float, radius: float) -> None:
        """
        Function for Blender interface. 

            Args:
                imol (int): 
                x (float): 
                y (float): 
                z (float): 
                level (float): 
                radius (float): 

            Returns:
                None
        """

    def make_mesh_for_molecular_representation_for_blender(self, imol: int, cid: str, colour_scheme: str, style: str, secondary_structure_usage_flag: int) -> None:
        """
        Function for Blender interface

            Make an (internal) mesh

            This function doesn't return a value, instead it stores a 

            @modifies internal state to fill the internal 

            Args:
                imol (int): 
                cid (str): 
                colour_scheme (str): 
                style (str): 
                secondary_structure_usage_flag (int): 

            Returns:
                None
        """

    def mask_map_by_atom_selection(self, imol_coords: int, imol_map: int, cid: str, atom_radius: float, invert_flag: bool) -> int:
        """
        Mask map by atom selection

            (note the argument order is reversed compared to the coot api).

            Args:
                imol_coords (int): is the model molecule index 
                imol_map (int): is the map molecule index 
                cid (str): is the atom selection CID e.g "//A/15" (all the atoms in residue 15 of chain A) 
                atom_radius (float): is the atom radius. Use a negative number to mean "default". 
                invert_flag (bool): changes the parts of the map that are masked, so to highlight the density for a ligand one would pass the cid for the ligand and invert_flag as true, so that the parts of the map that are not the ligand are suppressed.

            Returns:
                int: the index of the new map or -1 on failure
        """

    def make_power_scaled_map(self, imol_ref: int, imol_map_for_scaling: int) -> int:
        """
        Make a FSC-scaled map

            Args:
                imol_ref (int): is the reference map molecule index 
                imol_map_for_scaling (int): is the second map molecule index

            Returns:
                int: the molecule index of the new map
        """

    def merge_molecules(self, imol: int, list_of_other_molecules: str) -> tuple[int, list[merge_molecule_results_info_t]]:
        """
        Merge molecules

            Args:
                imol (int): is the model molecule index 
                list_of_other_molecules (str): is a colon-separated list of molecules, e.g. "2:3:4"

            Returns:
                tuple: the first is a flag set to 1 if a merge occurred (and 0 if it did not) the second is a vector of merge results, i.e. if you merged a ligand, what is the new residue spec of the ligand, and if you merged a (polymer) chain, what is the new chain-id of that chain.
        """

    def minimize_energy(self, imol: int, atom_selection_cid: str, n_cycles: int, do_rama_plot_restraints: bool, rama_plot_weight: float, do_torsion_restraints: bool, torsion_weight: float, refinement_is_quiet: bool) -> tuple[int, instanced_mesh_t]:
        """
        Minimise/optimise the geometry of the specified residue(s)

            The use of "energy" should not be taken literally here

            Args:
                imol (int): is the model molecule index 
                atom_selection_cid (str): is the selection CID e.g. "//A/15" (residue 15 of chain A) 
                n_cycles (int): is the number of refinement cycles. If you pass n_cycles = 100 (or some such) then you can get the mesh for the partially optimized ligand/residues 
                do_rama_plot_restraints (bool): is the flag for the usage of Ramachandran plot restraints 
                rama_plot_weight (float): is the flag to set the Ramachandran plot restraints weight 
                do_torsion_restraints (bool): is the flag for the usage of torsion restraints 
                torsion_weight (float): is the flag to set the torsion restraints weight 
                refinement_is_quiet (bool): is used to reduce the amount of diagnostic text written to the output

            Returns:
                tuple: the success status 1 if the minimization was performed and 0 if it was not.
        """

    def minimize(self, imol: int, atom_selection_cid: str, n_cycles: int, do_rama_plot_restraints: bool, rama_plot_weight: float, do_torsion_restraints: bool, torsion_weight: float, refinement_is_quiet: bool) -> float:
        """
        Args:
            imol (int): is the model molecule index 
            atom_selection_cid (str): is the selection CID e.g. "//A/15" (residue 15 of chain A) 
            n_cycles (int): is the number of refinement cycles. If you pass n_cycles = 100 (or some such) then you can get the mesh for the partially optimized ligand/residues 
            do_rama_plot_restraints (bool): is the flag for the usage of Ramachandran plot restraints 
            rama_plot_weight (float): is the flag to set the Ramachandran plot restraints weight 
            do_torsion_restraints (bool): is the flag for the usage of torsion restraints 
            torsion_weight (float): is the flag to set the torsion restraints weight 
            refinement_is_quiet (bool): is used to reduce the amount of diagnostic text written to the output

        Returns:
            float: the function value at termination
        """

    def mmcif_tests(self, last_test_only: bool) -> int:
        """
        Testing function

            a test for mmdb/gemmi/mmcif functionality

            Args:
                last_test_only (bool): is True to mean that only that last test should be run. The default is False. This is useful to set to True while a test is being developed.

            Returns:
                int: the success status: 1 means that all the tests passed.
        """

    def mmrrcc(self, arg0: int, arg1: str, arg2: int, /) -> tuple[dict[residue_spec_t, density_correlation_stats_info_t], dict[residue_spec_t, density_correlation_stats_info_t]]:
        """
        Args:
            imol (int): 
            chain_id (str): 
            imol_map (int): 

        Returns:
            tuple
        """

    def move_molecule_to_new_centre(self, imol: int, x: float, y: float, z: float) -> int:
        """
        Move the molecule to the given centre

            Args:
                imol (int): is the model molecule index 
                x (float): is the x coordinate of the new centre of the screen 
                y (float): is the y coordinate of the new centre of the screen 
                z (float): is the z coordinate of the new centre of the screen

            Returns:
                int: 1 on a successful move, 0 on failure.
        """

    def multiply_residue_temperature_factors(self, imol: int, cid: str, factor: float) -> None:
        """
        Interactive B-factor refinement

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID e.g "//A/15" (residue 15 of chain A) 
                factor (float): might typically be 0.9 or 1.1 

            Returns:
                None
        """

    def mutate(self, imol: int, cid: str, new_residue_type: str) -> int:
        """
        Mutate residue

            Args:
                imol (int): is the model molecule index 
                cid (str): 
                new_residue_type (str): is the 3-letter code of the new residue, e.g. "TYR" for tyrosine

            Returns:
                int: 1 on a successful move, 0 on failure.
        """

    def new_positions_for_atoms_in_residues(self, imol: int, moved_residues: Sequence[moved_residue_t]) -> int:
        """
        Update the positions of the atoms in the residues

            Args:
                imol (int): is the model molecule index 
                moved_residues (list): 

            Returns:
                int
        """

    def new_positions_for_residue_atoms(self, imol: int, residue_cid: str, moved_atoms: Sequence[moved_atom_t]) -> int:
        """
        Update the positions of the atoms in the residue

            Args:
                imol (int): is the model molecule index 
                residue_cid (str): is the residue selection CID e.g "//A/15" (residue 15 of chain A) 
                moved_atoms (list): is a list of the atoms moved in the specified residue, e.g. moved_atom_t(" CA ", 1, 2, 3) 

            Returns:
                int
        """

    def non_standard_residue_types_in_model(self, imol: int) -> list[str]:
        """
        Get a list of non-standard residues in the given molecule

            Args:
                imol (int): is the model molecule index

            Returns:
                list: a vector/list of non-standard residues
        """

    def package_version(self) -> str:
        """
        Get the package version

            Returns:
                str: the package version, e.g. "1.1.11" - if this is a not yet a release version the version will end in a "+", such as "1.1.11+"
        """

    def partition_map_by_chain(self, imol_map: int, imol_model: int) -> list[int]:
        """
        Partition the input map

            Each voxel in the map is assigned to the chain to which it is nearest. Unlike masking, the generated maps are not restricted to be "close" to the atoms in the atom selection.

            e.g. maskChains for ChimeraX - JiangLab

            Args:
                imol_map (int): is the map molecule index 
                imol_model (int): is the model molecule index

            Returns:
                list: a vector/list of the molecules indices of the newly created maps
        """

    def pepflips_using_difference_map(self, imol_coords: int, imol_difference_map: int, n_sigma: float) -> list[interesting_place_t]:
        """
        Get pepflips based on the difference map

            Args:
                imol_coords (int): is the model molecule index 
                imol_difference_map (int): is the difference map molecule index 
                n_sigma (float): number of sd, e.g. 4.8

            Returns:
                list: a vector/list of
        """

    def peptide_omega_analysis(self, imol_model: int) -> validation_information_t:
        """
        Peptide omega validation information

            Args:
                imol_model (int): is the model molecule index
        """

    def print_secondary_structure_info(self, imol: int) -> None:
        """
        Print the secondary structure information

            Args:
                imol (int): is the model molecule index 

            Returns:
                None
        """

    def rail_points_total(self) -> int:
        """
        The total rail points

            Returns:
                int: the sum of all rail points accumulated since the maps were connected.
        """

    def ramachandran_analysis(self, imol_model: int) -> validation_information_t:
        """
        Get the ramachandran validation information (formatted for a graph, not 3D)

            Args:
                imol_model (int): is the model molecule index
        """

    def ramachandran_validation(self, imol: int) -> list[phi_psi_prob_t]:
        """
        Get the data for Ramachandran validation, which importantly contains probability information

            Args:
                imol (int): is the model molecule index

            Returns:
                list: a vector/list of
        """

    def read_coordinates(self, file_name: str) -> int:
        """
        Read a coordinates file (mmcif or PDB)

            Args:
                file_name (str): is the name of the coordinates file

            Returns:
                int: the new molecule index on success and -1 on failure
        """

    def read_ccp4_map(self, file_name: str, is_a_difference_map: bool) -> int:
        """
        Read a CCP4 (or MRC) map

            There is currently a size limit of 1000 pixels per edge.

            Args:
                file_name (str): is the name of the map file 
                is_a_difference_map (bool): False

            Returns:
                int: the new molecule number or -1 on failure
        """

    def read_extra_restraints(self, imol: int, file_name: str) -> int:
        """
        Read extra restraints (e.g. from ProSMART)

            Args:
                imol (int): is the model molecule index 
                file_name (str): 

            Returns:
                int
        """

    def read_mtz(self, file_name: str, f: str, phi: str, weight: str, use_weight: bool, is_a_difference_map: bool) -> int:
        """
        Read the given mtz file

            Args:
                file_name (str): is the name of the MTZ file 
                f (str): F column, "FWT" 
                phi (str): phi column, "PHWT" 
                weight (str): weight column, "W" 
                use_weight (bool): flag for weights usage, False 
                is_a_difference_map (bool): False

            Returns:
                int: the new molecule number or -1 on failure
        """

    def read_pdb(self, file_name: str) -> int:
        """
        Read a PDB file (or mmcif coordinates file, despite the name)

            It does the same job as 

            Args:
                file_name (str): is the name of the coordinates file

            Returns:
                int: the new molecule index on success and -1 on failure
        """

    def read_small_molecule_cif(self, file_name: str) -> int:
        """
        Read a small molecule CIF file

            Args:
                file_name (str): is the cif file-name

            Returns:
                int: the new molecule index on success and -1 on failure
        """

    def redo(self, imol: int) -> int:
        """
        Redo

            Args:
                imol (int): is the model molecule index

            Returns:
                int: 1 on successful redo, return 0 on failure
        """

    def refine(self, imol: int, n_cycles: int) -> tuple[int, instanced_mesh_t]:
        """
        Run some cycles of refinement and return a mesh

            That way we can see the molecule animate as it refines

            Args:
                imol (int): is the model molecule index 
                n_cycles (int): is the number of refinement cycles

            Returns:
                tuple: a pair: the first of which is the status of the refinement: GSL_CONTINUE, GSL_SUCCESS, GSL_ENOPROG (no progress). i.e. don't call this function again unless the status is GSL_CONTINUE (-2); The second is a
        """

    def refine_residue_range(self, imol: int, chain_id: str, res_no_start: int, res_no_end: int, n_cycles: int) -> int:
        """
        Refine residue range

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" for chain A 
                res_no_start (int): the starting residue number 
                res_no_end (int): 
                n_cycles (int): is the number of refinement cycles

            Returns:
                int: a value of 1 if the refinement was performed and 0 if it was not.
        """

    def refine_residues(self, imol: int, chain_id: str, res_no: int, ins_code: str, alt_conf: str, mode: str, n_cycles: int) -> int:
        """
        Refine the residues

            Args:
                imol (int): is the model molecule index 
                chain_id (str): e.g. "A" for chain A 
                res_no (int): is the residue number, e.g. 12 
                ins_code (str): is the insertion code, e.g. "A" 
                alt_conf (str): is the alternate conformation, e.g. "A" or "B" 
                mode (str): is the mode of real space refinement e.g. "SINGLE", "TRIPLE", "QUINTUPLE", "HEPTUPLE", "SPHERE", "BIG_SPHERE", "CHAIN", "ALL" 
                n_cycles (int): is the number of refinement cycles

            Returns:
                int: a value of 1 if the refinement was performed and 0 if it was not.
        """

    def refine_residues_using_atom_cid(self, imol: int, cid: str, mode: str, n_cycles: int) -> int:
        """
        Refine the residues using cid

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID e.g "//A/15" (residue 15 of chain A) 
                mode (str): is the mode of real space refinement e.g. "SINGLE", "TRIPLE", "QUINTUPLE", "HEPTUPLE", "SPHERE", "BIG_SPHERE", "CHAIN", "ALL" 
                n_cycles (int): is the number of refinement cycles

            Returns:
                int: a value of 1 if the refinement was performed and 0 if it was not.
        """

    def regen_map(self, imol_map: int, imol_maps: str, scales: Sequence[float]) -> bool:
        """
        This function does no normalisation of the scales, presuming that they are pre-normalized.

            The number of maps in imol_maps should match the size of the scale vector. If not, nothing will happen and False will be returned

            Args:
                imol_map (int): is the map molecule index 
                imol_maps (str): is a colon-separated list of map indices e.g. "2:3:4" 
                scales (list): is the list of weights corresponding to the list of maps

            Returns:
                bool: the success status
        """

    def replace_fragment(self, imol_base: int, imol_reference: int, atom_selection: str) -> int:
        """
        Replace a fragment

            Args:
                imol_base (int): is the base model index 
                imol_reference (int): is the reference model index 
                atom_selection (str): is the selection CID e.g "//A/15-17" (residue 15, 16 and 17 of chain A)

            Returns:
                int: the success status
        """

    def replace_map_by_mtz_from_file(self, imol: int, file_name: str, f: str, phi: str, weight: str, use_weight: bool) -> int:
        """
        Replace map by mtz

            Args:
                imol (int): is the map molecule index 
                file_name (str): 
                f (str): F column, "FWT" 
                phi (str): phi column, "PHWT" 
                weight (str): weight column, "W" 
                use_weight (bool): flag for weights usage, False 

            Returns:
                int
        """

    def replace_molecule_by_model_from_file(self, imol: int, pdb_file_name: str) -> None:
        """
        Read a PDB file (or mmcif coordinates file, despite the name) to replace the current molecule

            This will only work if the molecules is already a model molecule

            Args:
                imol (int): is the model molecule index 
                pdb_file_name (str): 

            Returns:
                None
        """

    def replace_residue(self, imol: int, residue_cid: str, new_residue_type: str, imol_enc: int) -> None:
        """
        Replace a residue

            This has a different meaning of "replace" to 

            Change the type of a residue (for example, "TYR" to "CYS") The algorithm will superpose the mainchain CA, C and N and try to set matching torsion to the angle that they were in the reference structure.

            Args:
                imol (int): is the model molecule index 
                residue_cid (str): is the residue selection CID e.g "//A/15" (residue 15 of chain A) 
                new_residue_type (str): is the 3-letter code of the new residue, e.g "CYS" 
                imol_enc (int): is the molecule index for the residue type/compound_id 

            Returns:
                None
        """

    def residues_with_missing_atoms(self, imol: int) -> list[residue_spec_t]:
        """
        Get residues with missing atoms

            Args:
                imol (int): is the model molecule index

            Returns:
                list: an object that has information about residues without dictionaries and residues with missing atom in the the specified molecule
        """

    def rigid_body_fit(self, imol: int, multi_cid: str, imol_map: int) -> int:
        """
        Rigid-body fitting

            Args:
                imol (int): is the model molecule index 
                multi_cid (str): 
                imol_map (int): is the map molecule index 

            Returns:
                int
        """

    def rotamer_analysis(self, imol_model: int) -> validation_information_t:
        """
        Get the rotamer validation information

            Args:
                imol_model (int): is the model molecule index
        """

    def rotate_around_bond(self, imol: int, residue_cid: str, atom_name_1: str, atom_name_2: str, atom_name_3: str, atom_name_4: str, torsion_angle: float) -> int:
        """
        Rotate atoms around torsion

            the bond is presumed to be between atom-2 and atom-3. Atom-1 and atom-4 are used to define the absolute torsion angle.

            Args:
                imol (int): is the model molecule index 
                residue_cid (str): is the residue selection CID e.g "//A/15" (residue 15 of chain A) 
                atom_name_1 (str): e.g. " CA " 
                atom_name_2 (str): e.g. " CB " 
                atom_name_3 (str): e.g. " CG " 
                atom_name_4 (str): e.g. " CD1" 
                torsion_angle (double): e.g. 12.3 degrees

            Returns:
                int: status 1 if successful, 0 if not.
        """

    def scale_map(self, imol_map: int, scale_factor: float) -> None:
        """
        Scale map

            Args:
                imol_map (int): 
                scale_factor (float): is the scale factor 

            Returns:
                None
        """

    def servalcat_refine_xray(self, imol: int, imol_map: int, output_prefix: str) -> int:
        """
        External refinement using servalcat, using data that has already been associated.

            Args:
                imol (int): is the model molecule index 
                imol_map (int): is the map molecule index 
                output_prefix (str): is the prefix of the output filename, e.g. "ref-1"

            Returns:
                int: the imol of the refined model.
        """

    def servalcat_refine_xray_with_keywords(self, arg0: int, arg1: int, arg2: str, arg3: dict, /) -> int:
        """
        Use servalcat keywords

            Args:
                imol (int): is the model molecule index 
                imol_map (int): is the map molecule index 
                output_prefix (str): is the prefix of the output filename, e.g. "ref-1" 
                key_value_pairs (const nanobind::dict &): is a dictionary of key-value pairs for the servalcat keywords, e.g. resolution: 2.05

            Returns:
                int: the imol of the refined model.
        """

    def set_add_waters_sigma_cutoff(self, d: float) -> None:
        """
        Parameter for 

            Args:
                d (float): is the sigma cutoff, default is 1.75 

            Returns:
                None
        """

    def set_add_waters_variance_limit(self, d: float) -> None:
        """
        Parameter for 

            Args:
                d (float): is the variance limit, default is 0.1 

            Returns:
                None
        """

    def set_add_waters_water_to_protein_distance_lim_min(self, d: float) -> None:
        """
        Parameter for 

            Args:
                d (float): is the min distance, default 2.4 

            Returns:
                None
        """

    def set_add_waters_water_to_protein_distance_lim_max(self, d: float) -> None:
        """
        Parameter for 

            Args:
                d (float): is the max distance, default 3.4 

            Returns:
                None
        """

    def set_colour_map_for_map_coloured_by_other_map(self, colour_table: Sequence[tuple[float, Sequence[float]]]) -> None:
        """
        Args:
            colour_table (list): 

        Returns:
            None
        """

    def set_colour_wheel_rotation_base(self, imol: int, r: float) -> None:
        """
        Set the colour wheel rotation base for the specified molecule (in degrees)

            Args:
                imol (int): is the model molecule index 
                r (float): is the rotation angle in degrees 

            Returns:
                None
        """

    @overload
    def set_draw_missing_residue_loops(self, state: bool) -> None:
        """
        Set the state for drawing missing loops

            By default missing loops are drawn. This function allows missing loops to not be drawn. Sometimes that can clarify the representation. This is a lightweight function that sets a flag that is used by subsequent calls to 

            Args:
                state (bool): is True to mean it is enabled 

            Returns:
                None
        """

    @overload
    def set_draw_missing_residue_loops(self, state: bool) -> None: ...

    def set_gltf_pbr_metalicity_factor(self, imol: int, metalicity: float) -> None:
        """
        set the gltf PBR metalicity factor

            Args:
                imol (int): is the model molecule index 
                metalicity (float): is the factor for the roughness (0.0 to 1.0) 

            Returns:
                None
        """

    def set_gltf_pbr_roughness_factor(self, imol: int, roughness_factor: float) -> None:
        """
        set the gltf PBR roughness factor

            Args:
                imol (int): is the model molecule index 
                roughness_factor (float): is the factor for the roughness (0.0 to 1.0) 

            Returns:
                None
        """

    def set_imol_refinement_map(self, i: int) -> None:
        """
        Set the map used for refinement and fitting

            Args:
                i (int): the map molecule index used for refinement and fitting 

            Returns:
                None
        """

    def set_make_backups(self, state: bool) -> None:
        """
        Allow the user to disable/enable backups

            Args:
                state (bool): is True to mean that it is enabled. The default is True. 

            Returns:
                None
        """

    def set_logging_file(self, file_name: str) -> None:
        """
        Control the logging

            Args:
                level (str): is the logging level, level is either "LOW" or "HIGH" or "DEBUGGING" 

            Returns:
                None
        """

    def set_logging_level(self, level: str) -> None:
        """
        Control the logging

            Args:
                level (str): is the logging level, level is either "LOW" or "HIGH" or "DEBUGGING" 

            Returns:
                None
        """

    def set_map_sampling_rate(self, msr: float) -> None:
        """
        Set the map sampling rate

            Higher numbers mean smoother maps, but they take longer to generate, longer to transfer, longer to parse and longer to draw

            Args:
                msr (float): is the map sampling rate to set, the default is 1.8 

            Returns:
                None
        """

    def set_map_weight(self, w: float) -> None:
        """
        Set the map weight

            Args:
                w (float): the map weight to be used for refinement, e.g. 50.0 

            Returns:
                None
        """

    def set_max_number_of_threads(self, n_threads: int) -> None:
        """
        Testing function

            set the maximum number of threads for both the thread pool and the vector of threads

            Args:
                n_threads (unsigned int): is the number of threads 

            Returns:
                None
        """

    def set_molecule_name(self, imol: int, new_name: str) -> None:
        """
        Set the molecule name

            Args:
                imol (int): is the model or map molecule index 
                new_name (str): is the new name of the model or map 

            Returns:
                None
        """

    def set_occupancy(self, imol: int, cid: str, occ_new: float) -> None:
        """
        Set the occupancy for the given atom selection

            Args:
                imol (int): is the model molecule index 
                cid (str): is the atom selection CID e.g "//A/15/OH" (atom OH in residue 15 of chain A) 
                occ_new (float): is the new occupancy 

            Returns:
                None
        """

    def set_rama_plot_restraints_weight(self, f: float) -> None:
        """
        Set the Ramachandran plot restraints weight

            Args:
                f (float): is the weight to set, default 1.0 

            Returns:
                None
        """

    def set_refinement_is_verbose(self, state: bool) -> None:
        """
        For debugging the refinement - write out some diagnositics - some might be useful.

            API change 20240226 - this function now takes a boolean argument

            Args:
                state (bool): is True to mean that it is enabled 

            Returns:
                None
        """

    def set_refinement_geman_mcclure_alpha(self, a: float) -> None:
        """
        Set the refinement Geman-McClure alpha

            Args:
                a (float): is the Geman-McClure alpha, e.g. 0.01 

            Returns:
                None
        """

    def set_show_timings(self, s: bool) -> None:
        """
        Set the show_timings flag

            Various (not all) functions in this class can calculate how long they took to run. Setting this will write the time to taken (in milliseconds) to stdout.

            Args:
                s (bool): is True to mean that it is enabled. The default is True. 

            Returns:
                None
        """

    def set_temperature_factors_using_cid(self, imol: int, cid: str, temp_fact: float) -> None:
        """
        Change the B factors

            Args:
                imol (int): is the model molecule index 
                cid (str): is the selection CID, e.g. //A/15 (residue 15 in chain A) 
                temp_fact (float): is the isotropic ADP/temperature factor, e.g., 22 

            Returns:
                None
        """

    def set_torsion_restraints_weight(self, f: float) -> None:
        """
        Set the torsiont restraints weight

            Args:
                f (float): is the weight to set, default value is 1.0 

            Returns:
                None
        """

    def set_use_gemmi(self, state: bool) -> None:
        """
        Set the state of using GEMMI for coordinates parsing

            Args:
                state (bool): is True to mean that it is enabled. The default is True. 

            Returns:
                None
        """

    def set_use_rama_plot_restraints(self, state: bool) -> None:
        """
        Turn on or off ramachandran restraints

            Args:
                state (bool): is True to mean that it is enabled 

            Returns:
                None
        """

    def set_use_torsion_restraints(self, state: bool) -> None:
        """
        Turn on or off torsion restraints

            Args:
                state (bool): is True to mean that it is enabled 

            Returns:
                None
        """

    def set_user_defined_atom_colour_by_selection(self, imol: int, indexed_residues_cids: Sequence[tuple[str, int]], colour_applies_to_non_carbon_atoms_also: bool) -> None:
        """
        Set the user-defined residue selections (CIDs) to colour index

            Args:
                imol (int): is the model molecule index 
                indexed_residues_cids (list): 
                colour_applies_to_non_carbon_atoms_also (bool): 

            Returns:
                None
        """

    def set_user_defined_bond_colours(self, imol: int, colour_map: Mapping[int, "std::array<float, 4ul>"]) -> None:
        """
        User-defined colour-index to colour. 

            Args:
                imol (int): 
                colour_map (const std::map< unsigned int, std::array< float, 4 > > &): 

            Returns:
                None
        """

    def sfcalc_genmap(self, imol_model: int, imol_map_with_data_attached: int, imol_updating_difference_map: int) -> None:
        """
        Calculate SF and re-generate maps

            This is a low-level function - generally one would use the updating maps method rather than this

            Args:
                imol_model (int): is the model molecule index 
                imol_map_with_data_attached (int): is the map index with the data have been attached by the previous function (associate_data_mtz_file_with_map) 
                imol_updating_difference_map (int): is the index of the difference map that you want to update when the model updates 

            Returns:
                None
        """

    def sfcalc_genmaps_using_bulk_solvent(self, imol_model: int, imol_2fofc_map: int, imol_updating_difference_map: int, imol_map_with_data_attached: int) -> "coot::util::sfcalc_genmap_stats_t":
        """
        Calculate SF and re-generate maps using bulk solvent

            This is a low-level function. Call this function after connecting maps for updating maps to set the initial R-factor and store the initial map flatness.

            Args:
                imol_model (int): is the model molecule index 
                imol_2fofc_map (int): is the map molecule index of the 2FO-FC map 
                imol_updating_difference_map (int): is the index of the difference map that you want to update when the model updates 
                imol_map_with_data_attached (int): is the map index with the data have been attached by the previous function (associate_data_mtz_file_with_map)
        """

    def sharpen_blur_map(self, imol_map: int, b_factor: float, in_place_flag: bool) -> int:
        """
        Create a new map that is blurred/sharpened

            Args:
                imol_map (int): 
                b_factor (float): e.g. 100.0 
                in_place_flag (bool): True if you want to replace the current map, False if you want to create a new map

            Returns:
                int: the molecule index of the new map or -1 on failure or if
        """

    def sharpen_blur_map_with_resample(self, imol_map: int, b_factor: float, resample_factor: float, in_place_flag: bool) -> int:
        """
        Create a new map that is blurred/sharpened and resampling

            Note that resampling can be slow, a resample_factor of 1.5 is about the limit of the trade of of prettiness for speed.

            Args:
                imol_map (int): is the map molecule index 
                b_factor (float): e.g. 100.0 
                resample_factor (float): e.g. 1.4 
                in_place_flag (bool): True if you want to replace the current map, False if you want to create a new map

            Returns:
                int: the molecule index of the new map or -1 on failure or if
        """

    def side_chain_180(self, imol: int, atom_cid: str) -> int:
        """
        Rotate last chi angle of the side chain by 180 degrees

            Args:
                imol (int): is the model molecule index 
                atom_cid (str): is the atom selection CID e.g "//A/15/OH" (atom OH of residue 15 of chain A)

            Returns:
                int: 1 on a successful move, 0 on failure.
        """

    def split_multi_model_molecule(self, imol: int) -> list[int]:
        """
        Split an NMR model into multiple models

            Args:
                imol (int): is the model molecule index

            Returns:
                list: the vector/list of new molecule indices
        """

    def split_residue_using_map(self, imol: int, residue_cid: str, imol_diff_map: int) -> int:
        """
        Split a residue into alt-confs

            do nothing if the residue already has alt-confs.

            Args:
                imol (int): the modified model 
                residue_cid (str): the modified residue, the residue selection CID e.g "//A/15" (residue 15 of chain A) 
                imol_diff_map (int): is the difference map that is used to determine the residue split

            Returns:
                int: split success status
        """

    def test_function(self, s: str) -> None:
        """
        Args:
            s (str): 

        Returns:
            None
        """

    def test_origin_cube(self) -> simple_mesh_t:
        """Get a simple test mesh"""

    def transform_map_using_lsq_matrix(self, imol_map: int, lsq_matrix: lsq_results_t, x: float, y: float, z: float, radius: float) -> int:
        """
        Transform a map and create a new map

            Args:
                imol_map (int): map molecule index 
                lsq_matrix (lsq_results_t): is an object of type lsq_results_t, is the object returned by 
                x (float): is the point in the map about which the map is transformed 
                y (float): is the point in the map about which the map is transformed 
                z (float): is the point in the map about which the map is transformed 
                radius (float): the radius of the transformed map, typically between 10 and 100 A

            Returns:
                int: the molecule index of the new map, -1 for failure
        """

    def try_read_dictionaries_for_new_residue_types(self, imol: int) -> bool:
        """
        Try to read the dictionaries for any residue type in imol that as yet does not have a dictionary

            Args:
                imol (int): is the model molecule index 

            Returns:
                bool: true if there were no dictionary for new types that couldn't be read.
        """

    def undo(self, imol: int) -> int:
        """
        Undo

            Args:
                imol (int): is the model molecule index

            Returns:
                int: 1 on successful undo, return 0 on failure
        """

    def unmodelled_blobs(self, imol_model: int, imol_map: int, rmsd_cut_off: float) -> list[interesting_place_t]:
        """
        Unmodelled blobs

            Args:
                imol_model (int): is the model molecule index 
                imol_map (int): is the map molecule index 
                rmsd_cut_off (float): is the low map limit for cluster generation 1.4 is a reasonable value.

            Returns:
                list: a vector/list of
        """

    def write_coordinates(self, imol: int, file_name: str) -> int:
        """
        Write the coordinates to the given file name

            Args:
                imol (int): is the model molecule index 
                file_name (str): is the name of the new model

            Returns:
                int: 1 on success and 0 on failure
        """

    def write_map(self, imol: int, file_name: str) -> int:
        """
        Write a map

            Args:
                imol (int): is the map molecule index 
                file_name (str): is the name of the new map file

            Returns:
                int: 1 on a successful write, return 0 on failure.
        """

    def write_png(self, compound_id: str, imol: int, file_name: str) -> None:
        """
        Write a PNG for the given compound_id.

            Currently this function does nothing (drawing is done with the not-allowed cairo)

            Args:
                compound_id (str): is the 3-letter code for the residue/ligand in the first model, e.g. "TYR" for tyrosine 
                imol (int): is the model molecule index 
                file_name (str): 

            Returns:
                None
        """

class chain_mutation_info_container_t:
    @property
    def chain_id(self) -> str: ...

    @property
    def alignedS(self) -> str: ...

    @property
    def alignedT(self) -> str: ...

    @property
    def alignedS_label(self) -> str: ...

    @property
    def alignedT_label(self) -> str: ...

    @property
    def alignment_string(self) -> str: ...

    @property
    def alignment_score(self) -> tuple[bool, float]: ...

    @property
    def insertions(self) -> list["coot::mutate_insertion_range_info_t"]: ...

    @property
    def deletions(self) -> list[residue_spec_t]: ...

    @property
    def mutations(self) -> list[tuple[residue_spec_t, str]]: ...

class molecules_container_py(molecules_container_t):
    def __init__(self, arg: bool, /) -> None: ...

    def writePDBASCII(self, arg0: int, arg1: str, /) -> int: ...

    def writeCIFASCII(self, arg0: int, arg1: str, /) -> int: ...

    def writeCCP4Map(self, arg0: int, arg1: str, /) -> int: ...

class simple_rotamer:
    def P_r1234(self) -> float: ...

    def Probability_rich(self) -> float: ...

    def get_chi(self, arg: int, /) -> float: ...

class merge_molecule_results_info_t:
    @property
    def chain_id(self) -> str: ...

    @property
    def spec(self) -> residue_spec_t: ...

    @property
    def is_chain(self) -> bool: ...

class graph_data_type(enum.Enum):
    Unset = 0

    Density = 1

    Distortion = 2

    Energy = 3

    Probability = 4

    Correlation = 5

    LogProbability = 6

    TorsionAngle = 7

class residue_validation_information_t:
    @property
    def function_value(self) -> float: ...

    @property
    def label(self) -> str: ...

    @property
    def residue_spec(self) -> residue_spec_t: ...

    @property
    def atom_spec(self) -> atom_spec_t: ...

class chain_validation_information_t:
    @property
    def chain_id(self) -> str: ...

    @property
    def rviv(self) -> list[residue_validation_information_t]: ...

class validation_information_t:
    @property
    def name(self) -> str: ...

    @property
    def type(self) -> graph_data_type: ...

    @property
    def cviv(self) -> list[chain_validation_information_t]: ...

    def get_index_for_chain(self, arg: str, /) -> int: ...

class restraint_type(enum.Enum):
    Bond = 1

    Angle = 2

    Torsion = 4

    Plane = 8

    Non-Bonded-Contact = 16

    Chiral-Volume = 32

    Trans-Peptide = 2048

    Geman-McClure = 1024

class simple_restraint:
    @property
    def restraint_type(self) -> restraint_type: ...

    @property
    def target_value(self) -> float: ...

class geometry_distortion_info_t:
    @property
    def distortion_score(self) -> float: ...

    @property
    def atom_indices(self) -> list[int]: ...

    @property
    def atom_specs(self) -> list[atom_spec_t]: ...

    @property
    def residue_spec(self) -> residue_spec_t: ...

    @property
    def restraint(self) -> simple_restraint: ...

class geometry_distortion_info_container_t:
    @property
    def chain_id(self) -> str: ...

    def distortion_sum(self) -> float: ...

    def size(self) -> int: ...

    def get_geometry_distortion_info(self, arg: int, /) -> geometry_distortion_info_t: ...

    @property
    def geometry_distortion(self) -> list[geometry_distortion_info_t]: ...

class fit_ligand_info_t:
    @property
    def imol(self) -> int: ...

    @property
    def cluster_idx(self) -> int: ...

    @property
    def ligand_idx(self) -> int: ...

    def get_fitting_score(self) -> float: ...

    def get_cluster_volume(self) -> float: ...

class residue_spec_t:
    def __init__(self, arg0: str, arg1: int, arg2: str, /) -> None: ...

    @property
    def model_number(self) -> int: ...

    @model_number.setter
    def model_number(self, arg: int, /) -> None: ...

    @property
    def chain_id(self) -> str: ...

    @chain_id.setter
    def chain_id(self, arg: str, /) -> None: ...

    @property
    def res_no(self) -> int: ...

    @res_no.setter
    def res_no(self, arg: int, /) -> None: ...

    @property
    def ins_code(self) -> str: ...

    @ins_code.setter
    def ins_code(self, arg: str, /) -> None: ...

    @property
    def int_user_data(self) -> int: ...

    @int_user_data.setter
    def int_user_data(self, arg: int, /) -> None: ...

    def format(self) -> str: ...

class atom_spec_t:
    def __init__(self, arg0: str, arg1: int, arg2: str, arg3: str, arg4: str, /) -> None: ...

    @property
    def chain_id(self) -> str: ...

    @chain_id.setter
    def chain_id(self, arg: str, /) -> None: ...

    @property
    def res_no(self) -> int: ...

    @res_no.setter
    def res_no(self, arg: int, /) -> None: ...

    @property
    def ins_code(self) -> str: ...

    @ins_code.setter
    def ins_code(self, arg: str, /) -> None: ...

    @property
    def atom_name(self) -> str: ...

    @atom_name.setter
    def atom_name(self, arg: str, /) -> None: ...

    @property
    def alt_conf(self) -> str: ...

    @alt_conf.setter
    def alt_conf(self, arg: str, /) -> None: ...

    @property
    def int_user_data(self) -> int: ...

    @int_user_data.setter
    def int_user_data(self, arg: int, /) -> None: ...

    @property
    def float_user_data(self) -> float: ...

    @float_user_data.setter
    def float_user_data(self, arg: float, /) -> None: ...

    @property
    def string_user_data(self) -> str: ...

    @string_user_data.setter
    def string_user_data(self, arg: str, /) -> None: ...

    @property
    def model_number(self) -> int: ...

    @model_number.setter
    def model_number(self, arg: int, /) -> None: ...

    def format(self) -> str: ...

class plain_atom_overlap_t:
    def __init__(self) -> None: ...

    @property
    def ligand_atom_index(self) -> int: ...

    @ligand_atom_index.setter
    def ligand_atom_index(self, arg: int, /) -> None: ...

    @property
    def atom_spec_1(self) -> atom_spec_t: ...

    @atom_spec_1.setter
    def atom_spec_1(self, arg: atom_spec_t, /) -> None: ...

    @property
    def atom_spec_2(self) -> atom_spec_t: ...

    @atom_spec_2.setter
    def atom_spec_2(self, arg: atom_spec_t, /) -> None: ...

    @property
    def overlap_volume(self) -> float: ...

    @overlap_volume.setter
    def overlap_volume(self, arg: float, /) -> None: ...

    @property
    def r_1(self) -> float: ...

    @r_1.setter
    def r_1(self, arg: float, /) -> None: ...

    @property
    def r_2(self) -> float: ...

    @r_2.setter
    def r_2(self, arg: float, /) -> None: ...

    @property
    def is_h_bond(self) -> bool: ...

    @is_h_bond.setter
    def is_h_bond(self, arg: bool, /) -> None: ...

class positioned_atom_spec_t:
    def __init__(self) -> None: ...

    @property
    def atom_spec(self) -> atom_spec_t: ...

    @property
    def pos1(self) -> Cartesian: ...

    @property
    def pos2(self) -> Cartesian: ...

class atom_distance_t:
    def __init__(self) -> None: ...

    @property
    def atom_1(self) -> atom_spec_t: ...

    @property
    def atom_2(self) -> atom_spec_t: ...

    @property
    def distance(self) -> float: ...

class residue_range_t:
    def __init__(self) -> None: ...

    @property
    def chain_id(self) -> str: ...

    @chain_id.setter
    def chain_id(self, arg: str, /) -> None: ...

    @property
    def res_no_start(self) -> int: ...

    @res_no_start.setter
    def res_no_start(self, arg: int, /) -> None: ...

    @property
    def res_no_end(self) -> int: ...

    @res_no_end.setter
    def res_no_end(self, arg: int, /) -> None: ...

class generic_3d_lines_bonds_box_t:
    @property
    def line_segments(self) -> list[list[CartesianPair]]: ...

class CartesianPair:
    def getStart(self) -> Cartesian: ...

    def getFinish(self) -> Cartesian: ...

    def amplitude(self) -> float: ...

class RamachandranInfo:
    def __init__(self) -> None: ...

    @property
    def chainId(self) -> str: ...

    @chainId.setter
    def chainId(self, arg: str, /) -> None: ...

    @property
    def seqNum(self) -> int: ...

    @seqNum.setter
    def seqNum(self, arg: int, /) -> None: ...

    @property
    def insCode(self) -> str: ...

    @insCode.setter
    def insCode(self, arg: str, /) -> None: ...

    @property
    def restype(self) -> str: ...

    @restype.setter
    def restype(self, arg: str, /) -> None: ...

    @property
    def phi(self) -> float: ...

    @phi.setter
    def phi(self, arg: float, /) -> None: ...

    @property
    def psi(self) -> float: ...

    @psi.setter
    def psi(self, arg: float, /) -> None: ...

    @property
    def isOutlier(self) -> bool: ...

    @isOutlier.setter
    def isOutlier(self, arg: bool, /) -> None: ...

    @property
    def is_pre_pro(self) -> bool: ...

    @is_pre_pro.setter
    def is_pre_pro(self, arg: bool, /) -> None: ...

class ResiduePropertyInfo:
    def __init__(self) -> None: ...

    @property
    def chainId(self) -> str: ...

    @chainId.setter
    def chainId(self, arg: str, /) -> None: ...

    @property
    def seqNum(self) -> int: ...

    @seqNum.setter
    def seqNum(self, arg: int, /) -> None: ...

    @property
    def insCode(self) -> str: ...

    @insCode.setter
    def insCode(self, arg: str, /) -> None: ...

    @property
    def restype(self) -> str: ...

    @restype.setter
    def restype(self, arg: str, /) -> None: ...

    @property
    def property(self) -> float: ...

    @property.setter
    def property(self, arg: float, /) -> None: ...

class instancing_data_type_A_t:
    @property
    def colour(self) -> list[float]: ...

    @property
    def size(self) -> list[float]: ...

    @property
    def position(self) -> list[float]: ...

class instancing_data_type_B_t:
    @property
    def colour(self) -> list[float]: ...

    @property
    def size(self) -> list[float]: ...

    @property
    def position(self) -> list[float]: ...

    @property
    def orientation(self) -> list[float]: ...

class instanced_geometry_t:
    @property
    def vertices(self) -> list[vn_vertex]: ...

    @property
    def triangles(self) -> list[g_triangle]: ...

    @property
    def instancing_data_A(self) -> list[instancing_data_type_A_t]: ...

    @property
    def instancing_data_B(self) -> list[instancing_data_type_B_t]: ...

    @property
    def name(self) -> str: ...

class instanced_mesh_t:
    @property
    def geom(self) -> list[instanced_geometry_t]: ...

    @property
    def markup(self) -> simple_mesh_t: ...

class acedrg_types_for_bond_t:
    @property
    def atom_id_1(self) -> str: ...

    @property
    def atom_id_2(self) -> str: ...

    @property
    def atom_type_1(self) -> str: ...

    @property
    def atom_type_2(self) -> str: ...

    @property
    def bond_length(self) -> float: ...

    @property
    def bond_is_between_atoms_in_the_same_ring(self) -> bool: ...

class acedrg_types_for_residue_t:
    @property
    def bond_types(self) -> list[acedrg_types_for_bond_t]: ...

class phi_psi_t:
    def phi(self) -> float: ...

    def psi(self) -> float: ...

    def label(self) -> str: ...

    def residue_name(self) -> str: ...

    def is_filled(self) -> bool: ...

    def is_pre_pro(self) -> bool: ...

    @property
    def ins_code(self) -> str: ...

    @property
    def chain_id(self) -> str: ...

    @property
    def residue_number(self) -> int: ...

class Cartesian:
    def x(self) -> float: ...

    def y(self) -> float: ...

    def z(self) -> float: ...

class vnc_vertex:
    def __init__(self, arg0: "glm::vec<3, float, (glm::qualifier)0>", arg1: "glm::vec<3, float, (glm::qualifier)0>", arg2: "glm::vec<4, float, (glm::qualifier)0>", /) -> None: ...

    @property
    def pos(self) -> list[float]: ...

    @property
    def normal(self) -> list[float]: ...

    @property
    def color(self) -> list[float]: ...

class vn_vertex:
    def __init__(self, arg0: "glm::vec<3, float, (glm::qualifier)0>", arg1: "glm::vec<3, float, (glm::qualifier)0>", /) -> None: ...

    @property
    def pos(self) -> list[float]: ...

    @property
    def normal(self) -> list[float]: ...

class rotamer_change_info_t:
    @property
    def rank(self) -> int: ...

    @property
    def name(self) -> str: ...

    @property
    def richardson_probability(self) -> float: ...

    @property
    def status(self) -> int: ...

class g_triangle:
    def __init__(self, arg0: int, arg1: int, arg2: int, /) -> None: ...

    @property
    def point_id(self) -> list[int]: ...

    def set_point_id(self, arg: Sequence[int], /) -> None: ...

    def get_point_id(self) -> list[int]: ...

class Cell_Translation:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg0: int, arg1: int, arg2: int, /) -> None: ...

    @property
    def us(self) -> int: ...

    @property
    def ws(self) -> int: ...

    @property
    def vs(self) -> int: ...

class symm_trans_t:
    @property
    def symm_as_string(self) -> str: ...

    def is_identity(self) -> bool: ...

    def add_shift(self, arg0: int, arg1: int, arg2: int, /) -> None: ...

    def isym(self) -> int: ...

    def x(self) -> int: ...

    def y(self) -> int: ...

    def z(self) -> int: ...

class simple_mesh_t:
    @property
    def vertices(self) -> list[vnc_vertex]: ...

    @property
    def triangles(self) -> list[g_triangle]: ...

    @property
    def status(self) -> int: ...

    @property
    def name(self) -> str: ...

class helix_t:
    @property
    def serNum(self) -> int: ...

    @property
    def helixID(self) -> str: ...

    @property
    def initResName(self) -> str: ...

    @property
    def initChainID(self) -> str: ...

    @property
    def initSeqNum(self) -> int: ...

    @property
    def initICode(self) -> str: ...

    @property
    def endResName(self) -> str: ...

    @property
    def endChainID(self) -> str: ...

    @property
    def endSeqNum(self) -> int: ...

    @property
    def endICode(self) -> str: ...

    @property
    def helixClass(self) -> int: ...

    @property
    def comment(self) -> str: ...

    @property
    def length(self) -> int: ...

class header_info_t:
    @property
    def title(self) -> str: ...

    @property
    def author_lines(self) -> list[str]: ...

    @property
    def journal_lines(self) -> list[str]: ...

    @property
    def compound_lines(self) -> list[str]: ...

    @property
    def helix_info(self) -> list[helix_t]: ...

class density_correlation_stats_info_t:
    @property
    def n(self) -> float: ...

    @property
    def sum_xy(self) -> float: ...

    @property
    def sum_sqrd_x(self) -> float: ...

    @property
    def sum_sqrd_y(self) -> float: ...

    @property
    def sum_x(self) -> float: ...

    @property
    def sum_y(self) -> float: ...

    def var_x(self) -> float: ...

    def var_y(self) -> float: ...

    def correlation(self) -> float: ...

class superpose_results_t:
    @property
    def superpose_info(self) -> str: ...

    @property
    def alignment(self) -> tuple[str, str]: ...

    @property
    def alignment_info_vec(self) -> list[validation_information_t]: ...

    @property
    def aligned_pairs(self) -> list[tuple[residue_validation_information_t, residue_validation_information_t]]: ...

class lsq_results_t:
    @property
    def rotation_matrix(self) -> list[float]: ...

    @property
    def translation(self) -> list[float]: ...

class h_bond:
    @property
    def hb_hydrogen(self) -> h_bond_atom: ...

    @property
    def donor(self) -> h_bond_atom: ...

    @property
    def acceptor(self) -> h_bond_atom: ...

    @property
    def donor_neigh(self) -> h_bond_atom: ...

    @property
    def acceptor_neigh(self) -> h_bond_atom: ...

    @property
    def angle_1(self) -> float: ...

    @property
    def angle_2(self) -> float: ...

    @property
    def angle_3(self) -> float: ...

    @property
    def dist(self) -> float: ...

    @property
    def ligand_atom_is_donor(self) -> bool: ...

    @property
    def hydrogen_is_ligand_atom(self) -> bool: ...

    @property
    def bond_has_hydrogen_flag(self) -> bool: ...

class h_bond_atom:
    @property
    def serial(self) -> int: ...

    @property
    def x(self) -> float: ...

    @property
    def y(self) -> float: ...

    @property
    def z(self) -> float: ...

    @property
    def charge(self) -> float: ...

    @property
    def occ(self) -> float: ...

    @property
    def b_iso(self) -> float: ...

    @property
    def element(self) -> str: ...

    @property
    def name(self) -> str: ...

    @property
    def model(self) -> int: ...

    @property
    def chain(self) -> str: ...

    @property
    def res_no(self) -> int: ...

    @property
    def residue_name(self) -> str: ...

    @property
    def altLoc(self) -> str: ...

class phi_psi_prob_t:
    @property
    def phi_psi(self) -> phi_psi_t: ...

    @property
    def position(self) -> Cartesian: ...

    @property
    def is_allowed_flag(self) -> bool: ...

    def residue_name(self) -> str: ...

    def is_allowed(self) -> bool: ...

class moved_atom_t:
    @overload
    def __init__(self, arg0: str, arg1: str, arg2: float, arg3: float, arg4: float, /) -> None: ...

    @overload
    def __init__(self, arg0: str, arg1: str, arg2: float, arg3: float, arg4: float, arg5: int, /) -> None: ...

    @property
    def atom_name(self) -> str: ...

    @property
    def alt_conf(self) -> str: ...

    @property
    def x(self) -> float: ...

    @property
    def y(self) -> float: ...

    @property
    def z(self) -> float: ...

    @property
    def index(self) -> int: ...

class interesting_place_t:
    @overload
    def __init__(self, arg0: str, arg1: residue_spec_t, arg2: Coord_orth, arg3: str, /) -> None: ...

    @overload
    def __init__(self, arg0: str, arg1: Coord_orth, arg2: str, /) -> None: ...

    @property
    def feature_type(self) -> str: ...

    @property
    def residue_spec(self) -> residue_spec_t: ...

    @property
    def button_label(self) -> str: ...

    @property
    def feature_value(self) -> float: ...

    @property
    def badness(self) -> float: ...

    @property
    def x(self) -> float: ...

    @property
    def y(self) -> float: ...

    @property
    def z(self) -> float: ...

class moved_residue_t:
    def __init__(self, arg0: str, arg1: int, arg2: str, /) -> None: ...

    @property
    def chain_id(self) -> str: ...

    @property
    def res_no(self) -> int: ...

    @property
    def ins_code(self) -> str: ...

    @property
    def moved_atoms(self) -> list[moved_atom_t]: ...

    def add_atom(self, arg: moved_atom_t, /) -> None: ...
