from typing import Optional, Tuple, Iterable

class DPMatrix:
    m: int
    n: int
    def __init__(self, reference: str, query: str): ...
    def set_entry(self, i: int, j: int, cost: int) -> None: ...
    def __str__(self) -> str: ...

class Aligner:
    def __init__(
        self,
        reference: str,
        max_error_rate: float,
        flags: int = 15,
        wildcard_ref: bool = False,
        wildcard_query: bool = False,
        indel_cost: int = 1,
        min_overlap: int = 1,
    ): ...
    def __repr__(self) -> str: ...
    def _set_reference(self, reference: str) -> None: ...
    @property
    def dpmatrix(self) -> DPMatrix: ...
    def scorematrix(self) -> DPMatrix: ...
    def enable_debug(self) -> None: ...
    def locate(self, query: str) -> Optional[Tuple[int, int, int, int, int, int]]: ...

class PrefixComparer:
    @property
    def effective_length(self) -> int: ...
    def __init__(
        self,
        reference: str,
        max_error_rate: float,
        wildcard_ref: bool = False,
        wildcard_query: bool = False,
        min_overlap: int = 1,
    ): ...
    def __repr__(self) -> str: ...
    def locate(self, query: str) -> Optional[Tuple[int, int, int, int, int, int]]: ...

class SuffixComparer(PrefixComparer): ...

def hamming_sphere(s: str, k: int) -> Iterable[str]: ...
def edit_environment(t: str, k: int) -> Iterable[Tuple[str, int, int]]: ...
