from pathlib import Path

import numpy as np

class FqEncoder:
    option: FqEncoderOption
    kmer2id_table: dict[str, int]
    id2kmer_table: dict[int, str]

    def __init__(self, option: FqEncoderOption) -> None: ...

class FqEncoderOption:
    kmer_size: int
    qual_offset: int
    bases: list[int]
    vectorized_target: bool
    max_width: int
    max_seq_len: int

    def __init__(
        self,
        kmer_size: int,
        qual_offset: int,
        bases: list[int],
        vectorized_target: bool,
        max_width: int | None,
        max_seq_len: int | None,
    ) -> None: ...

class RecordData:
    def __init__(self, id: str, seq: str, qual: str) -> None: ...
    def id(self) -> str: ...
    def set_id(self, id: str) -> None: ...
    def seq(self) -> str: ...
    def set_seq(self, seq: str) -> None: ...
    def qual(self) -> str: ...
    def set_qual(self, qual: str) -> None: ...

def seq_to_kmers(seq: str, k: int) -> list[str]: ...
def kmers_to_seq(kmers: list[str]) -> str: ...
def generate_kmers_table(base: str, k: int): ...
def generate_kmers(base: str, k: int) -> list[str]: ...
def to_kmer_target_region(start: int, end: int, k: int, seq_len: int | None) -> tuple[int, int]: ...
def to_original_target_region(start: int, end: int, k: int) -> tuple[int, int]: ...
def kmerids_to_seq(kmer_ids: list[int], id2kmer_table: dict[int, str]) -> str: ...
def write_fq(records_data: list[RecordData], file_path: Path | None): ...
def write_fq_parallel(records_data: list[RecordData], file_path: Path, threads: int): ...
def encode_fq_path(
    fq_path: Path,
    k: int,
    bases: str,
    qual_offset: int,
    vectorized_target: bool,
    max_width: int | None = None,
    max_seq_len: int | None = None,
) -> tuple[np.ndarray, np.ndarray, np.ndarray, dict[str, int]]: ...
def encode_fq_paths(
    fq_paths: list[Path],
    k: int,
    bases: str,
    qual_offset: int,
    vectorized_target: bool,
    parallel_for_files: bool,
    max_width: int | None = None,
    max_seq_len: int | None = None,
) -> tuple[np.ndarray, np.ndarray, np.ndarray, dict[str, int]]: ...
def summary_record_len(path: Path) -> list[int]: ...
