#!/usr/bin/env python3


def genetic_codes(code):
    return {
        "1": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "HTG": "M",
                "WTG": "M",
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTH": "L",
                "CTW": "L",
                "CTC": "L",
                "CTG": "M",
                "CTA": "L",
                "CTM": "L",
                "CTY": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "MTG": "M",
                "YTG": "M",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTG": "M",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "2": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "*",
                "AGG": "*",
                "AGA": "*",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATC": "I",
                "ATR": "M",
                "ATG": "M",
                "ATA": "M",
                "ATY": "I",
                "ATT": "I",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "RTG": "M",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTH": "V",
                "GTW": "V",
                "GTC": "V",
                "GTG": "M",
                "GTA": "V",
                "GTM": "V",
                "GTY": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "*",
                "AGG": "*",
                "AGA": "*",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATB": "M",
                "ATD": "M",
                "ATH": "M",
                "ATK": "M",
                "ATN": "M",
                "ATW": "M",
                "ATC": "M",
                "ATR": "M",
                "ATG": "M",
                "ATA": "M",
                "ATM": "M",
                "ATV": "M",
                "ATY": "M",
                "ATS": "M",
                "ATT": "M",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "3": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "T",
                "CTD": "T",
                "CTH": "T",
                "CTK": "T",
                "CTN": "T",
                "CTW": "T",
                "CTC": "T",
                "CTR": "T",
                "CTG": "T",
                "CTA": "T",
                "CTM": "T",
                "CTV": "T",
                "CTY": "T",
                "CTS": "T",
                "CTT": "T",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATC": "I",
                "ATR": "M",
                "ATG": "M",
                "ATA": "M",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "T",
                "CTD": "T",
                "CTH": "T",
                "CTK": "T",
                "CTN": "T",
                "CTW": "T",
                "CTC": "T",
                "CTR": "T",
                "CTG": "T",
                "CTA": "T",
                "CTM": "T",
                "CTV": "T",
                "CTY": "T",
                "CTS": "T",
                "CTT": "T",
                "RTG": "M",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTH": "V",
                "GTW": "V",
                "GTC": "V",
                "GTG": "M",
                "GTA": "V",
                "GTM": "V",
                "GTY": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATC": "I",
                "ATR": "M",
                "ATG": "M",
                "ATA": "M",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "4": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "BTG": "M",
                "DTG": "M",
                "HTG": "M",
                "KTG": "M",
                "NTG": "M",
                "WTR": "M",
                "WTG": "M",
                "WTA": "M",
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTH": "L",
                "CTW": "L",
                "CTC": "L",
                "CTG": "M",
                "CTA": "L",
                "CTM": "L",
                "CTY": "L",
                "CTT": "L",
                "RTG": "M",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTH": "V",
                "GTW": "V",
                "GTC": "V",
                "GTG": "M",
                "GTA": "V",
                "GTM": "V",
                "GTY": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATB": "M",
                "ATD": "M",
                "ATH": "M",
                "ATK": "M",
                "ATN": "M",
                "ATW": "M",
                "ATC": "M",
                "ATR": "M",
                "ATG": "M",
                "ATA": "M",
                "ATM": "M",
                "ATV": "M",
                "ATY": "M",
                "ATS": "M",
                "ATT": "M",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "MTG": "M",
                "VTG": "M",
                "YTG": "M",
                "STG": "M",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "M",
                "TTG": "M",
                "TTA": "M",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "5": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGB": "S",
                "AGD": "S",
                "AGH": "S",
                "AGK": "S",
                "AGN": "S",
                "AGW": "S",
                "AGC": "S",
                "AGR": "S",
                "AGG": "S",
                "AGA": "S",
                "AGM": "S",
                "AGV": "S",
                "AGY": "S",
                "AGS": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATC": "I",
                "ATR": "M",
                "ATG": "M",
                "ATA": "M",
                "ATY": "I",
                "ATT": "I",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "DTG": "M",
                "KTG": "M",
                "WTG": "M",
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "RTG": "M",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTH": "V",
                "GTW": "V",
                "GTC": "V",
                "GTG": "M",
                "GTA": "V",
                "GTM": "V",
                "GTY": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGB": "S",
                "AGD": "S",
                "AGH": "S",
                "AGK": "S",
                "AGN": "S",
                "AGW": "S",
                "AGC": "S",
                "AGR": "S",
                "AGG": "S",
                "AGA": "S",
                "AGM": "S",
                "AGV": "S",
                "AGY": "S",
                "AGS": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATB": "M",
                "ATD": "M",
                "ATH": "M",
                "ATK": "M",
                "ATN": "M",
                "ATW": "M",
                "ATC": "M",
                "ATR": "M",
                "ATG": "M",
                "ATA": "M",
                "ATM": "M",
                "ATV": "M",
                "ATY": "M",
                "ATS": "M",
                "ATT": "M",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTG": "M",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "6": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YAR": "Q",
                "YAG": "Q",
                "YAA": "Q",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "Q",
                "TAG": "Q",
                "TAA": "Q",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YAR": "Q",
                "YAG": "Q",
                "YAA": "Q",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "Q",
                "TAG": "Q",
                "TAA": "Q",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "9": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGB": "S",
                "AGD": "S",
                "AGH": "S",
                "AGK": "S",
                "AGN": "S",
                "AGW": "S",
                "AGC": "S",
                "AGR": "S",
                "AGG": "S",
                "AGA": "S",
                "AGM": "S",
                "AGV": "S",
                "AGY": "S",
                "AGS": "S",
                "AGT": "S",
                "AAH": "N",
                "AAW": "N",
                "AAC": "N",
                "AAG": "K",
                "AAA": "N",
                "AAM": "N",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "RTG": "M",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTH": "V",
                "GTW": "V",
                "GTC": "V",
                "GTG": "M",
                "GTA": "V",
                "GTM": "V",
                "GTY": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGB": "S",
                "AGD": "S",
                "AGH": "S",
                "AGK": "S",
                "AGN": "S",
                "AGW": "S",
                "AGC": "S",
                "AGR": "S",
                "AGG": "S",
                "AGA": "S",
                "AGM": "S",
                "AGV": "S",
                "AGY": "S",
                "AGS": "S",
                "AGT": "S",
                "AAH": "N",
                "AAW": "N",
                "AAC": "N",
                "AAG": "K",
                "AAA": "N",
                "AAM": "N",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "10": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGH": "C",
                "TGW": "C",
                "TGC": "C",
                "TGG": "W",
                "TGA": "C",
                "TGM": "C",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGH": "C",
                "TGW": "C",
                "TGC": "C",
                "TGG": "W",
                "TGA": "C",
                "TGM": "C",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "11": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "BTG": "M",
                "DTG": "M",
                "HTG": "M",
                "KTG": "M",
                "NTG": "M",
                "WTG": "M",
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTH": "L",
                "CTW": "L",
                "CTC": "L",
                "CTG": "M",
                "CTA": "L",
                "CTM": "L",
                "CTY": "L",
                "CTT": "L",
                "RTG": "M",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTH": "V",
                "GTW": "V",
                "GTC": "V",
                "GTG": "M",
                "GTA": "V",
                "GTM": "V",
                "GTY": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATB": "M",
                "ATD": "M",
                "ATH": "M",
                "ATK": "M",
                "ATN": "M",
                "ATW": "M",
                "ATC": "M",
                "ATR": "M",
                "ATG": "M",
                "ATA": "M",
                "ATM": "M",
                "ATV": "M",
                "ATY": "M",
                "ATS": "M",
                "ATT": "M",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "MTG": "M",
                "VTG": "M",
                "YTG": "M",
                "YTA": "L",
                "STG": "M",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTG": "M",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "12": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTH": "L",
                "CTW": "L",
                "CTC": "L",
                "CTG": "S",
                "CTA": "L",
                "CTM": "L",
                "CTY": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTH": "L",
                "CTW": "L",
                "CTC": "L",
                "CTG": "M",
                "CTA": "L",
                "CTM": "L",
                "CTY": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "MTG": "M",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "13": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "RGR": "G",
                "RGG": "G",
                "RGA": "G",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "G",
                "AGG": "G",
                "AGA": "G",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATC": "I",
                "ATR": "M",
                "ATG": "M",
                "ATA": "M",
                "ATY": "I",
                "ATT": "I",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "DTG": "M",
                "KTG": "M",
                "WTG": "M",
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "RGR": "G",
                "RGG": "G",
                "RGA": "G",
                "RTG": "M",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTH": "V",
                "GTW": "V",
                "GTC": "V",
                "GTG": "M",
                "GTA": "V",
                "GTM": "V",
                "GTY": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "G",
                "AGG": "G",
                "AGA": "G",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATC": "I",
                "ATR": "M",
                "ATG": "M",
                "ATA": "M",
                "ATY": "I",
                "ATT": "I",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTG": "M",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "14": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGB": "S",
                "AGD": "S",
                "AGH": "S",
                "AGK": "S",
                "AGN": "S",
                "AGW": "S",
                "AGC": "S",
                "AGR": "S",
                "AGG": "S",
                "AGA": "S",
                "AGM": "S",
                "AGV": "S",
                "AGY": "S",
                "AGS": "S",
                "AGT": "S",
                "AAH": "N",
                "AAW": "N",
                "AAC": "N",
                "AAG": "K",
                "AAA": "N",
                "AAM": "N",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAH": "Y",
                "TAW": "Y",
                "TAC": "Y",
                "TAG": "*",
                "TAA": "Y",
                "TAM": "Y",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGB": "S",
                "AGD": "S",
                "AGH": "S",
                "AGK": "S",
                "AGN": "S",
                "AGW": "S",
                "AGC": "S",
                "AGR": "S",
                "AGG": "S",
                "AGA": "S",
                "AGM": "S",
                "AGV": "S",
                "AGY": "S",
                "AGS": "S",
                "AGT": "S",
                "AAH": "N",
                "AAW": "N",
                "AAC": "N",
                "AAG": "K",
                "AAA": "N",
                "AAM": "N",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAH": "Y",
                "TAW": "Y",
                "TAC": "Y",
                "TAG": "*",
                "TAA": "Y",
                "TAM": "Y",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "15": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YAG": "Q",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAG": "Q",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YAG": "Q",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAG": "Q",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "16": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TWG": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAG": "L",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TWG": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAG": "L",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "21": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGB": "S",
                "AGD": "S",
                "AGH": "S",
                "AGK": "S",
                "AGN": "S",
                "AGW": "S",
                "AGC": "S",
                "AGR": "S",
                "AGG": "S",
                "AGA": "S",
                "AGM": "S",
                "AGV": "S",
                "AGY": "S",
                "AGS": "S",
                "AGT": "S",
                "AAH": "N",
                "AAW": "N",
                "AAC": "N",
                "AAG": "K",
                "AAA": "N",
                "AAM": "N",
                "AAY": "N",
                "AAT": "N",
                "ATC": "I",
                "ATR": "M",
                "ATG": "M",
                "ATA": "M",
                "ATY": "I",
                "ATT": "I",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "RTG": "M",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTH": "V",
                "GTW": "V",
                "GTC": "V",
                "GTG": "M",
                "GTA": "V",
                "GTM": "V",
                "GTY": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGB": "S",
                "AGD": "S",
                "AGH": "S",
                "AGK": "S",
                "AGN": "S",
                "AGW": "S",
                "AGC": "S",
                "AGR": "S",
                "AGG": "S",
                "AGA": "S",
                "AGM": "S",
                "AGV": "S",
                "AGY": "S",
                "AGS": "S",
                "AGT": "S",
                "AAH": "N",
                "AAW": "N",
                "AAC": "N",
                "AAG": "K",
                "AAA": "N",
                "AAM": "N",
                "AAY": "N",
                "AAT": "N",
                "ATC": "I",
                "ATR": "M",
                "ATG": "M",
                "ATA": "M",
                "ATY": "I",
                "ATT": "I",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "22": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TWG": "L",
                "TCB": "S",
                "TCK": "S",
                "TCC": "S",
                "TCG": "S",
                "TCA": "*",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAG": "L",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TMA": "*",
                "TVA": "*",
                "TSA": "*",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TWG": "L",
                "TCB": "S",
                "TCK": "S",
                "TCC": "S",
                "TCG": "S",
                "TCA": "*",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAG": "L",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TMA": "*",
                "TVA": "*",
                "TSA": "*",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "23": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTG": "L",
                "TDA": "*",
                "TKA": "*",
                "TWA": "*",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTG": "L",
                "TTA": "*",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "RTG": "M",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTH": "V",
                "GTW": "V",
                "GTC": "V",
                "GTG": "M",
                "GTA": "V",
                "GTM": "V",
                "GTY": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATK": "M",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATT": "M",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTG": "L",
                "TDA": "*",
                "TKA": "*",
                "TWA": "*",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTG": "L",
                "TTA": "*",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "24": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "ARG": "K",
                "AGH": "S",
                "AGW": "S",
                "AGC": "S",
                "AGG": "K",
                "AGA": "S",
                "AGM": "S",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "BTG": "M",
                "DTG": "M",
                "HTG": "M",
                "KTG": "M",
                "NTG": "M",
                "WTG": "M",
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTH": "L",
                "CTW": "L",
                "CTC": "L",
                "CTG": "M",
                "CTA": "L",
                "CTM": "L",
                "CTY": "L",
                "CTT": "L",
                "RTG": "M",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTH": "V",
                "GTW": "V",
                "GTC": "V",
                "GTG": "M",
                "GTA": "V",
                "GTM": "V",
                "GTY": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "ARG": "K",
                "AGH": "S",
                "AGW": "S",
                "AGC": "S",
                "AGG": "K",
                "AGA": "S",
                "AGM": "S",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MTG": "M",
                "VTG": "M",
                "YTG": "M",
                "YTA": "L",
                "STG": "M",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTG": "M",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "25": {
            "trans_table": {
                "KGA": "G",
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGG": "W",
                "TGA": "G",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "DTG": "M",
                "KGA": "G",
                "KTG": "M",
                "WTG": "M",
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "RTG": "M",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTH": "V",
                "GTW": "V",
                "GTC": "V",
                "GTG": "M",
                "GTA": "V",
                "GTM": "V",
                "GTY": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGG": "W",
                "TGA": "G",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTG": "M",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "26": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTH": "L",
                "CTW": "L",
                "CTC": "L",
                "CTG": "A",
                "CTA": "L",
                "CTM": "L",
                "CTY": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTH": "L",
                "CTW": "L",
                "CTC": "L",
                "CTG": "M",
                "CTA": "L",
                "CTM": "L",
                "CTY": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "MTG": "M",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "27": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YAR": "Q",
                "YAG": "Q",
                "YAA": "Q",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "Q",
                "TAG": "Q",
                "TAA": "Q",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YAR": "Q",
                "YAG": "Q",
                "YAA": "Q",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "Q",
                "TAG": "Q",
                "TAA": "Q",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "28": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YAR": "Q",
                "YAG": "Q",
                "YAA": "Q",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "Q",
                "TAG": "Q",
                "TAA": "Q",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TRA": "*",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "29": {
            "trans_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAB": "Y",
                "TAD": "Y",
                "TAH": "Y",
                "TAK": "Y",
                "TAN": "Y",
                "TAW": "Y",
                "TAC": "Y",
                "TAR": "Y",
                "TAG": "Y",
                "TAA": "Y",
                "TAM": "Y",
                "TAV": "Y",
                "TAY": "Y",
                "TAS": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAB": "Y",
                "TAD": "Y",
                "TAH": "Y",
                "TAK": "Y",
                "TAN": "Y",
                "TAW": "Y",
                "TAC": "Y",
                "TAR": "Y",
                "TAG": "Y",
                "TAA": "Y",
                "TAM": "Y",
                "TAV": "Y",
                "TAY": "Y",
                "TAS": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "30": {
            "trans_table": {
                "KAR": "E",
                "KAG": "E",
                "KAA": "E",
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "E",
                "TAG": "E",
                "TAA": "E",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "KAR": "E",
                "KAG": "E",
                "KAA": "E",
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGG": "W",
                "TGA": "*",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "E",
                "TAG": "E",
                "TAA": "E",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
        "31": {
            "trans_table": {
                "KAR": "E",
                "KAG": "E",
                "KAA": "E",
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "E",
                "TAG": "E",
                "TAA": "E",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
            "start_table": {
                "CCB": "P",
                "CCD": "P",
                "CCH": "P",
                "CCK": "P",
                "CCN": "P",
                "CCW": "P",
                "CCC": "P",
                "CCR": "P",
                "CCG": "P",
                "CCA": "P",
                "CCM": "P",
                "CCV": "P",
                "CCY": "P",
                "CCS": "P",
                "CCT": "P",
                "CGB": "R",
                "CGD": "R",
                "CGH": "R",
                "CGK": "R",
                "CGN": "R",
                "CGW": "R",
                "CGC": "R",
                "CGR": "R",
                "CGG": "R",
                "CGA": "R",
                "CGM": "R",
                "CGV": "R",
                "CGY": "R",
                "CGS": "R",
                "CGT": "R",
                "CAC": "H",
                "CAR": "Q",
                "CAG": "Q",
                "CAA": "Q",
                "CAY": "H",
                "CAT": "H",
                "CTB": "L",
                "CTD": "L",
                "CTH": "L",
                "CTK": "L",
                "CTN": "L",
                "CTW": "L",
                "CTC": "L",
                "CTR": "L",
                "CTG": "L",
                "CTA": "L",
                "CTM": "L",
                "CTV": "L",
                "CTY": "L",
                "CTS": "L",
                "CTT": "L",
                "GCB": "A",
                "GCD": "A",
                "GCH": "A",
                "GCK": "A",
                "GCN": "A",
                "GCW": "A",
                "GCC": "A",
                "GCR": "A",
                "GCG": "A",
                "GCA": "A",
                "GCM": "A",
                "GCV": "A",
                "GCY": "A",
                "GCS": "A",
                "GCT": "A",
                "GGB": "G",
                "GGD": "G",
                "GGH": "G",
                "GGK": "G",
                "GGN": "G",
                "GGW": "G",
                "GGC": "G",
                "GGR": "G",
                "GGG": "G",
                "GGA": "G",
                "GGM": "G",
                "GGV": "G",
                "GGY": "G",
                "GGS": "G",
                "GGT": "G",
                "GAC": "D",
                "GAR": "E",
                "GAG": "E",
                "GAA": "E",
                "GAY": "D",
                "GAT": "D",
                "GTB": "V",
                "GTD": "V",
                "GTH": "V",
                "GTK": "V",
                "GTN": "V",
                "GTW": "V",
                "GTC": "V",
                "GTR": "V",
                "GTG": "V",
                "GTA": "V",
                "GTM": "V",
                "GTV": "V",
                "GTY": "V",
                "GTS": "V",
                "GTT": "V",
                "ACB": "T",
                "ACD": "T",
                "ACH": "T",
                "ACK": "T",
                "ACN": "T",
                "ACW": "T",
                "ACC": "T",
                "ACR": "T",
                "ACG": "T",
                "ACA": "T",
                "ACM": "T",
                "ACV": "T",
                "ACY": "T",
                "ACS": "T",
                "ACT": "T",
                "AGC": "S",
                "AGR": "R",
                "AGG": "R",
                "AGA": "R",
                "AGY": "S",
                "AGT": "S",
                "AAC": "N",
                "AAR": "K",
                "AAG": "K",
                "AAA": "K",
                "AAY": "N",
                "AAT": "N",
                "ATH": "I",
                "ATW": "I",
                "ATC": "I",
                "ATG": "M",
                "ATA": "I",
                "ATM": "I",
                "ATY": "I",
                "ATT": "I",
                "MGR": "R",
                "MGG": "R",
                "MGA": "R",
                "YTR": "L",
                "YTG": "L",
                "YTA": "L",
                "TCB": "S",
                "TCD": "S",
                "TCH": "S",
                "TCK": "S",
                "TCN": "S",
                "TCW": "S",
                "TCC": "S",
                "TCR": "S",
                "TCG": "S",
                "TCA": "S",
                "TCM": "S",
                "TCV": "S",
                "TCY": "S",
                "TCS": "S",
                "TCT": "S",
                "TGC": "C",
                "TGR": "W",
                "TGG": "W",
                "TGA": "W",
                "TGY": "C",
                "TGT": "C",
                "TAC": "Y",
                "TAR": "*",
                "TAG": "*",
                "TAA": "*",
                "TAY": "Y",
                "TAT": "Y",
                "TTC": "F",
                "TTR": "L",
                "TTG": "L",
                "TTA": "L",
                "TTY": "F",
                "TTT": "F",
            },
        },
    }[code]
