"""
docs/conf
~~~~~~~~~
"""

# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html
# Note this is based off the pyopenms-docs conf.py for consistency

import os
import sys
from importlib.metadata import version as get_version
from pathlib import Path
from datetime import datetime

# -- Path Setup --------------------------------------------------------------
sys.path.insert(0, os.path.abspath(os.path.join("../pyprophet/")))
sys.path.insert(0, os.path.abspath(os.path.join("../../pyprophet/")))


import logging

logging.basicConfig(level=logging.INFO)  # Set up basic logging
logging.debug("PYTHON PATH: %s", sys.path)
logging.debug("Working Directory: %s", os.getcwd())


def find_git_directory(start_path):
    """Find the full path to the nearest '.git' directory by climbing up the directory tree.

    Args:
        start_path (str or Path, optional): The starting path for the search. If not provided,
            the current working directory is used.

    Returns:
        Path or None: The full path to the '.git' directory if found, or None if not found.
    """
    # If start_path is not provided, use the current working directory
    start_path = Path(start_path)
    # Iterate through parent directories until .git is found
    current_path = start_path
    while current_path:
        git_path = current_path / ".git"
        if git_path.is_dir():
            return git_path.resolve()
        current_path = current_path.parent

    # If .git is not found in any parent directory, return None
    return None


# -- Project Information -----------------------------------------------------
project = "PyProphet"
copyright = f"{datetime.now().year}, PyProphet Team"
author = "PyProphet Team"
release = get_version("pyprophet")
version = ".".join(release.split(".")[:2])

# if the variable is not set (e.g., when building locally and not on RTD)
rtd_branch = os.environ.get("READTHEDOCS_GIT_IDENTIFIER", "")
if not rtd_branch:
    release += "local"

# if not built from release branch or tag
elif not rtd_branch.startswith("release") and not rtd_branch.startswith("Release"):
    release += "dev"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# -- General Configuration ---------------------------------------------------
extensions = [
    "sphinx.ext.autodoc",  # Core Sphinx doc generator
    "sphinx.ext.autosectionlabel",
    "sphinx.ext.viewcode",  # Add links to source code
    "sphinx.ext.napoleon",  # Support Google/Numpy docstrings
    "sphinx.ext.autosummary",  # Generate autodoc summaries
    "sphinx.ext.githubpages",
    "sphinx_rtd_theme",  # ReadTheDocs theme
    "sphinx_copybutton",
    "sphinx_click",
]

# # Napoleon settings for docstring parsing
# napoleon_google_docstring = True
# napoleon_include_init_with_doc = True

# # Autodoc configuration
# autodoc_default_options = {
#     "members": True,
#     "member-order": "bysource",
#     "special-members": "__init__",
#     "undoc-members": True,
#     "exclude-members": "__weakref__",
#     "show-inheritance": True,
# }
# autodoc_mock_imports = ["numpy", "pandas", "scipy"]  # Mock heavy dependencies

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = [
    "_build",
    "Thumbs.db",
    ".DS_Store",
    "build",
    "tests",
    "README.md",
    ".egg-info",
]

autosummary_generate = True

autosectionlabel_prefix_document = True

# -- HTML Output -------------------------------------------------------------
html_theme = "sphinx_rtd_theme"
html_static_path = ["_static"]
# html_logo = "_static/logo.png"  # Optional
# html_favicon = "_static/favicon.ico"  # Optional


templates_path = ["templates"]


# -- Extension Settings ------------------------------------------------------
def setup(app):
    app.add_css_file("custom.css")
