# generated by datamodel-codegen:
#   filename:  https://opensource.ieee.org/2791-object/ieee-2791-schema/-/raw/master/parametric_domain.json
#   timestamp: 2022-09-13T23:51:53+00:00

from __future__ import annotations

from typing import List

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    RootModel,
)


class ParametricDomainItem(BaseModel):
    model_config = ConfigDict(extra="forbid")

    param: str = Field(
        ..., description="Specific variables for the computational workflow", examples=["seed"], title="param"
    )
    value: str = Field(
        ...,
        description="Specific (non-default) parameter values for the computational workflow",
        examples=["14"],
        title="value",
    )
    step: str = Field(
        ...,
        description="Refers to the specific step of the workflow relevant to the parameters specified in 'param' and 'value'",
        examples=["1"],
        pattern="^(.*)$",
        title="step",
    )


class ParametricDomain(RootModel):
    root: List[ParametricDomainItem] = Field(
        ...,
        description="This represents the list of NON-default parameters customizing the computational flow which can affect the output of the calculations. These fields can be custom to each kind of analysis and are tied to a particular pipeline implementation",
        title="Parametric Domain",
    )
