# coding: utf-8

# flake8: noqa

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "v18.13.0"

# Define package exports
__all__ = [
    "BioSampleApi",
    "GeneApi",
    "GenomeApi",
    "OrganelleApi",
    "ProkaryoteApi",
    "TaxonomyApi",
    "VersionApi",
    "VirusApi",
    "ApiResponse",
    "ApiClient",
    "Configuration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "Ncbiprotddv2ChainFootprint",
    "Ncbiprotddv2QueryStructureDefinition",
    "Ncbiprotddv2RedundancyLevel",
    "Ncbiprotddv2SdidRequest",
    "Ncbiprotddv2SimilarStructureReport",
    "Ncbiprotddv2SimilarStructureReportPage",
    "Ncbiprotddv2SimilarStructureRequest",
    "Ncbiprotddv2SortById",
    "Ncbiprotddv2StructureDataReport",
    "Ncbiprotddv2StructureDataReportBiounitChain",
    "Ncbiprotddv2StructureDataReportExperiment",
    "Ncbiprotddv2StructureDataReportKind",
    "Ncbiprotddv2StructureDataReportLigandChain",
    "Ncbiprotddv2StructureRequest",
    "Ncbiprotddv2VastScore",
    "ProtobufAny",
    "RpcStatus",
    "V2Accessions",
    "V2AnnotationForAssemblyType",
    "V2AnnotationForOrganelleType",
    "V2AssemblyAccessions",
    "V2AssemblyCheckMHistogramReply",
    "V2AssemblyCheckMHistogramReplyHistogramInterval",
    "V2AssemblyCheckMHistogramRequest",
    "V2AssemblyDataReportDraftRequest",
    "V2AssemblyDatasetAvailability",
    "V2AssemblyDatasetDescriptorsFilter",
    "V2AssemblyDatasetDescriptorsFilterAssemblySource",
    "V2AssemblyDatasetDescriptorsFilterAssemblyVersion",
    "V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter",
    "V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory",
    "V2AssemblyDatasetReportsRequest",
    "V2AssemblyDatasetReportsRequestContentType",
    "V2AssemblyDatasetRequest",
    "V2AssemblyDatasetRequestResolution",
    "V2AssemblyLinksReply",
    "V2AssemblyLinksReplyAssemblyLink",
    "V2AssemblyLinksReplyAssemblyLinkType",
    "V2AssemblyLinksRequest",
    "V2AssemblyRevisionHistory",
    "V2AssemblyRevisionHistoryRequest",
    "V2AssemblySequenceReportsRequest",
    "V2BioSampleDatasetReportsRequest",
    "V2CatalogApiVersion",
    "V2DatasetRequest",
    "V2DownloadSummary",
    "V2DownloadSummaryAvailableFiles",
    "V2DownloadSummaryDehydrated",
    "V2DownloadSummaryFileSummary",
    "V2DownloadSummaryHydrated",
    "V2ElementFlankConfig",
    "V2Fasta",
    "V2FileFileType",
    "V2GeneChromosomeSummaryReply",
    "V2GeneChromosomeSummaryReplyGeneChromosomeSummary",
    "V2GeneChromosomeSummaryRequest",
    "V2GeneCountsByTaxonReply",
    "V2GeneCountsByTaxonReplyGeneTypeAndCount",
    "V2GeneCountsByTaxonRequest",
    "V2GeneDatasetReportsRequest",
    "V2GeneDatasetReportsRequestContentType",
    "V2GeneDatasetReportsRequestSymbolsForTaxon",
    "V2GeneDatasetRequest",
    "V2GeneDatasetRequestContentType",
    "V2GeneDatasetRequestGeneDatasetReportType",
    "V2GeneLinksReply",
    "V2GeneLinksReplyGeneLink",
    "V2GeneLinksReplyGeneLinkType",
    "V2GeneLinksRequest",
    "V2GenePubmedIdsRequest",
    "V2GenePubmedIdsResponse",
    "V2GeneType",
    "V2GenomeAnnotationRequest",
    "V2GenomeAnnotationRequestAnnotationType",
    "V2GenomeAnnotationRequestGenomeAnnotationTableFormat",
    "V2GenomeAnnotationTableSummaryReply",
    "V2HttpBody",
    "V2ImageSize",
    "V2IncludeTabularHeader",
    "V2MicroBiggeDatasetRequest",
    "V2MicroBiggeDatasetRequestFileType",
    "V2MolType",
    "V2OrganelleDownloadRequest",
    "V2OrganelleMetadataRequest",
    "V2OrganelleMetadataRequestContentType",
    "V2OrganelleMetadataRequestOrganelleTableFormat",
    "V2OrganelleSort",
    "V2OrganismQueryRequest",
    "V2OrganismQueryRequestTaxRankFilter",
    "V2OrganismQueryRequestTaxonResourceFilter",
    "V2OrthologRequest",
    "V2OrthologRequestContentType",
    "V2ProkaryoteGeneRequest",
    "V2ProkaryoteGeneRequestGeneFlankConfig",
    "V2RefGeneCatalogDatasetRequest",
    "V2RefGeneCatalogDatasetRequestFileType",
    "V2Sars2ProteinDatasetRequest",
    "V2SciNameAndIds",
    "V2SciNameAndIdsSciNameAndId",
    "V2SeqRange",
    "V2SeqReply",
    "V2SequenceAccessionRequest",
    "V2SequenceReportPage",
    "V2SleepReply",
    "V2SleepRequest",
    "V2SortDirection",
    "V2SortField",
    "V2TableFormat",
    "V2TabularOutput",
    "V2TaxonomyDatasetRequest",
    "V2TaxonomyDatasetRequestTaxonomyReportType",
    "V2TaxonomyFilteredSubtreeRequest",
    "V2TaxonomyFilteredSubtreeResponse",
    "V2TaxonomyFilteredSubtreeResponseEdge",
    "V2TaxonomyFilteredSubtreeResponseEdgeChildStatus",
    "V2TaxonomyFilteredSubtreeResponseEdgesEntry",
    "V2TaxonomyImageMetadataRequest",
    "V2TaxonomyImageMetadataResponse",
    "V2TaxonomyImageRequest",
    "V2TaxonomyLinksRequest",
    "V2TaxonomyLinksResponse",
    "V2TaxonomyLinksResponseGenericLink",
    "V2TaxonomyMatch",
    "V2TaxonomyMetadataRequest",
    "V2TaxonomyMetadataRequestContentType",
    "V2TaxonomyMetadataRequestTableFormat",
    "V2TaxonomyMetadataResponse",
    "V2TaxonomyNode",
    "V2TaxonomyNodeCountByType",
    "V2TaxonomyRelatedIdRequest",
    "V2TaxonomyTaxIdsPage",
    "V2VersionReply",
    "V2ViralSequenceType",
    "V2VirusAnnotationFilter",
    "V2VirusAnnotationReportRequest",
    "V2VirusAvailability",
    "V2VirusAvailabilityRequest",
    "V2VirusDataReportRequest",
    "V2VirusDataReportRequestContentType",
    "V2VirusDatasetFilter",
    "V2VirusDatasetReportType",
    "V2VirusDatasetRequest",
    "V2VirusTableField",
    "V2archiveAffiliation",
    "V2archiveCatalog",
    "V2archiveLocation",
    "V2archiveModifier",
    "V2archiveMoleculeType",
    "V2archiveName",
    "V2archiveNuccoreRequest",
    "V2archiveSequence",
    "V2archiveSequenceLengthUnits",
    "V2archiveSubmitter",
    "V2archiveTaxonomyNode",
    "V2archiveTaxonomySubtype",
    "V2reportsANIMatch",
    "V2reportsANITypeCategory",
    "V2reportsAdditionalSubmitter",
    "V2reportsAnnotation",
    "V2reportsAnnotationInfo",
    "V2reportsAssemblyDataReport",
    "V2reportsAssemblyDataReportPage",
    "V2reportsAssemblyInfo",
    "V2reportsAssemblyLevel",
    "V2reportsAssemblyRevision",
    "V2reportsAssemblyStats",
    "V2reportsAssemblyStatus",
    "V2reportsAtypicalInfo",
    "V2reportsAverageNucleotideIdentity",
    "V2reportsAverageNucleotideIdentityMatchStatus",
    "V2reportsAverageNucleotideIdentityTaxonomyCheckStatus",
    "V2reportsBioProject",
    "V2reportsBioProjectLineage",
    "V2reportsBioSampleAttribute",
    "V2reportsBioSampleContact",
    "V2reportsBioSampleDataReport",
    "V2reportsBioSampleDataReportPage",
    "V2reportsBioSampleDescription",
    "V2reportsBioSampleDescriptor",
    "V2reportsBioSampleId",
    "V2reportsBioSampleOwner",
    "V2reportsBioSampleStatus",
    "V2reportsBuscoStat",
    "V2reportsCheckM",
    "V2reportsClassification",
    "V2reportsCollectionType",
    "V2reportsConservedDomain",
    "V2reportsContentType",
    "V2reportsCountType",
    "V2reportsError",
    "V2reportsErrorAssemblyErrorCode",
    "V2reportsErrorGeneErrorCode",
    "V2reportsErrorOrganelleErrorCode",
    "V2reportsErrorTaxonomyErrorCode",
    "V2reportsErrorVirusErrorCode",
    "V2reportsFeatureCounts",
    "V2reportsFunctionalSite",
    "V2reportsGeneCounts",
    "V2reportsGeneDataReportPage",
    "V2reportsGeneDescriptor",
    "V2reportsGeneGroup",
    "V2reportsGeneOntology",
    "V2reportsGeneReportMatch",
    "V2reportsGeneSummary",
    "V2reportsGeneType",
    "V2reportsGenomeAnnotation",
    "V2reportsGenomeAnnotationReportMatch",
    "V2reportsGenomeAnnotationReportPage",
    "V2reportsGenomicLocation",
    "V2reportsGenomicRegion",
    "V2reportsGenomicRegionGenomicRegionType",
    "V2reportsInfraspecificNames",
    "V2reportsIsolate",
    "V2reportsLineageOrganism",
    "V2reportsLinkedAssembly",
    "V2reportsLinkedAssemblyType",
    "V2reportsMaturePeptide",
    "V2reportsMessage",
    "V2reportsNameAndAuthority",
    "V2reportsNameAndAuthorityNote",
    "V2reportsNameAndAuthorityNoteClassifier",
    "V2reportsNameAndAuthorityPublication",
    "V2reportsNomenclatureAuthority",
    "V2reportsOrganelle",
    "V2reportsOrganelleBiosample",
    "V2reportsOrganelleDataReports",
    "V2reportsOrganelleGeneCounts",
    "V2reportsOrganelleInfo",
    "V2reportsOrganelleTopology",
    "V2reportsOrganelleType",
    "V2reportsOrganism",
    "V2reportsOrientation",
    "V2reportsPairedAssembly",
    "V2reportsProcessMetadata",
    "V2reportsProductDescriptor",
    "V2reportsProkaryoteGeneLocationCompleteness",
    "V2reportsProtein",
    "V2reportsProteinConservedDomain",
    "V2reportsProteinDataReport",
    "V2reportsProteinDataReportPage",
    "V2reportsProteinFamily",
    "V2reportsPurposeOfSampling",
    "V2reportsRange",
    "V2reportsRankType",
    "V2reportsReference",
    "V2reportsRnaType",
    "V2reportsSeqRangeSet",
    "V2reportsSeqRangeSetFasta",
    "V2reportsSequenceInfo",
    "V2reportsSequenceInformation",
    "V2reportsSourceDatabase",
    "V2reportsTaxData",
    "V2reportsTaxonomyDataReportPage",
    "V2reportsTaxonomyNamesDataReportPage",
    "V2reportsTaxonomyNamesDescriptor",
    "V2reportsTaxonomyNamesDescriptorCitation",
    "V2reportsTaxonomyNamesReportMatch",
    "V2reportsTaxonomyNode",
    "V2reportsTaxonomyNodeCountByType",
    "V2reportsTaxonomyReportMatch",
    "V2reportsTaxonomyTypeMaterial",
    "V2reportsTranscript",
    "V2reportsTranscriptSelectCategory",
    "V2reportsTranscriptTranscriptType",
    "V2reportsTranscriptTypeCount",
    "V2reportsTypeMaterial",
    "V2reportsVirusAnnotationReport",
    "V2reportsVirusAnnotationReportPage",
    "V2reportsVirusAssembly",
    "V2reportsVirusAssemblyCollectionLocation",
    "V2reportsVirusAssemblyCompleteness",
    "V2reportsVirusAssemblySubmitterInfo",
    "V2reportsVirusDataReportPage",
    "V2reportsVirusGene",
    "V2reportsVirusPeptide",
    "V2reportsVirusPeptideUniProtId",
    "V2reportsVirusPeptideViralPeptideCompleteness",
    "V2reportsWGSInfo",
    "V2reportsWarning",
    "V2reportsWarningGeneWarningCode",
    "V2reportsWarningReplacedId",
]

# import apis into sdk package
from ncbi.datasets.openapi.api.bio_sample_api import BioSampleApi as BioSampleApi
from ncbi.datasets.openapi.api.gene_api import GeneApi as GeneApi
from ncbi.datasets.openapi.api.genome_api import GenomeApi as GenomeApi
from ncbi.datasets.openapi.api.organelle_api import OrganelleApi as OrganelleApi
from ncbi.datasets.openapi.api.prokaryote_api import ProkaryoteApi as ProkaryoteApi
from ncbi.datasets.openapi.api.taxonomy_api import TaxonomyApi as TaxonomyApi
from ncbi.datasets.openapi.api.version_api import VersionApi as VersionApi
from ncbi.datasets.openapi.api.virus_api import VirusApi as VirusApi

# import ApiClient
from ncbi.datasets.openapi.api_response import ApiResponse as ApiResponse
from ncbi.datasets.openapi.api_client import ApiClient as ApiClient
from ncbi.datasets.openapi.configuration import Configuration as Configuration
from ncbi.datasets.openapi.exceptions import OpenApiException as OpenApiException
from ncbi.datasets.openapi.exceptions import ApiTypeError as ApiTypeError
from ncbi.datasets.openapi.exceptions import ApiValueError as ApiValueError
from ncbi.datasets.openapi.exceptions import ApiKeyError as ApiKeyError
from ncbi.datasets.openapi.exceptions import ApiAttributeError as ApiAttributeError
from ncbi.datasets.openapi.exceptions import ApiException as ApiException

# import models into sdk package
from ncbi.datasets.openapi.models.ncbiprotddv2_chain_footprint import Ncbiprotddv2ChainFootprint as Ncbiprotddv2ChainFootprint
from ncbi.datasets.openapi.models.ncbiprotddv2_query_structure_definition import Ncbiprotddv2QueryStructureDefinition as Ncbiprotddv2QueryStructureDefinition
from ncbi.datasets.openapi.models.ncbiprotddv2_redundancy_level import Ncbiprotddv2RedundancyLevel as Ncbiprotddv2RedundancyLevel
from ncbi.datasets.openapi.models.ncbiprotddv2_sdid_request import Ncbiprotddv2SdidRequest as Ncbiprotddv2SdidRequest
from ncbi.datasets.openapi.models.ncbiprotddv2_similar_structure_report import Ncbiprotddv2SimilarStructureReport as Ncbiprotddv2SimilarStructureReport
from ncbi.datasets.openapi.models.ncbiprotddv2_similar_structure_report_page import Ncbiprotddv2SimilarStructureReportPage as Ncbiprotddv2SimilarStructureReportPage
from ncbi.datasets.openapi.models.ncbiprotddv2_similar_structure_request import Ncbiprotddv2SimilarStructureRequest as Ncbiprotddv2SimilarStructureRequest
from ncbi.datasets.openapi.models.ncbiprotddv2_sort_by_id import Ncbiprotddv2SortById as Ncbiprotddv2SortById
from ncbi.datasets.openapi.models.ncbiprotddv2_structure_data_report import Ncbiprotddv2StructureDataReport as Ncbiprotddv2StructureDataReport
from ncbi.datasets.openapi.models.ncbiprotddv2_structure_data_report_biounit_chain import Ncbiprotddv2StructureDataReportBiounitChain as Ncbiprotddv2StructureDataReportBiounitChain
from ncbi.datasets.openapi.models.ncbiprotddv2_structure_data_report_experiment import Ncbiprotddv2StructureDataReportExperiment as Ncbiprotddv2StructureDataReportExperiment
from ncbi.datasets.openapi.models.ncbiprotddv2_structure_data_report_kind import Ncbiprotddv2StructureDataReportKind as Ncbiprotddv2StructureDataReportKind
from ncbi.datasets.openapi.models.ncbiprotddv2_structure_data_report_ligand_chain import Ncbiprotddv2StructureDataReportLigandChain as Ncbiprotddv2StructureDataReportLigandChain
from ncbi.datasets.openapi.models.ncbiprotddv2_structure_request import Ncbiprotddv2StructureRequest as Ncbiprotddv2StructureRequest
from ncbi.datasets.openapi.models.ncbiprotddv2_vast_score import Ncbiprotddv2VastScore as Ncbiprotddv2VastScore
from ncbi.datasets.openapi.models.protobuf_any import ProtobufAny as ProtobufAny
from ncbi.datasets.openapi.models.rpc_status import RpcStatus as RpcStatus
from ncbi.datasets.openapi.models.v2_accessions import V2Accessions as V2Accessions
from ncbi.datasets.openapi.models.v2_annotation_for_assembly_type import V2AnnotationForAssemblyType as V2AnnotationForAssemblyType
from ncbi.datasets.openapi.models.v2_annotation_for_organelle_type import V2AnnotationForOrganelleType as V2AnnotationForOrganelleType
from ncbi.datasets.openapi.models.v2_assembly_accessions import V2AssemblyAccessions as V2AssemblyAccessions
from ncbi.datasets.openapi.models.v2_assembly_check_m_histogram_reply import V2AssemblyCheckMHistogramReply as V2AssemblyCheckMHistogramReply
from ncbi.datasets.openapi.models.v2_assembly_check_m_histogram_reply_histogram_interval import V2AssemblyCheckMHistogramReplyHistogramInterval as V2AssemblyCheckMHistogramReplyHistogramInterval
from ncbi.datasets.openapi.models.v2_assembly_check_m_histogram_request import V2AssemblyCheckMHistogramRequest as V2AssemblyCheckMHistogramRequest
from ncbi.datasets.openapi.models.v2_assembly_data_report_draft_request import V2AssemblyDataReportDraftRequest as V2AssemblyDataReportDraftRequest
from ncbi.datasets.openapi.models.v2_assembly_dataset_availability import V2AssemblyDatasetAvailability as V2AssemblyDatasetAvailability
from ncbi.datasets.openapi.models.v2_assembly_dataset_descriptors_filter import V2AssemblyDatasetDescriptorsFilter as V2AssemblyDatasetDescriptorsFilter
from ncbi.datasets.openapi.models.v2_assembly_dataset_descriptors_filter_assembly_source import V2AssemblyDatasetDescriptorsFilterAssemblySource as V2AssemblyDatasetDescriptorsFilterAssemblySource
from ncbi.datasets.openapi.models.v2_assembly_dataset_descriptors_filter_assembly_version import V2AssemblyDatasetDescriptorsFilterAssemblyVersion as V2AssemblyDatasetDescriptorsFilterAssemblyVersion
from ncbi.datasets.openapi.models.v2_assembly_dataset_descriptors_filter_metagenome_derived_filter import V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter as V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
from ncbi.datasets.openapi.models.v2_assembly_dataset_descriptors_filter_type_material_category import V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory as V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
from ncbi.datasets.openapi.models.v2_assembly_dataset_reports_request import V2AssemblyDatasetReportsRequest as V2AssemblyDatasetReportsRequest
from ncbi.datasets.openapi.models.v2_assembly_dataset_reports_request_content_type import V2AssemblyDatasetReportsRequestContentType as V2AssemblyDatasetReportsRequestContentType
from ncbi.datasets.openapi.models.v2_assembly_dataset_request import V2AssemblyDatasetRequest as V2AssemblyDatasetRequest
from ncbi.datasets.openapi.models.v2_assembly_dataset_request_resolution import V2AssemblyDatasetRequestResolution as V2AssemblyDatasetRequestResolution
from ncbi.datasets.openapi.models.v2_assembly_links_reply import V2AssemblyLinksReply as V2AssemblyLinksReply
from ncbi.datasets.openapi.models.v2_assembly_links_reply_assembly_link import V2AssemblyLinksReplyAssemblyLink as V2AssemblyLinksReplyAssemblyLink
from ncbi.datasets.openapi.models.v2_assembly_links_reply_assembly_link_type import V2AssemblyLinksReplyAssemblyLinkType as V2AssemblyLinksReplyAssemblyLinkType
from ncbi.datasets.openapi.models.v2_assembly_links_request import V2AssemblyLinksRequest as V2AssemblyLinksRequest
from ncbi.datasets.openapi.models.v2_assembly_revision_history import V2AssemblyRevisionHistory as V2AssemblyRevisionHistory
from ncbi.datasets.openapi.models.v2_assembly_revision_history_request import V2AssemblyRevisionHistoryRequest as V2AssemblyRevisionHistoryRequest
from ncbi.datasets.openapi.models.v2_assembly_sequence_reports_request import V2AssemblySequenceReportsRequest as V2AssemblySequenceReportsRequest
from ncbi.datasets.openapi.models.v2_bio_sample_dataset_reports_request import V2BioSampleDatasetReportsRequest as V2BioSampleDatasetReportsRequest
from ncbi.datasets.openapi.models.v2_catalog_api_version import V2CatalogApiVersion as V2CatalogApiVersion
from ncbi.datasets.openapi.models.v2_dataset_request import V2DatasetRequest as V2DatasetRequest
from ncbi.datasets.openapi.models.v2_download_summary import V2DownloadSummary as V2DownloadSummary
from ncbi.datasets.openapi.models.v2_download_summary_available_files import V2DownloadSummaryAvailableFiles as V2DownloadSummaryAvailableFiles
from ncbi.datasets.openapi.models.v2_download_summary_dehydrated import V2DownloadSummaryDehydrated as V2DownloadSummaryDehydrated
from ncbi.datasets.openapi.models.v2_download_summary_file_summary import V2DownloadSummaryFileSummary as V2DownloadSummaryFileSummary
from ncbi.datasets.openapi.models.v2_download_summary_hydrated import V2DownloadSummaryHydrated as V2DownloadSummaryHydrated
from ncbi.datasets.openapi.models.v2_element_flank_config import V2ElementFlankConfig as V2ElementFlankConfig
from ncbi.datasets.openapi.models.v2_fasta import V2Fasta as V2Fasta
from ncbi.datasets.openapi.models.v2_file_file_type import V2FileFileType as V2FileFileType
from ncbi.datasets.openapi.models.v2_gene_chromosome_summary_reply import V2GeneChromosomeSummaryReply as V2GeneChromosomeSummaryReply
from ncbi.datasets.openapi.models.v2_gene_chromosome_summary_reply_gene_chromosome_summary import V2GeneChromosomeSummaryReplyGeneChromosomeSummary as V2GeneChromosomeSummaryReplyGeneChromosomeSummary
from ncbi.datasets.openapi.models.v2_gene_chromosome_summary_request import V2GeneChromosomeSummaryRequest as V2GeneChromosomeSummaryRequest
from ncbi.datasets.openapi.models.v2_gene_counts_by_taxon_reply import V2GeneCountsByTaxonReply as V2GeneCountsByTaxonReply
from ncbi.datasets.openapi.models.v2_gene_counts_by_taxon_reply_gene_type_and_count import V2GeneCountsByTaxonReplyGeneTypeAndCount as V2GeneCountsByTaxonReplyGeneTypeAndCount
from ncbi.datasets.openapi.models.v2_gene_counts_by_taxon_request import V2GeneCountsByTaxonRequest as V2GeneCountsByTaxonRequest
from ncbi.datasets.openapi.models.v2_gene_dataset_reports_request import V2GeneDatasetReportsRequest as V2GeneDatasetReportsRequest
from ncbi.datasets.openapi.models.v2_gene_dataset_reports_request_content_type import V2GeneDatasetReportsRequestContentType as V2GeneDatasetReportsRequestContentType
from ncbi.datasets.openapi.models.v2_gene_dataset_reports_request_symbols_for_taxon import V2GeneDatasetReportsRequestSymbolsForTaxon as V2GeneDatasetReportsRequestSymbolsForTaxon
from ncbi.datasets.openapi.models.v2_gene_dataset_request import V2GeneDatasetRequest as V2GeneDatasetRequest
from ncbi.datasets.openapi.models.v2_gene_dataset_request_content_type import V2GeneDatasetRequestContentType as V2GeneDatasetRequestContentType
from ncbi.datasets.openapi.models.v2_gene_dataset_request_gene_dataset_report_type import V2GeneDatasetRequestGeneDatasetReportType as V2GeneDatasetRequestGeneDatasetReportType
from ncbi.datasets.openapi.models.v2_gene_links_reply import V2GeneLinksReply as V2GeneLinksReply
from ncbi.datasets.openapi.models.v2_gene_links_reply_gene_link import V2GeneLinksReplyGeneLink as V2GeneLinksReplyGeneLink
from ncbi.datasets.openapi.models.v2_gene_links_reply_gene_link_type import V2GeneLinksReplyGeneLinkType as V2GeneLinksReplyGeneLinkType
from ncbi.datasets.openapi.models.v2_gene_links_request import V2GeneLinksRequest as V2GeneLinksRequest
from ncbi.datasets.openapi.models.v2_gene_pubmed_ids_request import V2GenePubmedIdsRequest as V2GenePubmedIdsRequest
from ncbi.datasets.openapi.models.v2_gene_pubmed_ids_response import V2GenePubmedIdsResponse as V2GenePubmedIdsResponse
from ncbi.datasets.openapi.models.v2_gene_type import V2GeneType as V2GeneType
from ncbi.datasets.openapi.models.v2_genome_annotation_request import V2GenomeAnnotationRequest as V2GenomeAnnotationRequest
from ncbi.datasets.openapi.models.v2_genome_annotation_request_annotation_type import V2GenomeAnnotationRequestAnnotationType as V2GenomeAnnotationRequestAnnotationType
from ncbi.datasets.openapi.models.v2_genome_annotation_request_genome_annotation_table_format import V2GenomeAnnotationRequestGenomeAnnotationTableFormat as V2GenomeAnnotationRequestGenomeAnnotationTableFormat
from ncbi.datasets.openapi.models.v2_genome_annotation_table_summary_reply import V2GenomeAnnotationTableSummaryReply as V2GenomeAnnotationTableSummaryReply
from ncbi.datasets.openapi.models.v2_http_body import V2HttpBody as V2HttpBody
from ncbi.datasets.openapi.models.v2_image_size import V2ImageSize as V2ImageSize
from ncbi.datasets.openapi.models.v2_include_tabular_header import V2IncludeTabularHeader as V2IncludeTabularHeader
from ncbi.datasets.openapi.models.v2_micro_bigge_dataset_request import V2MicroBiggeDatasetRequest as V2MicroBiggeDatasetRequest
from ncbi.datasets.openapi.models.v2_micro_bigge_dataset_request_file_type import V2MicroBiggeDatasetRequestFileType as V2MicroBiggeDatasetRequestFileType
from ncbi.datasets.openapi.models.v2_mol_type import V2MolType as V2MolType
from ncbi.datasets.openapi.models.v2_organelle_download_request import V2OrganelleDownloadRequest as V2OrganelleDownloadRequest
from ncbi.datasets.openapi.models.v2_organelle_metadata_request import V2OrganelleMetadataRequest as V2OrganelleMetadataRequest
from ncbi.datasets.openapi.models.v2_organelle_metadata_request_content_type import V2OrganelleMetadataRequestContentType as V2OrganelleMetadataRequestContentType
from ncbi.datasets.openapi.models.v2_organelle_metadata_request_organelle_table_format import V2OrganelleMetadataRequestOrganelleTableFormat as V2OrganelleMetadataRequestOrganelleTableFormat
from ncbi.datasets.openapi.models.v2_organelle_sort import V2OrganelleSort as V2OrganelleSort
from ncbi.datasets.openapi.models.v2_organism_query_request import V2OrganismQueryRequest as V2OrganismQueryRequest
from ncbi.datasets.openapi.models.v2_organism_query_request_tax_rank_filter import V2OrganismQueryRequestTaxRankFilter as V2OrganismQueryRequestTaxRankFilter
from ncbi.datasets.openapi.models.v2_organism_query_request_taxon_resource_filter import V2OrganismQueryRequestTaxonResourceFilter as V2OrganismQueryRequestTaxonResourceFilter
from ncbi.datasets.openapi.models.v2_ortholog_request import V2OrthologRequest as V2OrthologRequest
from ncbi.datasets.openapi.models.v2_ortholog_request_content_type import V2OrthologRequestContentType as V2OrthologRequestContentType
from ncbi.datasets.openapi.models.v2_prokaryote_gene_request import V2ProkaryoteGeneRequest as V2ProkaryoteGeneRequest
from ncbi.datasets.openapi.models.v2_prokaryote_gene_request_gene_flank_config import V2ProkaryoteGeneRequestGeneFlankConfig as V2ProkaryoteGeneRequestGeneFlankConfig
from ncbi.datasets.openapi.models.v2_ref_gene_catalog_dataset_request import V2RefGeneCatalogDatasetRequest as V2RefGeneCatalogDatasetRequest
from ncbi.datasets.openapi.models.v2_ref_gene_catalog_dataset_request_file_type import V2RefGeneCatalogDatasetRequestFileType as V2RefGeneCatalogDatasetRequestFileType
from ncbi.datasets.openapi.models.v2_sars2_protein_dataset_request import V2Sars2ProteinDatasetRequest as V2Sars2ProteinDatasetRequest
from ncbi.datasets.openapi.models.v2_sci_name_and_ids import V2SciNameAndIds as V2SciNameAndIds
from ncbi.datasets.openapi.models.v2_sci_name_and_ids_sci_name_and_id import V2SciNameAndIdsSciNameAndId as V2SciNameAndIdsSciNameAndId
from ncbi.datasets.openapi.models.v2_seq_range import V2SeqRange as V2SeqRange
from ncbi.datasets.openapi.models.v2_seq_reply import V2SeqReply as V2SeqReply
from ncbi.datasets.openapi.models.v2_sequence_accession_request import V2SequenceAccessionRequest as V2SequenceAccessionRequest
from ncbi.datasets.openapi.models.v2_sequence_report_page import V2SequenceReportPage as V2SequenceReportPage
from ncbi.datasets.openapi.models.v2_sleep_reply import V2SleepReply as V2SleepReply
from ncbi.datasets.openapi.models.v2_sleep_request import V2SleepRequest as V2SleepRequest
from ncbi.datasets.openapi.models.v2_sort_direction import V2SortDirection as V2SortDirection
from ncbi.datasets.openapi.models.v2_sort_field import V2SortField as V2SortField
from ncbi.datasets.openapi.models.v2_table_format import V2TableFormat as V2TableFormat
from ncbi.datasets.openapi.models.v2_tabular_output import V2TabularOutput as V2TabularOutput
from ncbi.datasets.openapi.models.v2_taxonomy_dataset_request import V2TaxonomyDatasetRequest as V2TaxonomyDatasetRequest
from ncbi.datasets.openapi.models.v2_taxonomy_dataset_request_taxonomy_report_type import V2TaxonomyDatasetRequestTaxonomyReportType as V2TaxonomyDatasetRequestTaxonomyReportType
from ncbi.datasets.openapi.models.v2_taxonomy_filtered_subtree_request import V2TaxonomyFilteredSubtreeRequest as V2TaxonomyFilteredSubtreeRequest
from ncbi.datasets.openapi.models.v2_taxonomy_filtered_subtree_response import V2TaxonomyFilteredSubtreeResponse as V2TaxonomyFilteredSubtreeResponse
from ncbi.datasets.openapi.models.v2_taxonomy_filtered_subtree_response_edge import V2TaxonomyFilteredSubtreeResponseEdge as V2TaxonomyFilteredSubtreeResponseEdge
from ncbi.datasets.openapi.models.v2_taxonomy_filtered_subtree_response_edge_child_status import V2TaxonomyFilteredSubtreeResponseEdgeChildStatus as V2TaxonomyFilteredSubtreeResponseEdgeChildStatus
from ncbi.datasets.openapi.models.v2_taxonomy_filtered_subtree_response_edges_entry import V2TaxonomyFilteredSubtreeResponseEdgesEntry as V2TaxonomyFilteredSubtreeResponseEdgesEntry
from ncbi.datasets.openapi.models.v2_taxonomy_image_metadata_request import V2TaxonomyImageMetadataRequest as V2TaxonomyImageMetadataRequest
from ncbi.datasets.openapi.models.v2_taxonomy_image_metadata_response import V2TaxonomyImageMetadataResponse as V2TaxonomyImageMetadataResponse
from ncbi.datasets.openapi.models.v2_taxonomy_image_request import V2TaxonomyImageRequest as V2TaxonomyImageRequest
from ncbi.datasets.openapi.models.v2_taxonomy_links_request import V2TaxonomyLinksRequest as V2TaxonomyLinksRequest
from ncbi.datasets.openapi.models.v2_taxonomy_links_response import V2TaxonomyLinksResponse as V2TaxonomyLinksResponse
from ncbi.datasets.openapi.models.v2_taxonomy_links_response_generic_link import V2TaxonomyLinksResponseGenericLink as V2TaxonomyLinksResponseGenericLink
from ncbi.datasets.openapi.models.v2_taxonomy_match import V2TaxonomyMatch as V2TaxonomyMatch
from ncbi.datasets.openapi.models.v2_taxonomy_metadata_request import V2TaxonomyMetadataRequest as V2TaxonomyMetadataRequest
from ncbi.datasets.openapi.models.v2_taxonomy_metadata_request_content_type import V2TaxonomyMetadataRequestContentType as V2TaxonomyMetadataRequestContentType
from ncbi.datasets.openapi.models.v2_taxonomy_metadata_request_table_format import V2TaxonomyMetadataRequestTableFormat as V2TaxonomyMetadataRequestTableFormat
from ncbi.datasets.openapi.models.v2_taxonomy_metadata_response import V2TaxonomyMetadataResponse as V2TaxonomyMetadataResponse
from ncbi.datasets.openapi.models.v2_taxonomy_node import V2TaxonomyNode as V2TaxonomyNode
from ncbi.datasets.openapi.models.v2_taxonomy_node_count_by_type import V2TaxonomyNodeCountByType as V2TaxonomyNodeCountByType
from ncbi.datasets.openapi.models.v2_taxonomy_related_id_request import V2TaxonomyRelatedIdRequest as V2TaxonomyRelatedIdRequest
from ncbi.datasets.openapi.models.v2_taxonomy_tax_ids_page import V2TaxonomyTaxIdsPage as V2TaxonomyTaxIdsPage
from ncbi.datasets.openapi.models.v2_version_reply import V2VersionReply as V2VersionReply
from ncbi.datasets.openapi.models.v2_viral_sequence_type import V2ViralSequenceType as V2ViralSequenceType
from ncbi.datasets.openapi.models.v2_virus_annotation_filter import V2VirusAnnotationFilter as V2VirusAnnotationFilter
from ncbi.datasets.openapi.models.v2_virus_annotation_report_request import V2VirusAnnotationReportRequest as V2VirusAnnotationReportRequest
from ncbi.datasets.openapi.models.v2_virus_availability import V2VirusAvailability as V2VirusAvailability
from ncbi.datasets.openapi.models.v2_virus_availability_request import V2VirusAvailabilityRequest as V2VirusAvailabilityRequest
from ncbi.datasets.openapi.models.v2_virus_data_report_request import V2VirusDataReportRequest as V2VirusDataReportRequest
from ncbi.datasets.openapi.models.v2_virus_data_report_request_content_type import V2VirusDataReportRequestContentType as V2VirusDataReportRequestContentType
from ncbi.datasets.openapi.models.v2_virus_dataset_filter import V2VirusDatasetFilter as V2VirusDatasetFilter
from ncbi.datasets.openapi.models.v2_virus_dataset_report_type import V2VirusDatasetReportType as V2VirusDatasetReportType
from ncbi.datasets.openapi.models.v2_virus_dataset_request import V2VirusDatasetRequest as V2VirusDatasetRequest
from ncbi.datasets.openapi.models.v2_virus_table_field import V2VirusTableField as V2VirusTableField
from ncbi.datasets.openapi.models.v2archive_affiliation import V2archiveAffiliation as V2archiveAffiliation
from ncbi.datasets.openapi.models.v2archive_catalog import V2archiveCatalog as V2archiveCatalog
from ncbi.datasets.openapi.models.v2archive_location import V2archiveLocation as V2archiveLocation
from ncbi.datasets.openapi.models.v2archive_modifier import V2archiveModifier as V2archiveModifier
from ncbi.datasets.openapi.models.v2archive_molecule_type import V2archiveMoleculeType as V2archiveMoleculeType
from ncbi.datasets.openapi.models.v2archive_name import V2archiveName as V2archiveName
from ncbi.datasets.openapi.models.v2archive_nuccore_request import V2archiveNuccoreRequest as V2archiveNuccoreRequest
from ncbi.datasets.openapi.models.v2archive_sequence import V2archiveSequence as V2archiveSequence
from ncbi.datasets.openapi.models.v2archive_sequence_length_units import V2archiveSequenceLengthUnits as V2archiveSequenceLengthUnits
from ncbi.datasets.openapi.models.v2archive_submitter import V2archiveSubmitter as V2archiveSubmitter
from ncbi.datasets.openapi.models.v2archive_taxonomy_node import V2archiveTaxonomyNode as V2archiveTaxonomyNode
from ncbi.datasets.openapi.models.v2archive_taxonomy_subtype import V2archiveTaxonomySubtype as V2archiveTaxonomySubtype
from ncbi.datasets.openapi.models.v2reports_ani_match import V2reportsANIMatch as V2reportsANIMatch
from ncbi.datasets.openapi.models.v2reports_ani_type_category import V2reportsANITypeCategory as V2reportsANITypeCategory
from ncbi.datasets.openapi.models.v2reports_additional_submitter import V2reportsAdditionalSubmitter as V2reportsAdditionalSubmitter
from ncbi.datasets.openapi.models.v2reports_annotation import V2reportsAnnotation as V2reportsAnnotation
from ncbi.datasets.openapi.models.v2reports_annotation_info import V2reportsAnnotationInfo as V2reportsAnnotationInfo
from ncbi.datasets.openapi.models.v2reports_assembly_data_report import V2reportsAssemblyDataReport as V2reportsAssemblyDataReport
from ncbi.datasets.openapi.models.v2reports_assembly_data_report_page import V2reportsAssemblyDataReportPage as V2reportsAssemblyDataReportPage
from ncbi.datasets.openapi.models.v2reports_assembly_info import V2reportsAssemblyInfo as V2reportsAssemblyInfo
from ncbi.datasets.openapi.models.v2reports_assembly_level import V2reportsAssemblyLevel as V2reportsAssemblyLevel
from ncbi.datasets.openapi.models.v2reports_assembly_revision import V2reportsAssemblyRevision as V2reportsAssemblyRevision
from ncbi.datasets.openapi.models.v2reports_assembly_stats import V2reportsAssemblyStats as V2reportsAssemblyStats
from ncbi.datasets.openapi.models.v2reports_assembly_status import V2reportsAssemblyStatus as V2reportsAssemblyStatus
from ncbi.datasets.openapi.models.v2reports_atypical_info import V2reportsAtypicalInfo as V2reportsAtypicalInfo
from ncbi.datasets.openapi.models.v2reports_average_nucleotide_identity import V2reportsAverageNucleotideIdentity as V2reportsAverageNucleotideIdentity
from ncbi.datasets.openapi.models.v2reports_average_nucleotide_identity_match_status import V2reportsAverageNucleotideIdentityMatchStatus as V2reportsAverageNucleotideIdentityMatchStatus
from ncbi.datasets.openapi.models.v2reports_average_nucleotide_identity_taxonomy_check_status import V2reportsAverageNucleotideIdentityTaxonomyCheckStatus as V2reportsAverageNucleotideIdentityTaxonomyCheckStatus
from ncbi.datasets.openapi.models.v2reports_bio_project import V2reportsBioProject as V2reportsBioProject
from ncbi.datasets.openapi.models.v2reports_bio_project_lineage import V2reportsBioProjectLineage as V2reportsBioProjectLineage
from ncbi.datasets.openapi.models.v2reports_bio_sample_attribute import V2reportsBioSampleAttribute as V2reportsBioSampleAttribute
from ncbi.datasets.openapi.models.v2reports_bio_sample_contact import V2reportsBioSampleContact as V2reportsBioSampleContact
from ncbi.datasets.openapi.models.v2reports_bio_sample_data_report import V2reportsBioSampleDataReport as V2reportsBioSampleDataReport
from ncbi.datasets.openapi.models.v2reports_bio_sample_data_report_page import V2reportsBioSampleDataReportPage as V2reportsBioSampleDataReportPage
from ncbi.datasets.openapi.models.v2reports_bio_sample_description import V2reportsBioSampleDescription as V2reportsBioSampleDescription
from ncbi.datasets.openapi.models.v2reports_bio_sample_descriptor import V2reportsBioSampleDescriptor as V2reportsBioSampleDescriptor
from ncbi.datasets.openapi.models.v2reports_bio_sample_id import V2reportsBioSampleId as V2reportsBioSampleId
from ncbi.datasets.openapi.models.v2reports_bio_sample_owner import V2reportsBioSampleOwner as V2reportsBioSampleOwner
from ncbi.datasets.openapi.models.v2reports_bio_sample_status import V2reportsBioSampleStatus as V2reportsBioSampleStatus
from ncbi.datasets.openapi.models.v2reports_busco_stat import V2reportsBuscoStat as V2reportsBuscoStat
from ncbi.datasets.openapi.models.v2reports_check_m import V2reportsCheckM as V2reportsCheckM
from ncbi.datasets.openapi.models.v2reports_classification import V2reportsClassification as V2reportsClassification
from ncbi.datasets.openapi.models.v2reports_collection_type import V2reportsCollectionType as V2reportsCollectionType
from ncbi.datasets.openapi.models.v2reports_conserved_domain import V2reportsConservedDomain as V2reportsConservedDomain
from ncbi.datasets.openapi.models.v2reports_content_type import V2reportsContentType as V2reportsContentType
from ncbi.datasets.openapi.models.v2reports_count_type import V2reportsCountType as V2reportsCountType
from ncbi.datasets.openapi.models.v2reports_error import V2reportsError as V2reportsError
from ncbi.datasets.openapi.models.v2reports_error_assembly_error_code import V2reportsErrorAssemblyErrorCode as V2reportsErrorAssemblyErrorCode
from ncbi.datasets.openapi.models.v2reports_error_gene_error_code import V2reportsErrorGeneErrorCode as V2reportsErrorGeneErrorCode
from ncbi.datasets.openapi.models.v2reports_error_organelle_error_code import V2reportsErrorOrganelleErrorCode as V2reportsErrorOrganelleErrorCode
from ncbi.datasets.openapi.models.v2reports_error_taxonomy_error_code import V2reportsErrorTaxonomyErrorCode as V2reportsErrorTaxonomyErrorCode
from ncbi.datasets.openapi.models.v2reports_error_virus_error_code import V2reportsErrorVirusErrorCode as V2reportsErrorVirusErrorCode
from ncbi.datasets.openapi.models.v2reports_feature_counts import V2reportsFeatureCounts as V2reportsFeatureCounts
from ncbi.datasets.openapi.models.v2reports_functional_site import V2reportsFunctionalSite as V2reportsFunctionalSite
from ncbi.datasets.openapi.models.v2reports_gene_counts import V2reportsGeneCounts as V2reportsGeneCounts
from ncbi.datasets.openapi.models.v2reports_gene_data_report_page import V2reportsGeneDataReportPage as V2reportsGeneDataReportPage
from ncbi.datasets.openapi.models.v2reports_gene_descriptor import V2reportsGeneDescriptor as V2reportsGeneDescriptor
from ncbi.datasets.openapi.models.v2reports_gene_group import V2reportsGeneGroup as V2reportsGeneGroup
from ncbi.datasets.openapi.models.v2reports_gene_ontology import V2reportsGeneOntology as V2reportsGeneOntology
from ncbi.datasets.openapi.models.v2reports_gene_report_match import V2reportsGeneReportMatch as V2reportsGeneReportMatch
from ncbi.datasets.openapi.models.v2reports_gene_summary import V2reportsGeneSummary as V2reportsGeneSummary
from ncbi.datasets.openapi.models.v2reports_gene_type import V2reportsGeneType as V2reportsGeneType
from ncbi.datasets.openapi.models.v2reports_genome_annotation import V2reportsGenomeAnnotation as V2reportsGenomeAnnotation
from ncbi.datasets.openapi.models.v2reports_genome_annotation_report_match import V2reportsGenomeAnnotationReportMatch as V2reportsGenomeAnnotationReportMatch
from ncbi.datasets.openapi.models.v2reports_genome_annotation_report_page import V2reportsGenomeAnnotationReportPage as V2reportsGenomeAnnotationReportPage
from ncbi.datasets.openapi.models.v2reports_genomic_location import V2reportsGenomicLocation as V2reportsGenomicLocation
from ncbi.datasets.openapi.models.v2reports_genomic_region import V2reportsGenomicRegion as V2reportsGenomicRegion
from ncbi.datasets.openapi.models.v2reports_genomic_region_genomic_region_type import V2reportsGenomicRegionGenomicRegionType as V2reportsGenomicRegionGenomicRegionType
from ncbi.datasets.openapi.models.v2reports_infraspecific_names import V2reportsInfraspecificNames as V2reportsInfraspecificNames
from ncbi.datasets.openapi.models.v2reports_isolate import V2reportsIsolate as V2reportsIsolate
from ncbi.datasets.openapi.models.v2reports_lineage_organism import V2reportsLineageOrganism as V2reportsLineageOrganism
from ncbi.datasets.openapi.models.v2reports_linked_assembly import V2reportsLinkedAssembly as V2reportsLinkedAssembly
from ncbi.datasets.openapi.models.v2reports_linked_assembly_type import V2reportsLinkedAssemblyType as V2reportsLinkedAssemblyType
from ncbi.datasets.openapi.models.v2reports_mature_peptide import V2reportsMaturePeptide as V2reportsMaturePeptide
from ncbi.datasets.openapi.models.v2reports_message import V2reportsMessage as V2reportsMessage
from ncbi.datasets.openapi.models.v2reports_name_and_authority import V2reportsNameAndAuthority as V2reportsNameAndAuthority
from ncbi.datasets.openapi.models.v2reports_name_and_authority_note import V2reportsNameAndAuthorityNote as V2reportsNameAndAuthorityNote
from ncbi.datasets.openapi.models.v2reports_name_and_authority_note_classifier import V2reportsNameAndAuthorityNoteClassifier as V2reportsNameAndAuthorityNoteClassifier
from ncbi.datasets.openapi.models.v2reports_name_and_authority_publication import V2reportsNameAndAuthorityPublication as V2reportsNameAndAuthorityPublication
from ncbi.datasets.openapi.models.v2reports_nomenclature_authority import V2reportsNomenclatureAuthority as V2reportsNomenclatureAuthority
from ncbi.datasets.openapi.models.v2reports_organelle import V2reportsOrganelle as V2reportsOrganelle
from ncbi.datasets.openapi.models.v2reports_organelle_biosample import V2reportsOrganelleBiosample as V2reportsOrganelleBiosample
from ncbi.datasets.openapi.models.v2reports_organelle_data_reports import V2reportsOrganelleDataReports as V2reportsOrganelleDataReports
from ncbi.datasets.openapi.models.v2reports_organelle_gene_counts import V2reportsOrganelleGeneCounts as V2reportsOrganelleGeneCounts
from ncbi.datasets.openapi.models.v2reports_organelle_info import V2reportsOrganelleInfo as V2reportsOrganelleInfo
from ncbi.datasets.openapi.models.v2reports_organelle_topology import V2reportsOrganelleTopology as V2reportsOrganelleTopology
from ncbi.datasets.openapi.models.v2reports_organelle_type import V2reportsOrganelleType as V2reportsOrganelleType
from ncbi.datasets.openapi.models.v2reports_organism import V2reportsOrganism as V2reportsOrganism
from ncbi.datasets.openapi.models.v2reports_orientation import V2reportsOrientation as V2reportsOrientation
from ncbi.datasets.openapi.models.v2reports_paired_assembly import V2reportsPairedAssembly as V2reportsPairedAssembly
from ncbi.datasets.openapi.models.v2reports_process_metadata import V2reportsProcessMetadata as V2reportsProcessMetadata
from ncbi.datasets.openapi.models.v2reports_product_descriptor import V2reportsProductDescriptor as V2reportsProductDescriptor
from ncbi.datasets.openapi.models.v2reports_prokaryote_gene_location_completeness import V2reportsProkaryoteGeneLocationCompleteness as V2reportsProkaryoteGeneLocationCompleteness
from ncbi.datasets.openapi.models.v2reports_protein import V2reportsProtein as V2reportsProtein
from ncbi.datasets.openapi.models.v2reports_protein_conserved_domain import V2reportsProteinConservedDomain as V2reportsProteinConservedDomain
from ncbi.datasets.openapi.models.v2reports_protein_data_report import V2reportsProteinDataReport as V2reportsProteinDataReport
from ncbi.datasets.openapi.models.v2reports_protein_data_report_page import V2reportsProteinDataReportPage as V2reportsProteinDataReportPage
from ncbi.datasets.openapi.models.v2reports_protein_family import V2reportsProteinFamily as V2reportsProteinFamily
from ncbi.datasets.openapi.models.v2reports_purpose_of_sampling import V2reportsPurposeOfSampling as V2reportsPurposeOfSampling
from ncbi.datasets.openapi.models.v2reports_range import V2reportsRange as V2reportsRange
from ncbi.datasets.openapi.models.v2reports_rank_type import V2reportsRankType as V2reportsRankType
from ncbi.datasets.openapi.models.v2reports_reference import V2reportsReference as V2reportsReference
from ncbi.datasets.openapi.models.v2reports_rna_type import V2reportsRnaType as V2reportsRnaType
from ncbi.datasets.openapi.models.v2reports_seq_range_set import V2reportsSeqRangeSet as V2reportsSeqRangeSet
from ncbi.datasets.openapi.models.v2reports_seq_range_set_fasta import V2reportsSeqRangeSetFasta as V2reportsSeqRangeSetFasta
from ncbi.datasets.openapi.models.v2reports_sequence_info import V2reportsSequenceInfo as V2reportsSequenceInfo
from ncbi.datasets.openapi.models.v2reports_sequence_information import V2reportsSequenceInformation as V2reportsSequenceInformation
from ncbi.datasets.openapi.models.v2reports_source_database import V2reportsSourceDatabase as V2reportsSourceDatabase
from ncbi.datasets.openapi.models.v2reports_tax_data import V2reportsTaxData as V2reportsTaxData
from ncbi.datasets.openapi.models.v2reports_taxonomy_data_report_page import V2reportsTaxonomyDataReportPage as V2reportsTaxonomyDataReportPage
from ncbi.datasets.openapi.models.v2reports_taxonomy_names_data_report_page import V2reportsTaxonomyNamesDataReportPage as V2reportsTaxonomyNamesDataReportPage
from ncbi.datasets.openapi.models.v2reports_taxonomy_names_descriptor import V2reportsTaxonomyNamesDescriptor as V2reportsTaxonomyNamesDescriptor
from ncbi.datasets.openapi.models.v2reports_taxonomy_names_descriptor_citation import V2reportsTaxonomyNamesDescriptorCitation as V2reportsTaxonomyNamesDescriptorCitation
from ncbi.datasets.openapi.models.v2reports_taxonomy_names_report_match import V2reportsTaxonomyNamesReportMatch as V2reportsTaxonomyNamesReportMatch
from ncbi.datasets.openapi.models.v2reports_taxonomy_node import V2reportsTaxonomyNode as V2reportsTaxonomyNode
from ncbi.datasets.openapi.models.v2reports_taxonomy_node_count_by_type import V2reportsTaxonomyNodeCountByType as V2reportsTaxonomyNodeCountByType
from ncbi.datasets.openapi.models.v2reports_taxonomy_report_match import V2reportsTaxonomyReportMatch as V2reportsTaxonomyReportMatch
from ncbi.datasets.openapi.models.v2reports_taxonomy_type_material import V2reportsTaxonomyTypeMaterial as V2reportsTaxonomyTypeMaterial
from ncbi.datasets.openapi.models.v2reports_transcript import V2reportsTranscript as V2reportsTranscript
from ncbi.datasets.openapi.models.v2reports_transcript_select_category import V2reportsTranscriptSelectCategory as V2reportsTranscriptSelectCategory
from ncbi.datasets.openapi.models.v2reports_transcript_transcript_type import V2reportsTranscriptTranscriptType as V2reportsTranscriptTranscriptType
from ncbi.datasets.openapi.models.v2reports_transcript_type_count import V2reportsTranscriptTypeCount as V2reportsTranscriptTypeCount
from ncbi.datasets.openapi.models.v2reports_type_material import V2reportsTypeMaterial as V2reportsTypeMaterial
from ncbi.datasets.openapi.models.v2reports_virus_annotation_report import V2reportsVirusAnnotationReport as V2reportsVirusAnnotationReport
from ncbi.datasets.openapi.models.v2reports_virus_annotation_report_page import V2reportsVirusAnnotationReportPage as V2reportsVirusAnnotationReportPage
from ncbi.datasets.openapi.models.v2reports_virus_assembly import V2reportsVirusAssembly as V2reportsVirusAssembly
from ncbi.datasets.openapi.models.v2reports_virus_assembly_collection_location import V2reportsVirusAssemblyCollectionLocation as V2reportsVirusAssemblyCollectionLocation
from ncbi.datasets.openapi.models.v2reports_virus_assembly_completeness import V2reportsVirusAssemblyCompleteness as V2reportsVirusAssemblyCompleteness
from ncbi.datasets.openapi.models.v2reports_virus_assembly_submitter_info import V2reportsVirusAssemblySubmitterInfo as V2reportsVirusAssemblySubmitterInfo
from ncbi.datasets.openapi.models.v2reports_virus_data_report_page import V2reportsVirusDataReportPage as V2reportsVirusDataReportPage
from ncbi.datasets.openapi.models.v2reports_virus_gene import V2reportsVirusGene as V2reportsVirusGene
from ncbi.datasets.openapi.models.v2reports_virus_peptide import V2reportsVirusPeptide as V2reportsVirusPeptide
from ncbi.datasets.openapi.models.v2reports_virus_peptide_uni_prot_id import V2reportsVirusPeptideUniProtId as V2reportsVirusPeptideUniProtId
from ncbi.datasets.openapi.models.v2reports_virus_peptide_viral_peptide_completeness import V2reportsVirusPeptideViralPeptideCompleteness as V2reportsVirusPeptideViralPeptideCompleteness
from ncbi.datasets.openapi.models.v2reports_wgs_info import V2reportsWGSInfo as V2reportsWGSInfo
from ncbi.datasets.openapi.models.v2reports_warning import V2reportsWarning as V2reportsWarning
from ncbi.datasets.openapi.models.v2reports_warning_gene_warning_code import V2reportsWarningGeneWarningCode as V2reportsWarningGeneWarningCode
from ncbi.datasets.openapi.models.v2reports_warning_replaced_id import V2reportsWarningReplacedId as V2reportsWarningReplacedId

