# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr
from typing import List, Optional, Tuple, Union
from typing_extensions import Annotated
from ncbi.datasets.openapi.models.v2_download_summary import V2DownloadSummary
from ncbi.datasets.openapi.models.v2_fasta import V2Fasta
from ncbi.datasets.openapi.models.v2_gene_chromosome_summary_reply import V2GeneChromosomeSummaryReply
from ncbi.datasets.openapi.models.v2_gene_counts_by_taxon_reply import V2GeneCountsByTaxonReply
from ncbi.datasets.openapi.models.v2_gene_counts_by_taxon_request import V2GeneCountsByTaxonRequest
from ncbi.datasets.openapi.models.v2_gene_dataset_reports_request import V2GeneDatasetReportsRequest
from ncbi.datasets.openapi.models.v2_gene_dataset_reports_request_content_type import V2GeneDatasetReportsRequestContentType
from ncbi.datasets.openapi.models.v2_gene_dataset_request import V2GeneDatasetRequest
from ncbi.datasets.openapi.models.v2_gene_dataset_request_content_type import V2GeneDatasetRequestContentType
from ncbi.datasets.openapi.models.v2_gene_dataset_request_gene_dataset_report_type import V2GeneDatasetRequestGeneDatasetReportType
from ncbi.datasets.openapi.models.v2_gene_links_reply import V2GeneLinksReply
from ncbi.datasets.openapi.models.v2_gene_links_request import V2GeneLinksRequest
from ncbi.datasets.openapi.models.v2_gene_type import V2GeneType
from ncbi.datasets.openapi.models.v2_include_tabular_header import V2IncludeTabularHeader
from ncbi.datasets.openapi.models.v2_ortholog_request import V2OrthologRequest
from ncbi.datasets.openapi.models.v2_ortholog_request_content_type import V2OrthologRequestContentType
from ncbi.datasets.openapi.models.v2_sort_direction import V2SortDirection
from ncbi.datasets.openapi.models.v2reports_gene_data_report_page import V2reportsGeneDataReportPage

from ncbi.datasets.openapi.api_client import ApiClient, RequestSerialized
from ncbi.datasets.openapi.api_response import ApiResponse
from ncbi.datasets.openapi.rest import RESTResponseType


class GeneApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def download_gene_package(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        include_annotation_type: Annotated[Optional[List[V2Fasta]], Field(description="Specify which sequence files to include in the data package.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Limit the contents of the sequence files and tabular product report to the specified RNA and protein accessions")] = None,
        aux_report: Annotated[Optional[List[V2GeneDatasetRequestGeneDatasetReportType]], Field(description="Specify additional report files to include in the data package. The gene data report is always included, and its inclusion is not affected by this parameter.")] = None,
        tabular_reports: Annotated[Optional[List[V2GeneDatasetRequestGeneDatasetReportType]], Field(description="Specify which tabular report files to include in the data package.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a gene data package by GeneID

        Download a gene data package including sequence, annotation and data reports, as a compressed zip archive, by GeneID.

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param include_annotation_type: Specify which sequence files to include in the data package.
        :type include_annotation_type: List[V2Fasta]
        :param accession_filter: Limit the contents of the sequence files and tabular product report to the specified RNA and protein accessions
        :type accession_filter: List[str]
        :param aux_report: Specify additional report files to include in the data package. The gene data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2GeneDatasetRequestGeneDatasetReportType]
        :param tabular_reports: Specify which tabular report files to include in the data package.
        :type tabular_reports: List[V2GeneDatasetRequestGeneDatasetReportType]
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_gene_package_serialize(
            gene_ids=gene_ids,
            include_annotation_type=include_annotation_type,
            accession_filter=accession_filter,
            aux_report=aux_report,
            tabular_reports=tabular_reports,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_gene_package_with_http_info(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        include_annotation_type: Annotated[Optional[List[V2Fasta]], Field(description="Specify which sequence files to include in the data package.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Limit the contents of the sequence files and tabular product report to the specified RNA and protein accessions")] = None,
        aux_report: Annotated[Optional[List[V2GeneDatasetRequestGeneDatasetReportType]], Field(description="Specify additional report files to include in the data package. The gene data report is always included, and its inclusion is not affected by this parameter.")] = None,
        tabular_reports: Annotated[Optional[List[V2GeneDatasetRequestGeneDatasetReportType]], Field(description="Specify which tabular report files to include in the data package.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a gene data package by GeneID

        Download a gene data package including sequence, annotation and data reports, as a compressed zip archive, by GeneID.

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param include_annotation_type: Specify which sequence files to include in the data package.
        :type include_annotation_type: List[V2Fasta]
        :param accession_filter: Limit the contents of the sequence files and tabular product report to the specified RNA and protein accessions
        :type accession_filter: List[str]
        :param aux_report: Specify additional report files to include in the data package. The gene data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2GeneDatasetRequestGeneDatasetReportType]
        :param tabular_reports: Specify which tabular report files to include in the data package.
        :type tabular_reports: List[V2GeneDatasetRequestGeneDatasetReportType]
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_gene_package_serialize(
            gene_ids=gene_ids,
            include_annotation_type=include_annotation_type,
            accession_filter=accession_filter,
            aux_report=aux_report,
            tabular_reports=tabular_reports,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_gene_package_without_preload_content(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        include_annotation_type: Annotated[Optional[List[V2Fasta]], Field(description="Specify which sequence files to include in the data package.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Limit the contents of the sequence files and tabular product report to the specified RNA and protein accessions")] = None,
        aux_report: Annotated[Optional[List[V2GeneDatasetRequestGeneDatasetReportType]], Field(description="Specify additional report files to include in the data package. The gene data report is always included, and its inclusion is not affected by this parameter.")] = None,
        tabular_reports: Annotated[Optional[List[V2GeneDatasetRequestGeneDatasetReportType]], Field(description="Specify which tabular report files to include in the data package.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene data package by GeneID

        Download a gene data package including sequence, annotation and data reports, as a compressed zip archive, by GeneID.

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param include_annotation_type: Specify which sequence files to include in the data package.
        :type include_annotation_type: List[V2Fasta]
        :param accession_filter: Limit the contents of the sequence files and tabular product report to the specified RNA and protein accessions
        :type accession_filter: List[str]
        :param aux_report: Specify additional report files to include in the data package. The gene data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2GeneDatasetRequestGeneDatasetReportType]
        :param tabular_reports: Specify which tabular report files to include in the data package.
        :type tabular_reports: List[V2GeneDatasetRequestGeneDatasetReportType]
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_gene_package_serialize(
            gene_ids=gene_ids,
            include_annotation_type=include_annotation_type,
            accession_filter=accession_filter,
            aux_report=aux_report,
            tabular_reports=tabular_reports,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_gene_package_serialize(
        self,
        gene_ids,
        include_annotation_type,
        accession_filter,
        aux_report,
        tabular_reports,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'gene_ids': 'csv',
            'include_annotation_type': 'multi',
            'accession_filter': 'multi',
            'aux_report': 'multi',
            'tabular_reports': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if gene_ids is not None:
            _path_params['gene_ids'] = gene_ids
        # process the query parameters
        if include_annotation_type is not None:
            
            _query_params.append(('include_annotation_type', include_annotation_type))
            
        if accession_filter is not None:
            
            _query_params.append(('accession_filter', accession_filter))
            
        if aux_report is not None:
            
            _query_params.append(('aux_report', aux_report))
            
        if tabular_reports is not None:
            
            _query_params.append(('tabular_reports', tabular_reports))
            
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/id/{gene_ids}/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def download_gene_package_post(
        self,
        v2_gene_dataset_request: V2GeneDatasetRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a gene data package

        Download a gene data package including sequence, annotation and data reports, as a compressed zip archive.

        :param v2_gene_dataset_request: (required)
        :type v2_gene_dataset_request: V2GeneDatasetRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_gene_package_post_serialize(
            v2_gene_dataset_request=v2_gene_dataset_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_gene_package_post_with_http_info(
        self,
        v2_gene_dataset_request: V2GeneDatasetRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a gene data package

        Download a gene data package including sequence, annotation and data reports, as a compressed zip archive.

        :param v2_gene_dataset_request: (required)
        :type v2_gene_dataset_request: V2GeneDatasetRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_gene_package_post_serialize(
            v2_gene_dataset_request=v2_gene_dataset_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_gene_package_post_without_preload_content(
        self,
        v2_gene_dataset_request: V2GeneDatasetRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene data package

        Download a gene data package including sequence, annotation and data reports, as a compressed zip archive.

        :param v2_gene_dataset_request: (required)
        :type v2_gene_dataset_request: V2GeneDatasetRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_gene_package_post_serialize(
            v2_gene_dataset_request=v2_gene_dataset_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_gene_package_post_serialize(
        self,
        v2_gene_dataset_request,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_gene_dataset_request is not None:
            _body_params = v2_gene_dataset_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/gene/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_chromosome_summary(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank, with an anntoated genome")],
        annotation_name: Annotated[StrictStr, Field(description="Annotation name corresponding to the provided taxon")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2GeneChromosomeSummaryReply:
        """Get gene counts per chromosome by taxon and annotation name

        Get gene counts per chromosome by taxon and annotation name in JSON format.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank, with an anntoated genome (required)
        :type taxon: str
        :param annotation_name: Annotation name corresponding to the provided taxon (required)
        :type annotation_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_chromosome_summary_serialize(
            taxon=taxon,
            annotation_name=annotation_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneChromosomeSummaryReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_chromosome_summary_with_http_info(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank, with an anntoated genome")],
        annotation_name: Annotated[StrictStr, Field(description="Annotation name corresponding to the provided taxon")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2GeneChromosomeSummaryReply]:
        """Get gene counts per chromosome by taxon and annotation name

        Get gene counts per chromosome by taxon and annotation name in JSON format.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank, with an anntoated genome (required)
        :type taxon: str
        :param annotation_name: Annotation name corresponding to the provided taxon (required)
        :type annotation_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_chromosome_summary_serialize(
            taxon=taxon,
            annotation_name=annotation_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneChromosomeSummaryReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_chromosome_summary_without_preload_content(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank, with an anntoated genome")],
        annotation_name: Annotated[StrictStr, Field(description="Annotation name corresponding to the provided taxon")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get gene counts per chromosome by taxon and annotation name

        Get gene counts per chromosome by taxon and annotation name in JSON format.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank, with an anntoated genome (required)
        :type taxon: str
        :param annotation_name: Annotation name corresponding to the provided taxon (required)
        :type annotation_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_chromosome_summary_serialize(
            taxon=taxon,
            annotation_name=annotation_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneChromosomeSummaryReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_chromosome_summary_serialize(
        self,
        taxon,
        annotation_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if taxon is not None:
            _path_params['taxon'] = taxon
        if annotation_name is not None:
            _path_params['annotation_name'] = annotation_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/taxon/{taxon}/annotation/{annotation_name}/chromosome_summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_counts_for_taxon(
        self,
        taxon: Annotated[StrictStr, Field(description="Taxon for provided gene symbol")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2GeneCountsByTaxonReply:
        """Get gene counts by taxon

        Get gene counts by taxon in JSON format.

        :param taxon: Taxon for provided gene symbol (required)
        :type taxon: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_counts_for_taxon_serialize(
            taxon=taxon,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneCountsByTaxonReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_counts_for_taxon_with_http_info(
        self,
        taxon: Annotated[StrictStr, Field(description="Taxon for provided gene symbol")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2GeneCountsByTaxonReply]:
        """Get gene counts by taxon

        Get gene counts by taxon in JSON format.

        :param taxon: Taxon for provided gene symbol (required)
        :type taxon: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_counts_for_taxon_serialize(
            taxon=taxon,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneCountsByTaxonReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_counts_for_taxon_without_preload_content(
        self,
        taxon: Annotated[StrictStr, Field(description="Taxon for provided gene symbol")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get gene counts by taxon

        Get gene counts by taxon in JSON format.

        :param taxon: Taxon for provided gene symbol (required)
        :type taxon: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_counts_for_taxon_serialize(
            taxon=taxon,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneCountsByTaxonReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_counts_for_taxon_serialize(
        self,
        taxon,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if taxon is not None:
            _path_params['taxon'] = taxon
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/taxon/{taxon}/counts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_counts_for_taxon_by_post(
        self,
        v2_gene_counts_by_taxon_request: V2GeneCountsByTaxonRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2GeneCountsByTaxonReply:
        """Get gene counts by taxon

        Get gene counts by taxon in JSON format.

        :param v2_gene_counts_by_taxon_request: (required)
        :type v2_gene_counts_by_taxon_request: V2GeneCountsByTaxonRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_counts_for_taxon_by_post_serialize(
            v2_gene_counts_by_taxon_request=v2_gene_counts_by_taxon_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneCountsByTaxonReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_counts_for_taxon_by_post_with_http_info(
        self,
        v2_gene_counts_by_taxon_request: V2GeneCountsByTaxonRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2GeneCountsByTaxonReply]:
        """Get gene counts by taxon

        Get gene counts by taxon in JSON format.

        :param v2_gene_counts_by_taxon_request: (required)
        :type v2_gene_counts_by_taxon_request: V2GeneCountsByTaxonRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_counts_for_taxon_by_post_serialize(
            v2_gene_counts_by_taxon_request=v2_gene_counts_by_taxon_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneCountsByTaxonReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_counts_for_taxon_by_post_without_preload_content(
        self,
        v2_gene_counts_by_taxon_request: V2GeneCountsByTaxonRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get gene counts by taxon

        Get gene counts by taxon in JSON format.

        :param v2_gene_counts_by_taxon_request: (required)
        :type v2_gene_counts_by_taxon_request: V2GeneCountsByTaxonRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_counts_for_taxon_by_post_serialize(
            v2_gene_counts_by_taxon_request=v2_gene_counts_by_taxon_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneCountsByTaxonReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_counts_for_taxon_by_post_serialize(
        self,
        v2_gene_counts_by_taxon_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_gene_counts_by_taxon_request is not None:
            _body_params = v2_gene_counts_by_taxon_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/gene/taxon/counts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_dataset_report(
        self,
        v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene data report

        Get a gene data report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_gene_dataset_reports_request: (required)
        :type v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_report_serialize(
            v2_gene_dataset_reports_request=v2_gene_dataset_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_dataset_report_with_http_info(
        self,
        v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene data report

        Get a gene data report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_gene_dataset_reports_request: (required)
        :type v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_report_serialize(
            v2_gene_dataset_reports_request=v2_gene_dataset_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_dataset_report_without_preload_content(
        self,
        v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene data report

        Get a gene data report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_gene_dataset_reports_request: (required)
        :type v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_report_serialize(
            v2_gene_dataset_reports_request=v2_gene_dataset_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_dataset_report_serialize(
        self,
        v2_gene_dataset_reports_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_gene_dataset_reports_request is not None:
            _body_params = v2_gene_dataset_reports_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/gene/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_dataset_report_by_accession(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more RefSeq nucleotide or protein accessions")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene data report by RefSeq nucleotide or protein accession

        Get a gene data report by RefSeq nucleotide or protein accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more RefSeq nucleotide or protein accessions (required)
        :type accessions: List[str]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_report_by_accession_serialize(
            accessions=accessions,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_dataset_report_by_accession_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more RefSeq nucleotide or protein accessions")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene data report by RefSeq nucleotide or protein accession

        Get a gene data report by RefSeq nucleotide or protein accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more RefSeq nucleotide or protein accessions (required)
        :type accessions: List[str]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_report_by_accession_serialize(
            accessions=accessions,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_dataset_report_by_accession_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more RefSeq nucleotide or protein accessions")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene data report by RefSeq nucleotide or protein accession

        Get a gene data report by RefSeq nucleotide or protein accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more RefSeq nucleotide or protein accessions (required)
        :type accessions: List[str]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_report_by_accession_serialize(
            accessions=accessions,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_dataset_report_by_accession_serialize(
        self,
        accessions,
        returned_content,
        table_fields,
        table_format,
        include_tabular_header,
        page_size,
        page_token,
        query,
        types,
        sort_field,
        sort_direction,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
            'table_fields': 'multi',
            'types': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/accession/{accessions}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_dataset_report_by_tax_and_symbol(
        self,
        symbols: Annotated[List[StrictStr], Field(description="One or more gene symbols")],
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene data report by symbol and taxon

        Get a gene data report by gene symbol and taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param symbols: One or more gene symbols (required)
        :type symbols: List[str]
        :param taxon: NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol (required)
        :type taxon: str
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_report_by_tax_and_symbol_serialize(
            symbols=symbols,
            taxon=taxon,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            tax_search_subtree=tax_search_subtree,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_dataset_report_by_tax_and_symbol_with_http_info(
        self,
        symbols: Annotated[List[StrictStr], Field(description="One or more gene symbols")],
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene data report by symbol and taxon

        Get a gene data report by gene symbol and taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param symbols: One or more gene symbols (required)
        :type symbols: List[str]
        :param taxon: NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol (required)
        :type taxon: str
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_report_by_tax_and_symbol_serialize(
            symbols=symbols,
            taxon=taxon,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            tax_search_subtree=tax_search_subtree,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_dataset_report_by_tax_and_symbol_without_preload_content(
        self,
        symbols: Annotated[List[StrictStr], Field(description="One or more gene symbols")],
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene data report by symbol and taxon

        Get a gene data report by gene symbol and taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param symbols: One or more gene symbols (required)
        :type symbols: List[str]
        :param taxon: NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol (required)
        :type taxon: str
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_report_by_tax_and_symbol_serialize(
            symbols=symbols,
            taxon=taxon,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            tax_search_subtree=tax_search_subtree,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_dataset_report_by_tax_and_symbol_serialize(
        self,
        symbols,
        taxon,
        returned_content,
        table_fields,
        table_format,
        include_tabular_header,
        page_size,
        page_token,
        query,
        types,
        tax_search_subtree,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'symbols': 'csv',
            'table_fields': 'multi',
            'types': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if symbols is not None:
            _path_params['symbols'] = symbols
        if taxon is not None:
            _path_params['taxon'] = taxon
        # process the query parameters
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if tax_search_subtree is not None:
            
            _query_params.append(('tax_search_subtree', tax_search_subtree))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/symbol/{symbols}/taxon/{taxon}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_dataset_reports_by_id(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene data report by GeneID

        Get a gene data report by GeneID.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_reports_by_id_serialize(
            gene_ids=gene_ids,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_dataset_reports_by_id_with_http_info(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene data report by GeneID

        Get a gene data report by GeneID.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_reports_by_id_serialize(
            gene_ids=gene_ids,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_dataset_reports_by_id_without_preload_content(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene data report by GeneID

        Get a gene data report by GeneID.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_reports_by_id_serialize(
            gene_ids=gene_ids,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_dataset_reports_by_id_serialize(
        self,
        gene_ids,
        returned_content,
        table_fields,
        table_format,
        include_tabular_header,
        page_size,
        page_token,
        query,
        types,
        sort_field,
        sort_direction,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'gene_ids': 'csv',
            'table_fields': 'multi',
            'types': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if gene_ids is not None:
            _path_params['gene_ids'] = gene_ids
        # process the query parameters
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/id/{gene_ids}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_dataset_reports_by_locus_tag(
        self,
        locus_tags: Annotated[List[StrictStr], Field(description="Gene locus tags")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        sort_field: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene data report by locus tag

        Get a gene data report by gene locus tag. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param locus_tags: Gene locus tags (required)
        :type locus_tags: List[str]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param sort_field:
        :type sort_field: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_reports_by_locus_tag_serialize(
            locus_tags=locus_tags,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            sort_field=sort_field,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_dataset_reports_by_locus_tag_with_http_info(
        self,
        locus_tags: Annotated[List[StrictStr], Field(description="Gene locus tags")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        sort_field: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene data report by locus tag

        Get a gene data report by gene locus tag. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param locus_tags: Gene locus tags (required)
        :type locus_tags: List[str]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param sort_field:
        :type sort_field: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_reports_by_locus_tag_serialize(
            locus_tags=locus_tags,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            sort_field=sort_field,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_dataset_reports_by_locus_tag_without_preload_content(
        self,
        locus_tags: Annotated[List[StrictStr], Field(description="Gene locus tags")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        sort_field: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene data report by locus tag

        Get a gene data report by gene locus tag. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param locus_tags: Gene locus tags (required)
        :type locus_tags: List[str]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param sort_field:
        :type sort_field: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_reports_by_locus_tag_serialize(
            locus_tags=locus_tags,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            sort_field=sort_field,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_dataset_reports_by_locus_tag_serialize(
        self,
        locus_tags,
        returned_content,
        table_fields,
        table_format,
        include_tabular_header,
        page_size,
        page_token,
        query,
        types,
        sort_field,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'locus_tags': 'csv',
            'table_fields': 'multi',
            'types': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if locus_tags is not None:
            _path_params['locus_tags'] = locus_tags
        # process the query parameters
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/locus_tag/{locus_tags}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_dataset_reports_by_taxon(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene data report by taxon

        Get a gene data report by taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at (required)
        :type taxon: str
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_reports_by_taxon_serialize(
            taxon=taxon,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            tax_search_subtree=tax_search_subtree,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_dataset_reports_by_taxon_with_http_info(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene data report by taxon

        Get a gene data report by taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at (required)
        :type taxon: str
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_reports_by_taxon_serialize(
            taxon=taxon,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            tax_search_subtree=tax_search_subtree,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_dataset_reports_by_taxon_without_preload_content(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene data report by taxon

        Get a gene data report by taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at (required)
        :type taxon: str
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_dataset_reports_by_taxon_serialize(
            taxon=taxon,
            returned_content=returned_content,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            tax_search_subtree=tax_search_subtree,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_dataset_reports_by_taxon_serialize(
        self,
        taxon,
        returned_content,
        table_fields,
        table_format,
        include_tabular_header,
        page_size,
        page_token,
        query,
        types,
        tax_search_subtree,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'table_fields': 'multi',
            'types': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if taxon is not None:
            _path_params['taxon'] = taxon
        # process the query parameters
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if tax_search_subtree is not None:
            
            _query_params.append(('tax_search_subtree', tax_search_subtree))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/taxon/{taxon}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_download_summary_by_id(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        include_annotation_type: Annotated[Optional[List[V2Fasta]], Field(description="Specify which sequence files to include in the data package.")] = None,
        returned_content: Annotated[Optional[V2GeneDatasetRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        fasta_filter: Annotated[Optional[List[StrictStr]], Field(description="Limit the FASTA sequences in the datasets package to these transcript and protein accessions (deprecated)")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Limit the contents of the sequence files and tabular product report to the specified RNA and protein accessions")] = None,
        aux_report: Annotated[Optional[List[V2GeneDatasetRequestGeneDatasetReportType]], Field(description="Specify additional report files to include in the data package. The gene data report is always included, and its inclusion is not affected by this parameter.")] = None,
        tabular_reports: Annotated[Optional[List[V2GeneDatasetRequestGeneDatasetReportType]], Field(description="Specify which tabular report files to include in the data package.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2DownloadSummary:
        """Get a download summary of a gene data package by GeneID

        Get a download summary of a gene data package, including counts and estimated package size, in JSON format.

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param include_annotation_type: Specify which sequence files to include in the data package.
        :type include_annotation_type: List[V2Fasta]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetRequestContentType
        :param fasta_filter: Limit the FASTA sequences in the datasets package to these transcript and protein accessions (deprecated)
        :type fasta_filter: List[str]
        :param accession_filter: Limit the contents of the sequence files and tabular product report to the specified RNA and protein accessions
        :type accession_filter: List[str]
        :param aux_report: Specify additional report files to include in the data package. The gene data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2GeneDatasetRequestGeneDatasetReportType]
        :param tabular_reports: Specify which tabular report files to include in the data package.
        :type tabular_reports: List[V2GeneDatasetRequestGeneDatasetReportType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_download_summary_by_id_serialize(
            gene_ids=gene_ids,
            include_annotation_type=include_annotation_type,
            returned_content=returned_content,
            fasta_filter=fasta_filter,
            accession_filter=accession_filter,
            aux_report=aux_report,
            tabular_reports=tabular_reports,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_download_summary_by_id_with_http_info(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        include_annotation_type: Annotated[Optional[List[V2Fasta]], Field(description="Specify which sequence files to include in the data package.")] = None,
        returned_content: Annotated[Optional[V2GeneDatasetRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        fasta_filter: Annotated[Optional[List[StrictStr]], Field(description="Limit the FASTA sequences in the datasets package to these transcript and protein accessions (deprecated)")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Limit the contents of the sequence files and tabular product report to the specified RNA and protein accessions")] = None,
        aux_report: Annotated[Optional[List[V2GeneDatasetRequestGeneDatasetReportType]], Field(description="Specify additional report files to include in the data package. The gene data report is always included, and its inclusion is not affected by this parameter.")] = None,
        tabular_reports: Annotated[Optional[List[V2GeneDatasetRequestGeneDatasetReportType]], Field(description="Specify which tabular report files to include in the data package.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2DownloadSummary]:
        """Get a download summary of a gene data package by GeneID

        Get a download summary of a gene data package, including counts and estimated package size, in JSON format.

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param include_annotation_type: Specify which sequence files to include in the data package.
        :type include_annotation_type: List[V2Fasta]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetRequestContentType
        :param fasta_filter: Limit the FASTA sequences in the datasets package to these transcript and protein accessions (deprecated)
        :type fasta_filter: List[str]
        :param accession_filter: Limit the contents of the sequence files and tabular product report to the specified RNA and protein accessions
        :type accession_filter: List[str]
        :param aux_report: Specify additional report files to include in the data package. The gene data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2GeneDatasetRequestGeneDatasetReportType]
        :param tabular_reports: Specify which tabular report files to include in the data package.
        :type tabular_reports: List[V2GeneDatasetRequestGeneDatasetReportType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_download_summary_by_id_serialize(
            gene_ids=gene_ids,
            include_annotation_type=include_annotation_type,
            returned_content=returned_content,
            fasta_filter=fasta_filter,
            accession_filter=accession_filter,
            aux_report=aux_report,
            tabular_reports=tabular_reports,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_download_summary_by_id_without_preload_content(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        include_annotation_type: Annotated[Optional[List[V2Fasta]], Field(description="Specify which sequence files to include in the data package.")] = None,
        returned_content: Annotated[Optional[V2GeneDatasetRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        fasta_filter: Annotated[Optional[List[StrictStr]], Field(description="Limit the FASTA sequences in the datasets package to these transcript and protein accessions (deprecated)")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Limit the contents of the sequence files and tabular product report to the specified RNA and protein accessions")] = None,
        aux_report: Annotated[Optional[List[V2GeneDatasetRequestGeneDatasetReportType]], Field(description="Specify additional report files to include in the data package. The gene data report is always included, and its inclusion is not affected by this parameter.")] = None,
        tabular_reports: Annotated[Optional[List[V2GeneDatasetRequestGeneDatasetReportType]], Field(description="Specify which tabular report files to include in the data package.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a download summary of a gene data package by GeneID

        Get a download summary of a gene data package, including counts and estimated package size, in JSON format.

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param include_annotation_type: Specify which sequence files to include in the data package.
        :type include_annotation_type: List[V2Fasta]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetRequestContentType
        :param fasta_filter: Limit the FASTA sequences in the datasets package to these transcript and protein accessions (deprecated)
        :type fasta_filter: List[str]
        :param accession_filter: Limit the contents of the sequence files and tabular product report to the specified RNA and protein accessions
        :type accession_filter: List[str]
        :param aux_report: Specify additional report files to include in the data package. The gene data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2GeneDatasetRequestGeneDatasetReportType]
        :param tabular_reports: Specify which tabular report files to include in the data package.
        :type tabular_reports: List[V2GeneDatasetRequestGeneDatasetReportType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_download_summary_by_id_serialize(
            gene_ids=gene_ids,
            include_annotation_type=include_annotation_type,
            returned_content=returned_content,
            fasta_filter=fasta_filter,
            accession_filter=accession_filter,
            aux_report=aux_report,
            tabular_reports=tabular_reports,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_download_summary_by_id_serialize(
        self,
        gene_ids,
        include_annotation_type,
        returned_content,
        fasta_filter,
        accession_filter,
        aux_report,
        tabular_reports,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'gene_ids': 'csv',
            'include_annotation_type': 'multi',
            'fasta_filter': 'multi',
            'accession_filter': 'multi',
            'aux_report': 'multi',
            'tabular_reports': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if gene_ids is not None:
            _path_params['gene_ids'] = gene_ids
        # process the query parameters
        if include_annotation_type is not None:
            
            _query_params.append(('include_annotation_type', include_annotation_type))
            
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if fasta_filter is not None:
            
            _query_params.append(('fasta_filter', fasta_filter))
            
        if accession_filter is not None:
            
            _query_params.append(('accession_filter', accession_filter))
            
        if aux_report is not None:
            
            _query_params.append(('aux_report', aux_report))
            
        if tabular_reports is not None:
            
            _query_params.append(('tabular_reports', tabular_reports))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/id/{gene_ids}/download_summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_download_summary_by_post(
        self,
        v2_gene_dataset_request: V2GeneDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2DownloadSummary:
        """Get a download summary of a gene data package

        Get a download summary of a gene data package, including counts and estimated package size, in JSON format.

        :param v2_gene_dataset_request: (required)
        :type v2_gene_dataset_request: V2GeneDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_download_summary_by_post_serialize(
            v2_gene_dataset_request=v2_gene_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_download_summary_by_post_with_http_info(
        self,
        v2_gene_dataset_request: V2GeneDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2DownloadSummary]:
        """Get a download summary of a gene data package

        Get a download summary of a gene data package, including counts and estimated package size, in JSON format.

        :param v2_gene_dataset_request: (required)
        :type v2_gene_dataset_request: V2GeneDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_download_summary_by_post_serialize(
            v2_gene_dataset_request=v2_gene_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_download_summary_by_post_without_preload_content(
        self,
        v2_gene_dataset_request: V2GeneDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a download summary of a gene data package

        Get a download summary of a gene data package, including counts and estimated package size, in JSON format.

        :param v2_gene_dataset_request: (required)
        :type v2_gene_dataset_request: V2GeneDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_download_summary_by_post_serialize(
            v2_gene_dataset_request=v2_gene_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_download_summary_by_post_serialize(
        self,
        v2_gene_dataset_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_gene_dataset_request is not None:
            _body_params = v2_gene_dataset_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/gene/download_summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_links_by_id(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs, limited to 100")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2GeneLinksReply:
        """Get gene links by GeneID

        Get links to available gene resources in JSON format.

        :param gene_ids: One or more NCBI GeneIDs, limited to 100 (required)
        :type gene_ids: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_links_by_id_serialize(
            gene_ids=gene_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneLinksReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_links_by_id_with_http_info(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs, limited to 100")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2GeneLinksReply]:
        """Get gene links by GeneID

        Get links to available gene resources in JSON format.

        :param gene_ids: One or more NCBI GeneIDs, limited to 100 (required)
        :type gene_ids: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_links_by_id_serialize(
            gene_ids=gene_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneLinksReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_links_by_id_without_preload_content(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs, limited to 100")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get gene links by GeneID

        Get links to available gene resources in JSON format.

        :param gene_ids: One or more NCBI GeneIDs, limited to 100 (required)
        :type gene_ids: List[int]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_links_by_id_serialize(
            gene_ids=gene_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneLinksReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_links_by_id_serialize(
        self,
        gene_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'gene_ids': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if gene_ids is not None:
            _path_params['gene_ids'] = gene_ids
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/id/{gene_ids}/links',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_links_by_id_by_post(
        self,
        v2_gene_links_request: V2GeneLinksRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2GeneLinksReply:
        """Get gene links by GeneID

        Get links to available gene resources in JSON format.

        :param v2_gene_links_request: (required)
        :type v2_gene_links_request: V2GeneLinksRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_links_by_id_by_post_serialize(
            v2_gene_links_request=v2_gene_links_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneLinksReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_links_by_id_by_post_with_http_info(
        self,
        v2_gene_links_request: V2GeneLinksRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2GeneLinksReply]:
        """Get gene links by GeneID

        Get links to available gene resources in JSON format.

        :param v2_gene_links_request: (required)
        :type v2_gene_links_request: V2GeneLinksRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_links_by_id_by_post_serialize(
            v2_gene_links_request=v2_gene_links_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneLinksReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_links_by_id_by_post_without_preload_content(
        self,
        v2_gene_links_request: V2GeneLinksRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get gene links by GeneID

        Get links to available gene resources in JSON format.

        :param v2_gene_links_request: (required)
        :type v2_gene_links_request: V2GeneLinksRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_links_by_id_by_post_serialize(
            v2_gene_links_request=v2_gene_links_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GeneLinksReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_links_by_id_by_post_serialize(
        self,
        v2_gene_links_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_gene_links_request is not None:
            _body_params = v2_gene_links_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/gene/links',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_metadata_by_accession(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more RefSeq nucleotide or protein accessions")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        locus_tags: Annotated[Optional[List[StrictStr]], Field(description="Gene locus tags")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get gene metadata by RefSeq Accession (deprecated)

        Get a gene summary by RefSeq Accession. By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param accessions: One or more RefSeq nucleotide or protein accessions (required)
        :type accessions: List[str]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param locus_tags: Gene locus tags
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_metadata_by_accession_serialize(
            accessions=accessions,
            returned_content=returned_content,
            locus_tags=locus_tags,
            table_fields=table_fields,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_metadata_by_accession_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more RefSeq nucleotide or protein accessions")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        locus_tags: Annotated[Optional[List[StrictStr]], Field(description="Gene locus tags")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get gene metadata by RefSeq Accession (deprecated)

        Get a gene summary by RefSeq Accession. By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param accessions: One or more RefSeq nucleotide or protein accessions (required)
        :type accessions: List[str]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param locus_tags: Gene locus tags
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_metadata_by_accession_serialize(
            accessions=accessions,
            returned_content=returned_content,
            locus_tags=locus_tags,
            table_fields=table_fields,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_metadata_by_accession_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more RefSeq nucleotide or protein accessions")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        locus_tags: Annotated[Optional[List[StrictStr]], Field(description="Gene locus tags")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get gene metadata by RefSeq Accession (deprecated)

        Get a gene summary by RefSeq Accession. By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param accessions: One or more RefSeq nucleotide or protein accessions (required)
        :type accessions: List[str]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param locus_tags: Gene locus tags
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_metadata_by_accession_serialize(
            accessions=accessions,
            returned_content=returned_content,
            locus_tags=locus_tags,
            table_fields=table_fields,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_metadata_by_accession_serialize(
        self,
        accessions,
        returned_content,
        locus_tags,
        table_fields,
        include_tabular_header,
        page_size,
        page_token,
        accession_filter,
        tax_search_subtree,
        sort_field,
        sort_direction,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
            'locus_tags': 'multi',
            'table_fields': 'multi',
            'accession_filter': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if locus_tags is not None:
            
            _query_params.append(('locus_tags', locus_tags))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if accession_filter is not None:
            
            _query_params.append(('accession_filter', accession_filter))
            
        if tax_search_subtree is not None:
            
            _query_params.append(('tax_search_subtree', tax_search_subtree))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/accession/{accessions}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_metadata_by_post(
        self,
        v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get gene metadata as JSON (deprecated)

        Get a gene summary. By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param v2_gene_dataset_reports_request: (required)
        :type v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_metadata_by_post_serialize(
            v2_gene_dataset_reports_request=v2_gene_dataset_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_metadata_by_post_with_http_info(
        self,
        v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get gene metadata as JSON (deprecated)

        Get a gene summary. By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param v2_gene_dataset_reports_request: (required)
        :type v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_metadata_by_post_serialize(
            v2_gene_dataset_reports_request=v2_gene_dataset_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_metadata_by_post_without_preload_content(
        self,
        v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get gene metadata as JSON (deprecated)

        Get a gene summary. By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param v2_gene_dataset_reports_request: (required)
        :type v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_metadata_by_post_serialize(
            v2_gene_dataset_reports_request=v2_gene_dataset_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_metadata_by_post_serialize(
        self,
        v2_gene_dataset_reports_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_gene_dataset_reports_request is not None:
            _body_params = v2_gene_dataset_reports_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/gene',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_metadata_by_tax_and_symbol(
        self,
        symbols: Annotated[List[StrictStr], Field(description="One or more gene symbols")],
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        locus_tags: Annotated[Optional[List[StrictStr]], Field(description="Gene locus tags")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get gene metadata by gene symbol (deprecated)

        Get a gene summary by by gene symbol. By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param symbols: One or more gene symbols (required)
        :type symbols: List[str]
        :param taxon: NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol (required)
        :type taxon: str
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param locus_tags: Gene locus tags
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_metadata_by_tax_and_symbol_serialize(
            symbols=symbols,
            taxon=taxon,
            returned_content=returned_content,
            locus_tags=locus_tags,
            table_fields=table_fields,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_metadata_by_tax_and_symbol_with_http_info(
        self,
        symbols: Annotated[List[StrictStr], Field(description="One or more gene symbols")],
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        locus_tags: Annotated[Optional[List[StrictStr]], Field(description="Gene locus tags")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get gene metadata by gene symbol (deprecated)

        Get a gene summary by by gene symbol. By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param symbols: One or more gene symbols (required)
        :type symbols: List[str]
        :param taxon: NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol (required)
        :type taxon: str
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param locus_tags: Gene locus tags
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_metadata_by_tax_and_symbol_serialize(
            symbols=symbols,
            taxon=taxon,
            returned_content=returned_content,
            locus_tags=locus_tags,
            table_fields=table_fields,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_metadata_by_tax_and_symbol_without_preload_content(
        self,
        symbols: Annotated[List[StrictStr], Field(description="One or more gene symbols")],
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        locus_tags: Annotated[Optional[List[StrictStr]], Field(description="Gene locus tags")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get gene metadata by gene symbol (deprecated)

        Get a gene summary by by gene symbol. By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param symbols: One or more gene symbols (required)
        :type symbols: List[str]
        :param taxon: NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol (required)
        :type taxon: str
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param locus_tags: Gene locus tags
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_metadata_by_tax_and_symbol_serialize(
            symbols=symbols,
            taxon=taxon,
            returned_content=returned_content,
            locus_tags=locus_tags,
            table_fields=table_fields,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_metadata_by_tax_and_symbol_serialize(
        self,
        symbols,
        taxon,
        returned_content,
        locus_tags,
        table_fields,
        include_tabular_header,
        page_size,
        page_token,
        accession_filter,
        tax_search_subtree,
        sort_field,
        sort_direction,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'symbols': 'csv',
            'locus_tags': 'multi',
            'table_fields': 'multi',
            'accession_filter': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if symbols is not None:
            _path_params['symbols'] = symbols
        if taxon is not None:
            _path_params['taxon'] = taxon
        # process the query parameters
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if locus_tags is not None:
            
            _query_params.append(('locus_tags', locus_tags))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if accession_filter is not None:
            
            _query_params.append(('accession_filter', accession_filter))
            
        if tax_search_subtree is not None:
            
            _query_params.append(('tax_search_subtree', tax_search_subtree))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/symbol/{symbols}/taxon/{taxon}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_orthologs_by_id(
        self,
        gene_id: Annotated[StrictInt, Field(description="One or more NCBI GeneIDs")],
        returned_content: Annotated[Optional[V2OrthologRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        taxon_filter: Annotated[Optional[List[StrictStr]], Field(description="Limit to genes from the specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene data report for a gene ortholog set by GeneID

        Get a gene data report for a gene ortholog set by GeneID in JSON format.

        :param gene_id: One or more NCBI GeneIDs (required)
        :type gene_id: int
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2OrthologRequestContentType
        :param taxon_filter: Limit to genes from the specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.
        :type taxon_filter: List[str]
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_orthologs_by_id_serialize(
            gene_id=gene_id,
            returned_content=returned_content,
            taxon_filter=taxon_filter,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_orthologs_by_id_with_http_info(
        self,
        gene_id: Annotated[StrictInt, Field(description="One or more NCBI GeneIDs")],
        returned_content: Annotated[Optional[V2OrthologRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        taxon_filter: Annotated[Optional[List[StrictStr]], Field(description="Limit to genes from the specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene data report for a gene ortholog set by GeneID

        Get a gene data report for a gene ortholog set by GeneID in JSON format.

        :param gene_id: One or more NCBI GeneIDs (required)
        :type gene_id: int
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2OrthologRequestContentType
        :param taxon_filter: Limit to genes from the specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.
        :type taxon_filter: List[str]
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_orthologs_by_id_serialize(
            gene_id=gene_id,
            returned_content=returned_content,
            taxon_filter=taxon_filter,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_orthologs_by_id_without_preload_content(
        self,
        gene_id: Annotated[StrictInt, Field(description="One or more NCBI GeneIDs")],
        returned_content: Annotated[Optional[V2OrthologRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        taxon_filter: Annotated[Optional[List[StrictStr]], Field(description="Limit to genes from the specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene data report for a gene ortholog set by GeneID

        Get a gene data report for a gene ortholog set by GeneID in JSON format.

        :param gene_id: One or more NCBI GeneIDs (required)
        :type gene_id: int
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2OrthologRequestContentType
        :param taxon_filter: Limit to genes from the specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.
        :type taxon_filter: List[str]
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_orthologs_by_id_serialize(
            gene_id=gene_id,
            returned_content=returned_content,
            taxon_filter=taxon_filter,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_orthologs_by_id_serialize(
        self,
        gene_id,
        returned_content,
        taxon_filter,
        page_size,
        page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'taxon_filter': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if gene_id is not None:
            _path_params['gene_id'] = gene_id
        # process the query parameters
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if taxon_filter is not None:
            
            _query_params.append(('taxon_filter', taxon_filter))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/id/{gene_id}/orthologs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_orthologs_by_post(
        self,
        v2_ortholog_request: V2OrthologRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene data report for a gene ortholog set by GeneID

        Get a gene data report for a gene ortholog set by GeneID in JSON format.

        :param v2_ortholog_request: (required)
        :type v2_ortholog_request: V2OrthologRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_orthologs_by_post_serialize(
            v2_ortholog_request=v2_ortholog_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_orthologs_by_post_with_http_info(
        self,
        v2_ortholog_request: V2OrthologRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene data report for a gene ortholog set by GeneID

        Get a gene data report for a gene ortholog set by GeneID in JSON format.

        :param v2_ortholog_request: (required)
        :type v2_ortholog_request: V2OrthologRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_orthologs_by_post_serialize(
            v2_ortholog_request=v2_ortholog_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_orthologs_by_post_without_preload_content(
        self,
        v2_ortholog_request: V2OrthologRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene data report for a gene ortholog set by GeneID

        Get a gene data report for a gene ortholog set by GeneID in JSON format.

        :param v2_ortholog_request: (required)
        :type v2_ortholog_request: V2OrthologRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_orthologs_by_post_serialize(
            v2_ortholog_request=v2_ortholog_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_orthologs_by_post_serialize(
        self,
        v2_ortholog_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_ortholog_request is not None:
            _body_params = v2_ortholog_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/gene/orthologs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_product_report(
        self,
        v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene product report

        Get a gene product report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_gene_dataset_reports_request: (required)
        :type v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_report_serialize(
            v2_gene_dataset_reports_request=v2_gene_dataset_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_product_report_with_http_info(
        self,
        v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene product report

        Get a gene product report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_gene_dataset_reports_request: (required)
        :type v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_report_serialize(
            v2_gene_dataset_reports_request=v2_gene_dataset_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_product_report_without_preload_content(
        self,
        v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene product report

        Get a gene product report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_gene_dataset_reports_request: (required)
        :type v2_gene_dataset_reports_request: V2GeneDatasetReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_report_serialize(
            v2_gene_dataset_reports_request=v2_gene_dataset_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_product_report_serialize(
        self,
        v2_gene_dataset_reports_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_gene_dataset_reports_request is not None:
            _body_params = v2_gene_dataset_reports_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/gene/product_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_product_report_by_accession(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more RefSeq nucleotide or protein accessions")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene product report by RefSeq nucleotide or protein accession

        Get a gene product report by RefSeq nucleotide or protein accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more RefSeq nucleotide or protein accessions (required)
        :type accessions: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_report_by_accession_serialize(
            accessions=accessions,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_product_report_by_accession_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more RefSeq nucleotide or protein accessions")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene product report by RefSeq nucleotide or protein accession

        Get a gene product report by RefSeq nucleotide or protein accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more RefSeq nucleotide or protein accessions (required)
        :type accessions: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_report_by_accession_serialize(
            accessions=accessions,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_product_report_by_accession_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more RefSeq nucleotide or protein accessions")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene product report by RefSeq nucleotide or protein accession

        Get a gene product report by RefSeq nucleotide or protein accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more RefSeq nucleotide or protein accessions (required)
        :type accessions: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_report_by_accession_serialize(
            accessions=accessions,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_product_report_by_accession_serialize(
        self,
        accessions,
        table_fields,
        table_format,
        include_tabular_header,
        page_size,
        page_token,
        query,
        types,
        accession_filter,
        tax_search_subtree,
        sort_field,
        sort_direction,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
            'table_fields': 'multi',
            'types': 'multi',
            'accession_filter': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if accession_filter is not None:
            
            _query_params.append(('accession_filter', accession_filter))
            
        if tax_search_subtree is not None:
            
            _query_params.append(('tax_search_subtree', tax_search_subtree))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/accession/{accessions}/product_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_product_report_by_tax_and_symbol(
        self,
        symbols: Annotated[List[StrictStr], Field(description="One or more gene symbols")],
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene product report by symbol and taxon

        Get a gene product report by symbol and taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param symbols: One or more gene symbols (required)
        :type symbols: List[str]
        :param taxon: NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol (required)
        :type taxon: str
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_report_by_tax_and_symbol_serialize(
            symbols=symbols,
            taxon=taxon,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            tax_search_subtree=tax_search_subtree,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_product_report_by_tax_and_symbol_with_http_info(
        self,
        symbols: Annotated[List[StrictStr], Field(description="One or more gene symbols")],
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene product report by symbol and taxon

        Get a gene product report by symbol and taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param symbols: One or more gene symbols (required)
        :type symbols: List[str]
        :param taxon: NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol (required)
        :type taxon: str
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_report_by_tax_and_symbol_serialize(
            symbols=symbols,
            taxon=taxon,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            tax_search_subtree=tax_search_subtree,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_product_report_by_tax_and_symbol_without_preload_content(
        self,
        symbols: Annotated[List[StrictStr], Field(description="One or more gene symbols")],
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene product report by symbol and taxon

        Get a gene product report by symbol and taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param symbols: One or more gene symbols (required)
        :type symbols: List[str]
        :param taxon: NCBI Taxonomy ID or name (common or scientific, any taxonomic rank) for the provided gene symbol (required)
        :type taxon: str
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_report_by_tax_and_symbol_serialize(
            symbols=symbols,
            taxon=taxon,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            tax_search_subtree=tax_search_subtree,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_product_report_by_tax_and_symbol_serialize(
        self,
        symbols,
        taxon,
        table_fields,
        table_format,
        include_tabular_header,
        page_size,
        page_token,
        query,
        types,
        tax_search_subtree,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'symbols': 'csv',
            'table_fields': 'multi',
            'types': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if symbols is not None:
            _path_params['symbols'] = symbols
        if taxon is not None:
            _path_params['taxon'] = taxon
        # process the query parameters
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if tax_search_subtree is not None:
            
            _query_params.append(('tax_search_subtree', tax_search_subtree))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/symbol/{symbols}/taxon/{taxon}/product_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_product_reports_by_id(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene product report by GeneID

        Get a gene product report by GeneID. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_reports_by_id_serialize(
            gene_ids=gene_ids,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            accession_filter=accession_filter,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_product_reports_by_id_with_http_info(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene product report by GeneID

        Get a gene product report by GeneID. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_reports_by_id_serialize(
            gene_ids=gene_ids,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            accession_filter=accession_filter,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_product_reports_by_id_without_preload_content(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene product report by GeneID

        Get a gene product report by GeneID. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_reports_by_id_serialize(
            gene_ids=gene_ids,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            accession_filter=accession_filter,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_product_reports_by_id_serialize(
        self,
        gene_ids,
        table_fields,
        table_format,
        include_tabular_header,
        page_size,
        page_token,
        query,
        types,
        accession_filter,
        sort_field,
        sort_direction,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'gene_ids': 'csv',
            'table_fields': 'multi',
            'types': 'multi',
            'accession_filter': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if gene_ids is not None:
            _path_params['gene_ids'] = gene_ids
        # process the query parameters
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if accession_filter is not None:
            
            _query_params.append(('accession_filter', accession_filter))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/id/{gene_ids}/product_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_product_reports_by_locus_tags(
        self,
        locus_tags: Annotated[List[StrictStr], Field(description="Gene locus tags")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        sort_field: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene product report by locus tag

        Get a gene product report by gene locus tag. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param locus_tags: Gene locus tags (required)
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param sort_field:
        :type sort_field: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_reports_by_locus_tags_serialize(
            locus_tags=locus_tags,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            accession_filter=accession_filter,
            sort_field=sort_field,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_product_reports_by_locus_tags_with_http_info(
        self,
        locus_tags: Annotated[List[StrictStr], Field(description="Gene locus tags")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        sort_field: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene product report by locus tag

        Get a gene product report by gene locus tag. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param locus_tags: Gene locus tags (required)
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param sort_field:
        :type sort_field: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_reports_by_locus_tags_serialize(
            locus_tags=locus_tags,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            accession_filter=accession_filter,
            sort_field=sort_field,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_product_reports_by_locus_tags_without_preload_content(
        self,
        locus_tags: Annotated[List[StrictStr], Field(description="Gene locus tags")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        sort_field: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene product report by locus tag

        Get a gene product report by gene locus tag. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param locus_tags: Gene locus tags (required)
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param sort_field:
        :type sort_field: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_reports_by_locus_tags_serialize(
            locus_tags=locus_tags,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            accession_filter=accession_filter,
            sort_field=sort_field,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_product_reports_by_locus_tags_serialize(
        self,
        locus_tags,
        table_fields,
        table_format,
        include_tabular_header,
        page_size,
        page_token,
        query,
        types,
        accession_filter,
        sort_field,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'locus_tags': 'csv',
            'table_fields': 'multi',
            'types': 'multi',
            'accession_filter': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if locus_tags is not None:
            _path_params['locus_tags'] = locus_tags
        # process the query parameters
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if accession_filter is not None:
            
            _query_params.append(('accession_filter', accession_filter))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/locus_tag/{locus_tags}/product_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_product_reports_by_taxon(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get a gene product report by taxon

        Get a gene product report by taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at (required)
        :type taxon: str
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_reports_by_taxon_serialize(
            taxon=taxon,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            tax_search_subtree=tax_search_subtree,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_product_reports_by_taxon_with_http_info(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get a gene product report by taxon

        Get a gene product report by taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at (required)
        :type taxon: str
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_reports_by_taxon_serialize(
            taxon=taxon,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            tax_search_subtree=tax_search_subtree,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_product_reports_by_taxon_without_preload_content(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at")],
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        table_format: Annotated[Optional[StrictStr], Field(description="Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a gene product report by taxon

        Get a gene product report by taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at (required)
        :type taxon: str
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param table_format: Specify a predefined set of fields for the tabular report using built-in templates. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_format: str
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_product_reports_by_taxon_serialize(
            taxon=taxon,
            table_fields=table_fields,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            tax_search_subtree=tax_search_subtree,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_product_reports_by_taxon_serialize(
        self,
        taxon,
        table_fields,
        table_format,
        include_tabular_header,
        page_size,
        page_token,
        query,
        types,
        tax_search_subtree,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'table_fields': 'multi',
            'types': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if taxon is not None:
            _path_params['taxon'] = taxon
        # process the query parameters
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if tax_search_subtree is not None:
            
            _query_params.append(('tax_search_subtree', tax_search_subtree))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/taxon/{taxon}/product_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_reports_by_id(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        locus_tags: Annotated[Optional[List[StrictStr]], Field(description="Gene locus tags")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get gene reports by GeneID (deprecated)

        Get a gene summary by GeneID. By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param locus_tags: Gene locus tags
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_reports_by_id_serialize(
            gene_ids=gene_ids,
            returned_content=returned_content,
            locus_tags=locus_tags,
            table_fields=table_fields,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_reports_by_id_with_http_info(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        locus_tags: Annotated[Optional[List[StrictStr]], Field(description="Gene locus tags")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get gene reports by GeneID (deprecated)

        Get a gene summary by GeneID. By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param locus_tags: Gene locus tags
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_reports_by_id_serialize(
            gene_ids=gene_ids,
            returned_content=returned_content,
            locus_tags=locus_tags,
            table_fields=table_fields,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_reports_by_id_without_preload_content(
        self,
        gene_ids: Annotated[List[StrictInt], Field(description="One or more NCBI GeneIDs")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        locus_tags: Annotated[Optional[List[StrictStr]], Field(description="Gene locus tags")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get gene reports by GeneID (deprecated)

        Get a gene summary by GeneID. By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param gene_ids: One or more NCBI GeneIDs (required)
        :type gene_ids: List[int]
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param locus_tags: Gene locus tags
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_reports_by_id_serialize(
            gene_ids=gene_ids,
            returned_content=returned_content,
            locus_tags=locus_tags,
            table_fields=table_fields,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_reports_by_id_serialize(
        self,
        gene_ids,
        returned_content,
        locus_tags,
        table_fields,
        include_tabular_header,
        page_size,
        page_token,
        accession_filter,
        tax_search_subtree,
        sort_field,
        sort_direction,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'gene_ids': 'csv',
            'locus_tags': 'multi',
            'table_fields': 'multi',
            'accession_filter': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if gene_ids is not None:
            _path_params['gene_ids'] = gene_ids
        # process the query parameters
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if locus_tags is not None:
            
            _query_params.append(('locus_tags', locus_tags))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if accession_filter is not None:
            
            _query_params.append(('accession_filter', accession_filter))
            
        if tax_search_subtree is not None:
            
            _query_params.append(('tax_search_subtree', tax_search_subtree))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/id/{gene_ids}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def gene_reports_by_taxon(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        locus_tags: Annotated[Optional[List[StrictStr]], Field(description="Gene locus tags")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGeneDataReportPage:
        """Get gene reports by taxonomic identifier (deprecated)

        Get a gene summary for a specified NCBI Taxonomy ID or name (common or scientific). By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param taxon: NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at (required)
        :type taxon: str
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param locus_tags: Gene locus tags
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_reports_by_taxon_serialize(
            taxon=taxon,
            returned_content=returned_content,
            locus_tags=locus_tags,
            table_fields=table_fields,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def gene_reports_by_taxon_with_http_info(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        locus_tags: Annotated[Optional[List[StrictStr]], Field(description="Gene locus tags")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGeneDataReportPage]:
        """Get gene reports by taxonomic identifier (deprecated)

        Get a gene summary for a specified NCBI Taxonomy ID or name (common or scientific). By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param taxon: NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at (required)
        :type taxon: str
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param locus_tags: Gene locus tags
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_reports_by_taxon_serialize(
            taxon=taxon,
            returned_content=returned_content,
            locus_tags=locus_tags,
            table_fields=table_fields,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def gene_reports_by_taxon_without_preload_content(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at")],
        returned_content: Annotated[Optional[V2GeneDatasetReportsRequestContentType], Field(description="Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.")] = None,
        locus_tags: Annotated[Optional[List[StrictStr]], Field(description="Gene locus tags")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.")] = None,
        types: Annotated[Optional[List[V2GeneType]], Field(description="Limit to genes matching the specified gene type.")] = None,
        accession_filter: Annotated[Optional[List[StrictStr]], Field(description="Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        tax_search_subtree: Annotated[Optional[StrictBool], Field(description="If true, include genes from taxonomic ranks below the requested taxon.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get gene reports by taxonomic identifier (deprecated)

        Get a gene summary for a specified NCBI Taxonomy ID or name (common or scientific). By default, in paged JSON format, but also available as tabular (accept: text/tab-separated-values) or json-lines (accept: application/x-ndjson)

        :param taxon: NCBI Taxonomy ID or name (common or scientific) that the genes are annotated at (required)
        :type taxon: str
        :param returned_content: Return complete gene reports, or abbreviated reports with either GeneIDs only or GeneIDs, transcript and protein counts.
        :type returned_content: V2GeneDatasetReportsRequestContentType
        :param locus_tags: Gene locus tags
        :type locus_tags: List[str]
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [Create a table from the gene data reports](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/gene-data-reports/). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_size: The maximum number of gene reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param query: Limit to genes that match the specified gene symbol, name (description), alias, locus tag or protein name.
        :type query: str
        :param types: Limit to genes matching the specified gene type.
        :type types: List[V2GeneType]
        :param accession_filter: Filter tabular product report to only include the selected accessions. Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type accession_filter: List[str]
        :param tax_search_subtree: If true, include genes from taxonomic ranks below the requested taxon.
        :type tax_search_subtree: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._gene_reports_by_taxon_serialize(
            taxon=taxon,
            returned_content=returned_content,
            locus_tags=locus_tags,
            table_fields=table_fields,
            include_tabular_header=include_tabular_header,
            page_size=page_size,
            page_token=page_token,
            query=query,
            types=types,
            accession_filter=accession_filter,
            tax_search_subtree=tax_search_subtree,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGeneDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _gene_reports_by_taxon_serialize(
        self,
        taxon,
        returned_content,
        locus_tags,
        table_fields,
        include_tabular_header,
        page_size,
        page_token,
        query,
        types,
        accession_filter,
        tax_search_subtree,
        sort_field,
        sort_direction,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'locus_tags': 'multi',
            'table_fields': 'multi',
            'types': 'multi',
            'accession_filter': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if taxon is not None:
            _path_params['taxon'] = taxon
        # process the query parameters
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if locus_tags is not None:
            
            _query_params.append(('locus_tags', locus_tags))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if accession_filter is not None:
            
            _query_params.append(('accession_filter', accession_filter))
            
        if tax_search_subtree is not None:
            
            _query_params.append(('tax_search_subtree', tax_search_subtree))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/gene/taxon/{taxon}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


