# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr
from typing import List, Optional, Tuple, Union
from typing_extensions import Annotated
from ncbi.datasets.openapi.models.v2_annotation_for_assembly_type import V2AnnotationForAssemblyType
from ncbi.datasets.openapi.models.v2_assembly_accessions import V2AssemblyAccessions
from ncbi.datasets.openapi.models.v2_assembly_check_m_histogram_reply import V2AssemblyCheckMHistogramReply
from ncbi.datasets.openapi.models.v2_assembly_check_m_histogram_request import V2AssemblyCheckMHistogramRequest
from ncbi.datasets.openapi.models.v2_assembly_dataset_availability import V2AssemblyDatasetAvailability
from ncbi.datasets.openapi.models.v2_assembly_dataset_descriptors_filter_assembly_source import V2AssemblyDatasetDescriptorsFilterAssemblySource
from ncbi.datasets.openapi.models.v2_assembly_dataset_descriptors_filter_assembly_version import V2AssemblyDatasetDescriptorsFilterAssemblyVersion
from ncbi.datasets.openapi.models.v2_assembly_dataset_descriptors_filter_metagenome_derived_filter import V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
from ncbi.datasets.openapi.models.v2_assembly_dataset_descriptors_filter_type_material_category import V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
from ncbi.datasets.openapi.models.v2_assembly_dataset_reports_request import V2AssemblyDatasetReportsRequest
from ncbi.datasets.openapi.models.v2_assembly_dataset_reports_request_content_type import V2AssemblyDatasetReportsRequestContentType
from ncbi.datasets.openapi.models.v2_assembly_dataset_request import V2AssemblyDatasetRequest
from ncbi.datasets.openapi.models.v2_assembly_dataset_request_resolution import V2AssemblyDatasetRequestResolution
from ncbi.datasets.openapi.models.v2_assembly_links_reply import V2AssemblyLinksReply
from ncbi.datasets.openapi.models.v2_assembly_links_request import V2AssemblyLinksRequest
from ncbi.datasets.openapi.models.v2_assembly_revision_history import V2AssemblyRevisionHistory
from ncbi.datasets.openapi.models.v2_assembly_revision_history_request import V2AssemblyRevisionHistoryRequest
from ncbi.datasets.openapi.models.v2_assembly_sequence_reports_request import V2AssemblySequenceReportsRequest
from ncbi.datasets.openapi.models.v2_download_summary import V2DownloadSummary
from ncbi.datasets.openapi.models.v2_genome_annotation_request import V2GenomeAnnotationRequest
from ncbi.datasets.openapi.models.v2_genome_annotation_request_annotation_type import V2GenomeAnnotationRequestAnnotationType
from ncbi.datasets.openapi.models.v2_genome_annotation_request_genome_annotation_table_format import V2GenomeAnnotationRequestGenomeAnnotationTableFormat
from ncbi.datasets.openapi.models.v2_genome_annotation_table_summary_reply import V2GenomeAnnotationTableSummaryReply
from ncbi.datasets.openapi.models.v2_include_tabular_header import V2IncludeTabularHeader
from ncbi.datasets.openapi.models.v2_sequence_accession_request import V2SequenceAccessionRequest
from ncbi.datasets.openapi.models.v2_sequence_report_page import V2SequenceReportPage
from ncbi.datasets.openapi.models.v2_sort_direction import V2SortDirection
from ncbi.datasets.openapi.models.v2reports_assembly_data_report_page import V2reportsAssemblyDataReportPage
from ncbi.datasets.openapi.models.v2reports_assembly_level import V2reportsAssemblyLevel
from ncbi.datasets.openapi.models.v2reports_genome_annotation_report_page import V2reportsGenomeAnnotationReportPage

from ncbi.datasets.openapi.api_client import ApiClient, RequestSerialized
from ncbi.datasets.openapi.api_response import ApiResponse
from ncbi.datasets.openapi.rest import RESTResponseType


class GenomeApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def annotation_report_facets_by_accession(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2GenomeAnnotationTableSummaryReply:
        """Get genome annotation report summary information by genome assembly accession

        Get genome annotation report summary information by genome assembly accession in JSON format, including chromosome names and gene types.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._annotation_report_facets_by_accession_serialize(
            accession=accession,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GenomeAnnotationTableSummaryReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def annotation_report_facets_by_accession_with_http_info(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2GenomeAnnotationTableSummaryReply]:
        """Get genome annotation report summary information by genome assembly accession

        Get genome annotation report summary information by genome assembly accession in JSON format, including chromosome names and gene types.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._annotation_report_facets_by_accession_serialize(
            accession=accession,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GenomeAnnotationTableSummaryReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def annotation_report_facets_by_accession_without_preload_content(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get genome annotation report summary information by genome assembly accession

        Get genome annotation report summary information by genome assembly accession in JSON format, including chromosome names and gene types.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._annotation_report_facets_by_accession_serialize(
            accession=accession,
            sort_field=sort_field,
            sort_direction=sort_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GenomeAnnotationTableSummaryReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _annotation_report_facets_by_accession_serialize(
        self,
        accession,
        sort_field,
        sort_direction,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accession is not None:
            _path_params['accession'] = accession
        # process the query parameters
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/accession/{accession}/annotation_summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def annotation_report_facets_by_post(
        self,
        v2_genome_annotation_request: V2GenomeAnnotationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2GenomeAnnotationTableSummaryReply:
        """Get genome annotation report summary information by genome assembly accession

        Get genome annotation report summary information by genome assembly accession in JSON format, including chromosome names and gene types.

        :param v2_genome_annotation_request: (required)
        :type v2_genome_annotation_request: V2GenomeAnnotationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._annotation_report_facets_by_post_serialize(
            v2_genome_annotation_request=v2_genome_annotation_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GenomeAnnotationTableSummaryReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def annotation_report_facets_by_post_with_http_info(
        self,
        v2_genome_annotation_request: V2GenomeAnnotationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2GenomeAnnotationTableSummaryReply]:
        """Get genome annotation report summary information by genome assembly accession

        Get genome annotation report summary information by genome assembly accession in JSON format, including chromosome names and gene types.

        :param v2_genome_annotation_request: (required)
        :type v2_genome_annotation_request: V2GenomeAnnotationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._annotation_report_facets_by_post_serialize(
            v2_genome_annotation_request=v2_genome_annotation_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GenomeAnnotationTableSummaryReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def annotation_report_facets_by_post_without_preload_content(
        self,
        v2_genome_annotation_request: V2GenomeAnnotationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get genome annotation report summary information by genome assembly accession

        Get genome annotation report summary information by genome assembly accession in JSON format, including chromosome names and gene types.

        :param v2_genome_annotation_request: (required)
        :type v2_genome_annotation_request: V2GenomeAnnotationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._annotation_report_facets_by_post_serialize(
            v2_genome_annotation_request=v2_genome_annotation_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GenomeAnnotationTableSummaryReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _annotation_report_facets_by_post_serialize(
        self,
        v2_genome_annotation_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_genome_annotation_request is not None:
            _body_params = v2_genome_annotation_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/annotation_summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def assembly_accessions_for_sequence_accession(
        self,
        accession: Annotated[StrictStr, Field(description="Nucleotide sequence accession associated with a genome assembly")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2AssemblyAccessions:
        """Get a genome assembly accession for a nucleotide sequence accession

        Get a genome assembly accession for a nucleotide sequence accession in JSON format.

        :param accession: Nucleotide sequence accession associated with a genome assembly (required)
        :type accession: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assembly_accessions_for_sequence_accession_serialize(
            accession=accession,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyAccessions",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def assembly_accessions_for_sequence_accession_with_http_info(
        self,
        accession: Annotated[StrictStr, Field(description="Nucleotide sequence accession associated with a genome assembly")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2AssemblyAccessions]:
        """Get a genome assembly accession for a nucleotide sequence accession

        Get a genome assembly accession for a nucleotide sequence accession in JSON format.

        :param accession: Nucleotide sequence accession associated with a genome assembly (required)
        :type accession: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assembly_accessions_for_sequence_accession_serialize(
            accession=accession,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyAccessions",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def assembly_accessions_for_sequence_accession_without_preload_content(
        self,
        accession: Annotated[StrictStr, Field(description="Nucleotide sequence accession associated with a genome assembly")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a genome assembly accession for a nucleotide sequence accession

        Get a genome assembly accession for a nucleotide sequence accession in JSON format.

        :param accession: Nucleotide sequence accession associated with a genome assembly (required)
        :type accession: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assembly_accessions_for_sequence_accession_serialize(
            accession=accession,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyAccessions",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _assembly_accessions_for_sequence_accession_serialize(
        self,
        accession,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accession is not None:
            _path_params['accession'] = accession
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/sequence_accession/{accession}/sequence_assemblies',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def assembly_accessions_for_sequence_accession_by_post(
        self,
        v2_sequence_accession_request: V2SequenceAccessionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2AssemblyAccessions:
        """Get a genome assembly accession for a nucleotide sequence accession

        Get a genome assembly accession for a nucleotide sequence accession in JSON format.

        :param v2_sequence_accession_request: (required)
        :type v2_sequence_accession_request: V2SequenceAccessionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assembly_accessions_for_sequence_accession_by_post_serialize(
            v2_sequence_accession_request=v2_sequence_accession_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyAccessions",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def assembly_accessions_for_sequence_accession_by_post_with_http_info(
        self,
        v2_sequence_accession_request: V2SequenceAccessionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2AssemblyAccessions]:
        """Get a genome assembly accession for a nucleotide sequence accession

        Get a genome assembly accession for a nucleotide sequence accession in JSON format.

        :param v2_sequence_accession_request: (required)
        :type v2_sequence_accession_request: V2SequenceAccessionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assembly_accessions_for_sequence_accession_by_post_serialize(
            v2_sequence_accession_request=v2_sequence_accession_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyAccessions",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def assembly_accessions_for_sequence_accession_by_post_without_preload_content(
        self,
        v2_sequence_accession_request: V2SequenceAccessionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a genome assembly accession for a nucleotide sequence accession

        Get a genome assembly accession for a nucleotide sequence accession in JSON format.

        :param v2_sequence_accession_request: (required)
        :type v2_sequence_accession_request: V2SequenceAccessionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assembly_accessions_for_sequence_accession_by_post_serialize(
            v2_sequence_accession_request=v2_sequence_accession_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyAccessions",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _assembly_accessions_for_sequence_accession_by_post_serialize(
        self,
        v2_sequence_accession_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_sequence_accession_request is not None:
            _body_params = v2_sequence_accession_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/sequence_assemblies',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def assembly_revision_history_by_get(
        self,
        accession: Annotated[StrictStr, Field(description="One genome assembly accession")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2AssemblyRevisionHistory:
        """Get a revision history for a genome assembly by genome assembly accession

        Get a revision history, or list of all versions of a genome assembly, in JSON format.

        :param accession: One genome assembly accession (required)
        :type accession: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assembly_revision_history_by_get_serialize(
            accession=accession,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyRevisionHistory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def assembly_revision_history_by_get_with_http_info(
        self,
        accession: Annotated[StrictStr, Field(description="One genome assembly accession")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2AssemblyRevisionHistory]:
        """Get a revision history for a genome assembly by genome assembly accession

        Get a revision history, or list of all versions of a genome assembly, in JSON format.

        :param accession: One genome assembly accession (required)
        :type accession: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assembly_revision_history_by_get_serialize(
            accession=accession,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyRevisionHistory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def assembly_revision_history_by_get_without_preload_content(
        self,
        accession: Annotated[StrictStr, Field(description="One genome assembly accession")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a revision history for a genome assembly by genome assembly accession

        Get a revision history, or list of all versions of a genome assembly, in JSON format.

        :param accession: One genome assembly accession (required)
        :type accession: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assembly_revision_history_by_get_serialize(
            accession=accession,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyRevisionHistory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _assembly_revision_history_by_get_serialize(
        self,
        accession,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accession is not None:
            _path_params['accession'] = accession
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/accession/{accession}/revision_history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def assembly_revision_history_by_post(
        self,
        v2_assembly_revision_history_request: V2AssemblyRevisionHistoryRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2AssemblyRevisionHistory:
        """Get a revision history for a genome assembly by genome assembly accession

        Get a revision history, or list of all versions of a genome assembly, in JSON format.

        :param v2_assembly_revision_history_request: (required)
        :type v2_assembly_revision_history_request: V2AssemblyRevisionHistoryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assembly_revision_history_by_post_serialize(
            v2_assembly_revision_history_request=v2_assembly_revision_history_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyRevisionHistory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def assembly_revision_history_by_post_with_http_info(
        self,
        v2_assembly_revision_history_request: V2AssemblyRevisionHistoryRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2AssemblyRevisionHistory]:
        """Get a revision history for a genome assembly by genome assembly accession

        Get a revision history, or list of all versions of a genome assembly, in JSON format.

        :param v2_assembly_revision_history_request: (required)
        :type v2_assembly_revision_history_request: V2AssemblyRevisionHistoryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assembly_revision_history_by_post_serialize(
            v2_assembly_revision_history_request=v2_assembly_revision_history_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyRevisionHistory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def assembly_revision_history_by_post_without_preload_content(
        self,
        v2_assembly_revision_history_request: V2AssemblyRevisionHistoryRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a revision history for a genome assembly by genome assembly accession

        Get a revision history, or list of all versions of a genome assembly, in JSON format.

        :param v2_assembly_revision_history_request: (required)
        :type v2_assembly_revision_history_request: V2AssemblyRevisionHistoryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assembly_revision_history_by_post_serialize(
            v2_assembly_revision_history_request=v2_assembly_revision_history_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyRevisionHistory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _assembly_revision_history_by_post_serialize(
        self,
        v2_assembly_revision_history_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_assembly_revision_history_request is not None:
            _body_params = v2_assembly_revision_history_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/revision_history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def check_assembly_availability(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2AssemblyDatasetAvailability:
        """Check the validity of a genome assembly accession

        Check the validity of a genome assembly accession. Output in JSON format.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_assembly_availability_serialize(
            accessions=accessions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyDatasetAvailability",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def check_assembly_availability_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2AssemblyDatasetAvailability]:
        """Check the validity of a genome assembly accession

        Check the validity of a genome assembly accession. Output in JSON format.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_assembly_availability_serialize(
            accessions=accessions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyDatasetAvailability",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def check_assembly_availability_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Check the validity of a genome assembly accession

        Check the validity of a genome assembly accession. Output in JSON format.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_assembly_availability_serialize(
            accessions=accessions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyDatasetAvailability",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _check_assembly_availability_serialize(
        self,
        accessions,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/accession/{accessions}/check',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def check_assembly_availability_post(
        self,
        v2_assembly_dataset_request: V2AssemblyDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2AssemblyDatasetAvailability:
        """Check the validity of a genome assembly accession

        Check the validity of a genome assembly accession. Output in JSON format.

        :param v2_assembly_dataset_request: (required)
        :type v2_assembly_dataset_request: V2AssemblyDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_assembly_availability_post_serialize(
            v2_assembly_dataset_request=v2_assembly_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyDatasetAvailability",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def check_assembly_availability_post_with_http_info(
        self,
        v2_assembly_dataset_request: V2AssemblyDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2AssemblyDatasetAvailability]:
        """Check the validity of a genome assembly accession

        Check the validity of a genome assembly accession. Output in JSON format.

        :param v2_assembly_dataset_request: (required)
        :type v2_assembly_dataset_request: V2AssemblyDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_assembly_availability_post_serialize(
            v2_assembly_dataset_request=v2_assembly_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyDatasetAvailability",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def check_assembly_availability_post_without_preload_content(
        self,
        v2_assembly_dataset_request: V2AssemblyDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Check the validity of a genome assembly accession

        Check the validity of a genome assembly accession. Output in JSON format.

        :param v2_assembly_dataset_request: (required)
        :type v2_assembly_dataset_request: V2AssemblyDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_assembly_availability_post_serialize(
            v2_assembly_dataset_request=v2_assembly_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyDatasetAvailability",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _check_assembly_availability_post_serialize(
        self,
        v2_assembly_dataset_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_assembly_dataset_request is not None:
            _body_params = v2_assembly_dataset_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/check',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def checkm_histogram_by_taxon(
        self,
        species_taxon: Annotated[StrictStr, Field(description="Bacterial species taxonomy ID or taxonomic name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2AssemblyCheckMHistogramReply:
        """Get CheckM histogram data by species taxon

        Get CheckM histogram data by species taxon. This data is used for rendering CheckM histograms on bacterial genome pages.

        :param species_taxon: Bacterial species taxonomy ID or taxonomic name (required)
        :type species_taxon: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._checkm_histogram_by_taxon_serialize(
            species_taxon=species_taxon,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyCheckMHistogramReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def checkm_histogram_by_taxon_with_http_info(
        self,
        species_taxon: Annotated[StrictStr, Field(description="Bacterial species taxonomy ID or taxonomic name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2AssemblyCheckMHistogramReply]:
        """Get CheckM histogram data by species taxon

        Get CheckM histogram data by species taxon. This data is used for rendering CheckM histograms on bacterial genome pages.

        :param species_taxon: Bacterial species taxonomy ID or taxonomic name (required)
        :type species_taxon: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._checkm_histogram_by_taxon_serialize(
            species_taxon=species_taxon,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyCheckMHistogramReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def checkm_histogram_by_taxon_without_preload_content(
        self,
        species_taxon: Annotated[StrictStr, Field(description="Bacterial species taxonomy ID or taxonomic name")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get CheckM histogram data by species taxon

        Get CheckM histogram data by species taxon. This data is used for rendering CheckM histograms on bacterial genome pages.

        :param species_taxon: Bacterial species taxonomy ID or taxonomic name (required)
        :type species_taxon: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._checkm_histogram_by_taxon_serialize(
            species_taxon=species_taxon,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyCheckMHistogramReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _checkm_histogram_by_taxon_serialize(
        self,
        species_taxon,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if species_taxon is not None:
            _path_params['species_taxon'] = species_taxon
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/taxon/{species_taxon}/checkm_histogram',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def checkm_histogram_by_taxon_by_post(
        self,
        v2_assembly_check_m_histogram_request: V2AssemblyCheckMHistogramRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2AssemblyCheckMHistogramReply:
        """Get CheckM histogram data by species taxon

        Get CheckM histogram data by species taxon. This data is used for rendering CheckM histograms on bacterial genome pages.

        :param v2_assembly_check_m_histogram_request: (required)
        :type v2_assembly_check_m_histogram_request: V2AssemblyCheckMHistogramRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._checkm_histogram_by_taxon_by_post_serialize(
            v2_assembly_check_m_histogram_request=v2_assembly_check_m_histogram_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyCheckMHistogramReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def checkm_histogram_by_taxon_by_post_with_http_info(
        self,
        v2_assembly_check_m_histogram_request: V2AssemblyCheckMHistogramRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2AssemblyCheckMHistogramReply]:
        """Get CheckM histogram data by species taxon

        Get CheckM histogram data by species taxon. This data is used for rendering CheckM histograms on bacterial genome pages.

        :param v2_assembly_check_m_histogram_request: (required)
        :type v2_assembly_check_m_histogram_request: V2AssemblyCheckMHistogramRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._checkm_histogram_by_taxon_by_post_serialize(
            v2_assembly_check_m_histogram_request=v2_assembly_check_m_histogram_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyCheckMHistogramReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def checkm_histogram_by_taxon_by_post_without_preload_content(
        self,
        v2_assembly_check_m_histogram_request: V2AssemblyCheckMHistogramRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get CheckM histogram data by species taxon

        Get CheckM histogram data by species taxon. This data is used for rendering CheckM histograms on bacterial genome pages.

        :param v2_assembly_check_m_histogram_request: (required)
        :type v2_assembly_check_m_histogram_request: V2AssemblyCheckMHistogramRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._checkm_histogram_by_taxon_by_post_serialize(
            v2_assembly_check_m_histogram_request=v2_assembly_check_m_histogram_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyCheckMHistogramReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _checkm_histogram_by_taxon_by_post_serialize(
        self,
        v2_assembly_check_m_histogram_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_assembly_check_m_histogram_request is not None:
            _body_params = v2_assembly_check_m_histogram_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/checkm_histogram',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def download_assembly_package(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        chromosomes: Annotated[Optional[List[StrictStr]], Field(description="Only return genomic fasta sequence for the specified chromosomes.")] = None,
        include_annotation_type: Annotated[Optional[List[V2AnnotationForAssemblyType]], Field(description="Specify which sequence, annotation, and report files to include in the data package. The assembly data report is always included, and its inclusion is not affected by this parameter.")] = None,
        hydrated: Annotated[Optional[V2AssemblyDatasetRequestResolution], Field(description="Specify whether to download a hydrated (with sequence and annotation files included) or dehydrated data package. A dehydrated data package includes the assembly data report and `fetch.txt`, which includes paths to the requested data files on NCBI servers.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a genome data package by genome assembly accession

        Download a genome data package including sequence, annotation, and a detailed data report by genome assembly accession.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param chromosomes: Only return genomic fasta sequence for the specified chromosomes.
        :type chromosomes: List[str]
        :param include_annotation_type: Specify which sequence, annotation, and report files to include in the data package. The assembly data report is always included, and its inclusion is not affected by this parameter.
        :type include_annotation_type: List[V2AnnotationForAssemblyType]
        :param hydrated: Specify whether to download a hydrated (with sequence and annotation files included) or dehydrated data package. A dehydrated data package includes the assembly data report and `fetch.txt`, which includes paths to the requested data files on NCBI servers.
        :type hydrated: V2AssemblyDatasetRequestResolution
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_assembly_package_serialize(
            accessions=accessions,
            chromosomes=chromosomes,
            include_annotation_type=include_annotation_type,
            hydrated=hydrated,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_assembly_package_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        chromosomes: Annotated[Optional[List[StrictStr]], Field(description="Only return genomic fasta sequence for the specified chromosomes.")] = None,
        include_annotation_type: Annotated[Optional[List[V2AnnotationForAssemblyType]], Field(description="Specify which sequence, annotation, and report files to include in the data package. The assembly data report is always included, and its inclusion is not affected by this parameter.")] = None,
        hydrated: Annotated[Optional[V2AssemblyDatasetRequestResolution], Field(description="Specify whether to download a hydrated (with sequence and annotation files included) or dehydrated data package. A dehydrated data package includes the assembly data report and `fetch.txt`, which includes paths to the requested data files on NCBI servers.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a genome data package by genome assembly accession

        Download a genome data package including sequence, annotation, and a detailed data report by genome assembly accession.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param chromosomes: Only return genomic fasta sequence for the specified chromosomes.
        :type chromosomes: List[str]
        :param include_annotation_type: Specify which sequence, annotation, and report files to include in the data package. The assembly data report is always included, and its inclusion is not affected by this parameter.
        :type include_annotation_type: List[V2AnnotationForAssemblyType]
        :param hydrated: Specify whether to download a hydrated (with sequence and annotation files included) or dehydrated data package. A dehydrated data package includes the assembly data report and `fetch.txt`, which includes paths to the requested data files on NCBI servers.
        :type hydrated: V2AssemblyDatasetRequestResolution
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_assembly_package_serialize(
            accessions=accessions,
            chromosomes=chromosomes,
            include_annotation_type=include_annotation_type,
            hydrated=hydrated,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_assembly_package_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        chromosomes: Annotated[Optional[List[StrictStr]], Field(description="Only return genomic fasta sequence for the specified chromosomes.")] = None,
        include_annotation_type: Annotated[Optional[List[V2AnnotationForAssemblyType]], Field(description="Specify which sequence, annotation, and report files to include in the data package. The assembly data report is always included, and its inclusion is not affected by this parameter.")] = None,
        hydrated: Annotated[Optional[V2AssemblyDatasetRequestResolution], Field(description="Specify whether to download a hydrated (with sequence and annotation files included) or dehydrated data package. A dehydrated data package includes the assembly data report and `fetch.txt`, which includes paths to the requested data files on NCBI servers.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a genome data package by genome assembly accession

        Download a genome data package including sequence, annotation, and a detailed data report by genome assembly accession.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param chromosomes: Only return genomic fasta sequence for the specified chromosomes.
        :type chromosomes: List[str]
        :param include_annotation_type: Specify which sequence, annotation, and report files to include in the data package. The assembly data report is always included, and its inclusion is not affected by this parameter.
        :type include_annotation_type: List[V2AnnotationForAssemblyType]
        :param hydrated: Specify whether to download a hydrated (with sequence and annotation files included) or dehydrated data package. A dehydrated data package includes the assembly data report and `fetch.txt`, which includes paths to the requested data files on NCBI servers.
        :type hydrated: V2AssemblyDatasetRequestResolution
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_assembly_package_serialize(
            accessions=accessions,
            chromosomes=chromosomes,
            include_annotation_type=include_annotation_type,
            hydrated=hydrated,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_assembly_package_serialize(
        self,
        accessions,
        chromosomes,
        include_annotation_type,
        hydrated,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
            'chromosomes': 'multi',
            'include_annotation_type': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        if chromosomes is not None:
            
            _query_params.append(('chromosomes', chromosomes))
            
        if include_annotation_type is not None:
            
            _query_params.append(('include_annotation_type', include_annotation_type))
            
        if hydrated is not None:
            
            _query_params.append(('hydrated', hydrated.value))
            
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/accession/{accessions}/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def download_assembly_package_post(
        self,
        v2_assembly_dataset_request: V2AssemblyDatasetRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a genome data package by genome assembly accession

        Download a genome data package including sequence, annotation, and a detailed data report by genome assembly accession.

        :param v2_assembly_dataset_request: (required)
        :type v2_assembly_dataset_request: V2AssemblyDatasetRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_assembly_package_post_serialize(
            v2_assembly_dataset_request=v2_assembly_dataset_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_assembly_package_post_with_http_info(
        self,
        v2_assembly_dataset_request: V2AssemblyDatasetRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a genome data package by genome assembly accession

        Download a genome data package including sequence, annotation, and a detailed data report by genome assembly accession.

        :param v2_assembly_dataset_request: (required)
        :type v2_assembly_dataset_request: V2AssemblyDatasetRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_assembly_package_post_serialize(
            v2_assembly_dataset_request=v2_assembly_dataset_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_assembly_package_post_without_preload_content(
        self,
        v2_assembly_dataset_request: V2AssemblyDatasetRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a genome data package by genome assembly accession

        Download a genome data package including sequence, annotation, and a detailed data report by genome assembly accession.

        :param v2_assembly_dataset_request: (required)
        :type v2_assembly_dataset_request: V2AssemblyDatasetRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_assembly_package_post_serialize(
            v2_assembly_dataset_request=v2_assembly_dataset_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_assembly_package_post_serialize(
        self,
        v2_assembly_dataset_request,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_assembly_dataset_request is not None:
            _body_params = v2_assembly_dataset_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def download_genome_annotation_package(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        annotation_ids: Annotated[Optional[List[StrictStr]], Field(description="Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).")] = None,
        symbols: Annotated[Optional[List[StrictStr]], Field(description="Limit to annotated features matching the given gene symbol (case-sensitive).")] = None,
        locations: Annotated[Optional[List[StrictStr]], Field(description="Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.")] = None,
        gene_types: Annotated[Optional[List[StrictStr]], Field(description="Limit to features of a specified gene locus type.")] = None,
        search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to features that match the specified gene symbol, gene name or protein name.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_annotation_type: Annotated[Optional[List[V2GenomeAnnotationRequestAnnotationType]], Field(description="Specify which sequence files to include in the data package. Options include gene (GENOME_FASTA), transcript (RNA_FASTA), and protein (PROT_FASTA) sequences.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a genome annotation data package by genome assembly accession

        Download an annotation data package including sequence and a detailed annotation report by genome assembly accession.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param annotation_ids: Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).
        :type annotation_ids: List[str]
        :param symbols: Limit to annotated features matching the given gene symbol (case-sensitive).
        :type symbols: List[str]
        :param locations: Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.
        :type locations: List[str]
        :param gene_types: Limit to features of a specified gene locus type.
        :type gene_types: List[str]
        :param search_text: Limit to features that match the specified gene symbol, gene name or protein name.
        :type search_text: List[str]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_annotation_type: Specify which sequence files to include in the data package. Options include gene (GENOME_FASTA), transcript (RNA_FASTA), and protein (PROT_FASTA) sequences.
        :type include_annotation_type: List[V2GenomeAnnotationRequestAnnotationType]
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_genome_annotation_package_serialize(
            accession=accession,
            annotation_ids=annotation_ids,
            symbols=symbols,
            locations=locations,
            gene_types=gene_types,
            search_text=search_text,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_annotation_type=include_annotation_type,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_genome_annotation_package_with_http_info(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        annotation_ids: Annotated[Optional[List[StrictStr]], Field(description="Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).")] = None,
        symbols: Annotated[Optional[List[StrictStr]], Field(description="Limit to annotated features matching the given gene symbol (case-sensitive).")] = None,
        locations: Annotated[Optional[List[StrictStr]], Field(description="Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.")] = None,
        gene_types: Annotated[Optional[List[StrictStr]], Field(description="Limit to features of a specified gene locus type.")] = None,
        search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to features that match the specified gene symbol, gene name or protein name.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_annotation_type: Annotated[Optional[List[V2GenomeAnnotationRequestAnnotationType]], Field(description="Specify which sequence files to include in the data package. Options include gene (GENOME_FASTA), transcript (RNA_FASTA), and protein (PROT_FASTA) sequences.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a genome annotation data package by genome assembly accession

        Download an annotation data package including sequence and a detailed annotation report by genome assembly accession.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param annotation_ids: Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).
        :type annotation_ids: List[str]
        :param symbols: Limit to annotated features matching the given gene symbol (case-sensitive).
        :type symbols: List[str]
        :param locations: Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.
        :type locations: List[str]
        :param gene_types: Limit to features of a specified gene locus type.
        :type gene_types: List[str]
        :param search_text: Limit to features that match the specified gene symbol, gene name or protein name.
        :type search_text: List[str]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_annotation_type: Specify which sequence files to include in the data package. Options include gene (GENOME_FASTA), transcript (RNA_FASTA), and protein (PROT_FASTA) sequences.
        :type include_annotation_type: List[V2GenomeAnnotationRequestAnnotationType]
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_genome_annotation_package_serialize(
            accession=accession,
            annotation_ids=annotation_ids,
            symbols=symbols,
            locations=locations,
            gene_types=gene_types,
            search_text=search_text,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_annotation_type=include_annotation_type,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_genome_annotation_package_without_preload_content(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        annotation_ids: Annotated[Optional[List[StrictStr]], Field(description="Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).")] = None,
        symbols: Annotated[Optional[List[StrictStr]], Field(description="Limit to annotated features matching the given gene symbol (case-sensitive).")] = None,
        locations: Annotated[Optional[List[StrictStr]], Field(description="Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.")] = None,
        gene_types: Annotated[Optional[List[StrictStr]], Field(description="Limit to features of a specified gene locus type.")] = None,
        search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to features that match the specified gene symbol, gene name or protein name.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_annotation_type: Annotated[Optional[List[V2GenomeAnnotationRequestAnnotationType]], Field(description="Specify which sequence files to include in the data package. Options include gene (GENOME_FASTA), transcript (RNA_FASTA), and protein (PROT_FASTA) sequences.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a genome annotation data package by genome assembly accession

        Download an annotation data package including sequence and a detailed annotation report by genome assembly accession.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param annotation_ids: Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).
        :type annotation_ids: List[str]
        :param symbols: Limit to annotated features matching the given gene symbol (case-sensitive).
        :type symbols: List[str]
        :param locations: Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.
        :type locations: List[str]
        :param gene_types: Limit to features of a specified gene locus type.
        :type gene_types: List[str]
        :param search_text: Limit to features that match the specified gene symbol, gene name or protein name.
        :type search_text: List[str]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_annotation_type: Specify which sequence files to include in the data package. Options include gene (GENOME_FASTA), transcript (RNA_FASTA), and protein (PROT_FASTA) sequences.
        :type include_annotation_type: List[V2GenomeAnnotationRequestAnnotationType]
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_genome_annotation_package_serialize(
            accession=accession,
            annotation_ids=annotation_ids,
            symbols=symbols,
            locations=locations,
            gene_types=gene_types,
            search_text=search_text,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_annotation_type=include_annotation_type,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_genome_annotation_package_serialize(
        self,
        accession,
        annotation_ids,
        symbols,
        locations,
        gene_types,
        search_text,
        sort_field,
        sort_direction,
        include_annotation_type,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'annotation_ids': 'multi',
            'symbols': 'multi',
            'locations': 'multi',
            'gene_types': 'multi',
            'search_text': 'multi',
            'include_annotation_type': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accession is not None:
            _path_params['accession'] = accession
        # process the query parameters
        if annotation_ids is not None:
            
            _query_params.append(('annotation_ids', annotation_ids))
            
        if symbols is not None:
            
            _query_params.append(('symbols', symbols))
            
        if locations is not None:
            
            _query_params.append(('locations', locations))
            
        if gene_types is not None:
            
            _query_params.append(('gene_types', gene_types))
            
        if search_text is not None:
            
            _query_params.append(('search_text', search_text))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        if include_annotation_type is not None:
            
            _query_params.append(('include_annotation_type', include_annotation_type))
            
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/accession/{accession}/annotation_report/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def download_genome_annotation_package_by_post(
        self,
        v2_genome_annotation_request: V2GenomeAnnotationRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a genome annotation data package by genome assembly accession

        Download an annotation data package including sequence and a detailed annotation report by genome assembly accession.

        :param v2_genome_annotation_request: (required)
        :type v2_genome_annotation_request: V2GenomeAnnotationRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_genome_annotation_package_by_post_serialize(
            v2_genome_annotation_request=v2_genome_annotation_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_genome_annotation_package_by_post_with_http_info(
        self,
        v2_genome_annotation_request: V2GenomeAnnotationRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a genome annotation data package by genome assembly accession

        Download an annotation data package including sequence and a detailed annotation report by genome assembly accession.

        :param v2_genome_annotation_request: (required)
        :type v2_genome_annotation_request: V2GenomeAnnotationRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_genome_annotation_package_by_post_serialize(
            v2_genome_annotation_request=v2_genome_annotation_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_genome_annotation_package_by_post_without_preload_content(
        self,
        v2_genome_annotation_request: V2GenomeAnnotationRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a genome annotation data package by genome assembly accession

        Download an annotation data package including sequence and a detailed annotation report by genome assembly accession.

        :param v2_genome_annotation_request: (required)
        :type v2_genome_annotation_request: V2GenomeAnnotationRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_genome_annotation_package_by_post_serialize(
            v2_genome_annotation_request=v2_genome_annotation_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_genome_annotation_package_by_post_serialize(
        self,
        v2_genome_annotation_request,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_genome_annotation_request is not None:
            _body_params = v2_genome_annotation_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/annotation_report/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_annotation_download_summary(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        annotation_ids: Annotated[Optional[List[StrictStr]], Field(description="Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).")] = None,
        symbols: Annotated[Optional[List[StrictStr]], Field(description="Limit to annotated features matching the given gene symbol (case-sensitive).")] = None,
        locations: Annotated[Optional[List[StrictStr]], Field(description="Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.")] = None,
        gene_types: Annotated[Optional[List[StrictStr]], Field(description="Limit to features of a specified gene locus type.")] = None,
        search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to features that match the specified gene symbol, gene name or protein name.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_annotation_type: Annotated[Optional[List[V2GenomeAnnotationRequestAnnotationType]], Field(description="Specify which sequence files to include in the data package. Options include gene (GENOME_FASTA), transcript (RNA_FASTA), and protein (PROT_FASTA) sequences.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2DownloadSummary:
        """Get a download summary (preview) of a genome annotation data package by genome assembly accession

        Get a downlaod summary (preview) of a genome annotation data package, including counts and file sizes, in JSON format.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param annotation_ids: Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).
        :type annotation_ids: List[str]
        :param symbols: Limit to annotated features matching the given gene symbol (case-sensitive).
        :type symbols: List[str]
        :param locations: Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.
        :type locations: List[str]
        :param gene_types: Limit to features of a specified gene locus type.
        :type gene_types: List[str]
        :param search_text: Limit to features that match the specified gene symbol, gene name or protein name.
        :type search_text: List[str]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_annotation_type: Specify which sequence files to include in the data package. Options include gene (GENOME_FASTA), transcript (RNA_FASTA), and protein (PROT_FASTA) sequences.
        :type include_annotation_type: List[V2GenomeAnnotationRequestAnnotationType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_annotation_download_summary_serialize(
            accession=accession,
            annotation_ids=annotation_ids,
            symbols=symbols,
            locations=locations,
            gene_types=gene_types,
            search_text=search_text,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_annotation_type=include_annotation_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_annotation_download_summary_with_http_info(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        annotation_ids: Annotated[Optional[List[StrictStr]], Field(description="Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).")] = None,
        symbols: Annotated[Optional[List[StrictStr]], Field(description="Limit to annotated features matching the given gene symbol (case-sensitive).")] = None,
        locations: Annotated[Optional[List[StrictStr]], Field(description="Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.")] = None,
        gene_types: Annotated[Optional[List[StrictStr]], Field(description="Limit to features of a specified gene locus type.")] = None,
        search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to features that match the specified gene symbol, gene name or protein name.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_annotation_type: Annotated[Optional[List[V2GenomeAnnotationRequestAnnotationType]], Field(description="Specify which sequence files to include in the data package. Options include gene (GENOME_FASTA), transcript (RNA_FASTA), and protein (PROT_FASTA) sequences.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2DownloadSummary]:
        """Get a download summary (preview) of a genome annotation data package by genome assembly accession

        Get a downlaod summary (preview) of a genome annotation data package, including counts and file sizes, in JSON format.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param annotation_ids: Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).
        :type annotation_ids: List[str]
        :param symbols: Limit to annotated features matching the given gene symbol (case-sensitive).
        :type symbols: List[str]
        :param locations: Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.
        :type locations: List[str]
        :param gene_types: Limit to features of a specified gene locus type.
        :type gene_types: List[str]
        :param search_text: Limit to features that match the specified gene symbol, gene name or protein name.
        :type search_text: List[str]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_annotation_type: Specify which sequence files to include in the data package. Options include gene (GENOME_FASTA), transcript (RNA_FASTA), and protein (PROT_FASTA) sequences.
        :type include_annotation_type: List[V2GenomeAnnotationRequestAnnotationType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_annotation_download_summary_serialize(
            accession=accession,
            annotation_ids=annotation_ids,
            symbols=symbols,
            locations=locations,
            gene_types=gene_types,
            search_text=search_text,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_annotation_type=include_annotation_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_annotation_download_summary_without_preload_content(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        annotation_ids: Annotated[Optional[List[StrictStr]], Field(description="Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).")] = None,
        symbols: Annotated[Optional[List[StrictStr]], Field(description="Limit to annotated features matching the given gene symbol (case-sensitive).")] = None,
        locations: Annotated[Optional[List[StrictStr]], Field(description="Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.")] = None,
        gene_types: Annotated[Optional[List[StrictStr]], Field(description="Limit to features of a specified gene locus type.")] = None,
        search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to features that match the specified gene symbol, gene name or protein name.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_annotation_type: Annotated[Optional[List[V2GenomeAnnotationRequestAnnotationType]], Field(description="Specify which sequence files to include in the data package. Options include gene (GENOME_FASTA), transcript (RNA_FASTA), and protein (PROT_FASTA) sequences.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a download summary (preview) of a genome annotation data package by genome assembly accession

        Get a downlaod summary (preview) of a genome annotation data package, including counts and file sizes, in JSON format.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param annotation_ids: Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).
        :type annotation_ids: List[str]
        :param symbols: Limit to annotated features matching the given gene symbol (case-sensitive).
        :type symbols: List[str]
        :param locations: Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.
        :type locations: List[str]
        :param gene_types: Limit to features of a specified gene locus type.
        :type gene_types: List[str]
        :param search_text: Limit to features that match the specified gene symbol, gene name or protein name.
        :type search_text: List[str]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_annotation_type: Specify which sequence files to include in the data package. Options include gene (GENOME_FASTA), transcript (RNA_FASTA), and protein (PROT_FASTA) sequences.
        :type include_annotation_type: List[V2GenomeAnnotationRequestAnnotationType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_annotation_download_summary_serialize(
            accession=accession,
            annotation_ids=annotation_ids,
            symbols=symbols,
            locations=locations,
            gene_types=gene_types,
            search_text=search_text,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_annotation_type=include_annotation_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_annotation_download_summary_serialize(
        self,
        accession,
        annotation_ids,
        symbols,
        locations,
        gene_types,
        search_text,
        sort_field,
        sort_direction,
        include_annotation_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'annotation_ids': 'multi',
            'symbols': 'multi',
            'locations': 'multi',
            'gene_types': 'multi',
            'search_text': 'multi',
            'include_annotation_type': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accession is not None:
            _path_params['accession'] = accession
        # process the query parameters
        if annotation_ids is not None:
            
            _query_params.append(('annotation_ids', annotation_ids))
            
        if symbols is not None:
            
            _query_params.append(('symbols', symbols))
            
        if locations is not None:
            
            _query_params.append(('locations', locations))
            
        if gene_types is not None:
            
            _query_params.append(('gene_types', gene_types))
            
        if search_text is not None:
            
            _query_params.append(('search_text', search_text))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        if include_annotation_type is not None:
            
            _query_params.append(('include_annotation_type', include_annotation_type))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/accession/{accession}/annotation_report/download_summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_annotation_download_summary_by_post(
        self,
        v2_genome_annotation_request: V2GenomeAnnotationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2DownloadSummary:
        """Get a download summary (preview) of a genome annotation data package by genome assembly accession

        Get a download summary (preview) of a genome annotation data package, including counts and file sizes, by genome assembly accession, in JSON format.

        :param v2_genome_annotation_request: (required)
        :type v2_genome_annotation_request: V2GenomeAnnotationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_annotation_download_summary_by_post_serialize(
            v2_genome_annotation_request=v2_genome_annotation_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_annotation_download_summary_by_post_with_http_info(
        self,
        v2_genome_annotation_request: V2GenomeAnnotationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2DownloadSummary]:
        """Get a download summary (preview) of a genome annotation data package by genome assembly accession

        Get a download summary (preview) of a genome annotation data package, including counts and file sizes, by genome assembly accession, in JSON format.

        :param v2_genome_annotation_request: (required)
        :type v2_genome_annotation_request: V2GenomeAnnotationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_annotation_download_summary_by_post_serialize(
            v2_genome_annotation_request=v2_genome_annotation_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_annotation_download_summary_by_post_without_preload_content(
        self,
        v2_genome_annotation_request: V2GenomeAnnotationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a download summary (preview) of a genome annotation data package by genome assembly accession

        Get a download summary (preview) of a genome annotation data package, including counts and file sizes, by genome assembly accession, in JSON format.

        :param v2_genome_annotation_request: (required)
        :type v2_genome_annotation_request: V2GenomeAnnotationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_annotation_download_summary_by_post_serialize(
            v2_genome_annotation_request=v2_genome_annotation_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_annotation_download_summary_by_post_serialize(
        self,
        v2_genome_annotation_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_genome_annotation_request is not None:
            _body_params = v2_genome_annotation_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/annotation_report/download_summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_annotation_report(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        annotation_ids: Annotated[Optional[List[StrictStr]], Field(description="Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).")] = None,
        symbols: Annotated[Optional[List[StrictStr]], Field(description="Limit to annotated features matching the given gene symbol (case-sensitive).")] = None,
        locations: Annotated[Optional[List[StrictStr]], Field(description="Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.")] = None,
        gene_types: Annotated[Optional[List[StrictStr]], Field(description="Limit to features of a specified gene locus type.")] = None,
        search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to features that match the specified gene symbol, gene name or protein name.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of features to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        table_format: Annotated[Optional[V2GenomeAnnotationRequestGenomeAnnotationTableFormat], Field(description="Optional pre-defined template for processing a tabular data request")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGenomeAnnotationReportPage:
        """Get genome annotation reports by genome assembly accession

        Get genome annotation reports by genome assembly accession, where each report represents a single feature annotated on the genome.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param annotation_ids: Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).
        :type annotation_ids: List[str]
        :param symbols: Limit to annotated features matching the given gene symbol (case-sensitive).
        :type symbols: List[str]
        :param locations: Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.
        :type locations: List[str]
        :param gene_types: Limit to features of a specified gene locus type.
        :type gene_types: List[str]
        :param search_text: Limit to features that match the specified gene symbol, gene name or protein name.
        :type search_text: List[str]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param page_size: The maximum number of features to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param table_format: Optional pre-defined template for processing a tabular data request
        :type table_format: V2GenomeAnnotationRequestGenomeAnnotationTableFormat
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_annotation_report_serialize(
            accession=accession,
            annotation_ids=annotation_ids,
            symbols=symbols,
            locations=locations,
            gene_types=gene_types,
            search_text=search_text,
            sort_field=sort_field,
            sort_direction=sort_direction,
            page_size=page_size,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGenomeAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_annotation_report_with_http_info(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        annotation_ids: Annotated[Optional[List[StrictStr]], Field(description="Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).")] = None,
        symbols: Annotated[Optional[List[StrictStr]], Field(description="Limit to annotated features matching the given gene symbol (case-sensitive).")] = None,
        locations: Annotated[Optional[List[StrictStr]], Field(description="Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.")] = None,
        gene_types: Annotated[Optional[List[StrictStr]], Field(description="Limit to features of a specified gene locus type.")] = None,
        search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to features that match the specified gene symbol, gene name or protein name.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of features to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        table_format: Annotated[Optional[V2GenomeAnnotationRequestGenomeAnnotationTableFormat], Field(description="Optional pre-defined template for processing a tabular data request")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGenomeAnnotationReportPage]:
        """Get genome annotation reports by genome assembly accession

        Get genome annotation reports by genome assembly accession, where each report represents a single feature annotated on the genome.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param annotation_ids: Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).
        :type annotation_ids: List[str]
        :param symbols: Limit to annotated features matching the given gene symbol (case-sensitive).
        :type symbols: List[str]
        :param locations: Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.
        :type locations: List[str]
        :param gene_types: Limit to features of a specified gene locus type.
        :type gene_types: List[str]
        :param search_text: Limit to features that match the specified gene symbol, gene name or protein name.
        :type search_text: List[str]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param page_size: The maximum number of features to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param table_format: Optional pre-defined template for processing a tabular data request
        :type table_format: V2GenomeAnnotationRequestGenomeAnnotationTableFormat
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_annotation_report_serialize(
            accession=accession,
            annotation_ids=annotation_ids,
            symbols=symbols,
            locations=locations,
            gene_types=gene_types,
            search_text=search_text,
            sort_field=sort_field,
            sort_direction=sort_direction,
            page_size=page_size,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGenomeAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_annotation_report_without_preload_content(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        annotation_ids: Annotated[Optional[List[StrictStr]], Field(description="Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).")] = None,
        symbols: Annotated[Optional[List[StrictStr]], Field(description="Limit to annotated features matching the given gene symbol (case-sensitive).")] = None,
        locations: Annotated[Optional[List[StrictStr]], Field(description="Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.")] = None,
        gene_types: Annotated[Optional[List[StrictStr]], Field(description="Limit to features of a specified gene locus type.")] = None,
        search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to features that match the specified gene symbol, gene name or protein name.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of features to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        table_format: Annotated[Optional[V2GenomeAnnotationRequestGenomeAnnotationTableFormat], Field(description="Optional pre-defined template for processing a tabular data request")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get genome annotation reports by genome assembly accession

        Get genome annotation reports by genome assembly accession, where each report represents a single feature annotated on the genome.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param annotation_ids: Limit to one or more features annotated on the genome by specifying a number corresponding to a row_id (unstable).
        :type annotation_ids: List[str]
        :param symbols: Limit to annotated features matching the given gene symbol (case-sensitive).
        :type symbols: List[str]
        :param locations: Limit to features annotated at a specific location on the genome, by specifying a chromosome name or accession and optional start-stop range.
        :type locations: List[str]
        :param gene_types: Limit to features of a specified gene locus type.
        :type gene_types: List[str]
        :param search_text: Limit to features that match the specified gene symbol, gene name or protein name.
        :type search_text: List[str]
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param page_size: The maximum number of features to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param table_format: Optional pre-defined template for processing a tabular data request
        :type table_format: V2GenomeAnnotationRequestGenomeAnnotationTableFormat
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_annotation_report_serialize(
            accession=accession,
            annotation_ids=annotation_ids,
            symbols=symbols,
            locations=locations,
            gene_types=gene_types,
            search_text=search_text,
            sort_field=sort_field,
            sort_direction=sort_direction,
            page_size=page_size,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGenomeAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_annotation_report_serialize(
        self,
        accession,
        annotation_ids,
        symbols,
        locations,
        gene_types,
        search_text,
        sort_field,
        sort_direction,
        page_size,
        table_format,
        include_tabular_header,
        page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'annotation_ids': 'multi',
            'symbols': 'multi',
            'locations': 'multi',
            'gene_types': 'multi',
            'search_text': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accession is not None:
            _path_params['accession'] = accession
        # process the query parameters
        if annotation_ids is not None:
            
            _query_params.append(('annotation_ids', annotation_ids))
            
        if symbols is not None:
            
            _query_params.append(('symbols', symbols))
            
        if locations is not None:
            
            _query_params.append(('locations', locations))
            
        if gene_types is not None:
            
            _query_params.append(('gene_types', gene_types))
            
        if search_text is not None:
            
            _query_params.append(('search_text', search_text))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format.value))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/accession/{accession}/annotation_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_annotation_report_by_post(
        self,
        v2_genome_annotation_request: V2GenomeAnnotationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsGenomeAnnotationReportPage:
        """Get genome annotation reports by genome assembly accession

        Get genome annotation reports by genome assembly accession, where each report represents a single feature annotated on the genome.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_genome_annotation_request: (required)
        :type v2_genome_annotation_request: V2GenomeAnnotationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_annotation_report_by_post_serialize(
            v2_genome_annotation_request=v2_genome_annotation_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGenomeAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_annotation_report_by_post_with_http_info(
        self,
        v2_genome_annotation_request: V2GenomeAnnotationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsGenomeAnnotationReportPage]:
        """Get genome annotation reports by genome assembly accession

        Get genome annotation reports by genome assembly accession, where each report represents a single feature annotated on the genome.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_genome_annotation_request: (required)
        :type v2_genome_annotation_request: V2GenomeAnnotationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_annotation_report_by_post_serialize(
            v2_genome_annotation_request=v2_genome_annotation_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGenomeAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_annotation_report_by_post_without_preload_content(
        self,
        v2_genome_annotation_request: V2GenomeAnnotationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get genome annotation reports by genome assembly accession

        Get genome annotation reports by genome assembly accession, where each report represents a single feature annotated on the genome.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_genome_annotation_request: (required)
        :type v2_genome_annotation_request: V2GenomeAnnotationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_annotation_report_by_post_serialize(
            v2_genome_annotation_request=v2_genome_annotation_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsGenomeAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_annotation_report_by_post_serialize(
        self,
        v2_genome_annotation_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_genome_annotation_request is not None:
            _body_params = v2_genome_annotation_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/annotation_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_dataset_report(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsAssemblyDataReportPage:
        """Get a genome assembly report by genome assembly accession

        Get a genome assembly report by assembly accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_report_serialize(
            accessions=accessions,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_dataset_report_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsAssemblyDataReportPage]:
        """Get a genome assembly report by genome assembly accession

        Get a genome assembly report by assembly accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_report_serialize(
            accessions=accessions,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_dataset_report_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a genome assembly report by genome assembly accession

        Get a genome assembly report by assembly accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_report_serialize(
            accessions=accessions,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_dataset_report_serialize(
        self,
        accessions,
        filters_reference_only,
        filters_assembly_source,
        filters_has_annotation,
        filters_exclude_paired_reports,
        filters_exclude_atypical,
        filters_assembly_version,
        filters_assembly_level,
        filters_first_release_date,
        filters_last_release_date,
        filters_search_text,
        filters_is_metagenome_derived,
        filters_is_type_material,
        filters_is_ictv_exemplar,
        filters_exclude_multi_isolate,
        filters_type_material_category,
        table_fields,
        returned_content,
        page_size,
        page_token,
        sort_field,
        sort_direction,
        include_tabular_header,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
            'filters.assembly_level': 'multi',
            'filters.search_text': 'multi',
            'table_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        if filters_reference_only is not None:
            
            _query_params.append(('filters.reference_only', filters_reference_only))
            
        if filters_assembly_source is not None:
            
            _query_params.append(('filters.assembly_source', filters_assembly_source.value))
            
        if filters_has_annotation is not None:
            
            _query_params.append(('filters.has_annotation', filters_has_annotation))
            
        if filters_exclude_paired_reports is not None:
            
            _query_params.append(('filters.exclude_paired_reports', filters_exclude_paired_reports))
            
        if filters_exclude_atypical is not None:
            
            _query_params.append(('filters.exclude_atypical', filters_exclude_atypical))
            
        if filters_assembly_version is not None:
            
            _query_params.append(('filters.assembly_version', filters_assembly_version.value))
            
        if filters_assembly_level is not None:
            
            _query_params.append(('filters.assembly_level', filters_assembly_level))
            
        if filters_first_release_date is not None:
            if isinstance(filters_first_release_date, datetime):
                _query_params.append(
                    (
                        'filters.first_release_date',
                        filters_first_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filters.first_release_date', filters_first_release_date))
            
        if filters_last_release_date is not None:
            if isinstance(filters_last_release_date, datetime):
                _query_params.append(
                    (
                        'filters.last_release_date',
                        filters_last_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filters.last_release_date', filters_last_release_date))
            
        if filters_search_text is not None:
            
            _query_params.append(('filters.search_text', filters_search_text))
            
        if filters_is_metagenome_derived is not None:
            
            _query_params.append(('filters.is_metagenome_derived', filters_is_metagenome_derived.value))
            
        if filters_is_type_material is not None:
            
            _query_params.append(('filters.is_type_material', filters_is_type_material))
            
        if filters_is_ictv_exemplar is not None:
            
            _query_params.append(('filters.is_ictv_exemplar', filters_is_ictv_exemplar))
            
        if filters_exclude_multi_isolate is not None:
            
            _query_params.append(('filters.exclude_multi_isolate', filters_exclude_multi_isolate))
            
        if filters_type_material_category is not None:
            
            _query_params.append(('filters.type_material_category', filters_type_material_category.value))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/accession/{accessions}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_dataset_report_by_post(
        self,
        v2_assembly_dataset_reports_request: V2AssemblyDatasetReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsAssemblyDataReportPage:
        """Get a genome assembly report

        Get a genome assembly report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_assembly_dataset_reports_request: (required)
        :type v2_assembly_dataset_reports_request: V2AssemblyDatasetReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_report_by_post_serialize(
            v2_assembly_dataset_reports_request=v2_assembly_dataset_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_dataset_report_by_post_with_http_info(
        self,
        v2_assembly_dataset_reports_request: V2AssemblyDatasetReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsAssemblyDataReportPage]:
        """Get a genome assembly report

        Get a genome assembly report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_assembly_dataset_reports_request: (required)
        :type v2_assembly_dataset_reports_request: V2AssemblyDatasetReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_report_by_post_serialize(
            v2_assembly_dataset_reports_request=v2_assembly_dataset_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_dataset_report_by_post_without_preload_content(
        self,
        v2_assembly_dataset_reports_request: V2AssemblyDatasetReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a genome assembly report

        Get a genome assembly report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_assembly_dataset_reports_request: (required)
        :type v2_assembly_dataset_reports_request: V2AssemblyDatasetReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_report_by_post_serialize(
            v2_assembly_dataset_reports_request=v2_assembly_dataset_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_dataset_report_by_post_serialize(
        self,
        v2_assembly_dataset_reports_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_assembly_dataset_reports_request is not None:
            _body_params = v2_assembly_dataset_reports_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_dataset_reports_by_assembly_name(
        self,
        assembly_names: Annotated[List[StrictStr], Field(description="One or more assembly names (exact match only)")],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsAssemblyDataReportPage:
        """Get genome assembly reports by assembly name

        Get genome assembly reports by assembly name (exact matches only).  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param assembly_names: One or more assembly names (exact match only) (required)
        :type assembly_names: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_assembly_name_serialize(
            assembly_names=assembly_names,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_dataset_reports_by_assembly_name_with_http_info(
        self,
        assembly_names: Annotated[List[StrictStr], Field(description="One or more assembly names (exact match only)")],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsAssemblyDataReportPage]:
        """Get genome assembly reports by assembly name

        Get genome assembly reports by assembly name (exact matches only).  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param assembly_names: One or more assembly names (exact match only) (required)
        :type assembly_names: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_assembly_name_serialize(
            assembly_names=assembly_names,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_dataset_reports_by_assembly_name_without_preload_content(
        self,
        assembly_names: Annotated[List[StrictStr], Field(description="One or more assembly names (exact match only)")],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get genome assembly reports by assembly name

        Get genome assembly reports by assembly name (exact matches only).  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param assembly_names: One or more assembly names (exact match only) (required)
        :type assembly_names: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_assembly_name_serialize(
            assembly_names=assembly_names,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_dataset_reports_by_assembly_name_serialize(
        self,
        assembly_names,
        filters_reference_only,
        filters_assembly_source,
        filters_has_annotation,
        filters_exclude_paired_reports,
        filters_exclude_atypical,
        filters_assembly_version,
        filters_assembly_level,
        filters_first_release_date,
        filters_last_release_date,
        filters_search_text,
        filters_is_metagenome_derived,
        filters_is_type_material,
        filters_is_ictv_exemplar,
        filters_exclude_multi_isolate,
        filters_type_material_category,
        tax_exact_match,
        table_fields,
        returned_content,
        page_size,
        page_token,
        sort_field,
        sort_direction,
        include_tabular_header,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'assembly_names': 'csv',
            'filters.assembly_level': 'multi',
            'filters.search_text': 'multi',
            'table_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if assembly_names is not None:
            _path_params['assembly_names'] = assembly_names
        # process the query parameters
        if filters_reference_only is not None:
            
            _query_params.append(('filters.reference_only', filters_reference_only))
            
        if filters_assembly_source is not None:
            
            _query_params.append(('filters.assembly_source', filters_assembly_source.value))
            
        if filters_has_annotation is not None:
            
            _query_params.append(('filters.has_annotation', filters_has_annotation))
            
        if filters_exclude_paired_reports is not None:
            
            _query_params.append(('filters.exclude_paired_reports', filters_exclude_paired_reports))
            
        if filters_exclude_atypical is not None:
            
            _query_params.append(('filters.exclude_atypical', filters_exclude_atypical))
            
        if filters_assembly_version is not None:
            
            _query_params.append(('filters.assembly_version', filters_assembly_version.value))
            
        if filters_assembly_level is not None:
            
            _query_params.append(('filters.assembly_level', filters_assembly_level))
            
        if filters_first_release_date is not None:
            if isinstance(filters_first_release_date, datetime):
                _query_params.append(
                    (
                        'filters.first_release_date',
                        filters_first_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filters.first_release_date', filters_first_release_date))
            
        if filters_last_release_date is not None:
            if isinstance(filters_last_release_date, datetime):
                _query_params.append(
                    (
                        'filters.last_release_date',
                        filters_last_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filters.last_release_date', filters_last_release_date))
            
        if filters_search_text is not None:
            
            _query_params.append(('filters.search_text', filters_search_text))
            
        if filters_is_metagenome_derived is not None:
            
            _query_params.append(('filters.is_metagenome_derived', filters_is_metagenome_derived.value))
            
        if filters_is_type_material is not None:
            
            _query_params.append(('filters.is_type_material', filters_is_type_material))
            
        if filters_is_ictv_exemplar is not None:
            
            _query_params.append(('filters.is_ictv_exemplar', filters_is_ictv_exemplar))
            
        if filters_exclude_multi_isolate is not None:
            
            _query_params.append(('filters.exclude_multi_isolate', filters_exclude_multi_isolate))
            
        if filters_type_material_category is not None:
            
            _query_params.append(('filters.type_material_category', filters_type_material_category.value))
            
        if tax_exact_match is not None:
            
            _query_params.append(('tax_exact_match', tax_exact_match))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/assembly_name/{assembly_names}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_dataset_reports_by_bioproject(
        self,
        bioprojects: List[StrictStr],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsAssemblyDataReportPage:
        """Get genome assembly reports by BioProject accession

        Get genome assembly reports by BioProject accession.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param bioprojects: (required)
        :type bioprojects: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_bioproject_serialize(
            bioprojects=bioprojects,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_dataset_reports_by_bioproject_with_http_info(
        self,
        bioprojects: List[StrictStr],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsAssemblyDataReportPage]:
        """Get genome assembly reports by BioProject accession

        Get genome assembly reports by BioProject accession.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param bioprojects: (required)
        :type bioprojects: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_bioproject_serialize(
            bioprojects=bioprojects,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_dataset_reports_by_bioproject_without_preload_content(
        self,
        bioprojects: List[StrictStr],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get genome assembly reports by BioProject accession

        Get genome assembly reports by BioProject accession.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param bioprojects: (required)
        :type bioprojects: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_bioproject_serialize(
            bioprojects=bioprojects,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_dataset_reports_by_bioproject_serialize(
        self,
        bioprojects,
        filters_reference_only,
        filters_assembly_source,
        filters_has_annotation,
        filters_exclude_paired_reports,
        filters_exclude_atypical,
        filters_assembly_version,
        filters_assembly_level,
        filters_first_release_date,
        filters_last_release_date,
        filters_search_text,
        filters_is_metagenome_derived,
        filters_is_type_material,
        filters_is_ictv_exemplar,
        filters_exclude_multi_isolate,
        filters_type_material_category,
        tax_exact_match,
        table_fields,
        returned_content,
        page_size,
        page_token,
        sort_field,
        sort_direction,
        include_tabular_header,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'bioprojects': 'csv',
            'filters.assembly_level': 'multi',
            'filters.search_text': 'multi',
            'table_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if bioprojects is not None:
            _path_params['bioprojects'] = bioprojects
        # process the query parameters
        if filters_reference_only is not None:
            
            _query_params.append(('filters.reference_only', filters_reference_only))
            
        if filters_assembly_source is not None:
            
            _query_params.append(('filters.assembly_source', filters_assembly_source.value))
            
        if filters_has_annotation is not None:
            
            _query_params.append(('filters.has_annotation', filters_has_annotation))
            
        if filters_exclude_paired_reports is not None:
            
            _query_params.append(('filters.exclude_paired_reports', filters_exclude_paired_reports))
            
        if filters_exclude_atypical is not None:
            
            _query_params.append(('filters.exclude_atypical', filters_exclude_atypical))
            
        if filters_assembly_version is not None:
            
            _query_params.append(('filters.assembly_version', filters_assembly_version.value))
            
        if filters_assembly_level is not None:
            
            _query_params.append(('filters.assembly_level', filters_assembly_level))
            
        if filters_first_release_date is not None:
            if isinstance(filters_first_release_date, datetime):
                _query_params.append(
                    (
                        'filters.first_release_date',
                        filters_first_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filters.first_release_date', filters_first_release_date))
            
        if filters_last_release_date is not None:
            if isinstance(filters_last_release_date, datetime):
                _query_params.append(
                    (
                        'filters.last_release_date',
                        filters_last_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filters.last_release_date', filters_last_release_date))
            
        if filters_search_text is not None:
            
            _query_params.append(('filters.search_text', filters_search_text))
            
        if filters_is_metagenome_derived is not None:
            
            _query_params.append(('filters.is_metagenome_derived', filters_is_metagenome_derived.value))
            
        if filters_is_type_material is not None:
            
            _query_params.append(('filters.is_type_material', filters_is_type_material))
            
        if filters_is_ictv_exemplar is not None:
            
            _query_params.append(('filters.is_ictv_exemplar', filters_is_ictv_exemplar))
            
        if filters_exclude_multi_isolate is not None:
            
            _query_params.append(('filters.exclude_multi_isolate', filters_exclude_multi_isolate))
            
        if filters_type_material_category is not None:
            
            _query_params.append(('filters.type_material_category', filters_type_material_category.value))
            
        if tax_exact_match is not None:
            
            _query_params.append(('tax_exact_match', tax_exact_match))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/bioproject/{bioprojects}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_dataset_reports_by_biosample_id(
        self,
        biosample_ids: List[StrictStr],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsAssemblyDataReportPage:
        """Get genome assembly reports by BioSample accession

        Get genome assembly reports by BioSample accession.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param biosample_ids: (required)
        :type biosample_ids: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_biosample_id_serialize(
            biosample_ids=biosample_ids,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_dataset_reports_by_biosample_id_with_http_info(
        self,
        biosample_ids: List[StrictStr],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsAssemblyDataReportPage]:
        """Get genome assembly reports by BioSample accession

        Get genome assembly reports by BioSample accession.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param biosample_ids: (required)
        :type biosample_ids: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_biosample_id_serialize(
            biosample_ids=biosample_ids,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_dataset_reports_by_biosample_id_without_preload_content(
        self,
        biosample_ids: List[StrictStr],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get genome assembly reports by BioSample accession

        Get genome assembly reports by BioSample accession.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param biosample_ids: (required)
        :type biosample_ids: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_biosample_id_serialize(
            biosample_ids=biosample_ids,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_dataset_reports_by_biosample_id_serialize(
        self,
        biosample_ids,
        filters_reference_only,
        filters_assembly_source,
        filters_has_annotation,
        filters_exclude_paired_reports,
        filters_exclude_atypical,
        filters_assembly_version,
        filters_assembly_level,
        filters_first_release_date,
        filters_last_release_date,
        filters_search_text,
        filters_is_metagenome_derived,
        filters_is_type_material,
        filters_is_ictv_exemplar,
        filters_exclude_multi_isolate,
        filters_type_material_category,
        tax_exact_match,
        table_fields,
        returned_content,
        page_size,
        page_token,
        sort_field,
        sort_direction,
        include_tabular_header,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'biosample_ids': 'csv',
            'filters.assembly_level': 'multi',
            'filters.search_text': 'multi',
            'table_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if biosample_ids is not None:
            _path_params['biosample_ids'] = biosample_ids
        # process the query parameters
        if filters_reference_only is not None:
            
            _query_params.append(('filters.reference_only', filters_reference_only))
            
        if filters_assembly_source is not None:
            
            _query_params.append(('filters.assembly_source', filters_assembly_source.value))
            
        if filters_has_annotation is not None:
            
            _query_params.append(('filters.has_annotation', filters_has_annotation))
            
        if filters_exclude_paired_reports is not None:
            
            _query_params.append(('filters.exclude_paired_reports', filters_exclude_paired_reports))
            
        if filters_exclude_atypical is not None:
            
            _query_params.append(('filters.exclude_atypical', filters_exclude_atypical))
            
        if filters_assembly_version is not None:
            
            _query_params.append(('filters.assembly_version', filters_assembly_version.value))
            
        if filters_assembly_level is not None:
            
            _query_params.append(('filters.assembly_level', filters_assembly_level))
            
        if filters_first_release_date is not None:
            if isinstance(filters_first_release_date, datetime):
                _query_params.append(
                    (
                        'filters.first_release_date',
                        filters_first_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filters.first_release_date', filters_first_release_date))
            
        if filters_last_release_date is not None:
            if isinstance(filters_last_release_date, datetime):
                _query_params.append(
                    (
                        'filters.last_release_date',
                        filters_last_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filters.last_release_date', filters_last_release_date))
            
        if filters_search_text is not None:
            
            _query_params.append(('filters.search_text', filters_search_text))
            
        if filters_is_metagenome_derived is not None:
            
            _query_params.append(('filters.is_metagenome_derived', filters_is_metagenome_derived.value))
            
        if filters_is_type_material is not None:
            
            _query_params.append(('filters.is_type_material', filters_is_type_material))
            
        if filters_is_ictv_exemplar is not None:
            
            _query_params.append(('filters.is_ictv_exemplar', filters_is_ictv_exemplar))
            
        if filters_exclude_multi_isolate is not None:
            
            _query_params.append(('filters.exclude_multi_isolate', filters_exclude_multi_isolate))
            
        if filters_type_material_category is not None:
            
            _query_params.append(('filters.type_material_category', filters_type_material_category.value))
            
        if tax_exact_match is not None:
            
            _query_params.append(('tax_exact_match', tax_exact_match))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/biosample/{biosample_ids}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_dataset_reports_by_taxon(
        self,
        taxons: Annotated[List[StrictStr], Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsAssemblyDataReportPage:
        """Get a genome assembly report by taxon

        Get a genome assembly report by taxon.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxons: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxons: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_taxon_serialize(
            taxons=taxons,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_dataset_reports_by_taxon_with_http_info(
        self,
        taxons: Annotated[List[StrictStr], Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsAssemblyDataReportPage]:
        """Get a genome assembly report by taxon

        Get a genome assembly report by taxon.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxons: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxons: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_taxon_serialize(
            taxons=taxons,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_dataset_reports_by_taxon_without_preload_content(
        self,
        taxons: Annotated[List[StrictStr], Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a genome assembly report by taxon

        Get a genome assembly report by taxon.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxons: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxons: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_taxon_serialize(
            taxons=taxons,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_dataset_reports_by_taxon_serialize(
        self,
        taxons,
        filters_reference_only,
        filters_assembly_source,
        filters_has_annotation,
        filters_exclude_paired_reports,
        filters_exclude_atypical,
        filters_assembly_version,
        filters_assembly_level,
        filters_first_release_date,
        filters_last_release_date,
        filters_search_text,
        filters_is_metagenome_derived,
        filters_is_type_material,
        filters_is_ictv_exemplar,
        filters_exclude_multi_isolate,
        filters_type_material_category,
        tax_exact_match,
        table_fields,
        returned_content,
        page_size,
        page_token,
        sort_field,
        sort_direction,
        include_tabular_header,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'taxons': 'csv',
            'filters.assembly_level': 'multi',
            'filters.search_text': 'multi',
            'table_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if taxons is not None:
            _path_params['taxons'] = taxons
        # process the query parameters
        if filters_reference_only is not None:
            
            _query_params.append(('filters.reference_only', filters_reference_only))
            
        if filters_assembly_source is not None:
            
            _query_params.append(('filters.assembly_source', filters_assembly_source.value))
            
        if filters_has_annotation is not None:
            
            _query_params.append(('filters.has_annotation', filters_has_annotation))
            
        if filters_exclude_paired_reports is not None:
            
            _query_params.append(('filters.exclude_paired_reports', filters_exclude_paired_reports))
            
        if filters_exclude_atypical is not None:
            
            _query_params.append(('filters.exclude_atypical', filters_exclude_atypical))
            
        if filters_assembly_version is not None:
            
            _query_params.append(('filters.assembly_version', filters_assembly_version.value))
            
        if filters_assembly_level is not None:
            
            _query_params.append(('filters.assembly_level', filters_assembly_level))
            
        if filters_first_release_date is not None:
            if isinstance(filters_first_release_date, datetime):
                _query_params.append(
                    (
                        'filters.first_release_date',
                        filters_first_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filters.first_release_date', filters_first_release_date))
            
        if filters_last_release_date is not None:
            if isinstance(filters_last_release_date, datetime):
                _query_params.append(
                    (
                        'filters.last_release_date',
                        filters_last_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filters.last_release_date', filters_last_release_date))
            
        if filters_search_text is not None:
            
            _query_params.append(('filters.search_text', filters_search_text))
            
        if filters_is_metagenome_derived is not None:
            
            _query_params.append(('filters.is_metagenome_derived', filters_is_metagenome_derived.value))
            
        if filters_is_type_material is not None:
            
            _query_params.append(('filters.is_type_material', filters_is_type_material))
            
        if filters_is_ictv_exemplar is not None:
            
            _query_params.append(('filters.is_ictv_exemplar', filters_is_ictv_exemplar))
            
        if filters_exclude_multi_isolate is not None:
            
            _query_params.append(('filters.exclude_multi_isolate', filters_exclude_multi_isolate))
            
        if filters_type_material_category is not None:
            
            _query_params.append(('filters.type_material_category', filters_type_material_category.value))
            
        if tax_exact_match is not None:
            
            _query_params.append(('tax_exact_match', tax_exact_match))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/taxon/{taxons}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_dataset_reports_by_wgs(
        self,
        wgs_accessions: Annotated[List[StrictStr], Field(description="One or more WGS accessions associated with a genome assembly")],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsAssemblyDataReportPage:
        """Get a genome assembly data report by WGS accession

        Get a genome assembly data report by WGS (whole genome shotgun) accession.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param wgs_accessions: One or more WGS accessions associated with a genome assembly (required)
        :type wgs_accessions: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_wgs_serialize(
            wgs_accessions=wgs_accessions,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_dataset_reports_by_wgs_with_http_info(
        self,
        wgs_accessions: Annotated[List[StrictStr], Field(description="One or more WGS accessions associated with a genome assembly")],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsAssemblyDataReportPage]:
        """Get a genome assembly data report by WGS accession

        Get a genome assembly data report by WGS (whole genome shotgun) accession.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param wgs_accessions: One or more WGS accessions associated with a genome assembly (required)
        :type wgs_accessions: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_wgs_serialize(
            wgs_accessions=wgs_accessions,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_dataset_reports_by_wgs_without_preload_content(
        self,
        wgs_accessions: Annotated[List[StrictStr], Field(description="One or more WGS accessions associated with a genome assembly")],
        filters_reference_only: Annotated[Optional[StrictBool], Field(description="If true, limit to reference genome assemblies.")] = None,
        filters_assembly_source: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblySource], Field(description="Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.")] = None,
        filters_has_annotation: Annotated[Optional[StrictBool], Field(description="Limit to annotated genome assemblies.")] = None,
        filters_exclude_paired_reports: Annotated[Optional[StrictBool], Field(description="If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.")] = None,
        filters_exclude_atypical: Annotated[Optional[StrictBool], Field(description="If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.")] = None,
        filters_assembly_version: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterAssemblyVersion], Field(description="Limit to the most recent (current) version of a genome assembly.")] = None,
        filters_assembly_level: Annotated[Optional[List[V2reportsAssemblyLevel]], Field(description="Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)")] = None,
        filters_first_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date")] = None,
        filters_last_release_date: Annotated[Optional[datetime], Field(description="Limit to genomes released on or before the specified date")] = None,
        filters_search_text: Annotated[Optional[List[StrictStr]], Field(description="Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.")] = None,
        filters_is_metagenome_derived: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter], Field(description="Exclude or limit to metagenome-assembled genomes (MAGs).")] = None,
        filters_is_type_material: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from type material.")] = None,
        filters_is_ictv_exemplar: Annotated[Optional[StrictBool], Field(description="If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).")] = None,
        filters_exclude_multi_isolate: Annotated[Optional[StrictBool], Field(description="If true, exclude genomes that were sequenced as part of large multi-isolate projects.")] = None,
        filters_type_material_category: Annotated[Optional[V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory], Field(description="Limit to genomes derived from specific type material categories.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        returned_content: Annotated[Optional[V2AssemblyDatasetReportsRequestContentType], Field(description="Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Specify when to include the table header when requesting a tabular report.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a genome assembly data report by WGS accession

        Get a genome assembly data report by WGS (whole genome shotgun) accession.  By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param wgs_accessions: One or more WGS accessions associated with a genome assembly (required)
        :type wgs_accessions: List[str]
        :param filters_reference_only: If true, limit to reference genome assemblies.
        :type filters_reference_only: bool
        :param filters_assembly_source: Limit to either RefSeq (GCF_) or GenBank (GCA_) genome assemblies.
        :type filters_assembly_source: V2AssemblyDatasetDescriptorsFilterAssemblySource
        :param filters_has_annotation: Limit to annotated genome assemblies.
        :type filters_has_annotation: bool
        :param filters_exclude_paired_reports: If true, for GenBank (GCA_)/RefSeq (GCF_) pairs, returns the RefSeq copy. When no RefSeq copy exists, the GenBank assembly is returned.
        :type filters_exclude_paired_reports: bool
        :param filters_exclude_atypical: If true, exclude [atypical genome assemblies](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/data-processing/policies-annotation/genome-processing/genome_notes/#atypical-assemblies), i.e., genomes that have assembly issues or are otherwise atypical.
        :type filters_exclude_atypical: bool
        :param filters_assembly_version: Limit to the most recent (current) version of a genome assembly.
        :type filters_assembly_version: V2AssemblyDatasetDescriptorsFilterAssemblyVersion
        :param filters_assembly_level: Limit to genomes at the specified [assembly level](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/glossary/#assembly-level)
        :type filters_assembly_level: List[V2reportsAssemblyLevel]
        :param filters_first_release_date: Limit to genomes released on or after the specified date
        :type filters_first_release_date: datetime
        :param filters_last_release_date: Limit to genomes released on or before the specified date
        :type filters_last_release_date: datetime
        :param filters_search_text: Limit to genomes that match the specified submitter name, assembly name, infraspecific name (or modifier), or organism name.
        :type filters_search_text: List[str]
        :param filters_is_metagenome_derived: Exclude or limit to metagenome-assembled genomes (MAGs).
        :type filters_is_metagenome_derived: V2AssemblyDatasetDescriptorsFilterMetagenomeDerivedFilter
        :param filters_is_type_material: If true, limit to genomes derived from type material.
        :type filters_is_type_material: bool
        :param filters_is_ictv_exemplar: If true, limit to genomes derived from an ICTV exemplar (only applies to virus genomes).
        :type filters_is_ictv_exemplar: bool
        :param filters_exclude_multi_isolate: If true, exclude genomes that were sequenced as part of large multi-isolate projects.
        :type filters_exclude_multi_isolate: bool
        :param filters_type_material_category: Limit to genomes derived from specific type material categories.
        :type filters_type_material_category: V2AssemblyDatasetDescriptorsFilterTypeMaterialCategory
        :param tax_exact_match: If true, only return assemblies matching the specified taxon, but not child taxa. For example, if querying by \"Canis lupus\", return Canis lupus but not Canis lupus familiaris genomes.
        :type tax_exact_match: bool
        :param table_fields:
        :type table_fields: List[str]
        :param returned_content: Return complete genome assembly reports, or abbreviated reports with assembly accessions with or without paired assembly information.
        :type returned_content: V2AssemblyDatasetReportsRequestContentType
        :param page_size: The maximum number of genome assembly reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param include_tabular_header: Specify when to include the table header when requesting a tabular report.
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_dataset_reports_by_wgs_serialize(
            wgs_accessions=wgs_accessions,
            filters_reference_only=filters_reference_only,
            filters_assembly_source=filters_assembly_source,
            filters_has_annotation=filters_has_annotation,
            filters_exclude_paired_reports=filters_exclude_paired_reports,
            filters_exclude_atypical=filters_exclude_atypical,
            filters_assembly_version=filters_assembly_version,
            filters_assembly_level=filters_assembly_level,
            filters_first_release_date=filters_first_release_date,
            filters_last_release_date=filters_last_release_date,
            filters_search_text=filters_search_text,
            filters_is_metagenome_derived=filters_is_metagenome_derived,
            filters_is_type_material=filters_is_type_material,
            filters_is_ictv_exemplar=filters_is_ictv_exemplar,
            filters_exclude_multi_isolate=filters_exclude_multi_isolate,
            filters_type_material_category=filters_type_material_category,
            tax_exact_match=tax_exact_match,
            table_fields=table_fields,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            sort_field=sort_field,
            sort_direction=sort_direction,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsAssemblyDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_dataset_reports_by_wgs_serialize(
        self,
        wgs_accessions,
        filters_reference_only,
        filters_assembly_source,
        filters_has_annotation,
        filters_exclude_paired_reports,
        filters_exclude_atypical,
        filters_assembly_version,
        filters_assembly_level,
        filters_first_release_date,
        filters_last_release_date,
        filters_search_text,
        filters_is_metagenome_derived,
        filters_is_type_material,
        filters_is_ictv_exemplar,
        filters_exclude_multi_isolate,
        filters_type_material_category,
        tax_exact_match,
        table_fields,
        returned_content,
        page_size,
        page_token,
        sort_field,
        sort_direction,
        include_tabular_header,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'wgs_accessions': 'csv',
            'filters.assembly_level': 'multi',
            'filters.search_text': 'multi',
            'table_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if wgs_accessions is not None:
            _path_params['wgs_accessions'] = wgs_accessions
        # process the query parameters
        if filters_reference_only is not None:
            
            _query_params.append(('filters.reference_only', filters_reference_only))
            
        if filters_assembly_source is not None:
            
            _query_params.append(('filters.assembly_source', filters_assembly_source.value))
            
        if filters_has_annotation is not None:
            
            _query_params.append(('filters.has_annotation', filters_has_annotation))
            
        if filters_exclude_paired_reports is not None:
            
            _query_params.append(('filters.exclude_paired_reports', filters_exclude_paired_reports))
            
        if filters_exclude_atypical is not None:
            
            _query_params.append(('filters.exclude_atypical', filters_exclude_atypical))
            
        if filters_assembly_version is not None:
            
            _query_params.append(('filters.assembly_version', filters_assembly_version.value))
            
        if filters_assembly_level is not None:
            
            _query_params.append(('filters.assembly_level', filters_assembly_level))
            
        if filters_first_release_date is not None:
            if isinstance(filters_first_release_date, datetime):
                _query_params.append(
                    (
                        'filters.first_release_date',
                        filters_first_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filters.first_release_date', filters_first_release_date))
            
        if filters_last_release_date is not None:
            if isinstance(filters_last_release_date, datetime):
                _query_params.append(
                    (
                        'filters.last_release_date',
                        filters_last_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filters.last_release_date', filters_last_release_date))
            
        if filters_search_text is not None:
            
            _query_params.append(('filters.search_text', filters_search_text))
            
        if filters_is_metagenome_derived is not None:
            
            _query_params.append(('filters.is_metagenome_derived', filters_is_metagenome_derived.value))
            
        if filters_is_type_material is not None:
            
            _query_params.append(('filters.is_type_material', filters_is_type_material))
            
        if filters_is_ictv_exemplar is not None:
            
            _query_params.append(('filters.is_ictv_exemplar', filters_is_ictv_exemplar))
            
        if filters_exclude_multi_isolate is not None:
            
            _query_params.append(('filters.exclude_multi_isolate', filters_exclude_multi_isolate))
            
        if filters_type_material_category is not None:
            
            _query_params.append(('filters.type_material_category', filters_type_material_category.value))
            
        if tax_exact_match is not None:
            
            _query_params.append(('tax_exact_match', tax_exact_match))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/wgs/{wgs_accessions}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_download_summary(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        chromosomes: Annotated[Optional[List[StrictStr]], Field(description="Only return genomic fasta sequence for the specified chromosomes.")] = None,
        include_annotation_type: Annotated[Optional[List[V2AnnotationForAssemblyType]], Field(description="Specify which sequence, annotation, and report files to include in the data package. The assembly data report is always included, and its inclusion is not affected by this parameter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2DownloadSummary:
        """Get a download summary (preview) of a genome data package by genome assembly accession

        Get a download summary (preview) of a genome data package, including counts and file sizes, in JSON format.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param chromosomes: Only return genomic fasta sequence for the specified chromosomes.
        :type chromosomes: List[str]
        :param include_annotation_type: Specify which sequence, annotation, and report files to include in the data package. The assembly data report is always included, and its inclusion is not affected by this parameter.
        :type include_annotation_type: List[V2AnnotationForAssemblyType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_download_summary_serialize(
            accessions=accessions,
            chromosomes=chromosomes,
            include_annotation_type=include_annotation_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_download_summary_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        chromosomes: Annotated[Optional[List[StrictStr]], Field(description="Only return genomic fasta sequence for the specified chromosomes.")] = None,
        include_annotation_type: Annotated[Optional[List[V2AnnotationForAssemblyType]], Field(description="Specify which sequence, annotation, and report files to include in the data package. The assembly data report is always included, and its inclusion is not affected by this parameter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2DownloadSummary]:
        """Get a download summary (preview) of a genome data package by genome assembly accession

        Get a download summary (preview) of a genome data package, including counts and file sizes, in JSON format.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param chromosomes: Only return genomic fasta sequence for the specified chromosomes.
        :type chromosomes: List[str]
        :param include_annotation_type: Specify which sequence, annotation, and report files to include in the data package. The assembly data report is always included, and its inclusion is not affected by this parameter.
        :type include_annotation_type: List[V2AnnotationForAssemblyType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_download_summary_serialize(
            accessions=accessions,
            chromosomes=chromosomes,
            include_annotation_type=include_annotation_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_download_summary_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        chromosomes: Annotated[Optional[List[StrictStr]], Field(description="Only return genomic fasta sequence for the specified chromosomes.")] = None,
        include_annotation_type: Annotated[Optional[List[V2AnnotationForAssemblyType]], Field(description="Specify which sequence, annotation, and report files to include in the data package. The assembly data report is always included, and its inclusion is not affected by this parameter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a download summary (preview) of a genome data package by genome assembly accession

        Get a download summary (preview) of a genome data package, including counts and file sizes, in JSON format.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param chromosomes: Only return genomic fasta sequence for the specified chromosomes.
        :type chromosomes: List[str]
        :param include_annotation_type: Specify which sequence, annotation, and report files to include in the data package. The assembly data report is always included, and its inclusion is not affected by this parameter.
        :type include_annotation_type: List[V2AnnotationForAssemblyType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_download_summary_serialize(
            accessions=accessions,
            chromosomes=chromosomes,
            include_annotation_type=include_annotation_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_download_summary_serialize(
        self,
        accessions,
        chromosomes,
        include_annotation_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
            'chromosomes': 'multi',
            'include_annotation_type': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        if chromosomes is not None:
            
            _query_params.append(('chromosomes', chromosomes))
            
        if include_annotation_type is not None:
            
            _query_params.append(('include_annotation_type', include_annotation_type))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/accession/{accessions}/download_summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_download_summary_by_post(
        self,
        v2_assembly_dataset_request: V2AssemblyDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2DownloadSummary:
        """Get a download summary (preview) of a genome data package by genome assembly accession

        Get a downlaod summary (preview) of a genome data package, including counts and file sizes, in JSON format.

        :param v2_assembly_dataset_request: (required)
        :type v2_assembly_dataset_request: V2AssemblyDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_download_summary_by_post_serialize(
            v2_assembly_dataset_request=v2_assembly_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_download_summary_by_post_with_http_info(
        self,
        v2_assembly_dataset_request: V2AssemblyDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2DownloadSummary]:
        """Get a download summary (preview) of a genome data package by genome assembly accession

        Get a downlaod summary (preview) of a genome data package, including counts and file sizes, in JSON format.

        :param v2_assembly_dataset_request: (required)
        :type v2_assembly_dataset_request: V2AssemblyDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_download_summary_by_post_serialize(
            v2_assembly_dataset_request=v2_assembly_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_download_summary_by_post_without_preload_content(
        self,
        v2_assembly_dataset_request: V2AssemblyDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a download summary (preview) of a genome data package by genome assembly accession

        Get a downlaod summary (preview) of a genome data package, including counts and file sizes, in JSON format.

        :param v2_assembly_dataset_request: (required)
        :type v2_assembly_dataset_request: V2AssemblyDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_download_summary_by_post_serialize(
            v2_assembly_dataset_request=v2_assembly_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_download_summary_by_post_serialize(
        self,
        v2_assembly_dataset_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_assembly_dataset_request is not None:
            _body_params = v2_assembly_dataset_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/download_summary',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_links_by_accession(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2AssemblyLinksReply:
        """Get assembly links by genome assembly accession

        Get links to assembly resources by genome assembly accession in JSON format.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_links_by_accession_serialize(
            accessions=accessions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyLinksReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_links_by_accession_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2AssemblyLinksReply]:
        """Get assembly links by genome assembly accession

        Get links to assembly resources by genome assembly accession in JSON format.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_links_by_accession_serialize(
            accessions=accessions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyLinksReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_links_by_accession_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more genome assembly accessions, limited to 100")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get assembly links by genome assembly accession

        Get links to assembly resources by genome assembly accession in JSON format.

        :param accessions: One or more genome assembly accessions, limited to 100 (required)
        :type accessions: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_links_by_accession_serialize(
            accessions=accessions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyLinksReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_links_by_accession_serialize(
        self,
        accessions,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/accession/{accessions}/links',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_links_by_accession_by_post(
        self,
        v2_assembly_links_request: V2AssemblyLinksRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2AssemblyLinksReply:
        """Get assembly links by genome assembly accession

        Get links to assembly resources by genome assembly accession in JSON format.

        :param v2_assembly_links_request: (required)
        :type v2_assembly_links_request: V2AssemblyLinksRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_links_by_accession_by_post_serialize(
            v2_assembly_links_request=v2_assembly_links_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyLinksReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_links_by_accession_by_post_with_http_info(
        self,
        v2_assembly_links_request: V2AssemblyLinksRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2AssemblyLinksReply]:
        """Get assembly links by genome assembly accession

        Get links to assembly resources by genome assembly accession in JSON format.

        :param v2_assembly_links_request: (required)
        :type v2_assembly_links_request: V2AssemblyLinksRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_links_by_accession_by_post_serialize(
            v2_assembly_links_request=v2_assembly_links_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyLinksReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_links_by_accession_by_post_without_preload_content(
        self,
        v2_assembly_links_request: V2AssemblyLinksRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get assembly links by genome assembly accession

        Get links to assembly resources by genome assembly accession in JSON format.

        :param v2_assembly_links_request: (required)
        :type v2_assembly_links_request: V2AssemblyLinksRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_links_by_accession_by_post_serialize(
            v2_assembly_links_request=v2_assembly_links_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2AssemblyLinksReply",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_links_by_accession_by_post_serialize(
        self,
        v2_assembly_links_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_assembly_links_request is not None:
            _body_params = v2_assembly_links_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/links',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_sequence_report(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        chromosomes: Annotated[Optional[List[StrictStr]], Field(description="Limit to sequences with the specified chromosome names")] = None,
        role_filters: Annotated[Optional[List[StrictStr]], Field(description="Limit to sequences with the specified \"role\", where possible roles are `assembled-molecule`, `unlocalized-scaffold`, or `unplaced-scaffold`")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        count_assembly_unplaced: Annotated[Optional[StrictBool], Field(description="Include the count of unplaced scaffold sequences")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assemblies to return. Maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        include_tabular_header: Optional[V2IncludeTabularHeader] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2SequenceReportPage:
        """Get a genome sequence report by genome assembly accession

        Get a genome sequence report by genome assembly accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param chromosomes: Limit to sequences with the specified chromosome names
        :type chromosomes: List[str]
        :param role_filters: Limit to sequences with the specified \"role\", where possible roles are `assembled-molecule`, `unlocalized-scaffold`, or `unplaced-scaffold`
        :type role_filters: List[str]
        :param table_fields:
        :type table_fields: List[str]
        :param count_assembly_unplaced: Include the count of unplaced scaffold sequences
        :type count_assembly_unplaced: bool
        :param page_size: The maximum number of genome assemblies to return. Maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param include_tabular_header:
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_sequence_report_serialize(
            accession=accession,
            chromosomes=chromosomes,
            role_filters=role_filters,
            table_fields=table_fields,
            count_assembly_unplaced=count_assembly_unplaced,
            page_size=page_size,
            page_token=page_token,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2SequenceReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_sequence_report_with_http_info(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        chromosomes: Annotated[Optional[List[StrictStr]], Field(description="Limit to sequences with the specified chromosome names")] = None,
        role_filters: Annotated[Optional[List[StrictStr]], Field(description="Limit to sequences with the specified \"role\", where possible roles are `assembled-molecule`, `unlocalized-scaffold`, or `unplaced-scaffold`")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        count_assembly_unplaced: Annotated[Optional[StrictBool], Field(description="Include the count of unplaced scaffold sequences")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assemblies to return. Maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        include_tabular_header: Optional[V2IncludeTabularHeader] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2SequenceReportPage]:
        """Get a genome sequence report by genome assembly accession

        Get a genome sequence report by genome assembly accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param chromosomes: Limit to sequences with the specified chromosome names
        :type chromosomes: List[str]
        :param role_filters: Limit to sequences with the specified \"role\", where possible roles are `assembled-molecule`, `unlocalized-scaffold`, or `unplaced-scaffold`
        :type role_filters: List[str]
        :param table_fields:
        :type table_fields: List[str]
        :param count_assembly_unplaced: Include the count of unplaced scaffold sequences
        :type count_assembly_unplaced: bool
        :param page_size: The maximum number of genome assemblies to return. Maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param include_tabular_header:
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_sequence_report_serialize(
            accession=accession,
            chromosomes=chromosomes,
            role_filters=role_filters,
            table_fields=table_fields,
            count_assembly_unplaced=count_assembly_unplaced,
            page_size=page_size,
            page_token=page_token,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2SequenceReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_sequence_report_without_preload_content(
        self,
        accession: Annotated[StrictStr, Field(description="One or more genome assembly accessions, limited to 100")],
        chromosomes: Annotated[Optional[List[StrictStr]], Field(description="Limit to sequences with the specified chromosome names")] = None,
        role_filters: Annotated[Optional[List[StrictStr]], Field(description="Limit to sequences with the specified \"role\", where possible roles are `assembled-molecule`, `unlocalized-scaffold`, or `unplaced-scaffold`")] = None,
        table_fields: Optional[List[StrictStr]] = None,
        count_assembly_unplaced: Annotated[Optional[StrictBool], Field(description="Include the count of unplaced scaffold sequences")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of genome assemblies to return. Maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        include_tabular_header: Optional[V2IncludeTabularHeader] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a genome sequence report by genome assembly accession

        Get a genome sequence report by genome assembly accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accession: One or more genome assembly accessions, limited to 100 (required)
        :type accession: str
        :param chromosomes: Limit to sequences with the specified chromosome names
        :type chromosomes: List[str]
        :param role_filters: Limit to sequences with the specified \"role\", where possible roles are `assembled-molecule`, `unlocalized-scaffold`, or `unplaced-scaffold`
        :type role_filters: List[str]
        :param table_fields:
        :type table_fields: List[str]
        :param count_assembly_unplaced: Include the count of unplaced scaffold sequences
        :type count_assembly_unplaced: bool
        :param page_size: The maximum number of genome assemblies to return. Maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param include_tabular_header:
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_sequence_report_serialize(
            accession=accession,
            chromosomes=chromosomes,
            role_filters=role_filters,
            table_fields=table_fields,
            count_assembly_unplaced=count_assembly_unplaced,
            page_size=page_size,
            page_token=page_token,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2SequenceReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_sequence_report_serialize(
        self,
        accession,
        chromosomes,
        role_filters,
        table_fields,
        count_assembly_unplaced,
        page_size,
        page_token,
        include_tabular_header,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'chromosomes': 'multi',
            'role_filters': 'multi',
            'table_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accession is not None:
            _path_params['accession'] = accession
        # process the query parameters
        if chromosomes is not None:
            
            _query_params.append(('chromosomes', chromosomes))
            
        if role_filters is not None:
            
            _query_params.append(('role_filters', role_filters))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if count_assembly_unplaced is not None:
            
            _query_params.append(('count_assembly_unplaced', count_assembly_unplaced))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'text/tab-separated-values', 
                    'application/x-ndjson'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/genome/accession/{accession}/sequence_reports',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def genome_sequence_report_by_post(
        self,
        v2_assembly_sequence_reports_request: V2AssemblySequenceReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2SequenceReportPage:
        """Get a genome sequence report by genome assembly accession

        Get a genome sequence report by genome assembly accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_assembly_sequence_reports_request: (required)
        :type v2_assembly_sequence_reports_request: V2AssemblySequenceReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_sequence_report_by_post_serialize(
            v2_assembly_sequence_reports_request=v2_assembly_sequence_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2SequenceReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def genome_sequence_report_by_post_with_http_info(
        self,
        v2_assembly_sequence_reports_request: V2AssemblySequenceReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2SequenceReportPage]:
        """Get a genome sequence report by genome assembly accession

        Get a genome sequence report by genome assembly accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_assembly_sequence_reports_request: (required)
        :type v2_assembly_sequence_reports_request: V2AssemblySequenceReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_sequence_report_by_post_serialize(
            v2_assembly_sequence_reports_request=v2_assembly_sequence_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2SequenceReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def genome_sequence_report_by_post_without_preload_content(
        self,
        v2_assembly_sequence_reports_request: V2AssemblySequenceReportsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a genome sequence report by genome assembly accession

        Get a genome sequence report by genome assembly accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_assembly_sequence_reports_request: (required)
        :type v2_assembly_sequence_reports_request: V2AssemblySequenceReportsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._genome_sequence_report_by_post_serialize(
            v2_assembly_sequence_reports_request=v2_assembly_sequence_reports_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2SequenceReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _genome_sequence_report_by_post_serialize(
        self,
        v2_assembly_sequence_reports_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_assembly_sequence_reports_request is not None:
            _body_params = v2_assembly_sequence_reports_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'text/tab-separated-values', 
                    'application/x-ndjson'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/genome/sequence_reports',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


