# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr
from typing import List, Optional, Tuple, Union
from typing_extensions import Annotated
from ncbi.datasets.openapi.models.v2_annotation_for_organelle_type import V2AnnotationForOrganelleType
from ncbi.datasets.openapi.models.v2_include_tabular_header import V2IncludeTabularHeader
from ncbi.datasets.openapi.models.v2_organelle_download_request import V2OrganelleDownloadRequest
from ncbi.datasets.openapi.models.v2_organelle_metadata_request import V2OrganelleMetadataRequest
from ncbi.datasets.openapi.models.v2_organelle_metadata_request_content_type import V2OrganelleMetadataRequestContentType
from ncbi.datasets.openapi.models.v2_organelle_metadata_request_organelle_table_format import V2OrganelleMetadataRequestOrganelleTableFormat
from ncbi.datasets.openapi.models.v2_sort_direction import V2SortDirection
from ncbi.datasets.openapi.models.v2reports_organelle_data_reports import V2reportsOrganelleDataReports
from ncbi.datasets.openapi.models.v2reports_organelle_type import V2reportsOrganelleType

from ncbi.datasets.openapi.api_client import ApiClient, RequestSerialized
from ncbi.datasets.openapi.api_response import ApiResponse
from ncbi.datasets.openapi.rest import RESTResponseType


class OrganelleApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def download_organelle_package(
        self,
        accessions: Annotated[List[StrictStr], Field(description="NCBI organelle assembly accessions")],
        exclude_sequence: Annotated[Optional[StrictBool], Field(description="Set to true to omit the genomic sequence.")] = None,
        include_annotation_type: Annotated[Optional[List[V2AnnotationForOrganelleType]], Field(description="Select additional types of annotation to include in the data package.  If unset, no annotation is provided.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a organelle data package by accesions

        Download a organelle data report and annotation data package.

        :param accessions: NCBI organelle assembly accessions (required)
        :type accessions: List[str]
        :param exclude_sequence: Set to true to omit the genomic sequence.
        :type exclude_sequence: bool
        :param include_annotation_type: Select additional types of annotation to include in the data package.  If unset, no annotation is provided.
        :type include_annotation_type: List[V2AnnotationForOrganelleType]
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_organelle_package_serialize(
            accessions=accessions,
            exclude_sequence=exclude_sequence,
            include_annotation_type=include_annotation_type,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_organelle_package_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="NCBI organelle assembly accessions")],
        exclude_sequence: Annotated[Optional[StrictBool], Field(description="Set to true to omit the genomic sequence.")] = None,
        include_annotation_type: Annotated[Optional[List[V2AnnotationForOrganelleType]], Field(description="Select additional types of annotation to include in the data package.  If unset, no annotation is provided.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a organelle data package by accesions

        Download a organelle data report and annotation data package.

        :param accessions: NCBI organelle assembly accessions (required)
        :type accessions: List[str]
        :param exclude_sequence: Set to true to omit the genomic sequence.
        :type exclude_sequence: bool
        :param include_annotation_type: Select additional types of annotation to include in the data package.  If unset, no annotation is provided.
        :type include_annotation_type: List[V2AnnotationForOrganelleType]
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_organelle_package_serialize(
            accessions=accessions,
            exclude_sequence=exclude_sequence,
            include_annotation_type=include_annotation_type,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_organelle_package_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="NCBI organelle assembly accessions")],
        exclude_sequence: Annotated[Optional[StrictBool], Field(description="Set to true to omit the genomic sequence.")] = None,
        include_annotation_type: Annotated[Optional[List[V2AnnotationForOrganelleType]], Field(description="Select additional types of annotation to include in the data package.  If unset, no annotation is provided.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a organelle data package by accesions

        Download a organelle data report and annotation data package.

        :param accessions: NCBI organelle assembly accessions (required)
        :type accessions: List[str]
        :param exclude_sequence: Set to true to omit the genomic sequence.
        :type exclude_sequence: bool
        :param include_annotation_type: Select additional types of annotation to include in the data package.  If unset, no annotation is provided.
        :type include_annotation_type: List[V2AnnotationForOrganelleType]
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_organelle_package_serialize(
            accessions=accessions,
            exclude_sequence=exclude_sequence,
            include_annotation_type=include_annotation_type,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_organelle_package_serialize(
        self,
        accessions,
        exclude_sequence,
        include_annotation_type,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
            'include_annotation_type': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        if exclude_sequence is not None:
            
            _query_params.append(('exclude_sequence', exclude_sequence))
            
        if include_annotation_type is not None:
            
            _query_params.append(('include_annotation_type', include_annotation_type))
            
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/organelle/accession/{accessions}/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def download_organelle_package_by_post(
        self,
        v2_organelle_download_request: V2OrganelleDownloadRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a organelle data package by post

        Download a organelle report and annotation data package by post.

        :param v2_organelle_download_request: (required)
        :type v2_organelle_download_request: V2OrganelleDownloadRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_organelle_package_by_post_serialize(
            v2_organelle_download_request=v2_organelle_download_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_organelle_package_by_post_with_http_info(
        self,
        v2_organelle_download_request: V2OrganelleDownloadRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a organelle data package by post

        Download a organelle report and annotation data package by post.

        :param v2_organelle_download_request: (required)
        :type v2_organelle_download_request: V2OrganelleDownloadRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_organelle_package_by_post_serialize(
            v2_organelle_download_request=v2_organelle_download_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_organelle_package_by_post_without_preload_content(
        self,
        v2_organelle_download_request: V2OrganelleDownloadRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a organelle data package by post

        Download a organelle report and annotation data package by post.

        :param v2_organelle_download_request: (required)
        :type v2_organelle_download_request: V2OrganelleDownloadRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_organelle_package_by_post_serialize(
            v2_organelle_download_request=v2_organelle_download_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_organelle_package_by_post_serialize(
        self,
        v2_organelle_download_request,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_organelle_download_request is not None:
            _body_params = v2_organelle_download_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/organelle/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def organelle_datareport_by_accession(
        self,
        accessions: Annotated[List[StrictStr], Field(description="NCBI assembly accession")],
        taxons: Annotated[Optional[List[StrictStr]], Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")] = None,
        organelle_types: Optional[List[V2reportsOrganelleType]] = None,
        first_release_date: Annotated[Optional[datetime], Field(description="Only return organelle assemblies that were released on or after the specified date By default, do not filter.")] = None,
        last_release_date: Annotated[Optional[datetime], Field(description="Only return organelle assemblies that were released on or before to the specified date By default, do not filter.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        returned_content: Annotated[Optional[V2OrganelleMetadataRequestContentType], Field(description="Return either assembly accessions, or entire assembly-metadata records")] = None,
        table_format: Annotated[Optional[V2OrganelleMetadataRequestOrganelleTableFormat], Field(description="Optional pre-defined template for processing a tabular data request")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Whether this request for tabular data should include the header row")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsOrganelleDataReports:
        """Get Organelle dataset report by accession

        Get Organelle dataset report by accession.

        :param accessions: NCBI assembly accession (required)
        :type accessions: List[str]
        :param taxons: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank
        :type taxons: List[str]
        :param organelle_types:
        :type organelle_types: List[V2reportsOrganelleType]
        :param first_release_date: Only return organelle assemblies that were released on or after the specified date By default, do not filter.
        :type first_release_date: datetime
        :param last_release_date: Only return organelle assemblies that were released on or before to the specified date By default, do not filter.
        :type last_release_date: datetime
        :param tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too.
        :type tax_exact_match: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param returned_content: Return either assembly accessions, or entire assembly-metadata records
        :type returned_content: V2OrganelleMetadataRequestContentType
        :param table_format: Optional pre-defined template for processing a tabular data request
        :type table_format: V2OrganelleMetadataRequestOrganelleTableFormat
        :param include_tabular_header: Whether this request for tabular data should include the header row
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organelle_datareport_by_accession_serialize(
            accessions=accessions,
            taxons=taxons,
            organelle_types=organelle_types,
            first_release_date=first_release_date,
            last_release_date=last_release_date,
            tax_exact_match=tax_exact_match,
            sort_field=sort_field,
            sort_direction=sort_direction,
            returned_content=returned_content,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsOrganelleDataReports",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def organelle_datareport_by_accession_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="NCBI assembly accession")],
        taxons: Annotated[Optional[List[StrictStr]], Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")] = None,
        organelle_types: Optional[List[V2reportsOrganelleType]] = None,
        first_release_date: Annotated[Optional[datetime], Field(description="Only return organelle assemblies that were released on or after the specified date By default, do not filter.")] = None,
        last_release_date: Annotated[Optional[datetime], Field(description="Only return organelle assemblies that were released on or before to the specified date By default, do not filter.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        returned_content: Annotated[Optional[V2OrganelleMetadataRequestContentType], Field(description="Return either assembly accessions, or entire assembly-metadata records")] = None,
        table_format: Annotated[Optional[V2OrganelleMetadataRequestOrganelleTableFormat], Field(description="Optional pre-defined template for processing a tabular data request")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Whether this request for tabular data should include the header row")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsOrganelleDataReports]:
        """Get Organelle dataset report by accession

        Get Organelle dataset report by accession.

        :param accessions: NCBI assembly accession (required)
        :type accessions: List[str]
        :param taxons: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank
        :type taxons: List[str]
        :param organelle_types:
        :type organelle_types: List[V2reportsOrganelleType]
        :param first_release_date: Only return organelle assemblies that were released on or after the specified date By default, do not filter.
        :type first_release_date: datetime
        :param last_release_date: Only return organelle assemblies that were released on or before to the specified date By default, do not filter.
        :type last_release_date: datetime
        :param tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too.
        :type tax_exact_match: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param returned_content: Return either assembly accessions, or entire assembly-metadata records
        :type returned_content: V2OrganelleMetadataRequestContentType
        :param table_format: Optional pre-defined template for processing a tabular data request
        :type table_format: V2OrganelleMetadataRequestOrganelleTableFormat
        :param include_tabular_header: Whether this request for tabular data should include the header row
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organelle_datareport_by_accession_serialize(
            accessions=accessions,
            taxons=taxons,
            organelle_types=organelle_types,
            first_release_date=first_release_date,
            last_release_date=last_release_date,
            tax_exact_match=tax_exact_match,
            sort_field=sort_field,
            sort_direction=sort_direction,
            returned_content=returned_content,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsOrganelleDataReports",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def organelle_datareport_by_accession_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="NCBI assembly accession")],
        taxons: Annotated[Optional[List[StrictStr]], Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")] = None,
        organelle_types: Optional[List[V2reportsOrganelleType]] = None,
        first_release_date: Annotated[Optional[datetime], Field(description="Only return organelle assemblies that were released on or after the specified date By default, do not filter.")] = None,
        last_release_date: Annotated[Optional[datetime], Field(description="Only return organelle assemblies that were released on or before to the specified date By default, do not filter.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        returned_content: Annotated[Optional[V2OrganelleMetadataRequestContentType], Field(description="Return either assembly accessions, or entire assembly-metadata records")] = None,
        table_format: Annotated[Optional[V2OrganelleMetadataRequestOrganelleTableFormat], Field(description="Optional pre-defined template for processing a tabular data request")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Whether this request for tabular data should include the header row")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Organelle dataset report by accession

        Get Organelle dataset report by accession.

        :param accessions: NCBI assembly accession (required)
        :type accessions: List[str]
        :param taxons: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank
        :type taxons: List[str]
        :param organelle_types:
        :type organelle_types: List[V2reportsOrganelleType]
        :param first_release_date: Only return organelle assemblies that were released on or after the specified date By default, do not filter.
        :type first_release_date: datetime
        :param last_release_date: Only return organelle assemblies that were released on or before to the specified date By default, do not filter.
        :type last_release_date: datetime
        :param tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too.
        :type tax_exact_match: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param returned_content: Return either assembly accessions, or entire assembly-metadata records
        :type returned_content: V2OrganelleMetadataRequestContentType
        :param table_format: Optional pre-defined template for processing a tabular data request
        :type table_format: V2OrganelleMetadataRequestOrganelleTableFormat
        :param include_tabular_header: Whether this request for tabular data should include the header row
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organelle_datareport_by_accession_serialize(
            accessions=accessions,
            taxons=taxons,
            organelle_types=organelle_types,
            first_release_date=first_release_date,
            last_release_date=last_release_date,
            tax_exact_match=tax_exact_match,
            sort_field=sort_field,
            sort_direction=sort_direction,
            returned_content=returned_content,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsOrganelleDataReports",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _organelle_datareport_by_accession_serialize(
        self,
        accessions,
        taxons,
        organelle_types,
        first_release_date,
        last_release_date,
        tax_exact_match,
        sort_field,
        sort_direction,
        returned_content,
        table_format,
        include_tabular_header,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
            'taxons': 'multi',
            'organelle_types': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        if taxons is not None:
            
            _query_params.append(('taxons', taxons))
            
        if organelle_types is not None:
            
            _query_params.append(('organelle_types', organelle_types))
            
        if first_release_date is not None:
            if isinstance(first_release_date, datetime):
                _query_params.append(
                    (
                        'first_release_date',
                        first_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('first_release_date', first_release_date))
            
        if last_release_date is not None:
            if isinstance(last_release_date, datetime):
                _query_params.append(
                    (
                        'last_release_date',
                        last_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('last_release_date', last_release_date))
            
        if tax_exact_match is not None:
            
            _query_params.append(('tax_exact_match', tax_exact_match))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format.value))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/organelle/accessions/{accessions}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def organelle_datareport_by_post(
        self,
        v2_organelle_metadata_request: V2OrganelleMetadataRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsOrganelleDataReports:
        """Get Organelle dataset report by http post

        Get Organelle dataset report by http post.

        :param v2_organelle_metadata_request: (required)
        :type v2_organelle_metadata_request: V2OrganelleMetadataRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organelle_datareport_by_post_serialize(
            v2_organelle_metadata_request=v2_organelle_metadata_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsOrganelleDataReports",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def organelle_datareport_by_post_with_http_info(
        self,
        v2_organelle_metadata_request: V2OrganelleMetadataRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsOrganelleDataReports]:
        """Get Organelle dataset report by http post

        Get Organelle dataset report by http post.

        :param v2_organelle_metadata_request: (required)
        :type v2_organelle_metadata_request: V2OrganelleMetadataRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organelle_datareport_by_post_serialize(
            v2_organelle_metadata_request=v2_organelle_metadata_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsOrganelleDataReports",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def organelle_datareport_by_post_without_preload_content(
        self,
        v2_organelle_metadata_request: V2OrganelleMetadataRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Organelle dataset report by http post

        Get Organelle dataset report by http post.

        :param v2_organelle_metadata_request: (required)
        :type v2_organelle_metadata_request: V2OrganelleMetadataRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organelle_datareport_by_post_serialize(
            v2_organelle_metadata_request=v2_organelle_metadata_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsOrganelleDataReports",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _organelle_datareport_by_post_serialize(
        self,
        v2_organelle_metadata_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_organelle_metadata_request is not None:
            _body_params = v2_organelle_metadata_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/organelle/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def organelle_datareport_by_taxon(
        self,
        taxons: Annotated[List[StrictStr], Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        organelle_types: Optional[List[V2reportsOrganelleType]] = None,
        first_release_date: Annotated[Optional[datetime], Field(description="Only return organelle assemblies that were released on or after the specified date By default, do not filter.")] = None,
        last_release_date: Annotated[Optional[datetime], Field(description="Only return organelle assemblies that were released on or before to the specified date By default, do not filter.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        returned_content: Annotated[Optional[V2OrganelleMetadataRequestContentType], Field(description="Return either assembly accessions, or entire assembly-metadata records")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of organelle assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned from an `OrganelleMetadata` call with more than `page_size` results. Use this token, along with the previous `OrganelleMetadata` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        table_format: Annotated[Optional[V2OrganelleMetadataRequestOrganelleTableFormat], Field(description="Optional pre-defined template for processing a tabular data request")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Whether this request for tabular data should include the header row")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsOrganelleDataReports:
        """Get Organelle dataset report by taxons

        Get Organelle dataset report by taxons.

        :param taxons: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxons: List[str]
        :param organelle_types:
        :type organelle_types: List[V2reportsOrganelleType]
        :param first_release_date: Only return organelle assemblies that were released on or after the specified date By default, do not filter.
        :type first_release_date: datetime
        :param last_release_date: Only return organelle assemblies that were released on or before to the specified date By default, do not filter.
        :type last_release_date: datetime
        :param tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too.
        :type tax_exact_match: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param returned_content: Return either assembly accessions, or entire assembly-metadata records
        :type returned_content: V2OrganelleMetadataRequestContentType
        :param page_size: The maximum number of organelle assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned from an `OrganelleMetadata` call with more than `page_size` results. Use this token, along with the previous `OrganelleMetadata` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param table_format: Optional pre-defined template for processing a tabular data request
        :type table_format: V2OrganelleMetadataRequestOrganelleTableFormat
        :param include_tabular_header: Whether this request for tabular data should include the header row
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organelle_datareport_by_taxon_serialize(
            taxons=taxons,
            organelle_types=organelle_types,
            first_release_date=first_release_date,
            last_release_date=last_release_date,
            tax_exact_match=tax_exact_match,
            sort_field=sort_field,
            sort_direction=sort_direction,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsOrganelleDataReports",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def organelle_datareport_by_taxon_with_http_info(
        self,
        taxons: Annotated[List[StrictStr], Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        organelle_types: Optional[List[V2reportsOrganelleType]] = None,
        first_release_date: Annotated[Optional[datetime], Field(description="Only return organelle assemblies that were released on or after the specified date By default, do not filter.")] = None,
        last_release_date: Annotated[Optional[datetime], Field(description="Only return organelle assemblies that were released on or before to the specified date By default, do not filter.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        returned_content: Annotated[Optional[V2OrganelleMetadataRequestContentType], Field(description="Return either assembly accessions, or entire assembly-metadata records")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of organelle assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned from an `OrganelleMetadata` call with more than `page_size` results. Use this token, along with the previous `OrganelleMetadata` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        table_format: Annotated[Optional[V2OrganelleMetadataRequestOrganelleTableFormat], Field(description="Optional pre-defined template for processing a tabular data request")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Whether this request for tabular data should include the header row")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsOrganelleDataReports]:
        """Get Organelle dataset report by taxons

        Get Organelle dataset report by taxons.

        :param taxons: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxons: List[str]
        :param organelle_types:
        :type organelle_types: List[V2reportsOrganelleType]
        :param first_release_date: Only return organelle assemblies that were released on or after the specified date By default, do not filter.
        :type first_release_date: datetime
        :param last_release_date: Only return organelle assemblies that were released on or before to the specified date By default, do not filter.
        :type last_release_date: datetime
        :param tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too.
        :type tax_exact_match: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param returned_content: Return either assembly accessions, or entire assembly-metadata records
        :type returned_content: V2OrganelleMetadataRequestContentType
        :param page_size: The maximum number of organelle assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned from an `OrganelleMetadata` call with more than `page_size` results. Use this token, along with the previous `OrganelleMetadata` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param table_format: Optional pre-defined template for processing a tabular data request
        :type table_format: V2OrganelleMetadataRequestOrganelleTableFormat
        :param include_tabular_header: Whether this request for tabular data should include the header row
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organelle_datareport_by_taxon_serialize(
            taxons=taxons,
            organelle_types=organelle_types,
            first_release_date=first_release_date,
            last_release_date=last_release_date,
            tax_exact_match=tax_exact_match,
            sort_field=sort_field,
            sort_direction=sort_direction,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsOrganelleDataReports",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def organelle_datareport_by_taxon_without_preload_content(
        self,
        taxons: Annotated[List[StrictStr], Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        organelle_types: Optional[List[V2reportsOrganelleType]] = None,
        first_release_date: Annotated[Optional[datetime], Field(description="Only return organelle assemblies that were released on or after the specified date By default, do not filter.")] = None,
        last_release_date: Annotated[Optional[datetime], Field(description="Only return organelle assemblies that were released on or before to the specified date By default, do not filter.")] = None,
        tax_exact_match: Annotated[Optional[StrictBool], Field(description="If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too.")] = None,
        sort_field: Optional[StrictStr] = None,
        sort_direction: Optional[V2SortDirection] = None,
        returned_content: Annotated[Optional[V2OrganelleMetadataRequestContentType], Field(description="Return either assembly accessions, or entire assembly-metadata records")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of organelle assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned from an `OrganelleMetadata` call with more than `page_size` results. Use this token, along with the previous `OrganelleMetadata` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        table_format: Annotated[Optional[V2OrganelleMetadataRequestOrganelleTableFormat], Field(description="Optional pre-defined template for processing a tabular data request")] = None,
        include_tabular_header: Annotated[Optional[V2IncludeTabularHeader], Field(description="Whether this request for tabular data should include the header row")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Organelle dataset report by taxons

        Get Organelle dataset report by taxons.

        :param taxons: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxons: List[str]
        :param organelle_types:
        :type organelle_types: List[V2reportsOrganelleType]
        :param first_release_date: Only return organelle assemblies that were released on or after the specified date By default, do not filter.
        :type first_release_date: datetime
        :param last_release_date: Only return organelle assemblies that were released on or before to the specified date By default, do not filter.
        :type last_release_date: datetime
        :param tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too.
        :type tax_exact_match: bool
        :param sort_field:
        :type sort_field: str
        :param sort_direction:
        :type sort_direction: V2SortDirection
        :param returned_content: Return either assembly accessions, or entire assembly-metadata records
        :type returned_content: V2OrganelleMetadataRequestContentType
        :param page_size: The maximum number of organelle assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned from an `OrganelleMetadata` call with more than `page_size` results. Use this token, along with the previous `OrganelleMetadata` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param table_format: Optional pre-defined template for processing a tabular data request
        :type table_format: V2OrganelleMetadataRequestOrganelleTableFormat
        :param include_tabular_header: Whether this request for tabular data should include the header row
        :type include_tabular_header: V2IncludeTabularHeader
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._organelle_datareport_by_taxon_serialize(
            taxons=taxons,
            organelle_types=organelle_types,
            first_release_date=first_release_date,
            last_release_date=last_release_date,
            tax_exact_match=tax_exact_match,
            sort_field=sort_field,
            sort_direction=sort_direction,
            returned_content=returned_content,
            page_size=page_size,
            page_token=page_token,
            table_format=table_format,
            include_tabular_header=include_tabular_header,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsOrganelleDataReports",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _organelle_datareport_by_taxon_serialize(
        self,
        taxons,
        organelle_types,
        first_release_date,
        last_release_date,
        tax_exact_match,
        sort_field,
        sort_direction,
        returned_content,
        page_size,
        page_token,
        table_format,
        include_tabular_header,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'taxons': 'csv',
            'organelle_types': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if taxons is not None:
            _path_params['taxons'] = taxons
        # process the query parameters
        if organelle_types is not None:
            
            _query_params.append(('organelle_types', organelle_types))
            
        if first_release_date is not None:
            if isinstance(first_release_date, datetime):
                _query_params.append(
                    (
                        'first_release_date',
                        first_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('first_release_date', first_release_date))
            
        if last_release_date is not None:
            if isinstance(last_release_date, datetime):
                _query_params.append(
                    (
                        'last_release_date',
                        last_release_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('last_release_date', last_release_date))
            
        if tax_exact_match is not None:
            
            _query_params.append(('tax_exact_match', tax_exact_match))
            
        if sort_field is not None:
            
            _query_params.append(('sort.field', sort_field))
            
        if sort_direction is not None:
            
            _query_params.append(('sort.direction', sort_direction.value))
            
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        if table_format is not None:
            
            _query_params.append(('table_format', table_format.value))
            
        if include_tabular_header is not None:
            
            _query_params.append(('include_tabular_header', include_tabular_header.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/organelle/taxon/{taxons}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


