# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBytes, StrictInt, StrictStr
from typing import List, Optional, Tuple, Union
from typing_extensions import Annotated
from ncbi.datasets.openapi.models.v2_fasta import V2Fasta
from ncbi.datasets.openapi.models.v2_prokaryote_gene_request import V2ProkaryoteGeneRequest

from ncbi.datasets.openapi.api_client import ApiClient, RequestSerialized
from ncbi.datasets.openapi.api_response import ApiResponse
from ncbi.datasets.openapi.rest import RESTResponseType


class ProkaryoteApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def download_prokaryote_gene_package(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more RefSeq non-redundant protein accessions (preceded by `WP_`)")],
        include_annotation_type: Annotated[Optional[List[V2Fasta]], Field(description="Specify which sequence files to include in the data package.")] = None,
        gene_flank_config_length: Optional[StrictInt] = None,
        taxon: Annotated[Optional[StrictStr], Field(description="Limit gene sequences and the genome assemblies described by the [annotation report file](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/reference-docs/data-reports/prokaryote-gene-location/) to the specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a prokaryote gene data package by RefSeq protein accession

        Download a prokaryote gene data package including sequence, annotation and data reports by RefSeq non-redundant protein accession.

        :param accessions: One or more RefSeq non-redundant protein accessions (preceded by `WP_`) (required)
        :type accessions: List[str]
        :param include_annotation_type: Specify which sequence files to include in the data package.
        :type include_annotation_type: List[V2Fasta]
        :param gene_flank_config_length:
        :type gene_flank_config_length: int
        :param taxon: Limit gene sequences and the genome assemblies described by the [annotation report file](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/reference-docs/data-reports/prokaryote-gene-location/) to the specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.
        :type taxon: str
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_prokaryote_gene_package_serialize(
            accessions=accessions,
            include_annotation_type=include_annotation_type,
            gene_flank_config_length=gene_flank_config_length,
            taxon=taxon,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_prokaryote_gene_package_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more RefSeq non-redundant protein accessions (preceded by `WP_`)")],
        include_annotation_type: Annotated[Optional[List[V2Fasta]], Field(description="Specify which sequence files to include in the data package.")] = None,
        gene_flank_config_length: Optional[StrictInt] = None,
        taxon: Annotated[Optional[StrictStr], Field(description="Limit gene sequences and the genome assemblies described by the [annotation report file](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/reference-docs/data-reports/prokaryote-gene-location/) to the specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a prokaryote gene data package by RefSeq protein accession

        Download a prokaryote gene data package including sequence, annotation and data reports by RefSeq non-redundant protein accession.

        :param accessions: One or more RefSeq non-redundant protein accessions (preceded by `WP_`) (required)
        :type accessions: List[str]
        :param include_annotation_type: Specify which sequence files to include in the data package.
        :type include_annotation_type: List[V2Fasta]
        :param gene_flank_config_length:
        :type gene_flank_config_length: int
        :param taxon: Limit gene sequences and the genome assemblies described by the [annotation report file](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/reference-docs/data-reports/prokaryote-gene-location/) to the specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.
        :type taxon: str
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_prokaryote_gene_package_serialize(
            accessions=accessions,
            include_annotation_type=include_annotation_type,
            gene_flank_config_length=gene_flank_config_length,
            taxon=taxon,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_prokaryote_gene_package_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more RefSeq non-redundant protein accessions (preceded by `WP_`)")],
        include_annotation_type: Annotated[Optional[List[V2Fasta]], Field(description="Specify which sequence files to include in the data package.")] = None,
        gene_flank_config_length: Optional[StrictInt] = None,
        taxon: Annotated[Optional[StrictStr], Field(description="Limit gene sequences and the genome assemblies described by the [annotation report file](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/reference-docs/data-reports/prokaryote-gene-location/) to the specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a prokaryote gene data package by RefSeq protein accession

        Download a prokaryote gene data package including sequence, annotation and data reports by RefSeq non-redundant protein accession.

        :param accessions: One or more RefSeq non-redundant protein accessions (preceded by `WP_`) (required)
        :type accessions: List[str]
        :param include_annotation_type: Specify which sequence files to include in the data package.
        :type include_annotation_type: List[V2Fasta]
        :param gene_flank_config_length:
        :type gene_flank_config_length: int
        :param taxon: Limit gene sequences and the genome assemblies described by the [annotation report file](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/reference-docs/data-reports/prokaryote-gene-location/) to the specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.
        :type taxon: str
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_prokaryote_gene_package_serialize(
            accessions=accessions,
            include_annotation_type=include_annotation_type,
            gene_flank_config_length=gene_flank_config_length,
            taxon=taxon,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_prokaryote_gene_package_serialize(
        self,
        accessions,
        include_annotation_type,
        gene_flank_config_length,
        taxon,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
            'include_annotation_type': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        if include_annotation_type is not None:
            
            _query_params.append(('include_annotation_type', include_annotation_type))
            
        if gene_flank_config_length is not None:
            
            _query_params.append(('gene_flank_config.length', gene_flank_config_length))
            
        if taxon is not None:
            
            _query_params.append(('taxon', taxon))
            
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/protein/accession/{accessions}/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def download_prokaryote_gene_package_post(
        self,
        v2_prokaryote_gene_request: V2ProkaryoteGeneRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a prokaryote gene data package by RefSeq protein accession

        Download a prokaryote gene data package including sequence, annotation and data reports by RefSeq non-redundant protein accession.

        :param v2_prokaryote_gene_request: (required)
        :type v2_prokaryote_gene_request: V2ProkaryoteGeneRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_prokaryote_gene_package_post_serialize(
            v2_prokaryote_gene_request=v2_prokaryote_gene_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_prokaryote_gene_package_post_with_http_info(
        self,
        v2_prokaryote_gene_request: V2ProkaryoteGeneRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a prokaryote gene data package by RefSeq protein accession

        Download a prokaryote gene data package including sequence, annotation and data reports by RefSeq non-redundant protein accession.

        :param v2_prokaryote_gene_request: (required)
        :type v2_prokaryote_gene_request: V2ProkaryoteGeneRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_prokaryote_gene_package_post_serialize(
            v2_prokaryote_gene_request=v2_prokaryote_gene_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_prokaryote_gene_package_post_without_preload_content(
        self,
        v2_prokaryote_gene_request: V2ProkaryoteGeneRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a prokaryote gene data package by RefSeq protein accession

        Download a prokaryote gene data package including sequence, annotation and data reports by RefSeq non-redundant protein accession.

        :param v2_prokaryote_gene_request: (required)
        :type v2_prokaryote_gene_request: V2ProkaryoteGeneRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_prokaryote_gene_package_post_serialize(
            v2_prokaryote_gene_request=v2_prokaryote_gene_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_prokaryote_gene_package_post_serialize(
        self,
        v2_prokaryote_gene_request,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_prokaryote_gene_request is not None:
            _body_params = v2_prokaryote_gene_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/protein/accession/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


