# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr
from typing import List, Optional, Tuple, Union
from typing_extensions import Annotated
from ncbi.datasets.openapi.models.v2_download_summary import V2DownloadSummary
from ncbi.datasets.openapi.models.v2_sars2_protein_dataset_request import V2Sars2ProteinDatasetRequest
from ncbi.datasets.openapi.models.v2_table_format import V2TableFormat
from ncbi.datasets.openapi.models.v2_tabular_output import V2TabularOutput
from ncbi.datasets.openapi.models.v2_viral_sequence_type import V2ViralSequenceType
from ncbi.datasets.openapi.models.v2_virus_annotation_report_request import V2VirusAnnotationReportRequest
from ncbi.datasets.openapi.models.v2_virus_availability import V2VirusAvailability
from ncbi.datasets.openapi.models.v2_virus_availability_request import V2VirusAvailabilityRequest
from ncbi.datasets.openapi.models.v2_virus_data_report_request import V2VirusDataReportRequest
from ncbi.datasets.openapi.models.v2_virus_data_report_request_content_type import V2VirusDataReportRequestContentType
from ncbi.datasets.openapi.models.v2_virus_dataset_report_type import V2VirusDatasetReportType
from ncbi.datasets.openapi.models.v2_virus_dataset_request import V2VirusDatasetRequest
from ncbi.datasets.openapi.models.v2_virus_table_field import V2VirusTableField
from ncbi.datasets.openapi.models.v2reports_virus_annotation_report_page import V2reportsVirusAnnotationReportPage
from ncbi.datasets.openapi.models.v2reports_virus_data_report_page import V2reportsVirusDataReportPage

from ncbi.datasets.openapi.api_client import ApiClient, RequestSerialized
from ncbi.datasets.openapi.api_response import ApiResponse
from ncbi.datasets.openapi.rest import RESTResponseType


class VirusApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def sars2_protein_download(
        self,
        proteins: Annotated[List[StrictStr], Field(description="One or more SARS-CoV-2 protein names")],
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes with the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a SARS-CoV-2 protein data package by protein name

        Download a SARS-CoV-2 protein data package including sequence, annotation, BioSample data and a detailed data report by protein name.

        :param proteins: One or more SARS-CoV-2 protein names (required)
        :type proteins: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes with the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specififed geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_download_serialize(
            proteins=proteins,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def sars2_protein_download_with_http_info(
        self,
        proteins: Annotated[List[StrictStr], Field(description="One or more SARS-CoV-2 protein names")],
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes with the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a SARS-CoV-2 protein data package by protein name

        Download a SARS-CoV-2 protein data package including sequence, annotation, BioSample data and a detailed data report by protein name.

        :param proteins: One or more SARS-CoV-2 protein names (required)
        :type proteins: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes with the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specififed geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_download_serialize(
            proteins=proteins,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def sars2_protein_download_without_preload_content(
        self,
        proteins: Annotated[List[StrictStr], Field(description="One or more SARS-CoV-2 protein names")],
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes with the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a SARS-CoV-2 protein data package by protein name

        Download a SARS-CoV-2 protein data package including sequence, annotation, BioSample data and a detailed data report by protein name.

        :param proteins: One or more SARS-CoV-2 protein names (required)
        :type proteins: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes with the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specififed geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_download_serialize(
            proteins=proteins,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _sars2_protein_download_serialize(
        self,
        proteins,
        refseq_only,
        annotated_only,
        released_since,
        updated_since,
        host,
        pangolin_classification,
        geo_location,
        usa_state,
        complete_only,
        include_sequence,
        aux_report,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'proteins': 'csv',
            'include_sequence': 'multi',
            'aux_report': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if proteins is not None:
            _path_params['proteins'] = proteins
        # process the query parameters
        if refseq_only is not None:
            
            _query_params.append(('refseq_only', refseq_only))
            
        if annotated_only is not None:
            
            _query_params.append(('annotated_only', annotated_only))
            
        if released_since is not None:
            if isinstance(released_since, datetime):
                _query_params.append(
                    (
                        'released_since',
                        released_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('released_since', released_since))
            
        if updated_since is not None:
            if isinstance(updated_since, datetime):
                _query_params.append(
                    (
                        'updated_since',
                        updated_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_since', updated_since))
            
        if host is not None:
            
            _query_params.append(('host', host))
            
        if pangolin_classification is not None:
            
            _query_params.append(('pangolin_classification', pangolin_classification))
            
        if geo_location is not None:
            
            _query_params.append(('geo_location', geo_location))
            
        if usa_state is not None:
            
            _query_params.append(('usa_state', usa_state))
            
        if complete_only is not None:
            
            _query_params.append(('complete_only', complete_only))
            
        if include_sequence is not None:
            
            _query_params.append(('include_sequence', include_sequence))
            
        if aux_report is not None:
            
            _query_params.append(('aux_report', aux_report))
            
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/virus/taxon/sars2/protein/{proteins}/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def sars2_protein_download_post(
        self,
        v2_sars2_protein_dataset_request: V2Sars2ProteinDatasetRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a SARS-CoV-2 protein data package

        Download a SARS-CoV-2 protein data package including sequence, annotation, BioSample data and a detailed data report.

        :param v2_sars2_protein_dataset_request: (required)
        :type v2_sars2_protein_dataset_request: V2Sars2ProteinDatasetRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_download_post_serialize(
            v2_sars2_protein_dataset_request=v2_sars2_protein_dataset_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def sars2_protein_download_post_with_http_info(
        self,
        v2_sars2_protein_dataset_request: V2Sars2ProteinDatasetRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a SARS-CoV-2 protein data package

        Download a SARS-CoV-2 protein data package including sequence, annotation, BioSample data and a detailed data report.

        :param v2_sars2_protein_dataset_request: (required)
        :type v2_sars2_protein_dataset_request: V2Sars2ProteinDatasetRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_download_post_serialize(
            v2_sars2_protein_dataset_request=v2_sars2_protein_dataset_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def sars2_protein_download_post_without_preload_content(
        self,
        v2_sars2_protein_dataset_request: V2Sars2ProteinDatasetRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a SARS-CoV-2 protein data package

        Download a SARS-CoV-2 protein data package including sequence, annotation, BioSample data and a detailed data report.

        :param v2_sars2_protein_dataset_request: (required)
        :type v2_sars2_protein_dataset_request: V2Sars2ProteinDatasetRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_download_post_serialize(
            v2_sars2_protein_dataset_request=v2_sars2_protein_dataset_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _sars2_protein_download_post_serialize(
        self,
        v2_sars2_protein_dataset_request,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_sars2_protein_dataset_request is not None:
            _body_params = v2_sars2_protein_dataset_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/virus/taxon/sars2/protein/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def sars2_protein_summary(
        self,
        proteins: Annotated[List[StrictStr], Field(description="One or more SARS-CoV-2 protein names")],
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes with the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2DownloadSummary:
        """Get a download summary of a SARS-CoV-2 protein data package by protein name

        Get a download summary of a SARS-CoV-2 protein data package, including counts and file sizes, in JSON format.

        :param proteins: One or more SARS-CoV-2 protein names (required)
        :type proteins: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes with the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specififed geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_summary_serialize(
            proteins=proteins,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def sars2_protein_summary_with_http_info(
        self,
        proteins: Annotated[List[StrictStr], Field(description="One or more SARS-CoV-2 protein names")],
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes with the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2DownloadSummary]:
        """Get a download summary of a SARS-CoV-2 protein data package by protein name

        Get a download summary of a SARS-CoV-2 protein data package, including counts and file sizes, in JSON format.

        :param proteins: One or more SARS-CoV-2 protein names (required)
        :type proteins: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes with the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specififed geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_summary_serialize(
            proteins=proteins,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def sars2_protein_summary_without_preload_content(
        self,
        proteins: Annotated[List[StrictStr], Field(description="One or more SARS-CoV-2 protein names")],
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes with the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a download summary of a SARS-CoV-2 protein data package by protein name

        Get a download summary of a SARS-CoV-2 protein data package, including counts and file sizes, in JSON format.

        :param proteins: One or more SARS-CoV-2 protein names (required)
        :type proteins: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes with the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specififed geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_summary_serialize(
            proteins=proteins,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _sars2_protein_summary_serialize(
        self,
        proteins,
        refseq_only,
        annotated_only,
        released_since,
        updated_since,
        host,
        pangolin_classification,
        geo_location,
        usa_state,
        complete_only,
        include_sequence,
        aux_report,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'proteins': 'csv',
            'include_sequence': 'multi',
            'aux_report': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if proteins is not None:
            _path_params['proteins'] = proteins
        # process the query parameters
        if refseq_only is not None:
            
            _query_params.append(('refseq_only', refseq_only))
            
        if annotated_only is not None:
            
            _query_params.append(('annotated_only', annotated_only))
            
        if released_since is not None:
            if isinstance(released_since, datetime):
                _query_params.append(
                    (
                        'released_since',
                        released_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('released_since', released_since))
            
        if updated_since is not None:
            if isinstance(updated_since, datetime):
                _query_params.append(
                    (
                        'updated_since',
                        updated_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_since', updated_since))
            
        if host is not None:
            
            _query_params.append(('host', host))
            
        if pangolin_classification is not None:
            
            _query_params.append(('pangolin_classification', pangolin_classification))
            
        if geo_location is not None:
            
            _query_params.append(('geo_location', geo_location))
            
        if usa_state is not None:
            
            _query_params.append(('usa_state', usa_state))
            
        if complete_only is not None:
            
            _query_params.append(('complete_only', complete_only))
            
        if include_sequence is not None:
            
            _query_params.append(('include_sequence', include_sequence))
            
        if aux_report is not None:
            
            _query_params.append(('aux_report', aux_report))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/virus/taxon/sars2/protein/{proteins}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def sars2_protein_summary_by_post(
        self,
        v2_sars2_protein_dataset_request: V2Sars2ProteinDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2DownloadSummary:
        """Get a download summary of a SARS-CoV-2 protein data package by protein name

        Get a download summary of a SARS-CoV-2 protein data package, including counts and file sizes, in JSON format.

        :param v2_sars2_protein_dataset_request: (required)
        :type v2_sars2_protein_dataset_request: V2Sars2ProteinDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_summary_by_post_serialize(
            v2_sars2_protein_dataset_request=v2_sars2_protein_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def sars2_protein_summary_by_post_with_http_info(
        self,
        v2_sars2_protein_dataset_request: V2Sars2ProteinDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2DownloadSummary]:
        """Get a download summary of a SARS-CoV-2 protein data package by protein name

        Get a download summary of a SARS-CoV-2 protein data package, including counts and file sizes, in JSON format.

        :param v2_sars2_protein_dataset_request: (required)
        :type v2_sars2_protein_dataset_request: V2Sars2ProteinDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_summary_by_post_serialize(
            v2_sars2_protein_dataset_request=v2_sars2_protein_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def sars2_protein_summary_by_post_without_preload_content(
        self,
        v2_sars2_protein_dataset_request: V2Sars2ProteinDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a download summary of a SARS-CoV-2 protein data package by protein name

        Get a download summary of a SARS-CoV-2 protein data package, including counts and file sizes, in JSON format.

        :param v2_sars2_protein_dataset_request: (required)
        :type v2_sars2_protein_dataset_request: V2Sars2ProteinDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_summary_by_post_serialize(
            v2_sars2_protein_dataset_request=v2_sars2_protein_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _sars2_protein_summary_by_post_serialize(
        self,
        v2_sars2_protein_dataset_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_sars2_protein_dataset_request is not None:
            _body_params = v2_sars2_protein_dataset_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/virus/taxon/sars2/protein',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def sars2_protein_table(
        self,
        proteins: Annotated[List[StrictStr], Field(description="One or more SARS-CoV-2 protein names")],
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes with the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        table_fields: Annotated[Optional[List[V2VirusTableField]], Field(description="Specify which fields to include in the tabular report")] = None,
        format: Annotated[Optional[V2TableFormat], Field(description="Specify output format")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2TabularOutput:
        """Get SARS-CoV-2 protein metadata in a tabular format by protein name

        Get SARS-CoV-2 protein metadata in a tabular format by protein name.

        :param proteins: One or more SARS-CoV-2 protein names (required)
        :type proteins: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes with the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specififed geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param table_fields: Specify which fields to include in the tabular report
        :type table_fields: List[V2VirusTableField]
        :param format: Specify output format
        :type format: V2TableFormat
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_table_serialize(
            proteins=proteins,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            table_fields=table_fields,
            format=format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2TabularOutput",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def sars2_protein_table_with_http_info(
        self,
        proteins: Annotated[List[StrictStr], Field(description="One or more SARS-CoV-2 protein names")],
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes with the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        table_fields: Annotated[Optional[List[V2VirusTableField]], Field(description="Specify which fields to include in the tabular report")] = None,
        format: Annotated[Optional[V2TableFormat], Field(description="Specify output format")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2TabularOutput]:
        """Get SARS-CoV-2 protein metadata in a tabular format by protein name

        Get SARS-CoV-2 protein metadata in a tabular format by protein name.

        :param proteins: One or more SARS-CoV-2 protein names (required)
        :type proteins: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes with the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specififed geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param table_fields: Specify which fields to include in the tabular report
        :type table_fields: List[V2VirusTableField]
        :param format: Specify output format
        :type format: V2TableFormat
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_table_serialize(
            proteins=proteins,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            table_fields=table_fields,
            format=format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2TabularOutput",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def sars2_protein_table_without_preload_content(
        self,
        proteins: Annotated[List[StrictStr], Field(description="One or more SARS-CoV-2 protein names")],
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes with the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        table_fields: Annotated[Optional[List[V2VirusTableField]], Field(description="Specify which fields to include in the tabular report")] = None,
        format: Annotated[Optional[V2TableFormat], Field(description="Specify output format")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get SARS-CoV-2 protein metadata in a tabular format by protein name

        Get SARS-CoV-2 protein metadata in a tabular format by protein name.

        :param proteins: One or more SARS-CoV-2 protein names (required)
        :type proteins: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes with the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specififed geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param table_fields: Specify which fields to include in the tabular report
        :type table_fields: List[V2VirusTableField]
        :param format: Specify output format
        :type format: V2TableFormat
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._sars2_protein_table_serialize(
            proteins=proteins,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            table_fields=table_fields,
            format=format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2TabularOutput",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _sars2_protein_table_serialize(
        self,
        proteins,
        refseq_only,
        annotated_only,
        released_since,
        updated_since,
        host,
        pangolin_classification,
        geo_location,
        usa_state,
        complete_only,
        table_fields,
        format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'proteins': 'csv',
            'table_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if proteins is not None:
            _path_params['proteins'] = proteins
        # process the query parameters
        if refseq_only is not None:
            
            _query_params.append(('refseq_only', refseq_only))
            
        if annotated_only is not None:
            
            _query_params.append(('annotated_only', annotated_only))
            
        if released_since is not None:
            if isinstance(released_since, datetime):
                _query_params.append(
                    (
                        'released_since',
                        released_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('released_since', released_since))
            
        if updated_since is not None:
            if isinstance(updated_since, datetime):
                _query_params.append(
                    (
                        'updated_since',
                        updated_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_since', updated_since))
            
        if host is not None:
            
            _query_params.append(('host', host))
            
        if pangolin_classification is not None:
            
            _query_params.append(('pangolin_classification', pangolin_classification))
            
        if geo_location is not None:
            
            _query_params.append(('geo_location', geo_location))
            
        if usa_state is not None:
            
            _query_params.append(('usa_state', usa_state))
            
        if complete_only is not None:
            
            _query_params.append(('complete_only', complete_only))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/virus/taxon/sars2/protein/{proteins}/table',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_accession_availability(
        self,
        accessions: Annotated[List[StrictStr], Field(description="virus accessions")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2VirusAvailability:
        """Check the validity of a virus genome nucleotide accession

        Check the validity of a virus genome nucleotide accession. Output in JSON format.

        :param accessions: virus accessions (required)
        :type accessions: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_accession_availability_serialize(
            accessions=accessions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2VirusAvailability",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_accession_availability_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="virus accessions")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2VirusAvailability]:
        """Check the validity of a virus genome nucleotide accession

        Check the validity of a virus genome nucleotide accession. Output in JSON format.

        :param accessions: virus accessions (required)
        :type accessions: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_accession_availability_serialize(
            accessions=accessions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2VirusAvailability",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_accession_availability_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="virus accessions")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Check the validity of a virus genome nucleotide accession

        Check the validity of a virus genome nucleotide accession. Output in JSON format.

        :param accessions: virus accessions (required)
        :type accessions: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_accession_availability_serialize(
            accessions=accessions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2VirusAvailability",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_accession_availability_serialize(
        self,
        accessions,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/virus/accession/{accessions}/check',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_accession_availability_post(
        self,
        v2_virus_availability_request: V2VirusAvailabilityRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2VirusAvailability:
        """Check the validity of a virus genome nucleotide accession

        Check the validity of a virus genome nucleotide accession. Output in JSON format.

        :param v2_virus_availability_request: (required)
        :type v2_virus_availability_request: V2VirusAvailabilityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_accession_availability_post_serialize(
            v2_virus_availability_request=v2_virus_availability_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2VirusAvailability",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_accession_availability_post_with_http_info(
        self,
        v2_virus_availability_request: V2VirusAvailabilityRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2VirusAvailability]:
        """Check the validity of a virus genome nucleotide accession

        Check the validity of a virus genome nucleotide accession. Output in JSON format.

        :param v2_virus_availability_request: (required)
        :type v2_virus_availability_request: V2VirusAvailabilityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_accession_availability_post_serialize(
            v2_virus_availability_request=v2_virus_availability_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2VirusAvailability",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_accession_availability_post_without_preload_content(
        self,
        v2_virus_availability_request: V2VirusAvailabilityRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Check the validity of a virus genome nucleotide accession

        Check the validity of a virus genome nucleotide accession. Output in JSON format.

        :param v2_virus_availability_request: (required)
        :type v2_virus_availability_request: V2VirusAvailabilityRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_accession_availability_post_serialize(
            v2_virus_availability_request=v2_virus_availability_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2VirusAvailability",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_accession_availability_post_serialize(
        self,
        v2_virus_availability_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_virus_availability_request is not None:
            _body_params = v2_virus_availability_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/virus/check',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_annotation_reports_by_acessions(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more nucleotide sequence accessions")],
        filter_refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit to RefSeq genomes.")] = None,
        filter_annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit to annotated genomes.")] = None,
        filter_released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        filter_updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        filter_host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        filter_pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        filter_geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        filter_usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        filter_complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [virus annotation report fields](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/virus-data-reports/#virus-annotation-report-fields). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsVirusAnnotationReportPage:
        """Get a virus annotation report by nucleotide accession

        Get a virus annotation report by nucleotide accesion. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more nucleotide sequence accessions (required)
        :type accessions: List[str]
        :param filter_refseq_only: If true, limit to RefSeq genomes.
        :type filter_refseq_only: bool
        :param filter_annotated_only: If true, limit to annotated genomes.
        :type filter_annotated_only: bool
        :param filter_released_since: Limit to genomes released on or after the specified date.
        :type filter_released_since: datetime
        :param filter_updated_since: Limit to genomes updated on or after the specified date.
        :type filter_updated_since: datetime
        :param filter_host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type filter_host: str
        :param filter_pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type filter_pangolin_classification: str
        :param filter_geo_location: Limit to genomes collected from the specififed geographic location.
        :type filter_geo_location: str
        :param filter_usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type filter_usa_state: str
        :param filter_complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type filter_complete_only: bool
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [virus annotation report fields](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/virus-data-reports/#virus-annotation-report-fields). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param page_size: The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_annotation_reports_by_acessions_serialize(
            accessions=accessions,
            filter_refseq_only=filter_refseq_only,
            filter_annotated_only=filter_annotated_only,
            filter_released_since=filter_released_since,
            filter_updated_since=filter_updated_since,
            filter_host=filter_host,
            filter_pangolin_classification=filter_pangolin_classification,
            filter_geo_location=filter_geo_location,
            filter_usa_state=filter_usa_state,
            filter_complete_only=filter_complete_only,
            table_fields=table_fields,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_annotation_reports_by_acessions_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more nucleotide sequence accessions")],
        filter_refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit to RefSeq genomes.")] = None,
        filter_annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit to annotated genomes.")] = None,
        filter_released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        filter_updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        filter_host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        filter_pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        filter_geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        filter_usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        filter_complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [virus annotation report fields](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/virus-data-reports/#virus-annotation-report-fields). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsVirusAnnotationReportPage]:
        """Get a virus annotation report by nucleotide accession

        Get a virus annotation report by nucleotide accesion. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more nucleotide sequence accessions (required)
        :type accessions: List[str]
        :param filter_refseq_only: If true, limit to RefSeq genomes.
        :type filter_refseq_only: bool
        :param filter_annotated_only: If true, limit to annotated genomes.
        :type filter_annotated_only: bool
        :param filter_released_since: Limit to genomes released on or after the specified date.
        :type filter_released_since: datetime
        :param filter_updated_since: Limit to genomes updated on or after the specified date.
        :type filter_updated_since: datetime
        :param filter_host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type filter_host: str
        :param filter_pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type filter_pangolin_classification: str
        :param filter_geo_location: Limit to genomes collected from the specififed geographic location.
        :type filter_geo_location: str
        :param filter_usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type filter_usa_state: str
        :param filter_complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type filter_complete_only: bool
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [virus annotation report fields](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/virus-data-reports/#virus-annotation-report-fields). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param page_size: The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_annotation_reports_by_acessions_serialize(
            accessions=accessions,
            filter_refseq_only=filter_refseq_only,
            filter_annotated_only=filter_annotated_only,
            filter_released_since=filter_released_since,
            filter_updated_since=filter_updated_since,
            filter_host=filter_host,
            filter_pangolin_classification=filter_pangolin_classification,
            filter_geo_location=filter_geo_location,
            filter_usa_state=filter_usa_state,
            filter_complete_only=filter_complete_only,
            table_fields=table_fields,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_annotation_reports_by_acessions_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more nucleotide sequence accessions")],
        filter_refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit to RefSeq genomes.")] = None,
        filter_annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit to annotated genomes.")] = None,
        filter_released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        filter_updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        filter_host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        filter_pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        filter_geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        filter_usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        filter_complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [virus annotation report fields](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/virus-data-reports/#virus-annotation-report-fields). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a virus annotation report by nucleotide accession

        Get a virus annotation report by nucleotide accesion. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more nucleotide sequence accessions (required)
        :type accessions: List[str]
        :param filter_refseq_only: If true, limit to RefSeq genomes.
        :type filter_refseq_only: bool
        :param filter_annotated_only: If true, limit to annotated genomes.
        :type filter_annotated_only: bool
        :param filter_released_since: Limit to genomes released on or after the specified date.
        :type filter_released_since: datetime
        :param filter_updated_since: Limit to genomes updated on or after the specified date.
        :type filter_updated_since: datetime
        :param filter_host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type filter_host: str
        :param filter_pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type filter_pangolin_classification: str
        :param filter_geo_location: Limit to genomes collected from the specififed geographic location.
        :type filter_geo_location: str
        :param filter_usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type filter_usa_state: str
        :param filter_complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type filter_complete_only: bool
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [virus annotation report fields](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/virus-data-reports/#virus-annotation-report-fields). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param page_size: The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_annotation_reports_by_acessions_serialize(
            accessions=accessions,
            filter_refseq_only=filter_refseq_only,
            filter_annotated_only=filter_annotated_only,
            filter_released_since=filter_released_since,
            filter_updated_since=filter_updated_since,
            filter_host=filter_host,
            filter_pangolin_classification=filter_pangolin_classification,
            filter_geo_location=filter_geo_location,
            filter_usa_state=filter_usa_state,
            filter_complete_only=filter_complete_only,
            table_fields=table_fields,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_annotation_reports_by_acessions_serialize(
        self,
        accessions,
        filter_refseq_only,
        filter_annotated_only,
        filter_released_since,
        filter_updated_since,
        filter_host,
        filter_pangolin_classification,
        filter_geo_location,
        filter_usa_state,
        filter_complete_only,
        table_fields,
        page_size,
        page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
            'table_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        if filter_refseq_only is not None:
            
            _query_params.append(('filter.refseq_only', filter_refseq_only))
            
        if filter_annotated_only is not None:
            
            _query_params.append(('filter.annotated_only', filter_annotated_only))
            
        if filter_released_since is not None:
            if isinstance(filter_released_since, datetime):
                _query_params.append(
                    (
                        'filter.released_since',
                        filter_released_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter.released_since', filter_released_since))
            
        if filter_updated_since is not None:
            if isinstance(filter_updated_since, datetime):
                _query_params.append(
                    (
                        'filter.updated_since',
                        filter_updated_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter.updated_since', filter_updated_since))
            
        if filter_host is not None:
            
            _query_params.append(('filter.host', filter_host))
            
        if filter_pangolin_classification is not None:
            
            _query_params.append(('filter.pangolin_classification', filter_pangolin_classification))
            
        if filter_geo_location is not None:
            
            _query_params.append(('filter.geo_location', filter_geo_location))
            
        if filter_usa_state is not None:
            
            _query_params.append(('filter.usa_state', filter_usa_state))
            
        if filter_complete_only is not None:
            
            _query_params.append(('filter.complete_only', filter_complete_only))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/virus/accession/{accessions}/annotation_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_annotation_reports_by_post(
        self,
        v2_virus_annotation_report_request: V2VirusAnnotationReportRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsVirusAnnotationReportPage:
        """Get a virus annotation report

        Get a virus annotation report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_virus_annotation_report_request: (required)
        :type v2_virus_annotation_report_request: V2VirusAnnotationReportRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_annotation_reports_by_post_serialize(
            v2_virus_annotation_report_request=v2_virus_annotation_report_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_annotation_reports_by_post_with_http_info(
        self,
        v2_virus_annotation_report_request: V2VirusAnnotationReportRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsVirusAnnotationReportPage]:
        """Get a virus annotation report

        Get a virus annotation report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_virus_annotation_report_request: (required)
        :type v2_virus_annotation_report_request: V2VirusAnnotationReportRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_annotation_reports_by_post_serialize(
            v2_virus_annotation_report_request=v2_virus_annotation_report_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_annotation_reports_by_post_without_preload_content(
        self,
        v2_virus_annotation_report_request: V2VirusAnnotationReportRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a virus annotation report

        Get a virus annotation report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_virus_annotation_report_request: (required)
        :type v2_virus_annotation_report_request: V2VirusAnnotationReportRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_annotation_reports_by_post_serialize(
            v2_virus_annotation_report_request=v2_virus_annotation_report_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_annotation_reports_by_post_serialize(
        self,
        v2_virus_annotation_report_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_virus_annotation_report_request is not None:
            _body_params = v2_virus_annotation_report_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/virus/annotation_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_annotation_reports_by_taxon(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        filter_refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit to RefSeq genomes.")] = None,
        filter_annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit to annotated genomes.")] = None,
        filter_released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        filter_updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        filter_host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        filter_pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        filter_geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        filter_usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        filter_complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [virus annotation report fields](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/virus-data-reports/#virus-annotation-report-fields). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsVirusAnnotationReportPage:
        """Get a virus annotation report by taxon

        Get virus annotation report by taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param filter_refseq_only: If true, limit to RefSeq genomes.
        :type filter_refseq_only: bool
        :param filter_annotated_only: If true, limit to annotated genomes.
        :type filter_annotated_only: bool
        :param filter_released_since: Limit to genomes released on or after the specified date.
        :type filter_released_since: datetime
        :param filter_updated_since: Limit to genomes updated on or after the specified date.
        :type filter_updated_since: datetime
        :param filter_host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type filter_host: str
        :param filter_pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type filter_pangolin_classification: str
        :param filter_geo_location: Limit to genomes collected from the specififed geographic location.
        :type filter_geo_location: str
        :param filter_usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type filter_usa_state: str
        :param filter_complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type filter_complete_only: bool
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [virus annotation report fields](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/virus-data-reports/#virus-annotation-report-fields). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param page_size: The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_annotation_reports_by_taxon_serialize(
            taxon=taxon,
            filter_refseq_only=filter_refseq_only,
            filter_annotated_only=filter_annotated_only,
            filter_released_since=filter_released_since,
            filter_updated_since=filter_updated_since,
            filter_host=filter_host,
            filter_pangolin_classification=filter_pangolin_classification,
            filter_geo_location=filter_geo_location,
            filter_usa_state=filter_usa_state,
            filter_complete_only=filter_complete_only,
            table_fields=table_fields,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_annotation_reports_by_taxon_with_http_info(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        filter_refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit to RefSeq genomes.")] = None,
        filter_annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit to annotated genomes.")] = None,
        filter_released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        filter_updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        filter_host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        filter_pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        filter_geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        filter_usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        filter_complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [virus annotation report fields](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/virus-data-reports/#virus-annotation-report-fields). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsVirusAnnotationReportPage]:
        """Get a virus annotation report by taxon

        Get virus annotation report by taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param filter_refseq_only: If true, limit to RefSeq genomes.
        :type filter_refseq_only: bool
        :param filter_annotated_only: If true, limit to annotated genomes.
        :type filter_annotated_only: bool
        :param filter_released_since: Limit to genomes released on or after the specified date.
        :type filter_released_since: datetime
        :param filter_updated_since: Limit to genomes updated on or after the specified date.
        :type filter_updated_since: datetime
        :param filter_host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type filter_host: str
        :param filter_pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type filter_pangolin_classification: str
        :param filter_geo_location: Limit to genomes collected from the specififed geographic location.
        :type filter_geo_location: str
        :param filter_usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type filter_usa_state: str
        :param filter_complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type filter_complete_only: bool
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [virus annotation report fields](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/virus-data-reports/#virus-annotation-report-fields). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param page_size: The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_annotation_reports_by_taxon_serialize(
            taxon=taxon,
            filter_refseq_only=filter_refseq_only,
            filter_annotated_only=filter_annotated_only,
            filter_released_since=filter_released_since,
            filter_updated_since=filter_updated_since,
            filter_host=filter_host,
            filter_pangolin_classification=filter_pangolin_classification,
            filter_geo_location=filter_geo_location,
            filter_usa_state=filter_usa_state,
            filter_complete_only=filter_complete_only,
            table_fields=table_fields,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_annotation_reports_by_taxon_without_preload_content(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        filter_refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit to RefSeq genomes.")] = None,
        filter_annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit to annotated genomes.")] = None,
        filter_released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        filter_updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        filter_host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        filter_pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        filter_geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specififed geographic location.")] = None,
        filter_usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        filter_complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report. Additional fields are described here: [virus annotation report fields](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/virus-data-reports/#virus-annotation-report-fields). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a virus annotation report by taxon

        Get virus annotation report by taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param filter_refseq_only: If true, limit to RefSeq genomes.
        :type filter_refseq_only: bool
        :param filter_annotated_only: If true, limit to annotated genomes.
        :type filter_annotated_only: bool
        :param filter_released_since: Limit to genomes released on or after the specified date.
        :type filter_released_since: datetime
        :param filter_updated_since: Limit to genomes updated on or after the specified date.
        :type filter_updated_since: datetime
        :param filter_host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type filter_host: str
        :param filter_pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type filter_pangolin_classification: str
        :param filter_geo_location: Limit to genomes collected from the specififed geographic location.
        :type filter_geo_location: str
        :param filter_usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type filter_usa_state: str
        :param filter_complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type filter_complete_only: bool
        :param table_fields: Specify which fields to include in the tabular report. Additional fields are described here: [virus annotation report fields](https://www.ncbi.nlm.nih.gov/datasets/docs/v2/command-line-tools/using-dataformat/virus-data-reports/#virus-annotation-report-fields). Use of this parameter requires the HTTP header, `accept: text/tab-separated-values`.
        :type table_fields: List[str]
        :param page_size: The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_annotation_reports_by_taxon_serialize(
            taxon=taxon,
            filter_refseq_only=filter_refseq_only,
            filter_annotated_only=filter_annotated_only,
            filter_released_since=filter_released_since,
            filter_updated_since=filter_updated_since,
            filter_host=filter_host,
            filter_pangolin_classification=filter_pangolin_classification,
            filter_geo_location=filter_geo_location,
            filter_usa_state=filter_usa_state,
            filter_complete_only=filter_complete_only,
            table_fields=table_fields,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusAnnotationReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_annotation_reports_by_taxon_serialize(
        self,
        taxon,
        filter_refseq_only,
        filter_annotated_only,
        filter_released_since,
        filter_updated_since,
        filter_host,
        filter_pangolin_classification,
        filter_geo_location,
        filter_usa_state,
        filter_complete_only,
        table_fields,
        page_size,
        page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'table_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if taxon is not None:
            _path_params['taxon'] = taxon
        # process the query parameters
        if filter_refseq_only is not None:
            
            _query_params.append(('filter.refseq_only', filter_refseq_only))
            
        if filter_annotated_only is not None:
            
            _query_params.append(('filter.annotated_only', filter_annotated_only))
            
        if filter_released_since is not None:
            if isinstance(filter_released_since, datetime):
                _query_params.append(
                    (
                        'filter.released_since',
                        filter_released_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter.released_since', filter_released_since))
            
        if filter_updated_since is not None:
            if isinstance(filter_updated_since, datetime):
                _query_params.append(
                    (
                        'filter.updated_since',
                        filter_updated_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter.updated_since', filter_updated_since))
            
        if filter_host is not None:
            
            _query_params.append(('filter.host', filter_host))
            
        if filter_pangolin_classification is not None:
            
            _query_params.append(('filter.pangolin_classification', filter_pangolin_classification))
            
        if filter_geo_location is not None:
            
            _query_params.append(('filter.geo_location', filter_geo_location))
            
        if filter_usa_state is not None:
            
            _query_params.append(('filter.usa_state', filter_usa_state))
            
        if filter_complete_only is not None:
            
            _query_params.append(('filter.complete_only', filter_complete_only))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/virus/taxon/{taxon}/annotation_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_genome_download(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        use_psg: Annotated[Optional[StrictBool], Field(description="Experimental approach to retrieving sequence data.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a virus genome data package by taxon

        Download a virus genome data package including sequence, annotation, BioSample data and a detailed data report by taxon.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specified geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param use_psg: Experimental approach to retrieving sequence data.
        :type use_psg: bool
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_download_serialize(
            taxon=taxon,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            use_psg=use_psg,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_genome_download_with_http_info(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        use_psg: Annotated[Optional[StrictBool], Field(description="Experimental approach to retrieving sequence data.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a virus genome data package by taxon

        Download a virus genome data package including sequence, annotation, BioSample data and a detailed data report by taxon.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specified geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param use_psg: Experimental approach to retrieving sequence data.
        :type use_psg: bool
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_download_serialize(
            taxon=taxon,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            use_psg=use_psg,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_genome_download_without_preload_content(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        use_psg: Annotated[Optional[StrictBool], Field(description="Experimental approach to retrieving sequence data.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a virus genome data package by taxon

        Download a virus genome data package including sequence, annotation, BioSample data and a detailed data report by taxon.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specified geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param use_psg: Experimental approach to retrieving sequence data.
        :type use_psg: bool
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_download_serialize(
            taxon=taxon,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            use_psg=use_psg,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_genome_download_serialize(
        self,
        taxon,
        refseq_only,
        annotated_only,
        released_since,
        updated_since,
        host,
        pangolin_classification,
        geo_location,
        usa_state,
        complete_only,
        include_sequence,
        aux_report,
        use_psg,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'include_sequence': 'multi',
            'aux_report': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if taxon is not None:
            _path_params['taxon'] = taxon
        # process the query parameters
        if refseq_only is not None:
            
            _query_params.append(('refseq_only', refseq_only))
            
        if annotated_only is not None:
            
            _query_params.append(('annotated_only', annotated_only))
            
        if released_since is not None:
            if isinstance(released_since, datetime):
                _query_params.append(
                    (
                        'released_since',
                        released_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('released_since', released_since))
            
        if updated_since is not None:
            if isinstance(updated_since, datetime):
                _query_params.append(
                    (
                        'updated_since',
                        updated_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_since', updated_since))
            
        if host is not None:
            
            _query_params.append(('host', host))
            
        if pangolin_classification is not None:
            
            _query_params.append(('pangolin_classification', pangolin_classification))
            
        if geo_location is not None:
            
            _query_params.append(('geo_location', geo_location))
            
        if usa_state is not None:
            
            _query_params.append(('usa_state', usa_state))
            
        if complete_only is not None:
            
            _query_params.append(('complete_only', complete_only))
            
        if include_sequence is not None:
            
            _query_params.append(('include_sequence', include_sequence))
            
        if aux_report is not None:
            
            _query_params.append(('aux_report', aux_report))
            
        if use_psg is not None:
            
            _query_params.append(('use_psg', use_psg))
            
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/virus/taxon/{taxon}/genome/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_genome_download_accession(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more nucleotide sequence accessions")],
        taxons: Annotated[Optional[List[StrictStr]], Field(description="NCBI Taxonomy IDs or names (common or scientific) at any taxonomic rank")] = None,
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        use_psg: Annotated[Optional[StrictBool], Field(description="Experimental approach to retrieving sequence data.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a virus genome data package by nucleotide accession

        Download a virus genome data package including sequence, annotation, BioSample data and a detailed data report by nucleotide accession.

        :param accessions: One or more nucleotide sequence accessions (required)
        :type accessions: List[str]
        :param taxons: NCBI Taxonomy IDs or names (common or scientific) at any taxonomic rank
        :type taxons: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specified geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param use_psg: Experimental approach to retrieving sequence data.
        :type use_psg: bool
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_download_accession_serialize(
            accessions=accessions,
            taxons=taxons,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            use_psg=use_psg,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_genome_download_accession_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more nucleotide sequence accessions")],
        taxons: Annotated[Optional[List[StrictStr]], Field(description="NCBI Taxonomy IDs or names (common or scientific) at any taxonomic rank")] = None,
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        use_psg: Annotated[Optional[StrictBool], Field(description="Experimental approach to retrieving sequence data.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a virus genome data package by nucleotide accession

        Download a virus genome data package including sequence, annotation, BioSample data and a detailed data report by nucleotide accession.

        :param accessions: One or more nucleotide sequence accessions (required)
        :type accessions: List[str]
        :param taxons: NCBI Taxonomy IDs or names (common or scientific) at any taxonomic rank
        :type taxons: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specified geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param use_psg: Experimental approach to retrieving sequence data.
        :type use_psg: bool
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_download_accession_serialize(
            accessions=accessions,
            taxons=taxons,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            use_psg=use_psg,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_genome_download_accession_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more nucleotide sequence accessions")],
        taxons: Annotated[Optional[List[StrictStr]], Field(description="NCBI Taxonomy IDs or names (common or scientific) at any taxonomic rank")] = None,
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        use_psg: Annotated[Optional[StrictBool], Field(description="Experimental approach to retrieving sequence data.")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a virus genome data package by nucleotide accession

        Download a virus genome data package including sequence, annotation, BioSample data and a detailed data report by nucleotide accession.

        :param accessions: One or more nucleotide sequence accessions (required)
        :type accessions: List[str]
        :param taxons: NCBI Taxonomy IDs or names (common or scientific) at any taxonomic rank
        :type taxons: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specified geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param use_psg: Experimental approach to retrieving sequence data.
        :type use_psg: bool
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_download_accession_serialize(
            accessions=accessions,
            taxons=taxons,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            use_psg=use_psg,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_genome_download_accession_serialize(
        self,
        accessions,
        taxons,
        refseq_only,
        annotated_only,
        released_since,
        updated_since,
        host,
        pangolin_classification,
        geo_location,
        usa_state,
        complete_only,
        include_sequence,
        aux_report,
        use_psg,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
            'taxons': 'multi',
            'include_sequence': 'multi',
            'aux_report': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        if taxons is not None:
            
            _query_params.append(('taxons', taxons))
            
        if refseq_only is not None:
            
            _query_params.append(('refseq_only', refseq_only))
            
        if annotated_only is not None:
            
            _query_params.append(('annotated_only', annotated_only))
            
        if released_since is not None:
            if isinstance(released_since, datetime):
                _query_params.append(
                    (
                        'released_since',
                        released_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('released_since', released_since))
            
        if updated_since is not None:
            if isinstance(updated_since, datetime):
                _query_params.append(
                    (
                        'updated_since',
                        updated_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_since', updated_since))
            
        if host is not None:
            
            _query_params.append(('host', host))
            
        if pangolin_classification is not None:
            
            _query_params.append(('pangolin_classification', pangolin_classification))
            
        if geo_location is not None:
            
            _query_params.append(('geo_location', geo_location))
            
        if usa_state is not None:
            
            _query_params.append(('usa_state', usa_state))
            
        if complete_only is not None:
            
            _query_params.append(('complete_only', complete_only))
            
        if include_sequence is not None:
            
            _query_params.append(('include_sequence', include_sequence))
            
        if aux_report is not None:
            
            _query_params.append(('aux_report', aux_report))
            
        if use_psg is not None:
            
            _query_params.append(('use_psg', use_psg))
            
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/virus/accession/{accessions}/genome/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_genome_download_post(
        self,
        v2_virus_dataset_request: V2VirusDatasetRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get a virus genome data package

        Download a virus genome data package including sequence, annotation, BioSample data and a detailed data report by nucleotide accession.

        :param v2_virus_dataset_request: (required)
        :type v2_virus_dataset_request: V2VirusDatasetRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_download_post_serialize(
            v2_virus_dataset_request=v2_virus_dataset_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_genome_download_post_with_http_info(
        self,
        v2_virus_dataset_request: V2VirusDatasetRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get a virus genome data package

        Download a virus genome data package including sequence, annotation, BioSample data and a detailed data report by nucleotide accession.

        :param v2_virus_dataset_request: (required)
        :type v2_virus_dataset_request: V2VirusDatasetRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_download_post_serialize(
            v2_virus_dataset_request=v2_virus_dataset_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_genome_download_post_without_preload_content(
        self,
        v2_virus_dataset_request: V2VirusDatasetRequest,
        filename: Annotated[Optional[StrictStr], Field(description="Output file name.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a virus genome data package

        Download a virus genome data package including sequence, annotation, BioSample data and a detailed data report by nucleotide accession.

        :param v2_virus_dataset_request: (required)
        :type v2_virus_dataset_request: V2VirusDatasetRequest
        :param filename: Output file name.
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_download_post_serialize(
            v2_virus_dataset_request=v2_virus_dataset_request,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_genome_download_post_serialize(
        self,
        v2_virus_dataset_request,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_virus_dataset_request is not None:
            _body_params = v2_virus_dataset_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/zip'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/virus/genome/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_genome_summary(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        accessions: Annotated[Optional[List[StrictStr]], Field(description="One or more nucleotide sequence accessions")] = None,
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2DownloadSummary:
        """Get a download summary of a virus genome data package by taxon

        Get a download summary of a virus genome data package, including counts and file sizes, in JSON format.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param accessions: One or more nucleotide sequence accessions
        :type accessions: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specified geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_summary_serialize(
            taxon=taxon,
            accessions=accessions,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_genome_summary_with_http_info(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        accessions: Annotated[Optional[List[StrictStr]], Field(description="One or more nucleotide sequence accessions")] = None,
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2DownloadSummary]:
        """Get a download summary of a virus genome data package by taxon

        Get a download summary of a virus genome data package, including counts and file sizes, in JSON format.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param accessions: One or more nucleotide sequence accessions
        :type accessions: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specified geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_summary_serialize(
            taxon=taxon,
            accessions=accessions,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_genome_summary_without_preload_content(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        accessions: Annotated[Optional[List[StrictStr]], Field(description="One or more nucleotide sequence accessions")] = None,
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a download summary of a virus genome data package by taxon

        Get a download summary of a virus genome data package, including counts and file sizes, in JSON format.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param accessions: One or more nucleotide sequence accessions
        :type accessions: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specified geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_summary_serialize(
            taxon=taxon,
            accessions=accessions,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            include_sequence=include_sequence,
            aux_report=aux_report,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_genome_summary_serialize(
        self,
        taxon,
        accessions,
        refseq_only,
        annotated_only,
        released_since,
        updated_since,
        host,
        pangolin_classification,
        geo_location,
        usa_state,
        complete_only,
        include_sequence,
        aux_report,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'multi',
            'include_sequence': 'multi',
            'aux_report': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if taxon is not None:
            _path_params['taxon'] = taxon
        # process the query parameters
        if accessions is not None:
            
            _query_params.append(('accessions', accessions))
            
        if refseq_only is not None:
            
            _query_params.append(('refseq_only', refseq_only))
            
        if annotated_only is not None:
            
            _query_params.append(('annotated_only', annotated_only))
            
        if released_since is not None:
            if isinstance(released_since, datetime):
                _query_params.append(
                    (
                        'released_since',
                        released_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('released_since', released_since))
            
        if updated_since is not None:
            if isinstance(updated_since, datetime):
                _query_params.append(
                    (
                        'updated_since',
                        updated_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_since', updated_since))
            
        if host is not None:
            
            _query_params.append(('host', host))
            
        if pangolin_classification is not None:
            
            _query_params.append(('pangolin_classification', pangolin_classification))
            
        if geo_location is not None:
            
            _query_params.append(('geo_location', geo_location))
            
        if usa_state is not None:
            
            _query_params.append(('usa_state', usa_state))
            
        if complete_only is not None:
            
            _query_params.append(('complete_only', complete_only))
            
        if include_sequence is not None:
            
            _query_params.append(('include_sequence', include_sequence))
            
        if aux_report is not None:
            
            _query_params.append(('aux_report', aux_report))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/virus/taxon/{taxon}/genome',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_genome_summary_by_post(
        self,
        v2_virus_dataset_request: V2VirusDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2DownloadSummary:
        """Get a download summary of a virus genome data package

        Get a download summary of a virus genome data package, including counts and file sizes, in JSON format.

        :param v2_virus_dataset_request: (required)
        :type v2_virus_dataset_request: V2VirusDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_summary_by_post_serialize(
            v2_virus_dataset_request=v2_virus_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_genome_summary_by_post_with_http_info(
        self,
        v2_virus_dataset_request: V2VirusDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2DownloadSummary]:
        """Get a download summary of a virus genome data package

        Get a download summary of a virus genome data package, including counts and file sizes, in JSON format.

        :param v2_virus_dataset_request: (required)
        :type v2_virus_dataset_request: V2VirusDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_summary_by_post_serialize(
            v2_virus_dataset_request=v2_virus_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_genome_summary_by_post_without_preload_content(
        self,
        v2_virus_dataset_request: V2VirusDatasetRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a download summary of a virus genome data package

        Get a download summary of a virus genome data package, including counts and file sizes, in JSON format.

        :param v2_virus_dataset_request: (required)
        :type v2_virus_dataset_request: V2VirusDatasetRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_summary_by_post_serialize(
            v2_virus_dataset_request=v2_virus_dataset_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2DownloadSummary",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_genome_summary_by_post_serialize(
        self,
        v2_virus_dataset_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_virus_dataset_request is not None:
            _body_params = v2_virus_dataset_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/virus/genome',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_genome_table(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        accessions: Annotated[Optional[List[StrictStr]], Field(description="One or more nucleotide sequence accessions")] = None,
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        table_fields: Annotated[Optional[List[V2VirusTableField]], Field(description="Specify which fields to include in the tabular report")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        format: Annotated[Optional[V2TableFormat], Field(description="Choose download format (tsv, csv or jsonl)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2TabularOutput:
        """Get virus genome metadata in a tabular format (deprecated)

        Get virus genome metadata in tabular format for virus genomes by taxon.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param accessions: One or more nucleotide sequence accessions
        :type accessions: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specified geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param table_fields: Specify which fields to include in the tabular report
        :type table_fields: List[V2VirusTableField]
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param format: Choose download format (tsv, csv or jsonl)
        :type format: V2TableFormat
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_table_serialize(
            taxon=taxon,
            accessions=accessions,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            table_fields=table_fields,
            include_sequence=include_sequence,
            aux_report=aux_report,
            format=format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2TabularOutput",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_genome_table_with_http_info(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        accessions: Annotated[Optional[List[StrictStr]], Field(description="One or more nucleotide sequence accessions")] = None,
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        table_fields: Annotated[Optional[List[V2VirusTableField]], Field(description="Specify which fields to include in the tabular report")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        format: Annotated[Optional[V2TableFormat], Field(description="Choose download format (tsv, csv or jsonl)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2TabularOutput]:
        """Get virus genome metadata in a tabular format (deprecated)

        Get virus genome metadata in tabular format for virus genomes by taxon.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param accessions: One or more nucleotide sequence accessions
        :type accessions: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specified geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param table_fields: Specify which fields to include in the tabular report
        :type table_fields: List[V2VirusTableField]
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param format: Choose download format (tsv, csv or jsonl)
        :type format: V2TableFormat
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_table_serialize(
            taxon=taxon,
            accessions=accessions,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            table_fields=table_fields,
            include_sequence=include_sequence,
            aux_report=aux_report,
            format=format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2TabularOutput",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_genome_table_without_preload_content(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        accessions: Annotated[Optional[List[StrictStr]], Field(description="One or more nucleotide sequence accessions")] = None,
        refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        table_fields: Annotated[Optional[List[V2VirusTableField]], Field(description="Specify which fields to include in the tabular report")] = None,
        include_sequence: Annotated[Optional[List[V2ViralSequenceType]], Field(description="Specify which sequence files to include in the data package.")] = None,
        aux_report: Annotated[Optional[List[V2VirusDatasetReportType]], Field(description="Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.")] = None,
        format: Annotated[Optional[V2TableFormat], Field(description="Choose download format (tsv, csv or jsonl)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get virus genome metadata in a tabular format (deprecated)

        Get virus genome metadata in tabular format for virus genomes by taxon.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param accessions: One or more nucleotide sequence accessions
        :type accessions: List[str]
        :param refseq_only: If true, limit results to RefSeq genomes.
        :type refseq_only: bool
        :param annotated_only: If true, limit results to annotated genomes.
        :type annotated_only: bool
        :param released_since: Limit to genomes released on or after the specified date.
        :type released_since: datetime
        :param updated_since: Limit to genomes updated on or after the specified date.
        :type updated_since: datetime
        :param host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type host: str
        :param pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type pangolin_classification: str
        :param geo_location: Limit to genomes collected from the specified geographic location.
        :type geo_location: str
        :param usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type usa_state: str
        :param complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type complete_only: bool
        :param table_fields: Specify which fields to include in the tabular report
        :type table_fields: List[V2VirusTableField]
        :param include_sequence: Specify which sequence files to include in the data package.
        :type include_sequence: List[V2ViralSequenceType]
        :param aux_report: Specify which report files to include in the data package. The virus data report is always included, and its inclusion is not affected by this parameter.
        :type aux_report: List[V2VirusDatasetReportType]
        :param format: Choose download format (tsv, csv or jsonl)
        :type format: V2TableFormat
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_genome_table_serialize(
            taxon=taxon,
            accessions=accessions,
            refseq_only=refseq_only,
            annotated_only=annotated_only,
            released_since=released_since,
            updated_since=updated_since,
            host=host,
            pangolin_classification=pangolin_classification,
            geo_location=geo_location,
            usa_state=usa_state,
            complete_only=complete_only,
            table_fields=table_fields,
            include_sequence=include_sequence,
            aux_report=aux_report,
            format=format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2TabularOutput",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_genome_table_serialize(
        self,
        taxon,
        accessions,
        refseq_only,
        annotated_only,
        released_since,
        updated_since,
        host,
        pangolin_classification,
        geo_location,
        usa_state,
        complete_only,
        table_fields,
        include_sequence,
        aux_report,
        format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'multi',
            'table_fields': 'multi',
            'include_sequence': 'multi',
            'aux_report': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if taxon is not None:
            _path_params['taxon'] = taxon
        # process the query parameters
        if accessions is not None:
            
            _query_params.append(('accessions', accessions))
            
        if refseq_only is not None:
            
            _query_params.append(('refseq_only', refseq_only))
            
        if annotated_only is not None:
            
            _query_params.append(('annotated_only', annotated_only))
            
        if released_since is not None:
            if isinstance(released_since, datetime):
                _query_params.append(
                    (
                        'released_since',
                        released_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('released_since', released_since))
            
        if updated_since is not None:
            if isinstance(updated_since, datetime):
                _query_params.append(
                    (
                        'updated_since',
                        updated_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_since', updated_since))
            
        if host is not None:
            
            _query_params.append(('host', host))
            
        if pangolin_classification is not None:
            
            _query_params.append(('pangolin_classification', pangolin_classification))
            
        if geo_location is not None:
            
            _query_params.append(('geo_location', geo_location))
            
        if usa_state is not None:
            
            _query_params.append(('usa_state', usa_state))
            
        if complete_only is not None:
            
            _query_params.append(('complete_only', complete_only))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if include_sequence is not None:
            
            _query_params.append(('include_sequence', include_sequence))
            
        if aux_report is not None:
            
            _query_params.append(('aux_report', aux_report))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/virus/taxon/{taxon}/genome/table',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_reports_by_acessions(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more nucleotide sequence accessions")],
        filter_refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        filter_annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        filter_released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        filter_updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        filter_host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        filter_pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        filter_geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        filter_usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        filter_complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        returned_content: Annotated[Optional[V2VirusDataReportRequestContentType], Field(description="Return complete virus reports or nucleotide accessions only")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsVirusDataReportPage:
        """Get a virus data report by nucleotide accession

        Get a virus data report by nucleotide accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more nucleotide sequence accessions (required)
        :type accessions: List[str]
        :param filter_refseq_only: If true, limit results to RefSeq genomes.
        :type filter_refseq_only: bool
        :param filter_annotated_only: If true, limit results to annotated genomes.
        :type filter_annotated_only: bool
        :param filter_released_since: Limit to genomes released on or after the specified date.
        :type filter_released_since: datetime
        :param filter_updated_since: Limit to genomes updated on or after the specified date.
        :type filter_updated_since: datetime
        :param filter_host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type filter_host: str
        :param filter_pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type filter_pangolin_classification: str
        :param filter_geo_location: Limit to genomes collected from the specified geographic location.
        :type filter_geo_location: str
        :param filter_usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type filter_usa_state: str
        :param filter_complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type filter_complete_only: bool
        :param returned_content: Return complete virus reports or nucleotide accessions only
        :type returned_content: V2VirusDataReportRequestContentType
        :param table_fields: Specify which fields to include in the tabular report
        :type table_fields: List[str]
        :param page_size: The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_reports_by_acessions_serialize(
            accessions=accessions,
            filter_refseq_only=filter_refseq_only,
            filter_annotated_only=filter_annotated_only,
            filter_released_since=filter_released_since,
            filter_updated_since=filter_updated_since,
            filter_host=filter_host,
            filter_pangolin_classification=filter_pangolin_classification,
            filter_geo_location=filter_geo_location,
            filter_usa_state=filter_usa_state,
            filter_complete_only=filter_complete_only,
            returned_content=returned_content,
            table_fields=table_fields,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_reports_by_acessions_with_http_info(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more nucleotide sequence accessions")],
        filter_refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        filter_annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        filter_released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        filter_updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        filter_host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        filter_pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        filter_geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        filter_usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        filter_complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        returned_content: Annotated[Optional[V2VirusDataReportRequestContentType], Field(description="Return complete virus reports or nucleotide accessions only")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsVirusDataReportPage]:
        """Get a virus data report by nucleotide accession

        Get a virus data report by nucleotide accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more nucleotide sequence accessions (required)
        :type accessions: List[str]
        :param filter_refseq_only: If true, limit results to RefSeq genomes.
        :type filter_refseq_only: bool
        :param filter_annotated_only: If true, limit results to annotated genomes.
        :type filter_annotated_only: bool
        :param filter_released_since: Limit to genomes released on or after the specified date.
        :type filter_released_since: datetime
        :param filter_updated_since: Limit to genomes updated on or after the specified date.
        :type filter_updated_since: datetime
        :param filter_host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type filter_host: str
        :param filter_pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type filter_pangolin_classification: str
        :param filter_geo_location: Limit to genomes collected from the specified geographic location.
        :type filter_geo_location: str
        :param filter_usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type filter_usa_state: str
        :param filter_complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type filter_complete_only: bool
        :param returned_content: Return complete virus reports or nucleotide accessions only
        :type returned_content: V2VirusDataReportRequestContentType
        :param table_fields: Specify which fields to include in the tabular report
        :type table_fields: List[str]
        :param page_size: The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_reports_by_acessions_serialize(
            accessions=accessions,
            filter_refseq_only=filter_refseq_only,
            filter_annotated_only=filter_annotated_only,
            filter_released_since=filter_released_since,
            filter_updated_since=filter_updated_since,
            filter_host=filter_host,
            filter_pangolin_classification=filter_pangolin_classification,
            filter_geo_location=filter_geo_location,
            filter_usa_state=filter_usa_state,
            filter_complete_only=filter_complete_only,
            returned_content=returned_content,
            table_fields=table_fields,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_reports_by_acessions_without_preload_content(
        self,
        accessions: Annotated[List[StrictStr], Field(description="One or more nucleotide sequence accessions")],
        filter_refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        filter_annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        filter_released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        filter_updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        filter_host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        filter_pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        filter_geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        filter_usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        filter_complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        returned_content: Annotated[Optional[V2VirusDataReportRequestContentType], Field(description="Return complete virus reports or nucleotide accessions only")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a virus data report by nucleotide accession

        Get a virus data report by nucleotide accession. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param accessions: One or more nucleotide sequence accessions (required)
        :type accessions: List[str]
        :param filter_refseq_only: If true, limit results to RefSeq genomes.
        :type filter_refseq_only: bool
        :param filter_annotated_only: If true, limit results to annotated genomes.
        :type filter_annotated_only: bool
        :param filter_released_since: Limit to genomes released on or after the specified date.
        :type filter_released_since: datetime
        :param filter_updated_since: Limit to genomes updated on or after the specified date.
        :type filter_updated_since: datetime
        :param filter_host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type filter_host: str
        :param filter_pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type filter_pangolin_classification: str
        :param filter_geo_location: Limit to genomes collected from the specified geographic location.
        :type filter_geo_location: str
        :param filter_usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type filter_usa_state: str
        :param filter_complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type filter_complete_only: bool
        :param returned_content: Return complete virus reports or nucleotide accessions only
        :type returned_content: V2VirusDataReportRequestContentType
        :param table_fields: Specify which fields to include in the tabular report
        :type table_fields: List[str]
        :param page_size: The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_reports_by_acessions_serialize(
            accessions=accessions,
            filter_refseq_only=filter_refseq_only,
            filter_annotated_only=filter_annotated_only,
            filter_released_since=filter_released_since,
            filter_updated_since=filter_updated_since,
            filter_host=filter_host,
            filter_pangolin_classification=filter_pangolin_classification,
            filter_geo_location=filter_geo_location,
            filter_usa_state=filter_usa_state,
            filter_complete_only=filter_complete_only,
            returned_content=returned_content,
            table_fields=table_fields,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_reports_by_acessions_serialize(
        self,
        accessions,
        filter_refseq_only,
        filter_annotated_only,
        filter_released_since,
        filter_updated_since,
        filter_host,
        filter_pangolin_classification,
        filter_geo_location,
        filter_usa_state,
        filter_complete_only,
        returned_content,
        table_fields,
        page_size,
        page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
            'table_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if accessions is not None:
            _path_params['accessions'] = accessions
        # process the query parameters
        if filter_refseq_only is not None:
            
            _query_params.append(('filter.refseq_only', filter_refseq_only))
            
        if filter_annotated_only is not None:
            
            _query_params.append(('filter.annotated_only', filter_annotated_only))
            
        if filter_released_since is not None:
            if isinstance(filter_released_since, datetime):
                _query_params.append(
                    (
                        'filter.released_since',
                        filter_released_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter.released_since', filter_released_since))
            
        if filter_updated_since is not None:
            if isinstance(filter_updated_since, datetime):
                _query_params.append(
                    (
                        'filter.updated_since',
                        filter_updated_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter.updated_since', filter_updated_since))
            
        if filter_host is not None:
            
            _query_params.append(('filter.host', filter_host))
            
        if filter_pangolin_classification is not None:
            
            _query_params.append(('filter.pangolin_classification', filter_pangolin_classification))
            
        if filter_geo_location is not None:
            
            _query_params.append(('filter.geo_location', filter_geo_location))
            
        if filter_usa_state is not None:
            
            _query_params.append(('filter.usa_state', filter_usa_state))
            
        if filter_complete_only is not None:
            
            _query_params.append(('filter.complete_only', filter_complete_only))
            
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/virus/accession/{accessions}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_reports_by_post(
        self,
        v2_virus_data_report_request: V2VirusDataReportRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsVirusDataReportPage:
        """Get a virus data report

        Get a virus data report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_virus_data_report_request: (required)
        :type v2_virus_data_report_request: V2VirusDataReportRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_reports_by_post_serialize(
            v2_virus_data_report_request=v2_virus_data_report_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_reports_by_post_with_http_info(
        self,
        v2_virus_data_report_request: V2VirusDataReportRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsVirusDataReportPage]:
        """Get a virus data report

        Get a virus data report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_virus_data_report_request: (required)
        :type v2_virus_data_report_request: V2VirusDataReportRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_reports_by_post_serialize(
            v2_virus_data_report_request=v2_virus_data_report_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_reports_by_post_without_preload_content(
        self,
        v2_virus_data_report_request: V2VirusDataReportRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a virus data report

        Get a virus data report. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param v2_virus_data_report_request: (required)
        :type v2_virus_data_report_request: V2VirusDataReportRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_reports_by_post_serialize(
            v2_virus_data_report_request=v2_virus_data_report_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_reports_by_post_serialize(
        self,
        v2_virus_data_report_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v2_virus_data_report_request is not None:
            _body_params = v2_virus_data_report_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/virus',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def virus_reports_by_taxon(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        filter_refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        filter_annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        filter_released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        filter_updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        filter_host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        filter_pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        filter_geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        filter_usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        filter_complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        returned_content: Annotated[Optional[V2VirusDataReportRequestContentType], Field(description="Return complete virus reports or nucleotide accessions only")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2reportsVirusDataReportPage:
        """Get a virus data report by taxon

        Get a virus data report by taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param filter_refseq_only: If true, limit results to RefSeq genomes.
        :type filter_refseq_only: bool
        :param filter_annotated_only: If true, limit results to annotated genomes.
        :type filter_annotated_only: bool
        :param filter_released_since: Limit to genomes released on or after the specified date.
        :type filter_released_since: datetime
        :param filter_updated_since: Limit to genomes updated on or after the specified date.
        :type filter_updated_since: datetime
        :param filter_host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type filter_host: str
        :param filter_pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type filter_pangolin_classification: str
        :param filter_geo_location: Limit to genomes collected from the specified geographic location.
        :type filter_geo_location: str
        :param filter_usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type filter_usa_state: str
        :param filter_complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type filter_complete_only: bool
        :param returned_content: Return complete virus reports or nucleotide accessions only
        :type returned_content: V2VirusDataReportRequestContentType
        :param table_fields: Specify which fields to include in the tabular report
        :type table_fields: List[str]
        :param page_size: The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_reports_by_taxon_serialize(
            taxon=taxon,
            filter_refseq_only=filter_refseq_only,
            filter_annotated_only=filter_annotated_only,
            filter_released_since=filter_released_since,
            filter_updated_since=filter_updated_since,
            filter_host=filter_host,
            filter_pangolin_classification=filter_pangolin_classification,
            filter_geo_location=filter_geo_location,
            filter_usa_state=filter_usa_state,
            filter_complete_only=filter_complete_only,
            returned_content=returned_content,
            table_fields=table_fields,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def virus_reports_by_taxon_with_http_info(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        filter_refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        filter_annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        filter_released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        filter_updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        filter_host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        filter_pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        filter_geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        filter_usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        filter_complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        returned_content: Annotated[Optional[V2VirusDataReportRequestContentType], Field(description="Return complete virus reports or nucleotide accessions only")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2reportsVirusDataReportPage]:
        """Get a virus data report by taxon

        Get a virus data report by taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param filter_refseq_only: If true, limit results to RefSeq genomes.
        :type filter_refseq_only: bool
        :param filter_annotated_only: If true, limit results to annotated genomes.
        :type filter_annotated_only: bool
        :param filter_released_since: Limit to genomes released on or after the specified date.
        :type filter_released_since: datetime
        :param filter_updated_since: Limit to genomes updated on or after the specified date.
        :type filter_updated_since: datetime
        :param filter_host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type filter_host: str
        :param filter_pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type filter_pangolin_classification: str
        :param filter_geo_location: Limit to genomes collected from the specified geographic location.
        :type filter_geo_location: str
        :param filter_usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type filter_usa_state: str
        :param filter_complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type filter_complete_only: bool
        :param returned_content: Return complete virus reports or nucleotide accessions only
        :type returned_content: V2VirusDataReportRequestContentType
        :param table_fields: Specify which fields to include in the tabular report
        :type table_fields: List[str]
        :param page_size: The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_reports_by_taxon_serialize(
            taxon=taxon,
            filter_refseq_only=filter_refseq_only,
            filter_annotated_only=filter_annotated_only,
            filter_released_since=filter_released_since,
            filter_updated_since=filter_updated_since,
            filter_host=filter_host,
            filter_pangolin_classification=filter_pangolin_classification,
            filter_geo_location=filter_geo_location,
            filter_usa_state=filter_usa_state,
            filter_complete_only=filter_complete_only,
            returned_content=returned_content,
            table_fields=table_fields,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def virus_reports_by_taxon_without_preload_content(
        self,
        taxon: Annotated[StrictStr, Field(description="NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank")],
        filter_refseq_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to RefSeq genomes.")] = None,
        filter_annotated_only: Annotated[Optional[StrictBool], Field(description="If true, limit results to annotated genomes.")] = None,
        filter_released_since: Annotated[Optional[datetime], Field(description="Limit to genomes released on or after the specified date.")] = None,
        filter_updated_since: Annotated[Optional[datetime], Field(description="Limit to genomes updated on or after the specified date.")] = None,
        filter_host: Annotated[Optional[StrictStr], Field(description="Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).")] = None,
        filter_pangolin_classification: Annotated[Optional[StrictStr], Field(description="Limit to SARS-CoV-2 genomes from the specified Pango lineage.")] = None,
        filter_geo_location: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified geographic location.")] = None,
        filter_usa_state: Annotated[Optional[StrictStr], Field(description="Limit to genomes collected from the specified U.S. state (two-letter abbreviation).")] = None,
        filter_complete_only: Annotated[Optional[StrictBool], Field(description="Limit to genomes designated as complete, as defined by the submitter.")] = None,
        returned_content: Annotated[Optional[V2VirusDataReportRequestContentType], Field(description="Return complete virus reports or nucleotide accessions only")] = None,
        table_fields: Annotated[Optional[List[StrictStr]], Field(description="Specify which fields to include in the tabular report")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.")] = None,
        page_token: Annotated[Optional[StrictStr], Field(description="A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a virus data report by taxon

        Get a virus data report by taxon. By default, in paged JSON format, but also available in tabular (accept: text/tab-separated-values) or JSON Lines (accept: application/x-ndjson) formats.

        :param taxon: NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank (required)
        :type taxon: str
        :param filter_refseq_only: If true, limit results to RefSeq genomes.
        :type filter_refseq_only: bool
        :param filter_annotated_only: If true, limit results to annotated genomes.
        :type filter_annotated_only: bool
        :param filter_released_since: Limit to genomes released on or after the specified date.
        :type filter_released_since: datetime
        :param filter_updated_since: Limit to genomes updated on or after the specified date.
        :type filter_updated_since: datetime
        :param filter_host: Limit to genomes isolated from the specified host species (NCBI Taxonomy ID, common or scientific name).
        :type filter_host: str
        :param filter_pangolin_classification: Limit to SARS-CoV-2 genomes from the specified Pango lineage.
        :type filter_pangolin_classification: str
        :param filter_geo_location: Limit to genomes collected from the specified geographic location.
        :type filter_geo_location: str
        :param filter_usa_state: Limit to genomes collected from the specified U.S. state (two-letter abbreviation).
        :type filter_usa_state: str
        :param filter_complete_only: Limit to genomes designated as complete, as defined by the submitter.
        :type filter_complete_only: bool
        :param returned_content: Return complete virus reports or nucleotide accessions only
        :type returned_content: V2VirusDataReportRequestContentType
        :param table_fields: Specify which fields to include in the tabular report
        :type table_fields: List[str]
        :param page_size: The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.
        :type page_size: int
        :param page_token: A page token is returned when the results count exceeds `page size`. Use this token along with previous request parameters to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._virus_reports_by_taxon_serialize(
            taxon=taxon,
            filter_refseq_only=filter_refseq_only,
            filter_annotated_only=filter_annotated_only,
            filter_released_since=filter_released_since,
            filter_updated_since=filter_updated_since,
            filter_host=filter_host,
            filter_pangolin_classification=filter_pangolin_classification,
            filter_geo_location=filter_geo_location,
            filter_usa_state=filter_usa_state,
            filter_complete_only=filter_complete_only,
            returned_content=returned_content,
            table_fields=table_fields,
            page_size=page_size,
            page_token=page_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2reportsVirusDataReportPage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _virus_reports_by_taxon_serialize(
        self,
        taxon,
        filter_refseq_only,
        filter_annotated_only,
        filter_released_since,
        filter_updated_since,
        filter_host,
        filter_pangolin_classification,
        filter_geo_location,
        filter_usa_state,
        filter_complete_only,
        returned_content,
        table_fields,
        page_size,
        page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'table_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if taxon is not None:
            _path_params['taxon'] = taxon
        # process the query parameters
        if filter_refseq_only is not None:
            
            _query_params.append(('filter.refseq_only', filter_refseq_only))
            
        if filter_annotated_only is not None:
            
            _query_params.append(('filter.annotated_only', filter_annotated_only))
            
        if filter_released_since is not None:
            if isinstance(filter_released_since, datetime):
                _query_params.append(
                    (
                        'filter.released_since',
                        filter_released_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter.released_since', filter_released_since))
            
        if filter_updated_since is not None:
            if isinstance(filter_updated_since, datetime):
                _query_params.append(
                    (
                        'filter.updated_since',
                        filter_updated_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('filter.updated_since', filter_updated_since))
            
        if filter_host is not None:
            
            _query_params.append(('filter.host', filter_host))
            
        if filter_pangolin_classification is not None:
            
            _query_params.append(('filter.pangolin_classification', filter_pangolin_classification))
            
        if filter_geo_location is not None:
            
            _query_params.append(('filter.geo_location', filter_geo_location))
            
        if filter_usa_state is not None:
            
            _query_params.append(('filter.usa_state', filter_usa_state))
            
        if filter_complete_only is not None:
            
            _query_params.append(('filter.complete_only', filter_complete_only))
            
        if returned_content is not None:
            
            _query_params.append(('returned_content', returned_content.value))
            
        if table_fields is not None:
            
            _query_params.append(('table_fields', table_fields))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_token is not None:
            
            _query_params.append(('page_token', page_token))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'application/x-ndjson', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuthHeader'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/virus/taxon/{taxon}/dataset_report',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


