# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.ncbiprotddv2_chain_footprint import Ncbiprotddv2ChainFootprint
from ncbi.datasets.openapi.models.ncbiprotddv2_vast_score import Ncbiprotddv2VastScore
from typing import Optional, Set
from typing_extensions import Self

class Ncbiprotddv2SimilarStructureReport(BaseModel):
    """
    Ncbiprotddv2SimilarStructureReport
    """ # noqa: E501
    sdid: Optional[StrictInt] = None
    structure_title: Optional[StrictStr] = None
    protein_chain_name: Optional[StrictStr] = None
    chain_id: Optional[StrictStr] = None
    domain_number: Optional[StrictInt] = None
    mmdb_id: Optional[StrictInt] = None
    pdb_id: Optional[StrictStr] = None
    vast_score: Optional[Ncbiprotddv2VastScore] = None
    align_id: Optional[StrictInt] = None
    superkingdom_id: Optional[StrictInt] = None
    tax_id: Optional[StrictInt] = None
    footprints: Optional[List[Ncbiprotddv2ChainFootprint]] = None
    __properties: ClassVar[List[str]] = ["sdid", "structure_title", "protein_chain_name", "chain_id", "domain_number", "mmdb_id", "pdb_id", "vast_score", "align_id", "superkingdom_id", "tax_id", "footprints"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Ncbiprotddv2SimilarStructureReport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of vast_score
        if self.vast_score:
            _dict['vast_score'] = self.vast_score.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in footprints (list)
        _items = []
        if self.footprints:
            for _item_footprints in self.footprints:
                if _item_footprints:
                    _items.append(_item_footprints.to_dict())
            _dict['footprints'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Ncbiprotddv2SimilarStructureReport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sdid": obj.get("sdid"),
            "structure_title": obj.get("structure_title"),
            "protein_chain_name": obj.get("protein_chain_name"),
            "chain_id": obj.get("chain_id"),
            "domain_number": obj.get("domain_number"),
            "mmdb_id": obj.get("mmdb_id"),
            "pdb_id": obj.get("pdb_id"),
            "vast_score": Ncbiprotddv2VastScore.from_dict(obj["vast_score"]) if obj.get("vast_score") is not None else None,
            "align_id": obj.get("align_id"),
            "superkingdom_id": obj.get("superkingdom_id"),
            "tax_id": obj.get("tax_id"),
            "footprints": [Ncbiprotddv2ChainFootprint.from_dict(_item) for _item in obj["footprints"]] if obj.get("footprints") is not None else None
        })
        return _obj


