# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.ncbiprotddv2_structure_data_report_biounit_chain import Ncbiprotddv2StructureDataReportBiounitChain
from ncbi.datasets.openapi.models.ncbiprotddv2_structure_data_report_experiment import Ncbiprotddv2StructureDataReportExperiment
from ncbi.datasets.openapi.models.ncbiprotddv2_structure_data_report_ligand_chain import Ncbiprotddv2StructureDataReportLigandChain
from typing import Optional, Set
from typing_extensions import Self

class Ncbiprotddv2StructureDataReport(BaseModel):
    """
    Ncbiprotddv2StructureDataReport
    """ # noqa: E501
    pdb_id: Optional[StrictStr] = None
    mmdb_id: Optional[StrictInt] = None
    is_obsolete: Optional[StrictBool] = None
    publication_pmid: Optional[List[StrictInt]] = None
    deposition_date: Optional[StrictStr] = None
    update_date: Optional[StrictStr] = None
    experiment: Optional[Ncbiprotddv2StructureDataReportExperiment] = None
    chains: Optional[List[Ncbiprotddv2StructureDataReportBiounitChain]] = None
    ligand_chains: Optional[List[Ncbiprotddv2StructureDataReportLigandChain]] = None
    asymmetric_chains: Optional[List[Ncbiprotddv2StructureDataReportBiounitChain]] = None
    asymmetric_ligands: Optional[List[Ncbiprotddv2StructureDataReportLigandChain]] = None
    __properties: ClassVar[List[str]] = ["pdb_id", "mmdb_id", "is_obsolete", "publication_pmid", "deposition_date", "update_date", "experiment", "chains", "ligand_chains", "asymmetric_chains", "asymmetric_ligands"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Ncbiprotddv2StructureDataReport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of experiment
        if self.experiment:
            _dict['experiment'] = self.experiment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in chains (list)
        _items = []
        if self.chains:
            for _item_chains in self.chains:
                if _item_chains:
                    _items.append(_item_chains.to_dict())
            _dict['chains'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ligand_chains (list)
        _items = []
        if self.ligand_chains:
            for _item_ligand_chains in self.ligand_chains:
                if _item_ligand_chains:
                    _items.append(_item_ligand_chains.to_dict())
            _dict['ligand_chains'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in asymmetric_chains (list)
        _items = []
        if self.asymmetric_chains:
            for _item_asymmetric_chains in self.asymmetric_chains:
                if _item_asymmetric_chains:
                    _items.append(_item_asymmetric_chains.to_dict())
            _dict['asymmetric_chains'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in asymmetric_ligands (list)
        _items = []
        if self.asymmetric_ligands:
            for _item_asymmetric_ligands in self.asymmetric_ligands:
                if _item_asymmetric_ligands:
                    _items.append(_item_asymmetric_ligands.to_dict())
            _dict['asymmetric_ligands'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Ncbiprotddv2StructureDataReport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pdb_id": obj.get("pdb_id"),
            "mmdb_id": obj.get("mmdb_id"),
            "is_obsolete": obj.get("is_obsolete"),
            "publication_pmid": obj.get("publication_pmid"),
            "deposition_date": obj.get("deposition_date"),
            "update_date": obj.get("update_date"),
            "experiment": Ncbiprotddv2StructureDataReportExperiment.from_dict(obj["experiment"]) if obj.get("experiment") is not None else None,
            "chains": [Ncbiprotddv2StructureDataReportBiounitChain.from_dict(_item) for _item in obj["chains"]] if obj.get("chains") is not None else None,
            "ligand_chains": [Ncbiprotddv2StructureDataReportLigandChain.from_dict(_item) for _item in obj["ligand_chains"]] if obj.get("ligand_chains") is not None else None,
            "asymmetric_chains": [Ncbiprotddv2StructureDataReportBiounitChain.from_dict(_item) for _item in obj["asymmetric_chains"]] if obj.get("asymmetric_chains") is not None else None,
            "asymmetric_ligands": [Ncbiprotddv2StructureDataReportLigandChain.from_dict(_item) for _item in obj["asymmetric_ligands"]] if obj.get("asymmetric_ligands") is not None else None
        })
        return _obj


