# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2_download_summary_available_files import V2DownloadSummaryAvailableFiles
from ncbi.datasets.openapi.models.v2_download_summary_dehydrated import V2DownloadSummaryDehydrated
from ncbi.datasets.openapi.models.v2_download_summary_hydrated import V2DownloadSummaryHydrated
from ncbi.datasets.openapi.models.v2reports_error import V2reportsError
from ncbi.datasets.openapi.models.v2reports_message import V2reportsMessage
from typing import Optional, Set
from typing_extensions import Self

class V2DownloadSummary(BaseModel):
    """
    V2DownloadSummary
    """ # noqa: E501
    record_count: Optional[StrictInt] = None
    assembly_count: Optional[StrictInt] = None
    resource_updated_on: Optional[datetime] = None
    hydrated: Optional[V2DownloadSummaryHydrated] = None
    dehydrated: Optional[V2DownloadSummaryDehydrated] = None
    errors: Optional[List[V2reportsError]] = None
    messages: Optional[List[V2reportsMessage]] = None
    available_files: Optional[V2DownloadSummaryAvailableFiles] = None
    __properties: ClassVar[List[str]] = ["record_count", "assembly_count", "resource_updated_on", "hydrated", "dehydrated", "errors", "messages", "available_files"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2DownloadSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of hydrated
        if self.hydrated:
            _dict['hydrated'] = self.hydrated.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dehydrated
        if self.dehydrated:
            _dict['dehydrated'] = self.dehydrated.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict['errors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item_messages in self.messages:
                if _item_messages:
                    _items.append(_item_messages.to_dict())
            _dict['messages'] = _items
        # override the default output from pydantic by calling `to_dict()` of available_files
        if self.available_files:
            _dict['available_files'] = self.available_files.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2DownloadSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "record_count": obj.get("record_count"),
            "assembly_count": obj.get("assembly_count"),
            "resource_updated_on": obj.get("resource_updated_on"),
            "hydrated": V2DownloadSummaryHydrated.from_dict(obj["hydrated"]) if obj.get("hydrated") is not None else None,
            "dehydrated": V2DownloadSummaryDehydrated.from_dict(obj["dehydrated"]) if obj.get("dehydrated") is not None else None,
            "errors": [V2reportsError.from_dict(_item) for _item in obj["errors"]] if obj.get("errors") is not None else None,
            "messages": [V2reportsMessage.from_dict(_item) for _item in obj["messages"]] if obj.get("messages") is not None else None,
            "available_files": V2DownloadSummaryAvailableFiles.from_dict(obj["available_files"]) if obj.get("available_files") is not None else None
        })
        return _obj


