# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2_download_summary_file_summary import V2DownloadSummaryFileSummary
from typing import Optional, Set
from typing_extensions import Self

class V2DownloadSummaryAvailableFiles(BaseModel):
    """
    V2DownloadSummaryAvailableFiles
    """ # noqa: E501
    all_genomic_fasta: Optional[V2DownloadSummaryFileSummary] = None
    genome_gff: Optional[V2DownloadSummaryFileSummary] = None
    genome_gbff: Optional[V2DownloadSummaryFileSummary] = None
    rna_fasta: Optional[V2DownloadSummaryFileSummary] = None
    prot_fasta: Optional[V2DownloadSummaryFileSummary] = None
    genome_gtf: Optional[V2DownloadSummaryFileSummary] = None
    cds_fasta: Optional[V2DownloadSummaryFileSummary] = None
    sequence_report: Optional[V2DownloadSummaryFileSummary] = None
    annotation_report: Optional[V2DownloadSummaryFileSummary] = None
    __properties: ClassVar[List[str]] = ["all_genomic_fasta", "genome_gff", "genome_gbff", "rna_fasta", "prot_fasta", "genome_gtf", "cds_fasta", "sequence_report", "annotation_report"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2DownloadSummaryAvailableFiles from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of all_genomic_fasta
        if self.all_genomic_fasta:
            _dict['all_genomic_fasta'] = self.all_genomic_fasta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of genome_gff
        if self.genome_gff:
            _dict['genome_gff'] = self.genome_gff.to_dict()
        # override the default output from pydantic by calling `to_dict()` of genome_gbff
        if self.genome_gbff:
            _dict['genome_gbff'] = self.genome_gbff.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rna_fasta
        if self.rna_fasta:
            _dict['rna_fasta'] = self.rna_fasta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of prot_fasta
        if self.prot_fasta:
            _dict['prot_fasta'] = self.prot_fasta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of genome_gtf
        if self.genome_gtf:
            _dict['genome_gtf'] = self.genome_gtf.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cds_fasta
        if self.cds_fasta:
            _dict['cds_fasta'] = self.cds_fasta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sequence_report
        if self.sequence_report:
            _dict['sequence_report'] = self.sequence_report.to_dict()
        # override the default output from pydantic by calling `to_dict()` of annotation_report
        if self.annotation_report:
            _dict['annotation_report'] = self.annotation_report.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2DownloadSummaryAvailableFiles from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "all_genomic_fasta": V2DownloadSummaryFileSummary.from_dict(obj["all_genomic_fasta"]) if obj.get("all_genomic_fasta") is not None else None,
            "genome_gff": V2DownloadSummaryFileSummary.from_dict(obj["genome_gff"]) if obj.get("genome_gff") is not None else None,
            "genome_gbff": V2DownloadSummaryFileSummary.from_dict(obj["genome_gbff"]) if obj.get("genome_gbff") is not None else None,
            "rna_fasta": V2DownloadSummaryFileSummary.from_dict(obj["rna_fasta"]) if obj.get("rna_fasta") is not None else None,
            "prot_fasta": V2DownloadSummaryFileSummary.from_dict(obj["prot_fasta"]) if obj.get("prot_fasta") is not None else None,
            "genome_gtf": V2DownloadSummaryFileSummary.from_dict(obj["genome_gtf"]) if obj.get("genome_gtf") is not None else None,
            "cds_fasta": V2DownloadSummaryFileSummary.from_dict(obj["cds_fasta"]) if obj.get("cds_fasta") is not None else None,
            "sequence_report": V2DownloadSummaryFileSummary.from_dict(obj["sequence_report"]) if obj.get("sequence_report") is not None else None,
            "annotation_report": V2DownloadSummaryFileSummary.from_dict(obj["annotation_report"]) if obj.get("annotation_report") is not None else None
        })
        return _obj


