# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2_gene_dataset_reports_request_content_type import V2GeneDatasetReportsRequestContentType
from ncbi.datasets.openapi.models.v2_gene_dataset_reports_request_symbols_for_taxon import V2GeneDatasetReportsRequestSymbolsForTaxon
from ncbi.datasets.openapi.models.v2_gene_type import V2GeneType
from ncbi.datasets.openapi.models.v2_include_tabular_header import V2IncludeTabularHeader
from ncbi.datasets.openapi.models.v2_sort_field import V2SortField
from typing import Optional, Set
from typing_extensions import Self

class V2GeneDatasetReportsRequest(BaseModel):
    """
    V2GeneDatasetReportsRequest
    """ # noqa: E501
    returned_content: Optional[V2GeneDatasetReportsRequestContentType] = V2GeneDatasetReportsRequestContentType.COMPLETE
    gene_ids: Optional[List[StrictInt]] = None
    accessions: Optional[List[StrictStr]] = None
    symbols_for_taxon: Optional[V2GeneDatasetReportsRequestSymbolsForTaxon] = None
    taxon: Optional[StrictStr] = None
    locus_tags: Optional[List[StrictStr]] = None
    table_fields: Optional[List[StrictStr]] = None
    table_format: Optional[StrictStr] = None
    include_tabular_header: Optional[V2IncludeTabularHeader] = V2IncludeTabularHeader.INCLUDE_TABULAR_HEADER_FIRST_PAGE_ONLY
    page_size: Optional[StrictInt] = None
    page_token: Optional[StrictStr] = None
    query: Optional[StrictStr] = None
    types: Optional[List[V2GeneType]] = None
    accession_filter: Optional[List[StrictStr]] = None
    tax_search_subtree: Optional[StrictBool] = None
    sort: Optional[List[V2SortField]] = None
    __properties: ClassVar[List[str]] = ["returned_content", "gene_ids", "accessions", "symbols_for_taxon", "taxon", "locus_tags", "table_fields", "table_format", "include_tabular_header", "page_size", "page_token", "query", "types", "accession_filter", "tax_search_subtree", "sort"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2GeneDatasetReportsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of symbols_for_taxon
        if self.symbols_for_taxon:
            _dict['symbols_for_taxon'] = self.symbols_for_taxon.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sort (list)
        _items = []
        if self.sort:
            for _item_sort in self.sort:
                if _item_sort:
                    _items.append(_item_sort.to_dict())
            _dict['sort'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2GeneDatasetReportsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "returned_content": obj.get("returned_content") if obj.get("returned_content") is not None else V2GeneDatasetReportsRequestContentType.COMPLETE,
            "gene_ids": obj.get("gene_ids"),
            "accessions": obj.get("accessions"),
            "symbols_for_taxon": V2GeneDatasetReportsRequestSymbolsForTaxon.from_dict(obj["symbols_for_taxon"]) if obj.get("symbols_for_taxon") is not None else None,
            "taxon": obj.get("taxon"),
            "locus_tags": obj.get("locus_tags"),
            "table_fields": obj.get("table_fields"),
            "table_format": obj.get("table_format"),
            "include_tabular_header": obj.get("include_tabular_header") if obj.get("include_tabular_header") is not None else V2IncludeTabularHeader.INCLUDE_TABULAR_HEADER_FIRST_PAGE_ONLY,
            "page_size": obj.get("page_size"),
            "page_token": obj.get("page_token"),
            "query": obj.get("query"),
            "types": obj.get("types"),
            "accession_filter": obj.get("accession_filter"),
            "tax_search_subtree": obj.get("tax_search_subtree"),
            "sort": [V2SortField.from_dict(_item) for _item in obj["sort"]] if obj.get("sort") is not None else None
        })
        return _obj


