# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2_fasta import V2Fasta
from ncbi.datasets.openapi.models.v2_gene_dataset_request_content_type import V2GeneDatasetRequestContentType
from ncbi.datasets.openapi.models.v2_gene_dataset_request_gene_dataset_report_type import V2GeneDatasetRequestGeneDatasetReportType
from typing import Optional, Set
from typing_extensions import Self

class V2GeneDatasetRequest(BaseModel):
    """
    V2GeneDatasetRequest
    """ # noqa: E501
    gene_ids: Optional[List[StrictInt]] = None
    include_annotation_type: Optional[List[V2Fasta]] = None
    returned_content: Optional[V2GeneDatasetRequestContentType] = V2GeneDatasetRequestContentType.COMPLETE
    fasta_filter: Optional[List[StrictStr]] = None
    accession_filter: Optional[List[StrictStr]] = None
    aux_report: Optional[List[V2GeneDatasetRequestGeneDatasetReportType]] = None
    tabular_reports: Optional[List[V2GeneDatasetRequestGeneDatasetReportType]] = None
    table_fields: Optional[List[StrictStr]] = None
    table_report_type: Optional[V2GeneDatasetRequestGeneDatasetReportType] = V2GeneDatasetRequestGeneDatasetReportType.DATASET_REPORT
    __properties: ClassVar[List[str]] = ["gene_ids", "include_annotation_type", "returned_content", "fasta_filter", "accession_filter", "aux_report", "tabular_reports", "table_fields", "table_report_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2GeneDatasetRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2GeneDatasetRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "gene_ids": obj.get("gene_ids"),
            "include_annotation_type": obj.get("include_annotation_type"),
            "returned_content": obj.get("returned_content") if obj.get("returned_content") is not None else V2GeneDatasetRequestContentType.COMPLETE,
            "fasta_filter": obj.get("fasta_filter"),
            "accession_filter": obj.get("accession_filter"),
            "aux_report": obj.get("aux_report"),
            "tabular_reports": obj.get("tabular_reports"),
            "table_fields": obj.get("table_fields"),
            "table_report_type": obj.get("table_report_type") if obj.get("table_report_type") is not None else V2GeneDatasetRequestGeneDatasetReportType.DATASET_REPORT
        })
        return _obj


