# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2_genome_annotation_request_annotation_type import V2GenomeAnnotationRequestAnnotationType
from ncbi.datasets.openapi.models.v2_genome_annotation_request_genome_annotation_table_format import V2GenomeAnnotationRequestGenomeAnnotationTableFormat
from ncbi.datasets.openapi.models.v2_include_tabular_header import V2IncludeTabularHeader
from ncbi.datasets.openapi.models.v2_sort_field import V2SortField
from typing import Optional, Set
from typing_extensions import Self

class V2GenomeAnnotationRequest(BaseModel):
    """
    V2GenomeAnnotationRequest
    """ # noqa: E501
    accession: Optional[StrictStr] = None
    annotation_ids: Optional[List[StrictStr]] = None
    symbols: Optional[List[StrictStr]] = None
    locations: Optional[List[StrictStr]] = None
    gene_types: Optional[List[StrictStr]] = None
    search_text: Optional[List[StrictStr]] = None
    sort: Optional[List[V2SortField]] = None
    include_annotation_type: Optional[List[V2GenomeAnnotationRequestAnnotationType]] = None
    page_size: Optional[StrictInt] = None
    table_fields: Optional[List[StrictStr]] = None
    table_format: Optional[V2GenomeAnnotationRequestGenomeAnnotationTableFormat] = V2GenomeAnnotationRequestGenomeAnnotationTableFormat.NO_TABLE
    include_tabular_header: Optional[V2IncludeTabularHeader] = V2IncludeTabularHeader.INCLUDE_TABULAR_HEADER_FIRST_PAGE_ONLY
    page_token: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["accession", "annotation_ids", "symbols", "locations", "gene_types", "search_text", "sort", "include_annotation_type", "page_size", "table_fields", "table_format", "include_tabular_header", "page_token"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2GenomeAnnotationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in sort (list)
        _items = []
        if self.sort:
            for _item_sort in self.sort:
                if _item_sort:
                    _items.append(_item_sort.to_dict())
            _dict['sort'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2GenomeAnnotationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accession": obj.get("accession"),
            "annotation_ids": obj.get("annotation_ids"),
            "symbols": obj.get("symbols"),
            "locations": obj.get("locations"),
            "gene_types": obj.get("gene_types"),
            "search_text": obj.get("search_text"),
            "sort": [V2SortField.from_dict(_item) for _item in obj["sort"]] if obj.get("sort") is not None else None,
            "include_annotation_type": obj.get("include_annotation_type"),
            "page_size": obj.get("page_size"),
            "table_fields": obj.get("table_fields"),
            "table_format": obj.get("table_format") if obj.get("table_format") is not None else V2GenomeAnnotationRequestGenomeAnnotationTableFormat.NO_TABLE,
            "include_tabular_header": obj.get("include_tabular_header") if obj.get("include_tabular_header") is not None else V2IncludeTabularHeader.INCLUDE_TABULAR_HEADER_FIRST_PAGE_ONLY,
            "page_token": obj.get("page_token")
        })
        return _obj


