# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2_include_tabular_header import V2IncludeTabularHeader
from ncbi.datasets.openapi.models.v2_organelle_metadata_request_content_type import V2OrganelleMetadataRequestContentType
from ncbi.datasets.openapi.models.v2_organelle_metadata_request_organelle_table_format import V2OrganelleMetadataRequestOrganelleTableFormat
from ncbi.datasets.openapi.models.v2_organelle_sort import V2OrganelleSort
from ncbi.datasets.openapi.models.v2reports_organelle_type import V2reportsOrganelleType
from typing import Optional, Set
from typing_extensions import Self

class V2OrganelleMetadataRequest(BaseModel):
    """
    V2OrganelleMetadataRequest
    """ # noqa: E501
    taxons: Optional[List[StrictStr]] = None
    accessions: Optional[List[StrictStr]] = None
    organelle_types: Optional[List[V2reportsOrganelleType]] = None
    first_release_date: Optional[datetime] = None
    last_release_date: Optional[datetime] = None
    tax_exact_match: Optional[StrictBool] = None
    sort: Optional[List[V2OrganelleSort]] = None
    returned_content: Optional[V2OrganelleMetadataRequestContentType] = V2OrganelleMetadataRequestContentType.COMPLETE
    page_size: Optional[StrictInt] = None
    page_token: Optional[StrictStr] = None
    table_format: Optional[V2OrganelleMetadataRequestOrganelleTableFormat] = V2OrganelleMetadataRequestOrganelleTableFormat.ORGANELLE_TABLE_FORMAT_NO_TABLE
    include_tabular_header: Optional[V2IncludeTabularHeader] = V2IncludeTabularHeader.INCLUDE_TABULAR_HEADER_FIRST_PAGE_ONLY
    __properties: ClassVar[List[str]] = ["taxons", "accessions", "organelle_types", "first_release_date", "last_release_date", "tax_exact_match", "sort", "returned_content", "page_size", "page_token", "table_format", "include_tabular_header"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2OrganelleMetadataRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in sort (list)
        _items = []
        if self.sort:
            for _item_sort in self.sort:
                if _item_sort:
                    _items.append(_item_sort.to_dict())
            _dict['sort'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2OrganelleMetadataRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "taxons": obj.get("taxons"),
            "accessions": obj.get("accessions"),
            "organelle_types": obj.get("organelle_types"),
            "first_release_date": obj.get("first_release_date"),
            "last_release_date": obj.get("last_release_date"),
            "tax_exact_match": obj.get("tax_exact_match"),
            "sort": [V2OrganelleSort.from_dict(_item) for _item in obj["sort"]] if obj.get("sort") is not None else None,
            "returned_content": obj.get("returned_content") if obj.get("returned_content") is not None else V2OrganelleMetadataRequestContentType.COMPLETE,
            "page_size": obj.get("page_size"),
            "page_token": obj.get("page_token"),
            "table_format": obj.get("table_format") if obj.get("table_format") is not None else V2OrganelleMetadataRequestOrganelleTableFormat.ORGANELLE_TABLE_FORMAT_NO_TABLE,
            "include_tabular_header": obj.get("include_tabular_header") if obj.get("include_tabular_header") is not None else V2IncludeTabularHeader.INCLUDE_TABULAR_HEADER_FIRST_PAGE_ONLY
        })
        return _obj


