# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2_organism_query_request_tax_rank_filter import V2OrganismQueryRequestTaxRankFilter
from ncbi.datasets.openapi.models.v2_organism_query_request_taxon_resource_filter import V2OrganismQueryRequestTaxonResourceFilter
from typing import Optional, Set
from typing_extensions import Self

class V2OrganismQueryRequest(BaseModel):
    """
    V2OrganismQueryRequest
    """ # noqa: E501
    organism_query: Optional[StrictStr] = None
    taxon_query: Optional[StrictStr] = None
    tax_rank_filter: Optional[V2OrganismQueryRequestTaxRankFilter] = V2OrganismQueryRequestTaxRankFilter.SPECIES
    taxon_resource_filter: Optional[V2OrganismQueryRequestTaxonResourceFilter] = V2OrganismQueryRequestTaxonResourceFilter.TAXON_RESOURCE_FILTER_ALL
    exact_match: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["organism_query", "taxon_query", "tax_rank_filter", "taxon_resource_filter", "exact_match"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2OrganismQueryRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2OrganismQueryRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "organism_query": obj.get("organism_query"),
            "taxon_query": obj.get("taxon_query"),
            "tax_rank_filter": obj.get("tax_rank_filter") if obj.get("tax_rank_filter") is not None else V2OrganismQueryRequestTaxRankFilter.SPECIES,
            "taxon_resource_filter": obj.get("taxon_resource_filter") if obj.get("taxon_resource_filter") is not None else V2OrganismQueryRequestTaxonResourceFilter.TAXON_RESOURCE_FILTER_ALL,
            "exact_match": obj.get("exact_match")
        })
        return _obj


