# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2_taxonomy_links_response_generic_link import V2TaxonomyLinksResponseGenericLink
from typing import Optional, Set
from typing_extensions import Self

class V2TaxonomyLinksResponse(BaseModel):
    """
    V2TaxonomyLinksResponse
    """ # noqa: E501
    tax_id: Optional[StrictStr] = None
    encyclopedia_of_life: Optional[StrictStr] = None
    global_biodiversity_information_facility: Optional[StrictStr] = None
    inaturalist: Optional[StrictStr] = None
    viralzone: Optional[StrictStr] = None
    wikipedia: Optional[StrictStr] = None
    generic_links: Optional[List[V2TaxonomyLinksResponseGenericLink]] = None
    __properties: ClassVar[List[str]] = ["tax_id", "encyclopedia_of_life", "global_biodiversity_information_facility", "inaturalist", "viralzone", "wikipedia", "generic_links"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2TaxonomyLinksResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in generic_links (list)
        _items = []
        if self.generic_links:
            for _item_generic_links in self.generic_links:
                if _item_generic_links:
                    _items.append(_item_generic_links.to_dict())
            _dict['generic_links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2TaxonomyLinksResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "tax_id": obj.get("tax_id"),
            "encyclopedia_of_life": obj.get("encyclopedia_of_life"),
            "global_biodiversity_information_facility": obj.get("global_biodiversity_information_facility"),
            "inaturalist": obj.get("inaturalist"),
            "viralzone": obj.get("viralzone"),
            "wikipedia": obj.get("wikipedia"),
            "generic_links": [V2TaxonomyLinksResponseGenericLink.from_dict(_item) for _item in obj["generic_links"]] if obj.get("generic_links") is not None else None
        })
        return _obj


