# coding: utf-8

"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The NCBI Datasets version 2 API is updated often to add new features, fix bugs, and enhance usability. 

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ncbi.datasets.openapi.models.v2archive_molecule_type import V2archiveMoleculeType
from ncbi.datasets.openapi.models.v2archive_sequence import V2archiveSequence
from ncbi.datasets.openapi.models.v2archive_submitter import V2archiveSubmitter
from ncbi.datasets.openapi.models.v2archive_taxonomy_node import V2archiveTaxonomyNode
from ncbi.datasets.openapi.models.v2reports_organelle_topology import V2reportsOrganelleTopology
from typing import Optional, Set
from typing_extensions import Self

class V2archiveCatalog(BaseModel):
    """
    V2archiveCatalog
    """ # noqa: E501
    accession: Optional[StrictStr] = None
    molecule_type: Optional[V2archiveMoleculeType] = V2archiveMoleculeType.MOLECULE_TYPE_UNSPECIFIED
    definition: Optional[StrictStr] = None
    taxonomy: Optional[V2archiveTaxonomyNode] = None
    sequence: Optional[V2archiveSequence] = None
    topology: Optional[V2reportsOrganelleTopology] = V2reportsOrganelleTopology.TOPOLOGY_UNKNOWN
    modification_date: Optional[StrictStr] = None
    publication_date: Optional[StrictStr] = None
    submitters: Optional[List[V2archiveSubmitter]] = None
    __properties: ClassVar[List[str]] = ["accession", "molecule_type", "definition", "taxonomy", "sequence", "topology", "modification_date", "publication_date", "submitters"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2archiveCatalog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of taxonomy
        if self.taxonomy:
            _dict['taxonomy'] = self.taxonomy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sequence
        if self.sequence:
            _dict['sequence'] = self.sequence.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in submitters (list)
        _items = []
        if self.submitters:
            for _item_submitters in self.submitters:
                if _item_submitters:
                    _items.append(_item_submitters.to_dict())
            _dict['submitters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2archiveCatalog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accession": obj.get("accession"),
            "molecule_type": obj.get("molecule_type") if obj.get("molecule_type") is not None else V2archiveMoleculeType.MOLECULE_TYPE_UNSPECIFIED,
            "definition": obj.get("definition"),
            "taxonomy": V2archiveTaxonomyNode.from_dict(obj["taxonomy"]) if obj.get("taxonomy") is not None else None,
            "sequence": V2archiveSequence.from_dict(obj["sequence"]) if obj.get("sequence") is not None else None,
            "topology": obj.get("topology") if obj.get("topology") is not None else V2reportsOrganelleTopology.TOPOLOGY_UNKNOWN,
            "modification_date": obj.get("modification_date"),
            "publication_date": obj.get("publication_date"),
            "submitters": [V2archiveSubmitter.from_dict(_item) for _item in obj["submitters"]] if obj.get("submitters") is not None else None
        })
        return _obj


